/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template2.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.db2.SessionTemplate2;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.template2.dialogs.ByFieldCriteriaSpecificationTableLabelProvider;
import com.ibm.etools.fm.editor.template2.dialogs.CriteriaElement2;
import com.ibm.etools.fm.editor.template2.dialogs.FieldCriteriaSpecificationDialog2;
import com.ibm.etools.fm.model.template.Bylinetype;
import com.ibm.etools.fm.model.template.Criteriatype;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.LparenType;
import com.ibm.etools.fm.model.template.RparenType;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateFactory;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ByFieldCriteriaSpecificationDialog2
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int TABLE_COLUMN_COUNT = 10;
    private static final int INDEX_STATUS_COLUMN = 0;
    private static final int INDEX_CONNECTOR_COLUMN = 1;
    private static final int INDEX_GROUP_OPEN_COLUMN = 2;
    private static final int INDEX_REF_COLUMN = 3;
    private static final int INDEX_FIELD_COLUMN = 4;
    private static final int INDEX_TYPE_COLUMN = 5;
    private static final int INDEX_OPERATOR_COLUMN = 6;
    private static final int INDEX_CRITERIA_VALUE_COLUMN = 7;
    private static final int INDEX_GROUP_CLOSR_COLUMN = 8;
    private static final int INDEX_ERROR_MESSAGE_COLUMN = 9;
    private Text templateNameText = null;
    private Text db2ObjectText = null;
    private Table criteriaTable = null;
    private TableViewer criteriaTableViewer = null;
    private TableCursor criteriaTableCursor = null;
    private Button addButton = null;
    private Button modifyButton = null;
    private Button duplicateButton = null;
    private Button removeButton = null;
    private Button upButton = null;
    private Button downButton = null;
    private final SessionTemplate2 session;
    private final DataSetOrMember selectedTemplate;
    private final TemplateType currentTemplate;
    private TemplateType templateWithNewCriteria = null;
    private final List<CriteriaElement2> currentCriteriaList;
    private boolean noCriteria = false;

    public ByFieldCriteriaSpecificationDialog2(SessionTemplate2 session, DataSetOrMember aTemplate, TemplateType currentTemplate) {
        if (session == null) {
            throw new IllegalArgumentException("Must specify a non null SessionTemplate2.");
        }
        if (aTemplate == null) {
            throw new IllegalArgumentException("Must specify a non-null DataSetOfMember.");
        }
        if (currentTemplate == null) {
            throw new IllegalArgumentException("Must specify a non-null TemplateType.");
        }
        this.session = session;
        this.selectedTemplate = aTemplate;
        this.currentTemplate = currentTemplate;
        this.currentCriteriaList = new ArrayList<CriteriaElement2>();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.CriteriaSpecDialog_Title);
        this.setMessage(Messages.CriteriaSpecDialog_Msg);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.createLayoutComposite(composite);
        this.initByExistingCriteria();
        this.validateGroupingSpecification();
        ByFieldCriteriaSpecificationDialog2.populateTable(this.criteriaTableViewer, this.currentCriteriaList);
        return composite;
    }

    private void createLayoutComposite(Composite parent) {
        Composite templateComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)templateComposite, (String)Messages.CriteriaSpecDialog_TemplateName, (Object)GUI.grid.d.left1(), (int)16384);
        this.templateNameText = GUI.text.fieldReadOnly((Composite)templateComposite, (Object)GUI.grid.d.fillH((int)1));
        this.templateNameText.setText(this.selectedTemplate.getFormattedName());
        GUI.label((Composite)templateComposite, (String)Messages.CriteriaSpecDialog_DB2_ObjectName, (Object)GUI.grid.d.left1(), (int)16384);
        this.db2ObjectText = GUI.text.fieldReadOnly((Composite)templateComposite, (Object)GUI.grid.d.fillH((int)1));
        this.db2ObjectText.setText(this.session.getFromTemplateOptioons().getTable().getFormattedName());
        GridData tableGridData = GUI.grid.d.fillAll();
        tableGridData.heightHint = 300;
        Composite tableComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)tableGridData);
        this.criteriaTable = new Table(tableComposite, 68354);
        this.criteriaTable.setHeaderVisible(true);
        this.criteriaTable.setLinesVisible(true);
        this.criteriaTable.setLayoutData((Object)GUI.grid.d.fillAll());
        this.criteriaTableViewer = new TableViewer(this.criteriaTable);
        this.criteriaTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ByFieldCriteriaSpecificationDialog2.createMappingTableColumns(this.criteriaTableViewer);
        this.criteriaTableCursor = new TableCursor(this.criteriaTable, 0);
        this.criteriaTableCursor.setFont(JFaceResources.getTextFont());
        ControlEditor controlEditor = new ControlEditor((Composite)this.criteriaTableCursor);
        controlEditor.grabHorizontal = true;
        controlEditor.grabVertical = true;
        this.criteriaTableCursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ByFieldCriteriaSpecificationDialog2.this.handleSelectionEventForGroupStartEndColumn();
            }
        });
        this.criteriaTableCursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ByFieldCriteriaSpecificationDialog2.this.handleSelectionEventForGroupStartEndColumn();
            }
        });
        this.createFieldManipulateButtonsComposite(tableComposite);
        ByFieldCriteriaSpecificationDialog2.populateTable(this.criteriaTableViewer, this.currentCriteriaList);
    }

    private void handleSelectionEventForGroupStartEndColumn() {
        int columnNo = this.criteriaTableCursor.getColumn();
        if (columnNo == 2) {
            CriteriaElement2 selectedCriteria;
            TableItem selectedRow = this.criteriaTableCursor.getRow();
            int rowInex = this.criteriaTable.indexOf(selectedRow);
            selectedCriteria.setGroupStart(!(selectedCriteria = this.currentCriteriaList.get(rowInex)).isGroupStart());
            this.validateGroupingSpecification();
            int[] selection = this.criteriaTable.getSelectionIndices();
            ByFieldCriteriaSpecificationDialog2.populateTable(this.criteriaTableViewer, this.currentCriteriaList);
            this.criteriaTable.setSelection(selection);
            return;
        }
        if (columnNo == 8) {
            CriteriaElement2 selectedCriteria;
            TableItem selectedRow = this.criteriaTableCursor.getRow();
            int rowInex = this.criteriaTable.indexOf(selectedRow);
            selectedCriteria.setGroupEnd(!(selectedCriteria = this.currentCriteriaList.get(rowInex)).isGroupEnd());
            int[] selection = this.criteriaTable.getSelectionIndices();
            this.validateGroupingSpecification();
            ByFieldCriteriaSpecificationDialog2.populateTable(this.criteriaTableViewer, this.currentCriteriaList);
            this.criteriaTable.setSelection(selection);
            return;
        }
    }

    private static void createMappingTableColumns(TableViewer viewer) {
        FormattedEditorUtility.createTableViewerColumn("", 30, viewer, 0x1000000);
        FormattedEditorUtility.createTableViewerColumn(Messages.CriteriaSpecDialog_CONNECTOR_COLUMN, 80, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.CriteriaSpecDialog_GROUP_OPEN, 80, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_COLUMN_NUMBER, 50, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_COLUMN_NAME, 150, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_DATA_TYPE, 50, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.CriteriaSpecDialog_OPERATOR_COLUMN, 60, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.CriteriaSpecDialog_CRITERIA_VALUE_COLUMN, 150, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.CriteriaSpecDialog_GROUP_CLOSE, 80, viewer, 131072);
        viewer.setLabelProvider((IBaseLabelProvider)new ByFieldCriteriaSpecificationTableLabelProvider(9, 0));
    }

    private static void populateTable(TableViewer aTableViewer, List<CriteriaElement2> contents) {
        ArrayList<String[]> fieldList = new ArrayList<String[]>();
        int i = 0;
        while (i < contents.size()) {
            CriteriaElement2 anElement = contents.get(i);
            Symboltype aSymbol = anElement.getSymbol();
            String status0 = "";
            String connector1 = i == 0 ? "" : anElement.getConnectorType().getLiteral();
            String groupOpen2 = anElement.getGroupStartMarker();
            String ref3 = "" + aSymbol.getDb2col();
            String field4 = aSymbol.getName(anElement.getSystem());
            String type5 = aSymbol.getDb2typ();
            String operator6 = anElement.getOperator().getLiteral();
            String criteriaValue7 = anElement.getCriteriaValue();
            String groupCloser8 = anElement.getGroupEndMarker();
            String errorMessage9 = anElement.getErrorMessage();
            fieldList.add(new String[]{status0, connector1, groupOpen2, ref3, field4, type5, operator6, criteriaValue7, groupCloser8, errorMessage9});
            ++i;
        }
        aTableViewer.setInput(fieldList);
    }

    private void createFieldManipulateButtonsComposite(Composite parent) {
        GridData bGridData = GUI.grid.d.left1();
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.left1());
        this.addButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/add.gif"), (String)Messages.CriteriaSpecDialog_addButtonTip, (Object)bGridData);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FieldCriteriaSpecificationDialog2 dialog;
                ByFieldCriteriaSpecificationDialog2.this.setErrorMessage(null);
                boolean allowConnectorChange = true;
                if (ByFieldCriteriaSpecificationDialog2.this.criteriaTable.getItemCount() == 0) {
                    allowConnectorChange = false;
                }
                if ((dialog = new FieldCriteriaSpecificationDialog2((IZRL)ByFieldCriteriaSpecificationDialog2.this.selectedTemplate, ByFieldCriteriaSpecificationDialog2.this.currentTemplate, allowConnectorChange, ByFieldCriteriaSpecificationDialog2.this.session)).open() != 0) {
                    return;
                }
                CriteriaElement2 newElement = dialog.getSpecifiedCriteria();
                if (ByFieldCriteriaSpecificationDialog2.this.criteriaTable.getSelectionIndex() != -1) {
                    int insertLocation = ByFieldCriteriaSpecificationDialog2.this.criteriaTable.getSelectionIndex() + 1;
                    ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList.add(insertLocation, newElement);
                    ByFieldCriteriaSpecificationDialog2.this.validateGroupingSpecification();
                    ByFieldCriteriaSpecificationDialog2.populateTable(ByFieldCriteriaSpecificationDialog2.this.criteriaTableViewer, ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList);
                    ByFieldCriteriaSpecificationDialog2.this.criteriaTable.select(insertLocation);
                    return;
                }
                ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList.add(newElement);
                ByFieldCriteriaSpecificationDialog2.this.validateGroupingSpecification();
                ByFieldCriteriaSpecificationDialog2.populateTable(ByFieldCriteriaSpecificationDialog2.this.criteriaTableViewer, ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList);
                ByFieldCriteriaSpecificationDialog2.this.criteriaTable.select(ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList.size() - 1);
            }
        });
        this.modifyButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/editfield.gif"), (String)Messages.CriteriaSpecDialog_modifyButtonTip, (Object)bGridData);
        this.modifyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ByFieldCriteriaSpecificationDialog2.this.criteriaTable.getSelectionIndex() == -1) {
                    ByFieldCriteriaSpecificationDialog2.this.setErrorMessage(Messages.CriteriaSpecDialog_SelectItemWarning);
                    return;
                }
                ByFieldCriteriaSpecificationDialog2.this.setErrorMessage(null);
                int selection = ByFieldCriteriaSpecificationDialog2.this.criteriaTable.getSelectionIndex();
                boolean allowConnectorChange = selection != 0;
                CriteriaElement2 modifyElement = ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList.get(selection);
                FieldCriteriaSpecificationDialog2 dialog = new FieldCriteriaSpecificationDialog2((IZRL)ByFieldCriteriaSpecificationDialog2.this.selectedTemplate, ByFieldCriteriaSpecificationDialog2.this.currentTemplate, allowConnectorChange, ByFieldCriteriaSpecificationDialog2.this.session, modifyElement);
                if (dialog.open() != 0) {
                    return;
                }
                ByFieldCriteriaSpecificationDialog2.this.validateGroupingSpecification();
                ByFieldCriteriaSpecificationDialog2.populateTable(ByFieldCriteriaSpecificationDialog2.this.criteriaTableViewer, ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList);
                ByFieldCriteriaSpecificationDialog2.this.criteriaTable.select(selection);
            }
        });
        this.duplicateButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/duplicate.gif"), (String)Messages.CriteriaSpecDialog_duplicateButtonTip, (Object)bGridData);
        this.duplicateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ByFieldCriteriaSpecificationDialog2.this.criteriaTable.getSelectionIndex() == -1) {
                    ByFieldCriteriaSpecificationDialog2.this.setErrorMessage(Messages.CriteriaSpecDialog_SelectItemWarning);
                    return;
                }
                ByFieldCriteriaSpecificationDialog2.this.setErrorMessage(null);
                int selection = ByFieldCriteriaSpecificationDialog2.this.criteriaTable.getSelectionIndex();
                CriteriaElement2 copyFromElement = ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList.get(selection);
                CriteriaElement2 dupElement = new CriteriaElement2(copyFromElement.getConnectorType(), copyFromElement.getSymbol(), copyFromElement.getOperator(), copyFromElement.getSequenceNo(), copyFromElement.getCriteriaValue(), copyFromElement.getSystem());
                ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList.add(selection + 1, dupElement);
                ByFieldCriteriaSpecificationDialog2.this.validateGroupingSpecification();
                ByFieldCriteriaSpecificationDialog2.populateTable(ByFieldCriteriaSpecificationDialog2.this.criteriaTableViewer, ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList);
                ByFieldCriteriaSpecificationDialog2.this.criteriaTable.select(selection + 1);
            }
        });
        this.removeButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/delete.gif"), (String)Messages.CriteriaSpecDialog_removeButtonTip, (Object)bGridData);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ByFieldCriteriaSpecificationDialog2.this.criteriaTable.getSelectionIndex() == -1) {
                    ByFieldCriteriaSpecificationDialog2.this.setErrorMessage(Messages.CriteriaSpecDialog_SelectItemWarning);
                    return;
                }
                ByFieldCriteriaSpecificationDialog2.this.setErrorMessage(null);
                int[] selection = ByFieldCriteriaSpecificationDialog2.this.criteriaTable.getSelectionIndices();
                ArrayList<CriteriaElement2> criteriaToRemove = new ArrayList<CriteriaElement2>();
                int i = 0;
                while (i < selection.length) {
                    criteriaToRemove.add(ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList.get(selection[i]));
                    ++i;
                }
                i = 0;
                while (i < criteriaToRemove.size()) {
                    ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList.remove(criteriaToRemove.get(i));
                    ++i;
                }
                ByFieldCriteriaSpecificationDialog2.this.validateGroupingSpecification();
                ByFieldCriteriaSpecificationDialog2.populateTable(ByFieldCriteriaSpecificationDialog2.this.criteriaTableViewer, ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList);
                if (ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList.size() > 0) {
                    if (ByFieldCriteriaSpecificationDialog2.this.criteriaTableViewer.getElementAt(selection[0]) != null) {
                        ByFieldCriteriaSpecificationDialog2.this.criteriaTable.select(selection[0]);
                    } else {
                        ByFieldCriteriaSpecificationDialog2.this.criteriaTable.select(selection[0] - 1);
                    }
                }
            }
        });
        this.upButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/moveup.gif"), (String)Messages.CriteriaSpecDialog_upButtonTip, (Object)bGridData);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ByFieldCriteriaSpecificationDialog2.this.criteriaTable.getSelectionIndex() == -1) {
                    ByFieldCriteriaSpecificationDialog2.this.setErrorMessage(Messages.CriteriaSpecDialog_SelectItemWarning);
                    return;
                }
                ByFieldCriteriaSpecificationDialog2.this.setErrorMessage(null);
                int selectionIndex = ByFieldCriteriaSpecificationDialog2.this.criteriaTable.getSelectionIndex();
                if (selectionIndex == 0) {
                    return;
                }
                CriteriaElement2 selectedItem = ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList.get(selectionIndex);
                ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList.remove(selectedItem);
                ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList.add(selectionIndex - 1, selectedItem);
                ByFieldCriteriaSpecificationDialog2.this.validateGroupingSpecification();
                ByFieldCriteriaSpecificationDialog2.populateTable(ByFieldCriteriaSpecificationDialog2.this.criteriaTableViewer, ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList);
                ByFieldCriteriaSpecificationDialog2.this.criteriaTable.setSelection(selectionIndex - 1);
            }
        });
        this.downButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/movedown.gif"), (String)Messages.CriteriaSpecDialog_downButtonTip, (Object)bGridData);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ByFieldCriteriaSpecificationDialog2.this.criteriaTable.getSelectionIndex() == -1) {
                    ByFieldCriteriaSpecificationDialog2.this.setErrorMessage(Messages.CriteriaSpecDialog_SelectItemWarning);
                    return;
                }
                ByFieldCriteriaSpecificationDialog2.this.setErrorMessage(null);
                int selectionIndex = ByFieldCriteriaSpecificationDialog2.this.criteriaTable.getSelectionIndex();
                if (selectionIndex == ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList.size() - 1) {
                    return;
                }
                CriteriaElement2 selectedItem = ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList.get(selectionIndex);
                ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList.remove(selectedItem);
                ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList.add(selectionIndex + 1, selectedItem);
                ByFieldCriteriaSpecificationDialog2.this.validateGroupingSpecification();
                ByFieldCriteriaSpecificationDialog2.populateTable(ByFieldCriteriaSpecificationDialog2.this.criteriaTableViewer, ByFieldCriteriaSpecificationDialog2.this.currentCriteriaList);
                ByFieldCriteriaSpecificationDialog2.this.criteriaTable.setSelection(selectionIndex + 1);
            }
        });
    }

    private boolean validateGroupingSpecification() {
        this.setErrorMessage(null);
        int i = 0;
        while (i < this.currentCriteriaList.size()) {
            CriteriaElement2 aCriteria = this.currentCriteriaList.get(i);
            aCriteria.setErrorMessage(null);
            ++i;
        }
        Stack<CriteriaElement2> groupingStack = new Stack<CriteriaElement2>();
        int i2 = 0;
        while (i2 < this.currentCriteriaList.size()) {
            CriteriaElement2 aCriteria = this.currentCriteriaList.get(i2);
            if (!aCriteria.isGroupStart() || !aCriteria.isGroupEnd()) {
                if (aCriteria.isGroupStart()) {
                    groupingStack.push(aCriteria);
                } else if (aCriteria.isGroupEnd()) {
                    if (groupingStack.isEmpty()) {
                        aCriteria.setErrorMessage(Messages.CriteriaSpecDialog_UnmatchingOperator);
                        this.setErrorMessage(Messages.CriteriaSpecDialog_UnmatchingOperator);
                        return false;
                    }
                    groupingStack.pop();
                }
            }
            ++i2;
        }
        if (groupingStack.size() != 0) {
            CriteriaElement2 prevCriteria = (CriteriaElement2)groupingStack.pop();
            prevCriteria.setErrorMessage(Messages.CriteriaSpecDialog_UnmatchingOperator);
            this.setErrorMessage(Messages.CriteriaSpecDialog_UnmatchingOperator);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private void initByExistingCriteria() {
        Criteriatype currentCriteria = this.getCriteriaForEdit();
        if (currentCriteria == null) {
            return;
        }
        if (!currentCriteria.isSetByfield()) {
            return;
        }
        EList list = currentCriteria.getByline();
        int i = 0;
        while (i < list.size()) {
            Bylinetype aLine = (Bylinetype)list.get(i);
            if (aLine.isSetOper2()) {
                CriteriaElement2 anElement = new CriteriaElement2(aLine.getConn(), this.getSymbol(aLine.getSym()), aLine.getOper2(), aLine.getSeq(), aLine.getByval(), this.session.getSystem());
                if (aLine.isSetLparen()) {
                    anElement.setGroupStart(true);
                }
                if (aLine.isSetRparen()) {
                    anElement.setGroupEnd(true);
                }
                ByFieldCriteriaSpecificationDialog2.insertBySequenceNo(this.currentCriteriaList, anElement);
            }
            ++i;
        }
    }

    private static void insertBySequenceNo(List<CriteriaElement2> list, CriteriaElement2 newElement) {
        int i = 0;
        while (i < list.size()) {
            CriteriaElement2 anElement = list.get(i);
            if (newElement.getSequenceNo() < anElement.getSequenceNo()) {
                list.add(i, newElement);
                return;
            }
            ++i;
        }
        list.add(newElement);
    }

    private Criteriatype getCriteriaForEdit() {
        Iterator iterator = ((Layouttype)this.currentTemplate.getLayout().get(0)).getCriteria().iterator();
        if (iterator.hasNext()) {
            Criteriatype ct = (Criteriatype)iterator.next();
            return ct;
        }
        return null;
    }

    private Symboltype getSymbol(int symbolRef) {
        Layouttype selectedLayout = (Layouttype)this.currentTemplate.getLayout().get(0);
        int i = 0;
        while (i < selectedLayout.getSymbol().size()) {
            Symboltype aSymbol = (Symboltype)selectedLayout.getSymbol().get(i);
            if (aSymbol.getRef() == symbolRef) {
                return aSymbol;
            }
            ++i;
        }
        return null;
    }

    private Layouttype getLayout(int symbolRef) {
        Layouttype selectedLayout = (Layouttype)this.currentTemplate.getLayout().get(0);
        int i = 0;
        while (i < selectedLayout.getSymbol().size()) {
            Symboltype aSymbol = (Symboltype)selectedLayout.getSymbol().get(i);
            if (aSymbol.getRef() == symbolRef) {
                return selectedLayout;
            }
            ++i;
        }
        for (Layouttype aLayout : this.currentTemplate.getLayout()) {
            for (Symboltype aSymbol : aLayout.getSymbol()) {
                if (aSymbol.getRef() != symbolRef) continue;
                return aLayout;
            }
        }
        return null;
    }

    private Map<Layouttype, Criteriatype> getNewCriteria() {
        HashMap<Layouttype, Criteriatype> lookup = new HashMap<Layouttype, Criteriatype>();
        int i = 0;
        while (i < this.currentCriteriaList.size()) {
            CriteriaElement2 anElement = this.currentCriteriaList.get(i);
            Bylinetype aLine = ByFieldCriteriaSpecificationDialog2.getCriteriaElement(anElement, i + 1);
            Layouttype aLayout = this.getLayout(anElement.getSymbol().getRef());
            Criteriatype aCriteria = (Criteriatype)lookup.get(aLayout);
            if (aCriteria == null) {
                aCriteria = TemplateFactory.eINSTANCE.createCriteriatype();
                aCriteria.setByfield(true);
                lookup.put(aLayout, aCriteria);
            }
            aCriteria.getByline().add((Object)aLine);
            ++i;
        }
        return lookup;
    }

    private static Bylinetype getCriteriaElement(CriteriaElement2 anElement, int sequenceNo) {
        Bylinetype aLine = TemplateFactory.eINSTANCE.createBylinetype();
        if (anElement.getCriteriaValue() != null && anElement.getCriteriaValue().length() > 0) {
            aLine.setByval(anElement.getCriteriaValue());
        }
        aLine.setConn(anElement.getConnectorType());
        if (anElement.isGroupStart()) {
            aLine.setLparen(LparenType.__);
        }
        if (anElement.isGroupEnd()) {
            aLine.setRparen(RparenType.__);
        }
        aLine.setOper2(anElement.getOperator());
        aLine.setSym(anElement.getSymbol().getRef());
        aLine.setSeq(sequenceNo);
        return aLine;
    }

    private boolean validateCriteria() {
        StringBuffer newTemplate;
        block7: {
            Result result;
            try {
                this.templateWithNewCriteria = null;
                Map<Layouttype, Criteriatype> newCriteriaSpecification = this.getNewCriteria();
                TemplateType aTemplate = TemplateFactory.eINSTANCE.createTemplateType();
                aTemplate.setFmix(this.currentTemplate.isFmix());
                for (Map.Entry<Layouttype, Criteriatype> entry : newCriteriaSpecification.entrySet()) {
                    Layouttype aLayout = TemplateFactory.eINSTANCE.createLayouttype();
                    aLayout.setId(entry.getKey().getId());
                    aLayout.getCriteria().add((Object)entry.getValue());
                    aTemplate.getLayout().add((Object)aLayout);
                }
                final StringBuffer xmlTemplate = TemplateSerializeUtils.save((TemplateType)aTemplate, (IZRL)this.selectedTemplate);
                result = new Result();
                newTemplate = new StringBuffer();
                try {
                    PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask(Messages.CriteriaSpecDialog_CheckCriteriaWithHost, 1);
                            IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                            StringBuffer newXmlTemplate = ByFieldCriteriaSpecificationDialog2.this.session.updateTemplate(xmlTemplate, howIsGoing, result, true, false);
                            newTemplate.append(newXmlTemplate);
                        }
                    });
                }
                catch (Exception e) {
                    PDDialogs.openErrorThreadSafe((String)Messages.CriteriaSpecDialog_ExceptionWhileValidatingCriteria, (String)result.dumpOutputAndMessages(true), (Throwable)e);
                    return false;
                }
            }
            catch (Exception e) {
                PDDialogs.openErrorThreadSafe((String)Messages.CriteriaSpecDialog_ExceptionWhileValidatingCriteria, (Throwable)e);
                return false;
            }
            if (result.isSuccessfulWithoutWarnings()) break block7;
            PDDialogs.openErrorThreadSafe((String)Messages.CriteriaSpecDialog_CriteriaValidationErr, (String)result.dumpOutputAndMessages(true));
            return false;
        }
        this.templateWithNewCriteria = TemplateSerializeUtils.load((StringBuffer)newTemplate, (IZRL)this.selectedTemplate);
        return true;
    }

    public TemplateType getTemplateWithNewCriteria() {
        return this.templateWithNewCriteria;
    }

    protected void okPressed() {
        if (this.currentCriteriaList.isEmpty()) {
            this.noCriteria = true;
            super.okPressed();
        } else {
            if (!this.validateGroupingSpecification()) {
                return;
            }
            if (!this.validateCriteria()) {
                return;
            }
            super.okPressed();
        }
    }

    public boolean isNoCriteria() {
        return this.noCriteria;
    }
}

