/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.IRetrieveCcsidSession;
import com.ibm.etools.fm.core.model.db2.SessionTemplate2;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.template.dialogs.TemplateMappingDialog;
import com.ibm.etools.fm.editor.template2.ITemplateEditor2;
import com.ibm.etools.fm.editor.template2.TemplateLayoutComposite2TableLayoutProvider;
import com.ibm.etools.fm.editor.template2.dialogs.ByFieldCriteriaSpecificationDialog2;
import com.ibm.etools.fm.editor.template2.dialogs.CcsidSelectionDialog2;
import com.ibm.etools.fm.editor.template2.dialogs.FieldAttributeDialog2;
import com.ibm.etools.fm.editor.template2.dialogs.FreeCriteriaEntryDialog2;
import com.ibm.etools.fm.jhost.core.version.FMFeature;
import com.ibm.etools.fm.model.template.Criteriatype;
import com.ibm.etools.fm.model.template.Db2ADType;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.version.PDFeature;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class TemplateLayoutComposite2 {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(TemplateLayoutComposite2.class);
    private static final int NUMBER_OF_COLUMNS = 12;
    private static final int INDEX_STATUS_COLUMN = 0;
    private static final int INDEX_REFERENCE_COLUMN = 1;
    private static final int INDEX_SEQUENCE_COLUMN = 2;
    private static final int INDEX_HOLD_COLUMN = 3;
    private static final int INDEX_SELECTED_COLUMN = 4;
    private static final int INDEX_NAME_COLUMN = 5;
    private static final int INDEX_DATA_TYPE_COLUMN = 6;
    private static final int INDEX_NULL_COLUMN = 7;
    private static final int INDEX_DEFAULT_COLUMN = 8;
    private static final int INDEX_ORDER_COLUMN = 9;
    private static final int INDEX_AD_COLUMN = 10;
    private static final int INDEX_CCSID_COLUMN = 11;
    private SessionTemplate2 session;
    private TemplateType aTemplate;
    private IZRL aTemplateResource;
    private ITemplateEditor2 editor;
    private Text selCriteriaText;
    private Button selCriteriaBuildButton;
    private Button selCriteriaWritedButton;
    private Button selCriteriaClearButton;
    private TabItem layoutTab;
    private Table fieldTable;
    private TableViewer fieldTableViewer;
    private TableCursor fieldTableCursor;
    private ControlEditor fieldTableCursorEditor;
    private Button specifyAttributeButton;
    private Button setHoldButton;
    private Button setSelectedButton;
    private Button setCcsidButton;
    private Button mappingButton;
    private boolean updateInProgress = false;

    public TemplateLayoutComposite2(SessionTemplate2 session, TemplateType aTemplate, IZRL aTemplateResource, ITemplateEditor2 editor2) {
        this.session = session;
        this.aTemplate = aTemplate;
        this.aTemplateResource = aTemplateResource;
        this.editor = editor2;
    }

    public void createLayoutTab(TabFolder tabFolder) {
        this.layoutTab = new TabItem(tabFolder, 0);
        this.layoutTab.setText(Messages.TE_layoutTabName);
        Composite parent = GUI.composite((Composite)tabFolder, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        Group layoutGroup = GUI.group((Composite)parent, (String)Messages.TE_LAYOUT_DETAILED_INFO, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        Composite layoutInfoComposite = GUI.composite((Composite)layoutGroup, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)layoutInfoComposite, (String)Messages.TE_LAYOUT_SEL_CRITERIA, (Object)GUI.grid.d.left1(), (int)16384);
        this.selCriteriaText = GUI.text.fieldReadOnly((Composite)layoutInfoComposite, (Object)GUI.grid.d.fillH((int)1));
        Composite selButtonsComposite = GUI.composite((Composite)layoutInfoComposite, (Layout)GUI.grid.l.noMargins((int)3, (boolean)false), (Object)GUI.grid.d.left1());
        this.selCriteriaBuildButton = GUI.button.push((Composite)selButtonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaWiz.gif"), (String)Messages.TE_LAYOUT_BuildCriteriaButton_SEL, (Object)GUI.grid.d.left1());
        this.selCriteriaBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateLayoutComposite2.this.buildCriteria();
            }
        });
        this.selCriteriaWritedButton = GUI.button.push((Composite)selButtonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaWriter.gif"), (String)Messages.TE_LAYOUT_WriteCriteriaButton_SEL, (Object)GUI.grid.d.left1());
        this.selCriteriaWritedButton.setImage(FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaWriter.gif"));
        this.selCriteriaWritedButton.setToolTipText(Messages.TE_LAYOUT_WriteCriteriaButton_SEL);
        this.selCriteriaWritedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateLayoutComposite2.this.writeCriteria(TemplateLayoutComposite2.this.selCriteriaText.getText().trim());
            }
        });
        this.selCriteriaClearButton = GUI.button.push((Composite)selButtonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaClear.gif"), (String)Messages.TE_LAYOUT_ClearCriteriaButton_SEL, (Object)GUI.grid.d.left1());
        this.selCriteriaClearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateLayoutComposite2.this.setNoCriteria();
            }
        });
        Composite tableComposite = GUI.composite((Composite)layoutGroup, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.fieldTable = new Table(tableComposite, 68354);
        this.fieldTable.setHeaderVisible(true);
        this.fieldTable.setLinesVisible(true);
        GridData fillAll = GUI.grid.d.fillAll();
        fillAll.heightHint = 300;
        this.fieldTable.setLayoutData((Object)fillAll);
        this.fieldTableViewer = new TableViewer(this.fieldTable);
        this.fieldTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.createFieldColumns(this.fieldTableViewer);
        this.fieldTableCursor = new TableCursor(this.fieldTable, 0);
        this.fieldTableCursor.setFont(JFaceResources.getDefaultFont());
        this.fieldTableCursorEditor = new ControlEditor((Composite)this.fieldTableCursor);
        this.fieldTableCursorEditor.grabHorizontal = true;
        this.fieldTableCursorEditor.grabVertical = true;
        this.addCursorListener();
        this.createDynamicTemplateButtonsComposite(tableComposite);
        this.layoutTab.setControl((Control)parent);
        this.initialiseGUI();
    }

    private void initialiseGUI() {
        this.updateInProgress = true;
        this.setLayoutInformation(0, 0);
        this.updateInProgress = false;
    }

    private static void clearCriteriaSpec(Criteriatype aCriteria) {
        aCriteria.unsetByfield();
        aCriteria.setExp("");
        aCriteria.getByline().clear();
    }

    private void createFieldColumns(TableViewer viewer) {
        FormattedEditorUtility.createTableViewerColumn("", 10, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_COLUMN_NUMBER, 70, viewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_SEQUENCE, 70, viewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_HOLD, 70, viewer, 0x1000000);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_SELECTED, 70, viewer, 0x1000000);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_COLUMN_NAME, 150, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_DATA_TYPE, 250, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_NULL, 70, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_DEFAULT, 70, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_ORDER, 70, viewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_AD, 70, viewer, 131072);
        if (this.aTemplateResource.getSystem().supports((PDFeature)FMFeature.TEMPLATE_FIELD_CCSID)) {
            FormattedEditorUtility.createTableViewerColumn(Messages.CCSID, 70, viewer, 16384);
        }
        viewer.setLabelProvider((IBaseLabelProvider)new TemplateLayoutComposite2TableLayoutProvider(this.aTemplateResource));
    }

    private void addCursorListener() {
        this.fieldTableCursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TemplateLayoutComposite2.this.handleCursorSelection();
            }
        });
        this.fieldTableCursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TemplateLayoutComposite2.this.handleCursorSelection();
            }
        });
        this.fieldTableCursor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Text text2;
                int index = TemplateLayoutComposite2.this.fieldTable.indexOf(TemplateLayoutComposite2.this.fieldTableCursor.getRow());
                if (index != -1) {
                    TemplateLayoutComposite2.this.fieldTable.setSelection(index);
                }
                if (TemplateLayoutComposite2.this.fieldTableCursor.getColumn() == 11 && !Character.isISOControl(e.character) && Character.isDigit(e.character) && (text2 = TemplateLayoutComposite2.this.createCcsidText()) != null) {
                    TemplateLayoutComposite2.this.fieldTableCursorEditor.setEditor((Control)text2);
                    text2.setText("" + e.character);
                    text2.setSelection(1);
                    text2.setFocus();
                }
            }
        });
    }

    private void handleCursorSelection() {
        if (this.updateInProgress) {
            return;
        }
        if (this.fieldTableCursor.getColumn() == 2) {
            Symboltype selectedSymbol;
            int selectionIndex = this.fieldTable.indexOf(this.fieldTableCursor.getRow());
            Layouttype currentLayout = (Layouttype)this.aTemplate.getLayout().get(0);
            Text text2 = this.prepareSequenceEditText(this.fieldTableCursor, currentLayout, selectedSymbol = (Symboltype)currentLayout.getSymbol().get(selectionIndex), selectionIndex);
            if (text2 != null) {
                this.fieldTableCursorEditor.setEditor((Control)text2);
                text2.setFocus();
            }
            return;
        }
        if (this.fieldTableCursor.getColumn() == 3) {
            int selectionIndex = this.fieldTable.indexOf(this.fieldTableCursor.getRow());
            Layouttype currentLayout = (Layouttype)this.aTemplate.getLayout().get(0);
            Symboltype selectedSymbol = (Symboltype)currentLayout.getSymbol().get(selectionIndex);
            if (selectedSymbol.isSetHold()) {
                selectedSymbol.setHold(!selectedSymbol.isHold());
            } else {
                selectedSymbol.setHold(true);
            }
            this.updateInProgress = true;
            this.setLayoutInformation(0, selectionIndex);
            this.updateInProgress = false;
            this.editor.setEditorDirty();
            return;
        }
        if (this.fieldTableCursor.getColumn() == 4) {
            int selectionIndex = this.fieldTable.indexOf(this.fieldTableCursor.getRow());
            Layouttype currentLayout = (Layouttype)this.aTemplate.getLayout().get(0);
            Symboltype selectedSymbol = (Symboltype)currentLayout.getSymbol().get(selectionIndex);
            if (selectedSymbol.isSetSel()) {
                selectedSymbol.setSel(!selectedSymbol.isSel());
            } else {
                selectedSymbol.setSel(true);
            }
            this.updateInProgress = true;
            this.setLayoutInformation(0, selectionIndex);
            this.updateInProgress = false;
            this.editor.setEditorDirty();
            return;
        }
        if (this.fieldTableCursor.getColumn() == 9) {
            Symboltype selectedSymbol;
            int selectionIndex = this.fieldTable.indexOf(this.fieldTableCursor.getRow());
            Layouttype currentLayout = (Layouttype)this.aTemplate.getLayout().get(0);
            Text text3 = this.prepareDb2OrderEditText(this.fieldTableCursor, currentLayout, selectedSymbol = (Symboltype)currentLayout.getSymbol().get(selectionIndex), selectionIndex);
            if (text3 != null) {
                this.fieldTableCursorEditor.setEditor((Control)text3);
                text3.setFocus();
            }
            return;
        }
        if (this.fieldTableCursor.getColumn() == 10) {
            int selectionIndex = this.fieldTable.indexOf(this.fieldTableCursor.getRow());
            Layouttype currentLayout = (Layouttype)this.aTemplate.getLayout().get(0);
            Symboltype selectedSymbol = (Symboltype)currentLayout.getSymbol().get(selectionIndex);
            if (selectedSymbol.getDb2AD() == Db2ADType.A) {
                selectedSymbol.setDb2AD(Db2ADType.D);
            } else {
                selectedSymbol.setDb2AD(Db2ADType.A);
            }
            this.updateInProgress = true;
            this.setLayoutInformation(0, selectionIndex);
            this.updateInProgress = false;
            this.editor.setEditorDirty();
            return;
        }
        if (this.fieldTableCursor.getColumn() == 11) {
            Text text4 = this.createCcsidText();
            if (text4 != null) {
                this.fieldTableCursorEditor.setEditor((Control)text4);
                text4.setFocus();
            }
        } else {
            return;
        }
    }

    private Text prepareSequenceEditText(TableCursor cursor, Layouttype currentLayout, final Symboltype selectedSymbol, final int selectionIndex) {
        final Text text2 = new Text((Composite)cursor, 0);
        text2.setEditable(true);
        NumberForcer nf = NumberForcer.addTo(text2);
        nf.setLowerBound(0, true);
        text2.setFont(JFaceResources.getTextFont());
        if (!selectedSymbol.isSetSeq()) {
            text2.setText("" + TemplateLayoutComposite2.getSmallestUnusedSequenceNumber(currentLayout));
        } else if (selectedSymbol.getSeq() == 0) {
            text2.setText("" + TemplateLayoutComposite2.getSmallestUnusedSequenceNumber(currentLayout));
        } else {
            text2.setText("" + selectedSymbol.getSeq());
        }
        text2.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    int value = 0;
                    value = text2.getText().trim().isEmpty() ? 0 : Integer.parseInt(text2.getText().trim());
                    text2.dispose();
                    selectedSymbol.setSeq(value);
                    TemplateLayoutComposite2.this.updateInProgress = true;
                    TemplateLayoutComposite2.this.setLayoutInformation(0, selectionIndex);
                    TemplateLayoutComposite2.this.updateInProgress = false;
                    TemplateLayoutComposite2.this.editor.setEditorDirty();
                } else if (e.character == '\u001b') {
                    text2.dispose();
                }
            }
        });
        text2.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                int value = 0;
                value = text2.getText().trim().isEmpty() ? 0 : Integer.parseInt(text2.getText().trim());
                text2.dispose();
                selectedSymbol.setSeq(value);
                TemplateLayoutComposite2.this.updateInProgress = true;
                TemplateLayoutComposite2.this.setLayoutInformation(0, selectionIndex);
                TemplateLayoutComposite2.this.updateInProgress = false;
                TemplateLayoutComposite2.this.editor.setEditorDirty();
            }
        });
        return text2;
    }

    private Text prepareDb2OrderEditText(TableCursor cursor, Layouttype currentLayout, final Symboltype selectedSymbol, final int selectionIndex) {
        final Text text2 = new Text((Composite)cursor, 0);
        text2.setEditable(true);
        NumberForcer nf = NumberForcer.addTo(text2);
        nf.setLowerBound(0, true);
        text2.setFont(JFaceResources.getTextFont());
        if (selectedSymbol.isSetDb2ord()) {
            text2.setText("" + selectedSymbol.getDb2ord());
        } else {
            text2.setText("" + TemplateLayoutComposite2.getSmallestUnusedOrderNumber(currentLayout));
        }
        text2.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    int value = 0;
                    value = text2.getText().trim().isEmpty() ? 0 : Integer.parseInt(text2.getText().trim());
                    text2.dispose();
                    selectedSymbol.setDb2ord(value);
                    TemplateLayoutComposite2.this.updateInProgress = true;
                    TemplateLayoutComposite2.this.setLayoutInformation(0, selectionIndex);
                    TemplateLayoutComposite2.this.updateInProgress = false;
                    TemplateLayoutComposite2.this.editor.setEditorDirty();
                } else if (e.character == '\u001b') {
                    text2.dispose();
                }
            }
        });
        text2.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                int value = 0;
                value = text2.getText().trim().isEmpty() ? 0 : Integer.parseInt(text2.getText().trim());
                text2.dispose();
                selectedSymbol.setDb2ord(value);
                TemplateLayoutComposite2.this.updateInProgress = true;
                TemplateLayoutComposite2.this.setLayoutInformation(0, selectionIndex);
                TemplateLayoutComposite2.this.updateInProgress = false;
                TemplateLayoutComposite2.this.editor.setEditorDirty();
            }
        });
        return text2;
    }

    private static int getSmallestUnusedSequenceNumber(Layouttype aLayout) {
        Objects.requireNonNull(aLayout, "Must provide a non-null aLayout");
        int i = 0;
        while (i < aLayout.getSymbol().size()) {
            if (!TemplateLayoutComposite2.isIndexUsed(aLayout, i + 1)) {
                return i + 1;
            }
            ++i;
        }
        return aLayout.getSymbol().size();
    }

    private static boolean isIndexUsed(Layouttype aLayout, int index) {
        int i = 0;
        while (i < aLayout.getSymbol().size()) {
            Symboltype aSymbol = (Symboltype)aLayout.getSymbol().get(i);
            if (aSymbol.isSetSeq() && aSymbol.getSeq() == index) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static int getSmallestUnusedOrderNumber(Layouttype aLayout) {
        Objects.requireNonNull(aLayout, "Must provide a non-null aLayout");
        int i = 0;
        while (i < aLayout.getSymbol().size()) {
            if (!TemplateLayoutComposite2.isOrderIndexUsed(aLayout, i + 1)) {
                return i + 1;
            }
            ++i;
        }
        return aLayout.getSymbol().size();
    }

    private static boolean isOrderIndexUsed(Layouttype aLayout, int index) {
        int i = 0;
        while (i < aLayout.getSymbol().size()) {
            Symboltype aSymbol = (Symboltype)aLayout.getSymbol().get(i);
            if (aSymbol.isSetDb2ord() && aSymbol.getDb2ord() == index) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String[] getLayoutNames(TemplateType aTemplate, IPDHost pdHost) {
        Objects.requireNonNull(aTemplate, "Must provide a non-null aTemplate");
        String[] layoutNames = new String[aTemplate.getLayout().size()];
        EList layouts = aTemplate.getLayout();
        int i = 0;
        while (i < layouts.size()) {
            Layouttype aLayout = (Layouttype)layouts.get(i);
            EList symbols = aLayout.getSymbol();
            layoutNames[i] = ((Symboltype)symbols.get(0)).getName(pdHost);
            ++i;
        }
        return layoutNames;
    }

    private void setLayoutInformation(int layoutIndex, int rowSelectionIndex) {
        EList criteriaList;
        EList layouts = this.aTemplate.getLayout();
        if (layoutIndex >= layouts.size()) {
            String errMsg = MessageFormat.format(Messages.TE_InvalidLayoutIndex, layoutIndex, layouts.size(), this.aTemplateResource.getFormattedName());
            PDDialogs.openErrorThreadSafe((String)errMsg);
            logger.error((Object)errMsg);
            return;
        }
        Layouttype aLayout = (Layouttype)layouts.get(layoutIndex);
        this.justUpdateLayoutTableContents(aLayout);
        if (this.fieldTable.getItemCount() > 0) {
            if (rowSelectionIndex < this.fieldTable.getItemCount()) {
                this.fieldTable.setSelection(rowSelectionIndex);
                currentColumn = this.fieldTableCursor.isVisible() ? this.fieldTableCursor.getColumn() : 2;
                this.fieldTableCursor.setSelection(rowSelectionIndex, currentColumn);
            } else {
                this.fieldTable.setSelection(0);
                currentColumn = this.fieldTableCursor.isVisible() ? this.fieldTableCursor.getColumn() : 2;
                this.fieldTableCursor.setSelection(0, currentColumn);
            }
        }
        if ((criteriaList = aLayout.getCriteria()) != null && criteriaList.size() > 0) {
            for (Criteriatype aCriteria : criteriaList) {
                this.selCriteriaText.setText(aCriteria.getExp());
            }
        }
    }

    private void justUpdateLayoutTableContents(Layouttype aLayout) {
        this.fieldTableViewer.setInput((Object)aLayout.getSymbol());
        this.fieldTable.setSelection(this.fieldTable.getSelectionIndices());
    }

    private void buildCriteria() {
        Layouttype aLayout = (Layouttype)this.aTemplate.getLayout().get(0);
        Criteriatype currentCriteria = null;
        if (aLayout.getCriteria() != null && aLayout.getCriteria().size() > 0) {
            currentCriteria = (Criteriatype)aLayout.getCriteria().get(0);
        }
        if (!(currentCriteria == null || currentCriteria.isSetByfield() && currentCriteria.isByfield() || PDDialogs.openConfirm((String)Messages.TE_CriteriaChangeConfirm, (String)Messages.TE_FreeToByFieldWarning))) {
            return;
        }
        ByFieldCriteriaSpecificationDialog2 dialog = new ByFieldCriteriaSpecificationDialog2(this.session, (DataSetOrMember)this.aTemplateResource, this.aTemplate);
        if (dialog.open() != 0) {
            return;
        }
        if (dialog.isNoCriteria()) {
            this.setNoCriteria();
            return;
        }
        TemplateType templateWithNewCriteria = dialog.getTemplateWithNewCriteria();
        this.updateCriteria(templateWithNewCriteria);
        this.updateInProgress = true;
        this.setLayoutInformation(0, this.fieldTable.getSelectionIndex());
        this.updateInProgress = false;
        this.editor.setEditorDirty();
    }

    private void updateCriteria(TemplateType templateWithNewCriteria) {
        int i = 0;
        while (i < templateWithNewCriteria.getLayout().size()) {
            Layouttype aLayout = (Layouttype)templateWithNewCriteria.getLayout().get(i);
            this.updateCriteriaForLayout(aLayout);
            ++i;
        }
    }

    private void updateCriteriaForLayout(Layouttype newLayout) {
        int i = 0;
        while (i < this.aTemplate.getLayout().size()) {
            Layouttype aLayout = (Layouttype)this.aTemplate.getLayout().get(i);
            if (aLayout.getId() == newLayout.getId()) {
                aLayout.getCriteria().clear();
                aLayout.getCriteria().addAll((Collection)newLayout.getCriteria());
                return;
            }
            ++i;
        }
    }

    private void writeCriteria(String initValue) {
        Criteriatype currentCriteria = null;
        if (((Layouttype)this.aTemplate.getLayout().get(0)).getCriteria() != null && ((Layouttype)this.aTemplate.getLayout().get(0)).getCriteria().size() > 0) {
            currentCriteria = (Criteriatype)((Layouttype)this.aTemplate.getLayout().get(0)).getCriteria().get(0);
        }
        if (currentCriteria != null && currentCriteria.isSetByfield() && currentCriteria.isByfield() && !PDDialogs.openConfirm((String)Messages.TE_CriteriaChangeConfirm, (String)Messages.TE_ByFieldToFreeWarning)) {
            return;
        }
        FreeCriteriaEntryDialog2 dialog = new FreeCriteriaEntryDialog2(this.session, (DataSetOrMember)this.aTemplateResource, this.aTemplate, initValue);
        if (dialog.open() != 0) {
            return;
        }
        if (dialog.isEmptyCriteria()) {
            this.setNoCriteria();
            return;
        }
        TemplateType templateWithNewCriteria = dialog.getTemplateWithNewCriteria();
        this.updateCriteria(templateWithNewCriteria);
        this.updateInProgress = true;
        this.setLayoutInformation(0, this.fieldTable.getSelectionIndex());
        this.updateInProgress = false;
        this.editor.setEditorDirty();
    }

    private void setNoCriteria() {
        Layouttype currentLayout = (Layouttype)this.aTemplate.getLayout().get(0);
        EList criteriaList = currentLayout.getCriteria();
        int i = 0;
        while (i < criteriaList.size()) {
            Criteriatype aCriteria = (Criteriatype)criteriaList.get(i);
            TemplateLayoutComposite2.clearCriteriaSpec(aCriteria);
            this.editor.setEditorDirty();
            this.selCriteriaText.setText("");
            ++i;
        }
    }

    private void createDynamicTemplateButtonsComposite(Composite parent) {
        Composite controlComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.left1());
        GridData buttonsGrid = GUI.grid.d.left1();
        this.specifyAttributeButton = GUI.button.push((Composite)controlComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/attributes.gif"), (String)Messages.TE_LAYOUT_SpecifyAttrButtonTip, (Object)buttonsGrid);
        this.specifyAttributeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int fieldIndex = TemplateLayoutComposite2.this.getSelectedFieldIndex();
                if (fieldIndex == -1) {
                    PDDialogs.openInfoThreadSafe((String)Messages.TE_LAYOUT_NoFieldSelForAction);
                    return;
                }
                Layouttype currentLayout = (Layouttype)TemplateLayoutComposite2.this.aTemplate.getLayout().get(0);
                FieldAttributeDialog2 dialog = new FieldAttributeDialog2(TemplateLayoutComposite2.this.session, (DataSetOrMember)TemplateLayoutComposite2.this.aTemplateResource, TemplateLayoutComposite2.this.aTemplate, currentLayout, fieldIndex, false);
                if (dialog.open() != 0) {
                    if (dialog.validationErrorOccurred()) {
                        TemplateLayoutComposite2.this.editor.setEditorDirty();
                    }
                    return;
                }
                TemplateLayoutComposite2.this.editor.setEditorDirty();
            }
        });
        this.setHoldButton = GUI.button.push((Composite)controlComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/hold.gif"), (String)Messages.TE_LAYOUT_SetHoldTip, (Object)buttonsGrid);
        this.setHoldButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] selection = TemplateLayoutComposite2.this.fieldTable.getSelectionIndices();
                if (selection == null || selection.length == 0) {
                    return;
                }
                Layouttype currentLayout = (Layouttype)TemplateLayoutComposite2.this.aTemplate.getLayout().get(0);
                EList symbols = currentLayout.getSymbol();
                int i = 0;
                while (i < selection.length) {
                    Symboltype aSymbol = (Symboltype)symbols.get(selection[i]);
                    if (aSymbol.isSetHold() && aSymbol.isHold()) {
                        aSymbol.setHold(false);
                    } else {
                        aSymbol.setHold(true);
                    }
                    ++i;
                }
                TemplateLayoutComposite2.this.updateInProgress = true;
                TemplateLayoutComposite2.this.justUpdateLayoutTableContents(currentLayout);
                TemplateLayoutComposite2.this.updateInProgress = false;
                TemplateLayoutComposite2.this.editor.setEditorDirty();
            }
        });
        this.setSelectedButton = GUI.button.push((Composite)controlComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/selection.gif"), (String)Messages.TE_LAYOUT_SetSelectedTip, (Object)buttonsGrid);
        this.setSelectedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] selection = TemplateLayoutComposite2.this.fieldTable.getSelectionIndices();
                if (selection == null || selection.length == 0) {
                    return;
                }
                Layouttype currentLayout = (Layouttype)TemplateLayoutComposite2.this.aTemplate.getLayout().get(0);
                EList symbols = currentLayout.getSymbol();
                int i = 0;
                while (i < selection.length) {
                    Symboltype aSymbol = (Symboltype)symbols.get(selection[i]);
                    if (aSymbol.isSetSel() && aSymbol.isSel()) {
                        aSymbol.setSel(false);
                    } else {
                        aSymbol.setSel(true);
                    }
                    ++i;
                }
                TemplateLayoutComposite2.this.updateInProgress = true;
                TemplateLayoutComposite2.this.justUpdateLayoutTableContents(currentLayout);
                TemplateLayoutComposite2.this.updateInProgress = false;
                TemplateLayoutComposite2.this.editor.setEditorDirty();
            }
        });
        if (this.aTemplateResource.getSystem().supports((PDFeature)FMFeature.TEMPLATE_FIELD_CCSID)) {
            this.setCcsidButton = GUI.button.push((Composite)controlComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/encoding.gif"), (String)Messages.TemplateLayoutComposite_9, (Object)GUI.grid.d.left1());
            this.setCcsidButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Layouttype currentLayout = (Layouttype)TemplateLayoutComposite2.this.aTemplate.getLayout().get(0);
                    CcsidSelectionDialog2 dialog = new CcsidSelectionDialog2((IRetrieveCcsidSession)TemplateLayoutComposite2.this.session, TemplateLayoutComposite2.this.aTemplateResource.getSystem(), currentLayout, TemplateLayoutComposite2.this.fieldTable.getSelectionIndices());
                    if (dialog.open() != 0) {
                        return;
                    }
                    TemplateLayoutComposite2.this.updateInProgress = true;
                    TemplateLayoutComposite2.this.justUpdateLayoutTableContents(currentLayout);
                    TemplateLayoutComposite2.this.updateInProgress = false;
                    TemplateLayoutComposite2.this.editor.setEditorDirty();
                }
            });
        }
        this.mappingButton = GUI.button.push((Composite)controlComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/map.gif"), (String)Messages.TE_LAYOUT_fieldMapButtonTip, (Object)GUI.grid.d.left1());
        this.mappingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateLayoutComposite2.this.editor.isDirty() && !PDDialogs.openConfirm((String)Messages.Confirm, (String)Messages.TE_LAYOUT_editorDirtyBeforeMapping)) {
                    return;
                }
                TemplateMappingDialog dialog = new TemplateMappingDialog(null, TemplateLayoutComposite2.this.aTemplateResource);
                if (dialog.open() != 0) {
                    return;
                }
                TemplateType newTemplate = dialog.getToTemplateIfModified();
                if (newTemplate != null) {
                    TemplateLayoutComposite2.this.editor.updateTemplate(newTemplate);
                }
            }
        });
    }

    private int getSelectedFieldIndex() {
        if (this.fieldTableCursor.isVisible() && this.fieldTableCursor.getRow() != null) {
            int fieldIndex = -1;
            fieldIndex = this.fieldTable.indexOf(this.fieldTableCursor.getRow());
            if (fieldIndex == -1) {
                fieldIndex = this.fieldTable.getSelectionIndex();
            }
            return fieldIndex;
        }
        return this.fieldTable.getSelectionIndex();
    }

    public void setNewTemplate(TemplateType newTemplate) {
        this.aTemplate = newTemplate;
        this.initialiseGUI();
    }

    private Text createCcsidText() {
        final Text text2 = new Text((Composite)this.fieldTableCursor, 0);
        text2.setFont(JFaceResources.getTextFont());
        text2.setFocus();
        text2.setText(this.fieldTableCursor.getRow().getText(this.fieldTableCursor.getColumn()));
        text2.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    TemplateLayoutComposite2.this.updateCcsid(text2);
                    text2.dispose();
                } else if (e.keyCode == 27) {
                    text2.dispose();
                }
            }
        });
        text2.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent ve) {
                if (!Character.isISOControl(ve.character)) {
                    ve.doit = Character.isDigit(ve.character);
                }
            }
        });
        text2.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TemplateLayoutComposite2.this.updateCcsid(text2);
                text2.dispose();
            }
        });
        return text2;
    }

    private void updateCcsid(Text text2) {
        int selectionIndex = this.fieldTable.indexOf(this.fieldTableCursor.getRow());
        String newValue = text2.getText().trim();
        ((Symboltype)((Layouttype)this.aTemplate.getLayout().get(0)).getSymbol().get(selectionIndex)).setCcsid(newValue);
        ((Symboltype)((Layouttype)this.aTemplate.getLayout().get(0)).getSymbol().get(selectionIndex)).setCcside(null);
        text2.dispose();
        this.updateInProgress = true;
        this.setLayoutInformation(0, selectionIndex);
        this.updateInProgress = false;
        this.editor.setEditorDirty();
    }
}

