/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.db2.Db2TemplateOptions;
import com.ibm.etools.fm.core.model.db2.SessionTemplate2;
import com.ibm.etools.fm.editor.template2.FMTemplateEditorInput2;
import com.ibm.etools.fm.editor.template2.ITemplateEditor2;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.MemberPresence;
import com.ibm.etools.fm.ui.dialog.TemplateResourceSaveAsDialog;
import com.ibm.etools.fm.ui.util.EditorManagement;
import com.ibm.etools.fm.ui.util.ZrlLoaderDialogUtils;
import com.ibm.etools.fm.ui.views.systems.handlers.OpenTemplate;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsTreeUpdater;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public class TemplateEditorUtilities2 {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public static Result<StringBuffer> updateTemplate(IHowIsGoing monitor, boolean updateFromCopybooks, final TemplateType currentTemplate, final IZRL aTemplateResource, final SessionTemplate2 session, final StringBuffer newXmlTemplateContents) throws CoreException, InterruptedException, InvocationTargetException {
        if (updateFromCopybooks) {
            currentTemplate.getLayout().clear();
        }
        if (monitor != null) {
            Result result = new Result();
            StringBuffer xmlTemplate = TemplateSerializeUtils.save((TemplateType)currentTemplate, (IZRL)aTemplateResource);
            StringBuffer newXmlTemplate = session.updateTemplate(xmlTemplate, monitor, result, true, false);
            if (!result.isSuccessfulWithoutWarnings()) {
                monitor.done();
                return result;
            }
            newXmlTemplateContents.append(newXmlTemplate.toString());
            return result;
        }
        final Result overallResult = new Result();
        PlatformUI.getWorkbench().getProgressService().run(false, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(MessageFormat.format(Messages.TemplateEditor_UPDATE_TEMPLATE_IN_PROGRESS, aTemplateResource.getFormattedName()), 1);
                IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                try {
                    Result result = new Result();
                    StringBuffer xmlTemplate = TemplateSerializeUtils.save((TemplateType)currentTemplate, (IZRL)aTemplateResource);
                    StringBuffer newXmlTemplate = session.updateTemplate(xmlTemplate, howIsGoing, result, true, false);
                    overallResult.addSubResult(result);
                    if (!result.isSuccessfulWithoutWarnings()) {
                        monitor.done();
                        return;
                    }
                    newXmlTemplateContents.append(newXmlTemplate.toString());
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
                monitor.done();
            }
        });
        return overallResult;
    }

    public static Result<StringBuffer> doSave(ITemplateEditor2 templateEditor, final SessionTemplate2 session, final DataSetOrMember aTemplate, final TemplateType currentTemplate, final StringBuffer templateContentsAfterSave, boolean fromDialog, final PDLogger logger) {
        Objects.requireNonNull(session, "Must provide a non-null session.");
        final Result overallResult = new Result((Object)new StringBuffer());
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.TemplateEditor_SAVE_IN_PROGRESS, aTemplate.getFormattedName()), 2);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    try {
                        Result updateResult = new Result();
                        StringBuffer xmlTemplate = TemplateSerializeUtils.save((TemplateType)currentTemplate, (IZRL)aTemplate);
                        session.updateTemplate(xmlTemplate, howIsGoing, updateResult, false, false);
                        overallResult.addSubResult(updateResult);
                        if (!updateResult.isSuccessfulWithoutWarnings()) {
                            PDDialogs.openErrorThreadSafe((String)Messages.TE_UpdateErrWhileSave, (String)updateResult.dumpOutputAndMessages(true));
                            return;
                        }
                        Result saveResult = session.save(howIsGoing);
                        overallResult.addSubResult(saveResult);
                        if (saveResult.getRC() > 4) {
                            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.TemplateEditor_SAVE_ERR_MSG, aTemplate.getFormattedName()), (String)saveResult.getMessagesCombined().toString());
                            return;
                        }
                        Result loadCurrentResult = new Result();
                        StringBuffer latestXMLContents = session.getCurrentTemplateContents(PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor), loadCurrentResult);
                        overallResult.addSubResult(loadCurrentResult);
                        if (!loadCurrentResult.isSuccessfulWithoutWarnings()) {
                            PDDialogs.openErrorThreadSafe((String)Messages.TE_ErrGetLatestAfterSave, (String)loadCurrentResult.dumpOutputAndMessages(true));
                            return;
                        }
                        templateContentsAfterSave.append(latestXMLContents.toString());
                    }
                    catch (CoreException e1) {
                        overallResult.add((Throwable)e1);
                        overallResult.setRC(8);
                        String errMsg = Messages.TemplateEditorAction_EX;
                        logger.error((Object)errMsg, (Throwable)e1);
                        PDDialogs.openErrorThreadSafe((String)errMsg);
                        return;
                    }
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            PDDialogs.openErrorThreadSafe((String)Messages.TemplateEditor_SAVE_EX, (Throwable)e);
            overallResult.add(e);
            overallResult.setRC(8);
            return overallResult;
        }
        catch (InterruptedException e) {
            PDDialogs.openInfoThreadSafe((String)Messages.TemplateEditor_ACTION_CANCEL);
            overallResult.add((Throwable)e);
            overallResult.setRC(8);
            return overallResult;
        }
        return overallResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Result<StringBuffer> doSaveAs(final ITemplateEditor2 templateEditor, final SessionTemplate2 session, final DataSetOrMember aTemplate, final TemplateType currentTemplate, StringBuffer templateContentsAfterSave, final boolean fromDialog, final PDLogger logger) {
        IZRL target;
        IPDHost host;
        DataSetOrMember templateResource;
        block16: {
            Objects.requireNonNull(session, "Must provide a non-null session.");
            templateResource = aTemplate;
            host = session.getSystem();
            TemplateResourceSaveAsDialog dialog = new TemplateResourceSaveAsDialog(host, (IZRL)aTemplate, MemberPresence.Required);
            if (dialog.open() != 0) {
                return null;
            }
            target = dialog.getSelectedResource();
            if (templateResource.getFormattedName().equals(target.getFormattedName())) {
                if (!PDDialogs.openQuestion((String)Messages.TemplateEditor_SAVE_AS_SAME_TARGET)) return TemplateEditorUtilities2.doSaveAs(templateEditor, session, aTemplate, currentTemplate, templateContentsAfterSave, fromDialog, logger);
                return TemplateEditorUtilities2.doSave(templateEditor, session, aTemplate, currentTemplate, templateContentsAfterSave, fromDialog, logger);
            }
            if (FMUIPlugin.getDefault().templateEditSessionExist(target)) {
                PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.TemplateEditor_DUP_EDIT, target.getFormattedName()));
                return null;
            }
            try {
                Result<StringBuffer> checkDataSetResult = ZrlLoaderDialogUtils.retrieveInformation(target);
                if (!checkDataSetResult.isSuccessfulWithoutWarnings()) {
                    PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.TemplateEditor_SAVE_AS_TARGET_ERR, target.getFormattedName()), (String)checkDataSetResult.getMessagesCombined().toString());
                    return null;
                }
                if (target instanceof DataSetOrMember) {
                    DataSetOrMember dsom = (DataSetOrMember)target;
                    if (dsom.getConfirmedExists() && !PDDialogs.openQuestion((String)MessageFormat.format(Messages.TemplateEditor_SAVE_AS_TARGET_EXIST, target.getFormattedName()))) {
                        return null;
                    }
                    break block16;
                }
                if (!(target instanceof UssFile)) {
                    throw new IllegalArgumentException(MessageFormat.format(Messages.TemplateEditorUtilities2_1, target.getFormattedName()));
                }
                UssFile ussFile = (UssFile)target;
                if (ussFile.getConfirmedExists()) {
                    if (!PDDialogs.openQuestion((String)MessageFormat.format(Messages.TemplateEditor_SAVE_AS_TARGET_EXIST, target.getFormattedName()))) {
                        return null;
                    }
                } else if (ussFile.isDirectory()) {
                    PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.TemplateEditorUtilities2_0, target.getFormattedName()));
                    return null;
                }
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        final Result overallResult = new Result();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.TemplateEditor_SAVE_AS_IN_PROGRESS, target.getFormattedName()), 2);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    if (templateEditor.isDirty()) {
                        try {
                            Result result = new Result();
                            StringBuffer xmlTemplate = TemplateSerializeUtils.save((TemplateType)currentTemplate, (IZRL)aTemplate);
                            session.updateTemplate(xmlTemplate, howIsGoing, result, false, false);
                            overallResult.addSubResult(result);
                            if (!result.isSuccessfulWithoutWarnings()) {
                                return;
                            }
                        }
                        catch (CoreException e1) {
                            overallResult.add((Throwable)e1);
                            overallResult.setRC(8);
                            String errMsg = Messages.TemplateEditorAction_EX;
                            logger.error((Object)errMsg, (Throwable)e1);
                            PDDialogs.openErrorThreadSafe((String)errMsg);
                            return;
                        }
                    }
                    Result saveAsResult = new Result((Object)new StringBuffer());
                    session.saveAs(target, howIsGoing, saveAsResult);
                    overallResult.addSubResult(saveAsResult);
                    IFile newTemplateFile = session.getFromCacheFile();
                    if (newTemplateFile == null || !saveAsResult.isSuccessfulWithoutWarnings()) {
                        PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.TemplateEditor_SAVE_AS_ERR_MSG, target.getFormattedName(), host.getConnectionName()), (String)saveAsResult.getMessagesCombined().toString());
                        return;
                    }
                    FMTemplateEditorInput2 fmiInput = new FMTemplateEditorInput2(newTemplateFile, target, session, true, null, -1);
                    EditorManagement.openTemplateEditorFromWorkerThread(newTemplateFile, fmiInput, monitor, fromDialog);
                    FMUIPlugin.getDefault().addNewTemplateEditSession(target);
                    FMUIPlugin.getDefault().removeTemplateEditSession((IZRL)templateResource);
                    PDSystemsTreeUpdater.refreshAllRelatedTo((Object)target);
                }
            });
            return overallResult;
        }
        catch (InvocationTargetException e) {
            PDDialogs.openErrorThreadSafe((String)Messages.TemplateEditorAction_EX, (Throwable)e);
            overallResult.add(e);
            overallResult.setRC(8);
            return overallResult;
        }
        catch (InterruptedException e) {
            PDDialogs.openInfoThreadSafe((String)Messages.TemplateEditorAction_CACELLED);
            overallResult.add((Throwable)e);
            overallResult.setRC(8);
            return overallResult;
        }
    }

    public static void openTemplateEditSession(Db2TemplateOptions options) {
        Objects.requireNonNull(options, "Must specify a non-null options.");
        OpenTemplate.openTemplateEditor2(options);
    }

    public static void end(final SessionTemplate2 sessionToClose) {
        block4: {
            try {
                PlatformUI.getWorkbench().getProgressService().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.EndTemplateSession_0, 2);
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        monitor.worked(1);
                        if (sessionToClose == null) {
                            monitor.done();
                            return;
                        }
                        sessionToClose.end(howIsGoing);
                        monitor.worked(1);
                        monitor.done();
                    }
                });
            }
            catch (Exception e) {
                if (sessionToClose == null) break block4;
                try {
                    sessionToClose.closeConnection();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

