/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.db2.SessionTemplate2;
import com.ibm.etools.fm.editor.template2.FMTemplateEditorInput2;
import com.ibm.etools.fm.editor.template2.ITemplateEditor2;
import com.ibm.etools.fm.editor.template2.TemplateEditorUtilities2;
import com.ibm.etools.fm.editor.template2.TemplateInfoComposite2;
import com.ibm.etools.fm.editor.template2.TemplateLayoutComposite2;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.util.EditorManagement;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;

public class TemplateEditorDialog2
extends BaseTitleAreaDialog
implements ITemplateEditor2 {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(TemplateEditorDialog2.class);
    private FMTemplateEditorInput2 fmEditorInput;
    private SessionTemplate2 session;
    private boolean saveAsClosure = false;
    private boolean openInEditorClosure = false;
    private TabFolder tabFolder;
    private TemplateLayoutComposite2 layoutComposite;
    private TemplateInfoComposite2 infoComposite;
    private Button okButton;
    private Button cancelButton;
    private Button saveButton;
    private Button saveAsButton;
    private Button editorButton;

    public TemplateEditorDialog2(FMTemplateEditorInput2 input) {
        this.fmEditorInput = input;
    }

    public int open() {
        IFile localFile = this.fmEditorInput.getFile();
        DataSetOrMember zosResource = (DataSetOrMember)this.fmEditorInput.getResource();
        this.session = this.fmEditorInput.getSessionIdentifer();
        if (localFile == null) {
            FMUIPlugin.getDefault().removeTemplateEditSession(this.fmEditorInput.getResource());
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.TE_NoCachedFile, zosResource.getFormattedName()));
            this.close();
            return 1;
        }
        if (this.fmEditorInput.getLoadedTemplate() == null) {
            try {
                this.fmEditorInput.setTemplate(TemplateSerializeUtils.load((IFile)localFile, (IZRL)this.getTemplateResource()));
            }
            catch (Exception e) {
                FMUIPlugin.getDefault().removeTemplateEditSession(this.fmEditorInput.getResource());
                String errMsg = MessageFormat.format(Messages.TE_TemplateOpenError, this.fmEditorInput.getName());
                PDDialogs.openErrorThreadSafe((String)errMsg);
                logger.error((Object)errMsg, (Throwable)e);
                this.close();
                return 1;
            }
        } else if (this.fmEditorInput.isDirty()) {
            this.setEditorDirty();
        }
        if (this.fmEditorInput.getLoadedTemplate() != null && !"DB2".equals(this.fmEditorInput.getLoadedTemplate().getType())) {
            FMUIPlugin.getDefault().removeTemplateEditSession(this.fmEditorInput.getResource());
            String errMsg = MessageFormat.format(Messages.TemplateEditor_TypeNotSupportede, this.fmEditorInput.getName(), this.fmEditorInput.getLoadedTemplate().getType());
            PDDialogs.openErrorThreadSafe((String)errMsg);
            this.close();
            return 1;
        }
        return super.open();
    }

    public DataSetOrMember getTemplateResource() {
        return (DataSetOrMember)this.fmEditorInput.getResource();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(MessageFormat.format(Messages.TemplateEditor_DialogTitle, this.getTemplateResource().getSystem(), this.getTemplateResource().getFormattedName()));
        this.setMessage(Messages.TemplateEditor_DialogMsg);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.tabFolder = new TabFolder(composite, 128);
        this.tabFolder.setLayoutData((Object)GUI.grid.d.fillAll());
        this.layoutComposite = new TemplateLayoutComposite2(this.session, this.fmEditorInput.getLoadedTemplate(), this.fmEditorInput.getResource(), this);
        this.layoutComposite.createLayoutTab(this.tabFolder);
        this.infoComposite = new TemplateInfoComposite2(this, this.fmEditorInput.getLoadedTemplate());
        this.infoComposite.createInfoTab(this.tabFolder);
        return composite;
    }

    @Override
    public boolean isDirty() {
        return this.fmEditorInput.isDirty();
    }

    @Override
    public void setEditorDirty() {
        this.setTitle(MessageFormat.format(Messages.TemplateEditor_DialogTitleDirty, this.getTemplateResource().getSystem(), this.getTemplateResource().getFormattedName()));
        this.fmEditorInput.setDirty(true);
    }

    public void setEditorDirty(boolean dirty) {
        this.fmEditorInput.setDirty(dirty);
        if (this.fmEditorInput.isDirty()) {
            this.setTitle(MessageFormat.format(Messages.TemplateEditor_DialogTitleDirty, this.getTemplateResource().getSystem(), this.getTemplateResource().getFormattedName()));
        } else {
            this.setTitle(MessageFormat.format(Messages.TemplateEditor_DialogTitle, this.getTemplateResource().getSystem(), this.getTemplateResource().getFormattedName()));
        }
    }

    @Override
    public void refreshGUI() {
        this.layoutComposite.setNewTemplate(this.fmEditorInput.getLoadedTemplate());
        this.infoComposite.setNewTemplate(this.fmEditorInput.getLoadedTemplate());
    }

    @Override
    public void updateTemplate(TemplateType newTemplate) {
        if (newTemplate == null) {
            return;
        }
        this.fmEditorInput.setTemplate(newTemplate);
        this.refreshGUI();
        this.setEditorDirty();
    }

    @Override
    public Result<StringBuffer> updateTemplate(IHowIsGoing monitor, boolean updateFromCopybooks) throws CoreException, InterruptedException, InvocationTargetException {
        StringBuffer newTemplateContents = new StringBuffer();
        Result<StringBuffer> result = TemplateEditorUtilities2.updateTemplate(monitor, updateFromCopybooks, this.fmEditorInput.getLoadedTemplate(), (IZRL)this.getTemplateResource(), this.session, newTemplateContents);
        if (!result.isSuccessfulWithoutWarnings()) {
            return result;
        }
        this.fmEditorInput.setTemplate(TemplateSerializeUtils.load((StringBuffer)newTemplateContents, (IZRL)this.getTemplateResource()));
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData data = new GridData();
        data.widthHint = 100;
        this.okButton = GUI.button.push((Composite)parent, (String)JFaceResources.getString((String)"ok"), (Object)data, (String)Messages.TemplateEditor_OK_TIP);
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TemplateEditorDialog2.this.okPressed();
            }
        });
        this.cancelButton = GUI.button.push((Composite)parent, (String)JFaceResources.getString((String)"cancel"), (Object)data, (String)Messages.TemplateEditor_CANCEL_TIP);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TemplateEditorDialog2.this.cancelPressed();
            }
        });
        this.saveButton = GUI.button.push((Composite)parent, (String)Messages.TemplateEditor_SAVE, (Object)data, (String)Messages.TemplateEditor_SAVE_TIP);
        this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateEditorDialog2.this.doSave();
            }
        });
        this.saveAsButton = GUI.button.push((Composite)parent, (String)Messages.TemplateEditor_SAVEAS, (Object)data, (String)Messages.TemplateEditor_SAVEAS_TIP);
        this.saveAsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateEditorDialog2.this.doSaveAs();
            }
        });
        this.editorButton = GUI.button.push((Composite)parent, (String)Messages.TemplateEditor_EditorOpen, (Object)data, (String)Messages.TemplateEditor_EditorOpen_TIP);
        this.editorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateEditorDialog2.this.fmEditorInput.setInitialLayoutIndex(0);
                EditorManagement.openTemplateEditorFromWorkerThread(TemplateEditorDialog2.this.session.getFromCacheFile(), TemplateEditorDialog2.this.fmEditorInput, (IProgressMonitor)new NullProgressMonitor(), false);
                TemplateEditorDialog2.this.openInEditorClosure = true;
                TemplateEditorDialog2.this.close();
            }
        });
        this.getShell().setDefaultButton(this.okButton);
    }

    protected void okPressed() {
        if (this.isDirty()) {
            this.doSave();
        }
        super.okPressed();
    }

    public boolean close() {
        if (!this.openInEditorClosure) {
            FMUIPlugin.getDefault().removeTemplateEditSession(this.fmEditorInput.getResource());
            try {
                this.session.deleteCache();
                if (!this.saveAsClosure) {
                    TemplateEditorUtilities2.end(this.session);
                }
            }
            catch (Exception e) {
                PDDialogs.openErrorThreadSafe((String)Messages.TemplateEditor_DISPOSE_ERR);
                logger.error((Object)"Failed to properly dispose of template editor", (Throwable)e);
            }
        }
        return super.close();
    }

    protected void cancelPressed() {
        if (this.isDirty() && !PDDialogs.openConfirm((String)Messages.Confirm, (String)Messages.TemplateEditor_DialogCancelConfirm)) {
            return;
        }
        super.cancelPressed();
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = GUI.composite((Composite)parent, (Layout)GUI.grid.l.customMargins((int)5, (boolean)false, (int)10, (int)15), (Object)new GridData(0x1000008, 4, true, false));
        this.createButtonsForButtonBar(buttonBar);
        return buttonBar;
    }

    public void doSave() {
        StringBuffer latestXMLContents = new StringBuffer();
        Result<StringBuffer> result = TemplateEditorUtilities2.doSave(this, this.session, this.getTemplateResource(), this.fmEditorInput.getLoadedTemplate(), latestXMLContents, true, logger);
        if (result == null) {
            return;
        }
        if (result.isSuccessfulWithoutWarnings()) {
            try {
                this.fmEditorInput.setTemplate(TemplateSerializeUtils.load((StringBuffer)latestXMLContents, (IZRL)this.getTemplateResource()));
                this.refreshGUI();
                this.setEditorDirty(false);
            }
            catch (CoreException e) {
                String errMsg = Messages.TemplateEditor_SAVE_EX;
                logger.error((Object)errMsg, (Throwable)e);
                PDDialogs.openErrorThreadSafe((String)errMsg);
                return;
            }
        }
    }

    public void doSaveAs() {
        StringBuffer latestXMLContents = new StringBuffer();
        Result<StringBuffer> result = TemplateEditorUtilities2.doSaveAs(this, this.session, this.getTemplateResource(), this.fmEditorInput.getLoadedTemplate(), latestXMLContents, true, logger);
        if (result == null) {
            return;
        }
        if (result.isSuccessfulWithoutWarnings()) {
            this.saveAsClosure = true;
            this.close();
        }
    }

    @Override
    public FMTemplateEditorInput2 getEditorInput() {
        return this.fmEditorInput;
    }
}

