/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.db2.SessionTemplate2;
import com.ibm.etools.fm.editor.template2.FMTemplateEditorInput2;
import com.ibm.etools.fm.editor.template2.ITemplateEditor2;
import com.ibm.etools.fm.editor.template2.TemplateEditorTabs2;
import com.ibm.etools.fm.editor.template2.TemplateEditorUtilities2;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class TemplateEditor2
extends EditorPart
implements ITemplateEditor2 {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(TemplateEditor2.class);
    public static final String ID = "com.ibm.etools.fm.editor.template2.TemplateEditor2";
    private TemplateEditor2 templateEditor = null;
    private FMTemplateEditorInput2 fmEditorInput = null;
    private SessionTemplate2 session = null;
    private boolean saveAsClosure = false;
    private TemplateEditorTabs2 templateEditorTabs = null;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof FMTemplateEditorInput2)) {
            String errMsg = MessageFormat.format(Messages.TE_InvalidInput, input != null ? input.getClass().getName() : null);
            logger.error((Object)errMsg);
            throw new PartInitException(errMsg);
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.fmEditorInput = (FMTemplateEditorInput2)input;
        IFile localFile = this.fmEditorInput.getFile();
        DataSetOrMember zosResource = (DataSetOrMember)this.fmEditorInput.getResource();
        this.session = this.fmEditorInput.getSessionIdentifer();
        if (localFile == null) {
            FMUIPlugin.getDefault().removeTemplateEditSession(this.fmEditorInput.getResource());
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.TE_NoCachedFile, zosResource.getFormattedName()));
            this.getSite().getPage().closeEditor((IEditorPart)this, false);
            return;
        }
        if (this.fmEditorInput.getLoadedTemplate() == null) {
            try {
                this.fmEditorInput.setTemplate(TemplateSerializeUtils.load((IFile)localFile, (IZRL)this.getTemplateResource()));
            }
            catch (Exception e) {
                FMUIPlugin.getDefault().removeTemplateEditSession(this.fmEditorInput.getResource());
                String errMsg = MessageFormat.format(Messages.TE_TemplateOpenError, this.fmEditorInput.getName());
                PDDialogs.openErrorThreadSafe((String)errMsg);
                logger.error((Object)errMsg, (Throwable)e);
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
                return;
            }
        } else if (this.fmEditorInput.isDirty()) {
            this.setEditorDirty();
        }
        if (this.fmEditorInput.getLoadedTemplate() != null && !"DB2".equals(this.fmEditorInput.getLoadedTemplate().getType())) {
            FMUIPlugin.getDefault().removeTemplateEditSession(this.fmEditorInput.getResource());
            String errMsg = MessageFormat.format(Messages.TemplateEditor_TypeNotSupportede, this.fmEditorInput.getName(), this.fmEditorInput.getLoadedTemplate().getType());
            PDDialogs.openErrorThreadSafe((String)errMsg);
            this.getSite().getPage().closeEditor((IEditorPart)this, false);
            return;
        }
        this.templateEditor = this;
        this.setPartName(input.getName());
    }

    public void createPartControl(Composite parent) {
        this.templateEditorTabs = new TemplateEditorTabs2();
        this.templateEditorTabs.buildTemplateEditorTabs(parent, this.templateEditor);
    }

    public void dispose() {
        FMUIPlugin.getDefault().removeTemplateEditSession(this.fmEditorInput.getResource());
        try {
            this.session.deleteCache();
            if (!this.saveAsClosure) {
                TemplateEditorUtilities2.end(this.session);
            }
        }
        catch (Exception e) {
            PDDialogs.openErrorThreadSafe((String)Messages.TemplateEditor_DISPOSE_ERR);
            logger.error((Object)"Failed to properly dispose of template editor", (Throwable)e);
        }
        super.dispose();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSave(IProgressMonitor arg0) {
        StringBuffer latestXMLContents = new StringBuffer();
        Result<StringBuffer> result = TemplateEditorUtilities2.doSave(this, this.session, this.getTemplateResource(), this.fmEditorInput.getLoadedTemplate(), latestXMLContents, false, logger);
        if (result == null) {
            return;
        }
        if (result.isSuccessfulWithoutWarnings()) {
            try {
                this.fmEditorInput.setTemplate(TemplateSerializeUtils.load((StringBuffer)latestXMLContents, (IZRL)this.getTemplateResource()));
                this.refreshGUI();
                this.fmEditorInput.setDirty(false);
                this.firePropertyChange(257);
            }
            catch (CoreException e) {
                String errMsg = Messages.TemplateEditor_SAVE_EX;
                logger.error((Object)errMsg, (Throwable)e);
                PDDialogs.openErrorThreadSafe((String)errMsg);
                return;
            }
        }
    }

    @Override
    public Result<StringBuffer> updateTemplate(IHowIsGoing monitor, boolean updateFromCopybooks) throws CoreException, InterruptedException, InvocationTargetException {
        StringBuffer newTemplateContents = new StringBuffer();
        Result<StringBuffer> result = TemplateEditorUtilities2.updateTemplate(monitor, updateFromCopybooks, this.fmEditorInput.getLoadedTemplate(), (IZRL)this.getTemplateResource(), this.session, newTemplateContents);
        if (!result.isSuccessfulWithoutWarnings()) {
            monitor.done();
            return result;
        }
        this.fmEditorInput.setTemplate(TemplateSerializeUtils.load((StringBuffer)newTemplateContents, (IZRL)this.getTemplateResource()));
        return result;
    }

    @Override
    public void updateTemplate(TemplateType newTemplate) {
        if (newTemplate == null) {
            return;
        }
        this.fmEditorInput.setTemplate(newTemplate);
        this.refreshGUI();
        this.fmEditorInput.setDirty(false);
        this.firePropertyChange(257);
    }

    @Override
    public void refreshGUI() {
        this.templateEditorTabs.setNewTemplate(this.fmEditorInput.getLoadedTemplate());
    }

    public boolean isEditSession() {
        return this.fmEditorInput.isEditSession();
    }

    public DataSetOrMember getTemplateResource() {
        return (DataSetOrMember)this.fmEditorInput.getResource();
    }

    public void doSaveAs() {
        StringBuffer latestXMLContents = new StringBuffer();
        Result<StringBuffer> result = TemplateEditorUtilities2.doSaveAs(this, this.session, this.getTemplateResource(), this.fmEditorInput.getLoadedTemplate(), latestXMLContents, false, logger);
        if (result == null) {
            return;
        }
        if (result.isSuccessfulWithoutWarnings()) {
            this.saveAsClosure = true;
            this.getSite().getPage().closeEditor((IEditorPart)this.templateEditor, false);
        }
    }

    public void setFocus() {
        if (this.templateEditorTabs != null) {
            this.templateEditorTabs.setFocus();
        }
    }

    @Override
    public boolean isDirty() {
        return this.fmEditorInput.isDirty();
    }

    @Override
    public void setEditorDirty() {
        this.fmEditorInput.setDirty(true);
        this.firePropertyChange(257);
    }

    @Override
    public FMTemplateEditorInput2 getEditorInput() {
        return this.fmEditorInput;
    }

    public static String getFieldReferenceNumberForDisplay(Layouttype aLayout, Symboltype aSymbol) {
        Objects.requireNonNull(aSymbol, "Must specify a non-null aSymbol.");
        return "#" + aSymbol.getDb2col();
    }
}

