/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template1.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.model.ims.ImsAccessMode;
import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.model.ims.ImsTemplateOptions;
import com.ibm.etools.fm.core.model.ims.ImsTemplateType;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.lookup.ImsDatabaseLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.ImsSubsystemLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.views.systems.handlers.ModifyImsSubsystemConfig;
import com.ibm.pdtools.common.component.core.model.BasicModelObject;
import com.ibm.pdtools.common.component.core.model.ModelViewConnector;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import java.util.Objects;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ImsTemplateEditorWizardPageFirst
extends WizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PAGE_TITLE = Messages.ImsTemplateEditorWizardPageFirst_0;
    private ImsTemplateOptions model;
    private ImsTemplateEditorDialogConnector controller = new ImsTemplateEditorDialogConnector();
    private Text wImsSubsystemText = null;
    private Combo wDatabaseCombo = null;
    private Button wImsTemplateButton;
    private Button wImsViewButton;
    private Combo wDsnCombo = null;
    private String tempDSN = "";

    public ImsTemplateEditorWizardPageFirst(ImsTemplateOptions options) {
        super(PAGE_TITLE);
        this.setTitle(PAGE_TITLE);
        this.setMessage(Messages.ImsTemplateEditorWizardPageFirst_1);
        Objects.requireNonNull(options, "Must provide non-null IMS Template options");
        this.model = options;
        this.tempDSN = this.model.getTemplate() == null ? "" : this.model.getTemplate().getFormattedName();
    }

    public void createControl(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group imsGroup = GUI.group((Composite)composite, (String)Messages.ImsTemplateEditorWizardPageFirst_3, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)imsGroup, (String)Messages.ImsWizardFirstPageHeader_Subsystem, (Object)GUI.grid.d.left1());
        this.wImsSubsystemText = GUI.text.fieldReadOnly((Composite)imsGroup, (Object)GUI.grid.d.fillH((int)1));
        Button wEditSubsystemButton = GUI.button.push((Composite)imsGroup, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/ims_customize_subsystem_config.gif"), (String)Messages.CUSTOMIZE_IMS_SUBSYSTEM, (Object)GUI.grid.d.left1());
        wEditSubsystemButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImsSubsystemConfig config = ImsTemplateEditorWizardPageFirst.this.model.getSubsystem().getCanonicalConfig();
                if (ModifyImsSubsystemConfig.editConfigAndSaveIfSuccessful(config)) {
                    ImsTemplateEditorWizardPageFirst.this.model.setImsSubsystem(config.getSubsystem());
                    ImsTemplateEditorWizardPageFirst.this.model.setDatabase(null);
                    ImsTemplateEditorWizardPageFirst.this.model.fireModelChangeEvent();
                }
            }
        });
        final Button wLookupSubsystemButton = LookupButton.createLookupButtonLeft1((Composite)imsGroup);
        wLookupSubsystemButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImsSubsystemConfig selectedConfig = ImsSubsystemLookupDialog.promptForValidConfig(ImsTemplateEditorWizardPageFirst.this.model.getSystem(), null);
                if (selectedConfig != null) {
                    wLookupSubsystemButton.setFocus();
                    ImsTemplateEditorWizardPageFirst.this.model.setImsSubsystem(selectedConfig.getSubsystem());
                    ImsTemplateEditorWizardPageFirst.this.model.fireModelChangeEvent();
                }
            }
        });
        GUI.label.left((Composite)imsGroup, (String)Messages.ImsWizardFirstPageHeader_DBName, (Object)GUI.grid.d.left1());
        this.wDatabaseCombo = GUI.combo.editable((Composite)imsGroup, (Object)GUI.grid.d.fillH((int)2));
        new ComboValueSaver(this.wDatabaseCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "imsDatabase");
        final Button lookupDatabaseButton = LookupButton.createLookupButtonLeft1((Composite)imsGroup);
        lookupDatabaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String query = ImsTemplateEditorWizardPageFirst.this.wDatabaseCombo.getText().trim();
                ImsDatabase selectedDatabase = ImsDatabaseLookupDialog.promptForValidConfig(ImsTemplateEditorWizardPageFirst.this.model.getHostProvider(), ImsTemplateEditorWizardPageFirst.this.model.getSubsystem().getCanonicalConfig(), null, query, ImsTemplateEditorWizardPageFirst.this.model.getRegionType(), ImsAccessMode.DYNAMIC, ImsTemplateEditorWizardPageFirst.this.model.getSubsystem().getCanonicalConfig().isDir() || ImsTemplateEditorWizardPageFirst.this.model.getSubsystem().getCanonicalConfig().isStaticOnly(ImsTemplateEditorWizardPageFirst.this.model.getRegionType()) ? "XTPED" : null);
                if (selectedDatabase != null) {
                    lookupDatabaseButton.setFocus();
                    ImsTemplateEditorWizardPageFirst.this.model.setDatabase(selectedDatabase);
                    ImsTemplateEditorWizardPageFirst.this.model.fireModelChangeEvent();
                }
            }
        });
        Group imsGroup1 = GUI.group((Composite)composite, (String)Messages.ImsTemplateEditorWizardPageFirst_4, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)imsGroup1, (String)Messages.ImsTemplateEditorWizardPageFirst_5, (Object)GUI.grid.d.left1());
        Composite typeComposite = GUI.composite((Composite)imsGroup1, (Layout)GUI.grid.l.noMargins((int)2, (boolean)true), (Object)GUI.grid.d.fillH((int)2));
        this.wImsTemplateButton = GUI.button.radio((Composite)typeComposite, (String)Messages.ImsTemplateEditorWizardPageFirst_6, (Object)GUI.grid.d.fillH((int)1));
        this.wImsViewButton = GUI.button.radio((Composite)typeComposite, (String)Messages.ImsTemplateEditorWizardPageFirst_7, (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)imsGroup1, (String)Messages.ImsTemplateEditorWizardPageFirst_8, (Object)GUI.grid.d.left1());
        this.wDsnCombo = GUI.combo.editable((Composite)imsGroup1, (Object)GUI.grid.d.fillH((int)1));
        final Button lookupDSNButton = LookupButton.createLookupButtonLeft1((Composite)imsGroup1);
        LookupDialogFactory.defaults(lookupDSNButton, this.wDsnCombo, (IHostProvider)this.model).types(FMHost.getPermittedTemplateResourceType((IPDHost)this.model.getSystem())).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                lookupDSNButton.setFocus();
                ImsTemplateEditorWizardPageFirst.this.model.setTemplate(zrl);
                ImsTemplateEditorWizardPageFirst.this.tempDSN = zrl.getFormattedName();
                ImsTemplateEditorWizardPageFirst.this.model.fireModelChangeEvent();
            }
        }).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "Template").addComboValueSaver(((Object)((Object)this)).getClass().getCanonicalName() + "imsTemplate").create();
        this.controller.listenTo((BasicModelObject)this.model);
        this.controller.listenTo((Control)this.wDatabaseCombo);
        this.controller.listenTo((Control)this.wImsTemplateButton);
        this.controller.listenTo((Control)this.wImsViewButton);
        this.controller.listenTo((Control)this.wDsnCombo);
        this.controller.doManualViewUpdate();
        if (this.wDatabaseCombo.getText().trim().isEmpty()) {
            this.wDatabaseCombo.setFocus();
        } else {
            this.wDsnCombo.setFocus();
        }
        this.setControl((Control)parent);
    }

    public void dispose() {
        this.controller.dispose();
        super.dispose();
    }

    public String getValidationErrorMessage() {
        if (this.model.getDatabase() != null) {
            if (this.tempDSN != null && !this.tempDSN.isEmpty()) {
                if (ZRLs.isParseable((IPDHost)this.model.getSystem(), (String)this.tempDSN)) {
                    if (Member.isParseable((String)this.tempDSN, (boolean)true, (String)this.model.getSystem().getCodePage())) {
                        DataSetOrMember parsed = Member.parse((IPDHost)this.model.getHost(), (String)this.tempDSN);
                        if (this.model.getType() == ImsTemplateType.TEMPLATE) {
                            if (parsed.asMember().getName().equals(this.model.getDatabase().getName())) {
                                this.model.setTemplate((IZRL)parsed);
                                return null;
                            }
                            return Messages.ImsTemplateEditorWizardPageFirst_11;
                        }
                        this.model.setTemplate((IZRL)parsed);
                        return null;
                    }
                    this.model.setTemplate((IZRL)Member.parse((IPDHost)this.model.getHost(), (String)this.tempDSN, (String)this.model.getDatabase().getName()));
                    return null;
                }
                return Messages.ImsTemplateEditorWizardPageFirst_12;
            }
            return Messages.ImsTemplateEditorWizardPageFirst_13;
        }
        return Messages.ImsTemplateEditorWizardPageFirst_14;
    }

    public ImsTemplateOptions getOptions() {
        return this.model;
    }

    private class ImsTemplateEditorDialogConnector
    extends ModelViewConnector {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private ImsTemplateEditorDialogConnector() {
        }

        protected void updateModelFromViewImpl() {
            if (ImsTemplateEditorWizardPageFirst.this.wDatabaseCombo.getText().trim().isEmpty()) {
                ImsTemplateEditorWizardPageFirst.this.model.setDatabase(null);
            } else if (ImsDatabase.isValidName((String)ImsTemplateEditorWizardPageFirst.this.wDatabaseCombo.getText().trim().toUpperCase(), (String)ImsTemplateEditorWizardPageFirst.this.model.getSystem().getCodePage())) {
                ImsTemplateEditorWizardPageFirst.this.model.setDatabase(new ImsDatabase(ImsTemplateEditorWizardPageFirst.this.model.getSubsystem(), ImsTemplateEditorWizardPageFirst.this.wDatabaseCombo.getText().trim().toUpperCase()));
                if (ImsTemplateEditorWizardPageFirst.this.wImsTemplateButton.getSelection()) {
                    ImsTemplateEditorWizardPageFirst.this.model.setType(ImsTemplateType.TEMPLATE);
                } else if (ImsTemplateEditorWizardPageFirst.this.wImsViewButton.getSelection()) {
                    ImsTemplateEditorWizardPageFirst.this.model.setType(ImsTemplateType.VIEW);
                }
                ImsTemplateEditorWizardPageFirst.this.tempDSN = ImsTemplateEditorWizardPageFirst.this.wDsnCombo.getText().trim().toUpperCase();
            }
        }

        protected void updateViewFromModelImpl() {
            ImsSubsystemConfig canonicalConfig = ImsTemplateEditorWizardPageFirst.this.model.getSubsystem().getCanonicalConfig();
            ImsTemplateEditorDialogConnector.setText((Text)ImsTemplateEditorWizardPageFirst.this.wImsSubsystemText, (String)canonicalConfig.getLabel());
            ImsTemplateEditorDialogConnector.setText((Combo)ImsTemplateEditorWizardPageFirst.this.wDatabaseCombo, (String)(ImsTemplateEditorWizardPageFirst.this.model.getDatabase() == null ? "" : ImsTemplateEditorWizardPageFirst.this.model.getDatabase().getName()));
            ImsTemplateEditorWizardPageFirst.this.wImsTemplateButton.setSelection(ImsTemplateEditorWizardPageFirst.this.model.getType() == ImsTemplateType.TEMPLATE);
            ImsTemplateEditorWizardPageFirst.this.wImsViewButton.setSelection(ImsTemplateEditorWizardPageFirst.this.model.getType() == ImsTemplateType.VIEW);
            ImsTemplateEditorDialogConnector.setText((Combo)ImsTemplateEditorWizardPageFirst.this.wDsnCombo, (String)ImsTemplateEditorWizardPageFirst.this.tempDSN);
            boolean dsnSpecified = ImsTemplateEditorWizardPageFirst.this.model.getDatabase() != null;
            ImsTemplateEditorWizardPageFirst.this.wDsnCombo.setEnabled(dsnSpecified);
            ImsTemplateEditorWizardPageFirst.this.wImsTemplateButton.setEnabled(dsnSpecified);
            ImsTemplateEditorWizardPageFirst.this.wImsViewButton.setEnabled(dsnSpecified);
            String validationErrorMessage = ImsTemplateEditorWizardPageFirst.this.getValidationErrorMessage();
            ImsTemplateEditorWizardPageFirst.this.setErrorMessage(validationErrorMessage);
            ImsTemplateEditorWizardPageFirst.this.setPageComplete(validationErrorMessage == null);
        }
    }
}

