/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template1.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsTemplateOptions;
import com.ibm.etools.fm.core.model.ims.ImsTemplateType;
import com.ibm.etools.fm.editor.template1.dialogs.ImsTemplateEditorWizardPageFirst;
import com.ibm.etools.fm.ui.wizards.WizardRunnable;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.text.MessageFormat;
import org.eclipse.swt.widgets.Display;

public class ImsTemplateEditorRunnable
extends WizardRunnable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private ImsTemplateOptions model;
    private ImsTemplateEditorWizardPageFirst page;

    public ImsTemplateEditorRunnable(ImsTemplateOptions model, ImsTemplateEditorWizardPageFirst page) {
        this.model = model;
        this.page = page;
    }

    @Override
    protected boolean preWizardClose(IHowIsGoing monitor) {
        block3: {
            try {
                Result loadInfo = this.model.getDatabase().loadInfo(monitor, this.model.getSubsystem().getCanonicalConfig().isDir() || this.model.getSubsystem().getCanonicalConfig().isStaticOnly(ImsRegionType.BMP) ? "XTPED" : null, ImsRegionType.BMP);
                if (loadInfo.isSuccessfulWithoutWarnings()) break block3;
                this.displayErrorMessage(MessageFormat.format(Messages.ImsTemplateEditorRunnable_0, this.model.getDatabase().getName()));
                return false;
            }
            catch (InterruptedException e) {
                this.displayErrorMessage(Messages.ImsTemplateEditorRunnable_1);
                return false;
            }
        }
        return this.handleImsTemplate(monitor);
    }

    private static boolean checkDatasetUseable(IHowIsGoing monitor, DataSetOrMember dsom) throws InterruptedException, CommunicationException {
        Result dsStatus = dsom.refreshSelf(monitor);
        if (!dsStatus.isSuccessfulWithoutWarnings()) {
            throw new CommunicationException(dsStatus.dumpOutputAndMessages(true));
        }
        if (!dsom.asDataSet().getConfirmedExists()) {
            throw new CommunicationException(MessageFormat.format(Messages.ImsTemplateEditorRunnable_2, dsom.getFormattedName()));
        }
        if (dsom.asDataSet().getType() != DataSetType.PDS && dsom.asDataSet().getType() != DataSetType.LIBRARY) {
            throw new CommunicationException(MessageFormat.format(Messages.ImsTemplateEditorRunnable_3, dsom.asDataSet().getType().name()));
        }
        return true;
    }

    private static boolean checkMemberExists(IHowIsGoing monitor, Member aTemplateMember) throws InterruptedException, CommunicationException {
        Result memberStatus = aTemplateMember.refreshSelf(monitor);
        if (!memberStatus.isSuccessfulWithoutWarnings()) {
            throw new CommunicationException(memberStatus.dumpOutputAndMessages(true));
        }
        return aTemplateMember.getConfirmedExists();
    }

    private static Member.TemplateInfo getTemplateInfo(IHowIsGoing monitor, Member aTemplateMember) throws CommunicationException, InterruptedException {
        Result loadResult = aTemplateMember.loadTemplateInfo(monitor);
        if (!loadResult.isSuccessfulWithoutWarnings()) {
            throw new CommunicationException(loadResult.dumpOutputAndMessages(true));
        }
        return aTemplateMember.getTemplateInfo();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleImsTemplate(IHowIsGoing monitor) throws InterruptedException {
        boolean isOk = true;
        try {
            DataSetOrMember dsom = (DataSetOrMember)this.model.getTemplate();
            if (!ImsTemplateEditorRunnable.checkDatasetUseable(monitor, dsom)) {
                return false;
            }
            Member aTemplateMember = dsom.asMember();
            this.model.setTemplate((IZRL)aTemplateMember);
            if (!ImsTemplateEditorRunnable.checkMemberExists(monitor, aTemplateMember)) {
                this.model.setCreateNew(true);
                return isOk;
            }
            Member.TemplateInfo info = ImsTemplateEditorRunnable.getTemplateInfo(monitor, aTemplateMember);
            if (info.getType() != Member.TemplateInfo.DsfmTemplateType.IMS && info.getType() != Member.TemplateInfo.DsfmTemplateType.VIEW) {
                this.model.setCreateNew(true);
                if (PDDialogs.openQuestionThreadSafe((String)Messages.ImsTemplateEditorRunnable_5, (String)MessageFormat.format(Messages.ImsTemplateEditorRunnable_6, aTemplateMember.getFormattedName(), this.model.getType().toString()))) return isOk;
                return false;
            }
            if (this.model.getType() != ImsTemplateType.TEMPLATE) {
                if (this.model.getType() != ImsTemplateType.VIEW) throw new CommunicationException(Messages.ImsTemplateEditorRunnable_4 + this.model.getType().name());
            }
            this.model.setCreateNew(false);
            this.model.setType(info.getType() == Member.TemplateInfo.DsfmTemplateType.IMS ? ImsTemplateType.TEMPLATE : ImsTemplateType.VIEW);
            return isOk;
        }
        catch (CommunicationException e) {
            this.displayErrorMessage(e.getMessage());
            return false;
        }
    }

    private void displayErrorMessage(final String errMsg) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ImsTemplateEditorRunnable.this.page.setErrorMessage(errMsg);
            }
        });
    }

    @Override
    protected String getName() {
        return Messages.ImsTemplateEditorRunnable_7;
    }

    @Override
    protected Result<StringBuffer> execute(IHowIsGoing monitor) {
        Result result = new Result((Object)new StringBuffer());
        result.setRC(0);
        return result;
    }

    @Override
    public void showResult() {
    }

    @Override
    public boolean isCompletedSuccessfully() {
        return this.getResult() != null && this.getResult().getRC() <= 4;
    }
}

