/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template1.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.template.dialogs.CriteriaElement;
import com.ibm.etools.fm.editor.template1.dialogs.label.FieldCriteriaSpecificationDialog1LabelProvider;
import com.ibm.etools.fm.model.template.ConnType;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.OperType;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class FieldCriteriaSpecificationDialog1
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private Text templateNameText = null;
    private Text templateLayoutText = null;
    private Table layoutTable = null;
    private TableViewer layoutTableViewer = null;
    private Combo connectorCombo = null;
    private Combo operatorCombo = null;
    private Combo valueCombo = null;
    private IZRL templateResource = null;
    private String currentTemplateType = null;
    private Layouttype selectedLayout = null;
    private boolean allowConnectorChange = false;
    private CriteriaElement specifiedCriteria = null;

    public FieldCriteriaSpecificationDialog1(IZRL templateResource, String currentTemplate, Layouttype selectedLayout, boolean allowConnectorChange) {
        this(templateResource, currentTemplate, selectedLayout, allowConnectorChange, null);
    }

    public FieldCriteriaSpecificationDialog1(IZRL templateResource, String currentTemplate, Layouttype selectedLayout, boolean allowConnectorChange, CriteriaElement aCriteria) {
        this.templateResource = templateResource;
        this.currentTemplateType = currentTemplate;
        this.selectedLayout = selectedLayout;
        this.allowConnectorChange = allowConnectorChange;
        this.specifiedCriteria = aCriteria;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.FieldCriteriaSpecDialog_Title);
        this.setMessage(Messages.FieldCriteriaSpecDialog_Msg);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.createLayoutComposite(composite);
        this.createCriteriaComposite(composite);
        this.layoutTableViewer.setLabelProvider((IBaseLabelProvider)new FieldCriteriaSpecificationDialog1LabelProvider(this.templateResource.getSystem()));
        this.layoutTableViewer.setInput((Object)this.selectedLayout.getSymbol());
        this.initFieldCriteria();
        this.validateInput();
        return composite;
    }

    private void createLayoutComposite(Composite parent) {
        Composite templateComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)templateComposite, (String)Messages.FieldCriteriaSpecDialog_TemplateName, (Object)GUI.grid.d.left1(), (int)16384);
        this.templateNameText = GUI.text.fieldReadOnly((Composite)templateComposite, (Object)GUI.grid.d.fillH((int)1));
        this.templateNameText.setText(this.templateResource.getFormattedName());
        GUI.label((Composite)templateComposite, (String)Messages.FieldCriteriaSpecDialog_Layout_name, (Object)GUI.grid.d.left1(), (int)16384);
        this.templateLayoutText = GUI.text.fieldReadOnly((Composite)templateComposite, (Object)GUI.grid.d.fillH((int)1));
        this.templateLayoutText.setText(((Symboltype)this.selectedLayout.getSymbol().get(0)).getName(this.templateResource.getSystem()));
        GridData tableGridData = GUI.grid.d.fillAll();
        tableGridData.heightHint = 300;
        Composite tableComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)tableGridData);
        this.layoutTable = new Table(tableComposite, 68356);
        this.layoutTable.setHeaderVisible(true);
        this.layoutTable.setLinesVisible(true);
        this.layoutTable.setLayoutData((Object)GUI.grid.d.fillAll());
        this.layoutTableViewer = new TableViewer(this.layoutTable);
        this.layoutTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        FieldCriteriaSpecificationDialog1.createMappingTableColumns(this.layoutTableViewer);
        this.layoutTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FieldCriteriaSpecificationDialog1.this.validateInput();
            }
        });
    }

    private static void createMappingTableColumns(TableViewer viewer) {
        FormattedEditorUtility.createTableViewerColumn("", 30, viewer, 0x1000000);
        FormattedEditorUtility.createTableViewerColumn(Messages.FieldCriteriaSpecDialog_LEVEL_COLUMN, 60, viewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.FieldCriteriaSpecDialog_FIELD_COLUMN, 300, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.FieldCriteriaSpecDialog_TYPE_COLUMN, 80, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.FieldCriteriaSpecDialog_LEN_COLUMN, 80, viewer, 131072);
    }

    private void createCriteriaComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)composite, (String)Messages.FieldCriteriaSpecDialog_connector, (Object)GUI.grid.d.left1(), (int)16384);
        this.connectorCombo = GUI.combo.readOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1), (Object[])ConnType.values());
        this.connectorCombo.select(1);
        this.connectorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FieldCriteriaSpecificationDialog1.this.validateInput();
            }
        });
        if (!this.allowConnectorChange) {
            this.connectorCombo.setEnabled(false);
        }
        GUI.label((Composite)composite, (String)Messages.FieldCriteriaSpecDialog_operator, (Object)GUI.grid.d.left1(), (int)16384);
        this.operatorCombo = GUI.combo.readOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1), (Object[])FieldCriteriaSpecificationDialog1.getValidOperators());
        this.operatorCombo.select(0);
        this.operatorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FieldCriteriaSpecificationDialog1.this.validateInput();
                if (FieldCriteriaSpecificationDialog1.this.operatorCombo.getText().equals(OperType.NU.getLiteral()) || FieldCriteriaSpecificationDialog1.this.operatorCombo.getText().equals(OperType.NU1.getLiteral()) || FieldCriteriaSpecificationDialog1.this.operatorCombo.getText().equals(OperType.NN.getLiteral())) {
                    FieldCriteriaSpecificationDialog1.this.valueCombo.setEnabled(false);
                } else {
                    FieldCriteriaSpecificationDialog1.this.valueCombo.setEnabled(true);
                }
            }
        });
        GUI.label((Composite)composite, (String)Messages.FieldCriteriaSpecDialog_criteriaValue, (Object)GUI.grid.d.left1(), (int)16384);
        this.valueCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        this.valueCombo.setFocus();
        new ComboValueSaver(this.valueCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "criteriaValue");
        this.valueCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FieldCriteriaSpecificationDialog1.this.validateInput();
            }
        });
    }

    private static String[] getValidOperators() {
        String[] operators = new String[OperType.values().length];
        int i = 0;
        while (OperType.get((int)i) != null) {
            operators[i] = OperType.get((int)i).getLiteral();
            ++i;
        }
        return operators;
    }

    private void validateInput() {
        if (this.layoutTable.getSelectionIndex() == -1) {
            this.setComplete(false);
            return;
        }
        if ("DYNAMIC".equals(this.currentTemplateType) && this.layoutTable.getSelectionIndex() == 0) {
            this.setComplete(false);
            return;
        }
        if (this.operatorCombo.getText().equals(OperType.NU.getLiteral()) || this.operatorCombo.getText().equals(OperType.NU1.getLiteral()) || this.operatorCombo.getText().equals(OperType.NN.getLiteral())) {
            this.setComplete(true);
            return;
        }
        if (this.valueCombo.getText().trim().isEmpty()) {
            this.setComplete(false);
            return;
        }
        this.setComplete(true);
    }

    protected void okPressed() {
        Symboltype selectedSymbol = (Symboltype)this.selectedLayout.getSymbol().get(this.layoutTable.getSelectionIndex());
        ConnType connectorType = ConnType.get((int)this.connectorCombo.getSelectionIndex());
        OperType selectedOperator = OperType.get((int)this.operatorCombo.getSelectionIndex());
        String value = this.valueCombo.getText();
        if (this.operatorCombo.getText().equals(OperType.NU.getLiteral()) || this.operatorCombo.getText().equals(OperType.NU1.getLiteral()) || this.operatorCombo.getText().equals(OperType.NN.getLiteral())) {
            value = "";
        }
        if (this.specifiedCriteria == null) {
            this.specifiedCriteria = new CriteriaElement(connectorType, selectedSymbol, selectedOperator, 0, value, this.templateResource.getSystem());
        } else {
            this.specifiedCriteria.setaSymbol(selectedSymbol);
            this.specifiedCriteria.setOperator(selectedOperator);
            this.specifiedCriteria.setConnectorType(connectorType);
            this.specifiedCriteria.setCriteriaValue(value);
        }
        super.okPressed();
    }

    private void initFieldCriteria() {
        if (this.specifiedCriteria == null) {
            return;
        }
        int selectionIndex = 0;
        int i = 0;
        while (i < this.selectedLayout.getSymbol().size()) {
            Symboltype aSymbol = (Symboltype)this.selectedLayout.getSymbol().get(i);
            if (this.specifiedCriteria.getSymbol().getRef() == aSymbol.getRef()) {
                selectionIndex = i;
                break;
            }
            ++i;
        }
        this.layoutTable.setSelection(selectionIndex);
        this.connectorCombo.setText(this.specifiedCriteria.getConnectorType().getLiteral());
        this.operatorCombo.setText(this.specifiedCriteria.getOperator().getLiteral());
        this.valueCombo.setText(this.specifiedCriteria.getCriteriaValue());
        if (this.specifiedCriteria.getOperator() == OperType.NU || this.specifiedCriteria.getOperator() == OperType.NU1 || this.operatorCombo.getText().equals(OperType.NN.getLiteral())) {
            this.valueCombo.setEnabled(false);
        }
    }

    public CriteriaElement getSpecifiedCriteria() {
        return this.specifiedCriteria;
    }
}

