/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template1;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionTemplate;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.util.CompilerOptionsUtil;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.template.dialogs.AdvancedCopybookEntry;
import com.ibm.etools.fm.editor.template.dialogs.EditAdvancedSelectionCopybookDialog;
import com.ibm.etools.fm.editor.template1.ITemplateEditor1;
import com.ibm.etools.fm.editor.template1.label.TemplateSegmentsComposite1LibraryInformationLabelProvider;
import com.ibm.etools.fm.editor.template1.label.TemplateSegmentsComposite1MemberLabelProvider;
import com.ibm.etools.fm.editor.template1.label.TemplateSegmentsComposite1SegmentLabelProvider;
import com.ibm.etools.fm.model.template.Asmtype;
import com.ibm.etools.fm.model.template.Coboltype;
import com.ibm.etools.fm.model.template.MemberType;
import com.ibm.etools.fm.model.template.Plitype;
import com.ibm.etools.fm.model.template.Redefinetype;
import com.ibm.etools.fm.model.template.Sourcerangetype;
import com.ibm.etools.fm.model.template.TemplateFactory;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.models.compiler.CompileType;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.lookup.ResourceLookupDialog;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDFileSystemUtil;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.PDDialogWithText;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDEditorManagement;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class TemplateSegmentsComposite1 {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(TemplateSegmentsComposite1.class);
    private static final int MAX_COPYBOOK_LIBRARY_NUMBER = 12;
    private static final int INDEX_MEMBER_LIBRARY_INDEX_COLUMN = 1;
    private static final int INDEX_MEMBER_01_NAME_COLUMN = 3;
    private static final int INDEX_MEMBER_SEGMENT_DESC_COLUMN = 4;
    private static final int INDEX_SEGMENT_NAME = 0;
    private AbstractSessionTemplate session;
    private ITemplateEditor1 editor;
    private TemplateType aTemplate;
    private IZRL aTemplateResource;
    private TabItem segmentTab;
    private Table libraryTable;
    private TableViewer libraryTableViewer;
    private Table memberTable;
    private TableViewer memberTableViewer;
    private TableCursor memberTableCursor;
    private ControlEditor memberTableCursorEditor;
    private Table segmentTable;
    private TableViewer segmentTableViewer;
    private Button addLibButton;
    private Button removeLibButton;
    private Button addMemButton;
    private Button removeMemButton;
    private Button editMemButton;
    private Button updateButton;

    public TemplateSegmentsComposite1(AbstractSessionTemplate session, ITemplateEditor1 editor2, TemplateType aTemplate, IZRL aTemplateResource) {
        this.session = session;
        this.editor = editor2;
        this.aTemplate = aTemplate;
        this.aTemplateResource = aTemplateResource;
    }

    public void createSegmentTab(TabFolder tabFolder) {
        this.segmentTab = new TabItem(tabFolder, 0);
        this.segmentTab.setText(Messages.TemplateSegmentsComposite1_0);
        Composite parent = GUI.composite((Composite)tabFolder, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        SashForm tableSashForm = new SashForm(parent, 512);
        Group segMemberGroup = GUI.group((Composite)tableSashForm, (String)Messages.TemplateSegmentsComposite1_1, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        SashForm segMemberSashForm = new SashForm((Composite)segMemberGroup, 256);
        this.createSegmentTable((Composite)segMemberSashForm);
        this.createMemberTable((Composite)segMemberSashForm);
        segMemberSashForm.setLayoutData((Object)GUI.grid.d.fillAll());
        segMemberSashForm.setWeights(new int[]{50, 50});
        this.createLibraryTable((Composite)tableSashForm);
        tableSashForm.setLayoutData((Object)GUI.grid.d.fillAll());
        tableSashForm.setWeights(new int[]{50, 50});
        this.createButtons(parent);
        this.segmentTab.setControl((Control)parent);
        this.showSegmentLayoutCopybookInfo(-1);
    }

    private void createLibraryTable(Composite parent) {
        Group group = GUI.group((Composite)parent, (String)Messages.TE_infoCopybookLibraryGroup, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.libraryTable = new Table((Composite)group, 68354);
        this.libraryTable.setHeaderVisible(true);
        this.libraryTable.setLinesVisible(true);
        this.libraryTable.setLayoutData((Object)GUI.grid.d.fillAll());
        this.libraryTableViewer = new TableViewer(this.libraryTable);
        this.libraryTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TemplateSegmentsComposite1.createLibraryTableColumns(this.libraryTableViewer);
        this.libraryTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int selectionIndex = TemplateSegmentsComposite1.this.libraryTable.getSelectionIndex();
                int[] selection = TemplateSegmentsComposite1.this.getUsageIndex(selectionIndex + 1);
                TemplateSegmentsComposite1.this.memberTable.setSelection(selection);
            }
        });
        Composite buttonsComposite = GUI.composite((Composite)group, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.left1());
        this.addLibButton = GUI.button.push((Composite)buttonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/add.gif"), (String)Messages.TE_infoCopybookAddLibTip, (Object)GUI.grid.d.left1());
        this.addLibButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceLookupDialog dialog = new ResourceLookupDialog(TemplateSegmentsComposite1.this.aTemplateResource.getSystem(), FMHost.getPermittedTemplateResourceType((IPDHost)TemplateSegmentsComposite1.this.aTemplateResource.getSystem()));
                dialog.setAllowingMultiSelect(true);
                if (dialog.open() == 0) {
                    TemplateSegmentsComposite1.this.editor.libUpdated(true);
                    List<IZRL> selectedResource = dialog.getSelection();
                    int i = 0;
                    while (i < selectedResource.size()) {
                        IZRL selected = selectedResource.get(i);
                        if (!(selected instanceof DataSetOrMember)) {
                            throw new IllegalArgumentException("Specified resource type not supported: " + selected.getFormattedName());
                        }
                        DataSetOrMember dsom = (DataSetOrMember)selected;
                        DataSet aDataSet = dsom.asDataSet();
                        TemplateSegmentsComposite1.addLibIfNew((EList<String>)TemplateSegmentsComposite1.this.aTemplate.getCopybooks().getLibrary(), aDataSet.getName());
                        TemplateSegmentsComposite1.this.showSegmentLayoutCopybookInfo(-1);
                        TemplateSegmentsComposite1.this.editor.setEditorDirty();
                        ++i;
                    }
                }
            }
        });
        this.removeLibButton = GUI.button.push((Composite)buttonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/delete.gif"), (String)Messages.TE_infoCopybookRemoveLibTip, (Object)GUI.grid.d.left1());
        this.removeLibButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] selLibIDs = TemplateSegmentsComposite1.this.libraryTable.getSelectionIndices();
                if (selLibIDs == null || selLibIDs.length == 0) {
                    return;
                }
                String[] delLibs = new String[selLibIDs.length];
                int i = 0;
                while (i < selLibIDs.length) {
                    delLibs[i] = (String)TemplateSegmentsComposite1.this.aTemplate.getCopybooks().getLibrary().get(selLibIDs[i]);
                    ++i;
                }
                i = 0;
                while (i < delLibs.length) {
                    TemplateSegmentsComposite1.this.aTemplate.getCopybooks().getLibrary().remove((Object)delLibs[i]);
                    ++i;
                }
                TemplateSegmentsComposite1.this.editor.libUpdated(true);
                TemplateSegmentsComposite1.this.showSegmentLayoutCopybookInfo(-1);
                TemplateSegmentsComposite1.this.editor.setEditorDirty();
            }
        });
    }

    private int[] getUsageIndex(int libIndex) {
        ArrayList<Integer> usageIndex = new ArrayList<Integer>();
        int i = 0;
        while (i < this.aTemplate.getCopybooks().getMember().size()) {
            if (((MemberType)this.aTemplate.getCopybooks().getMember().get(i)).getLib() == libIndex) {
                usageIndex.add(i);
            }
            ++i;
        }
        int[] index = new int[usageIndex.size()];
        int i2 = 0;
        while (i2 < usageIndex.size()) {
            index[i2] = (Integer)usageIndex.get(i2);
            ++i2;
        }
        return index;
    }

    private void createMemberTable(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.memberTable = new Table(composite, 68354);
        this.memberTable.setHeaderVisible(true);
        this.memberTable.setLinesVisible(true);
        this.memberTable.setLayoutData((Object)GUI.grid.d.fillAll());
        this.memberTableViewer = new TableViewer(this.memberTable);
        this.memberTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TemplateSegmentsComposite1.createMemberTableColumns(this.memberTableViewer);
        this.memberTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int selectionIndex = TemplateSegmentsComposite1.this.memberTable.getSelectionIndex();
                TableItem item = TemplateSegmentsComposite1.this.memberTable.getItem(selectionIndex);
                int libIndex = Integer.parseInt(item.getText(1));
                int[] selection = new int[]{libIndex - 1};
                TemplateSegmentsComposite1.this.libraryTable.setSelection(selection);
            }
        });
        this.memberTableCursor = new TableCursor(this.memberTable, 0);
        this.memberTableCursor.setFont(JFaceResources.getDefaultFont());
        this.memberTableCursorEditor = new ControlEditor((Composite)this.memberTableCursor);
        this.memberTableCursorEditor.grabHorizontal = true;
        this.memberTableCursorEditor.grabVertical = true;
        this.setupListenersForTableCursor();
        Composite buttonsComposite = GUI.composite((Composite)composite, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.left1());
        this.addMemButton = GUI.button.push((Composite)buttonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/add.gif"), (String)Messages.TE_infoCopybookAddMemTip, (Object)GUI.grid.d.left1());
        this.addMemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateSegmentsComposite1.this.segmentTable.getSelectionIndex() == -1) {
                    PDDialogs.openWarningThreadSafe((String)Messages.Information, (String)Messages.TemplateSegmentsComposite1_2);
                    return;
                }
                int selectionIndex = TemplateSegmentsComposite1.this.segmentTable.getSelectionIndex();
                TableItem item = TemplateSegmentsComposite1.this.segmentTable.getItem(selectionIndex);
                String segmentName = item.getText(0);
                ResourceLookupDialog dialog = new ResourceLookupDialog(TemplateSegmentsComposite1.this.aTemplateResource.getSystem(), FMHost.getPermittedTemplateResourceType((IPDHost)TemplateSegmentsComposite1.this.aTemplateResource.getSystem()));
                dialog.setAllowingMultiSelect(true);
                if (dialog.open() == 0) {
                    List<IZRL> selectedResource = dialog.getSelection();
                    int i = 0;
                    while (i < selectedResource.size()) {
                        IZRL selected = selectedResource.get(i);
                        if (!(selected instanceof DataSetOrMember)) {
                            throw new IllegalArgumentException("Specified resource type not supported: " + selected.getFormattedName());
                        }
                        DataSetOrMember dsom = (DataSetOrMember)selected;
                        Member aMember = dsom.asMember();
                        DataSet aDataSet = dsom.asDataSet();
                        int libNo = TemplateSegmentsComposite1.addLibIfNew((EList<String>)TemplateSegmentsComposite1.this.aTemplate.getCopybooks().getLibrary(), aDataSet.getName());
                        TemplateSegmentsComposite1.addMemIfNew((EList<MemberType>)TemplateSegmentsComposite1.this.aTemplate.getCopybooks().getMember(), libNo, aMember.getName(), segmentName);
                        ++i;
                    }
                    TemplateSegmentsComposite1.this.editor.libUpdated(true);
                    TemplateSegmentsComposite1.this.showSegmentLayoutCopybookInfo(selectionIndex);
                    TemplateSegmentsComposite1.this.editor.setEditorDirty();
                }
            }
        });
        this.removeMemButton = GUI.button.push((Composite)buttonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/delete.gif"), (String)Messages.TE_infoCopybookRemoveMemTip, (Object)GUI.grid.d.left1());
        this.removeMemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateSegmentsComposite1.this.segmentTable.getSelectionIndex() == -1) {
                    PDDialogs.openWarningThreadSafe((String)Messages.Information, (String)Messages.TemplateSegmentsComposite1_3);
                    return;
                }
                int selectionIndex = TemplateSegmentsComposite1.this.segmentTable.getSelectionIndex();
                if (TemplateSegmentsComposite1.this.memberTable.getSelectionIndex() == -1) {
                    PDDialogs.openWarningThreadSafe((String)Messages.Information, (String)Messages.TemplateSegmentsComposite1_4);
                    return;
                }
                int[] memSel = TemplateSegmentsComposite1.this.memberTable.getSelectionIndices();
                MemberType[] selMembers = new MemberType[memSel.length];
                int i = 0;
                while (i < memSel.length) {
                    selMembers[i] = TemplateSegmentsComposite1.this.getSelectedMember(memSel[i]);
                    ++i;
                }
                i = 0;
                while (i < selMembers.length) {
                    TemplateSegmentsComposite1.this.aTemplate.getCopybooks().getMember().remove((Object)selMembers[i]);
                    ++i;
                }
                TemplateSegmentsComposite1.this.editor.libUpdated(true);
                TemplateSegmentsComposite1.this.showSegmentLayoutCopybookInfo(selectionIndex);
                TemplateSegmentsComposite1.this.editor.setEditorDirty();
            }
        });
        this.editMemButton = GUI.button.push((Composite)buttonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaWriter.gif"), (String)Messages.TE_infoCopybookEditMemTip, (Object)GUI.grid.d.left1());
        this.editMemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateSegmentsComposite1.this.segmentTable.getSelectionIndex() == -1) {
                    PDDialogs.openWarningThreadSafe((String)Messages.Information, (String)Messages.TemplateSegmentsComposite1_5);
                    return;
                }
                if (TemplateSegmentsComposite1.this.memberTable.getSelectionIndex() == -1) {
                    PDDialogs.openWarningThreadSafe((String)Messages.Information, (String)Messages.TemplateSegmentsComposite1_6);
                    return;
                }
                int[] memSel = TemplateSegmentsComposite1.this.memberTable.getSelectionIndices();
                if (memSel == null || memSel.length == 0) {
                    PDDialogs.openInfoThreadSafe((String)Messages.TE_infoCopybookEditNoSelErr);
                    return;
                }
                MemberType selectedMember = TemplateSegmentsComposite1.this.getSelectedMember(memSel[0]);
                if (selectedMember.getLib() > TemplateSegmentsComposite1.this.aTemplate.getCopybooks().getLibrary().size()) {
                    String errMsg = MessageFormat.format(Messages.TE_infoCopybookEditLibIndexErr, selectedMember.getLib(), TemplateSegmentsComposite1.this.aTemplate.getCopybooks().getLibrary().size());
                    PDDialogs.openErrorThreadSafe((String)errMsg);
                    return;
                }
                AdvancedCopybookEntry entry = TemplateSegmentsComposite1.this.populateAdvancedCopybookEntry(selectedMember);
                EditAdvancedSelectionCopybookDialog dlg = new EditAdvancedSelectionCopybookDialog(Display.getCurrent().getActiveShell());
                dlg.setCopybookEntry(entry);
                if (dlg.open() != 0) {
                    return;
                }
                TemplateSegmentsComposite1.repopulateMemberInfo(entry, selectedMember);
                TemplateSegmentsComposite1.this.editor.libUpdated(true);
                TemplateSegmentsComposite1.this.editor.setEditorDirty();
            }
        });
    }

    private void setupListenersForTableCursor() {
        this.memberTableCursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TemplateSegmentsComposite1.this.handleCursorSelection();
            }
        });
        this.memberTableCursor.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                TemplateSegmentsComposite1.this.handleCursorSelection();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.memberTableCursor.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                Text text2;
                int index = TemplateSegmentsComposite1.this.memberTable.indexOf(TemplateSegmentsComposite1.this.memberTableCursor.getRow());
                if (index != -1) {
                    TemplateSegmentsComposite1.this.memberTable.setSelection(index);
                }
                if (TemplateSegmentsComposite1.this.memberTableCursor.getColumn() == 3 && !Character.isISOControl(e.character)) {
                    Text text3 = TemplateSegmentsComposite1.this.create01FieldNameText();
                    if (text3 != null) {
                        TemplateSegmentsComposite1.this.memberTableCursorEditor.setEditor((Control)text3);
                        text3.setText("" + e.character);
                        text3.setSelection(1);
                        text3.setFocus();
                    }
                } else if (TemplateSegmentsComposite1.this.memberTableCursor.getColumn() == 4 && !Character.isISOControl(e.character) && (text2 = TemplateSegmentsComposite1.this.createSegmentDescriptionText()) != null) {
                    TemplateSegmentsComposite1.this.memberTableCursorEditor.setEditor((Control)text2);
                    text2.setText("" + e.character);
                    text2.setSelection(1);
                    text2.setFocus();
                }
            }
        });
    }

    private void handleCursorSelection() {
        if (this.memberTableCursor.getColumn() == 3) {
            Text text2 = this.create01FieldNameText();
            if (text2 != null) {
                this.memberTableCursorEditor.setEditor((Control)text2);
                text2.setFocus();
            }
            return;
        }
        if (this.memberTableCursor.getColumn() == 4) {
            if (this.memberTable.getSelectionIndex() != 0) {
                return;
            }
            Text text3 = this.createSegmentDescriptionText();
            if (text3 != null) {
                this.memberTableCursorEditor.setEditor((Control)text3);
                text3.setFocus();
            }
            return;
        }
    }

    private Text create01FieldNameText() {
        final Text text2 = new Text((Composite)this.memberTableCursor, 0);
        text2.setFont(JFaceResources.getTextFont());
        text2.setFocus();
        text2.setText(this.memberTableCursor.getRow().getText(this.memberTableCursor.getColumn()));
        text2.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    TemplateSegmentsComposite1.this.update01NameText(text2);
                    text2.dispose();
                } else if (e.keyCode == 27) {
                    text2.dispose();
                }
            }
        });
        text2.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TemplateSegmentsComposite1.this.update01NameText(text2);
                text2.dispose();
            }
        });
        return text2;
    }

    private void update01NameText(Text text2) {
        int selectionIndex = this.memberTable.indexOf(this.memberTableCursor.getRow());
        String newValue = text2.getText().trim();
        MemberType aMember = this.getSelectedMember(selectionIndex);
        aMember.setName01(newValue);
        this.showSegmentLayoutCopybookInfo(this.segmentTable.getSelectionIndex());
        text2.dispose();
        this.editor.libUpdated(true);
        this.editor.setEditorDirty();
    }

    private Text createSegmentDescriptionText() {
        final Text text2 = new Text((Composite)this.memberTableCursor, 0);
        text2.setFont(JFaceResources.getTextFont());
        text2.setFocus();
        text2.setText(this.memberTableCursor.getRow().getText(this.memberTableCursor.getColumn()));
        text2.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    TemplateSegmentsComposite1.this.updateSegmentDescription(text2);
                    text2.dispose();
                } else if (e.keyCode == 27) {
                    text2.dispose();
                }
            }
        });
        text2.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TemplateSegmentsComposite1.this.updateSegmentDescription(text2);
                text2.dispose();
            }
        });
        return text2;
    }

    private void updateSegmentDescription(Text text2) {
        int selectionIndex = this.memberTable.indexOf(this.memberTableCursor.getRow());
        String newValue = text2.getText().trim();
        MemberType aMember = this.getSelectedMember(selectionIndex);
        aMember.setSegdesc(newValue);
        this.showSegmentLayoutCopybookInfo(this.segmentTable.getSelectionIndex());
        text2.dispose();
        this.editor.libUpdated(true);
        this.editor.setEditorDirty();
    }

    private MemberType getSelectedMember(int memberIndex) {
        int selectionIndex = this.segmentTable.getSelectionIndex();
        if (selectionIndex == -1) {
            return null;
        }
        TableItem item = this.segmentTable.getItem(selectionIndex);
        String segmentName = item.getText(0);
        int memberIndexForSegment = -1;
        EList members = this.aTemplate.getCopybooks().getMember();
        for (MemberType aMember : members) {
            if (!segmentName.equals(aMember.getSegname()) || ++memberIndexForSegment != memberIndex) continue;
            return aMember;
        }
        return null;
    }

    private AdvancedCopybookEntry populateAdvancedCopybookEntry(MemberType selectedMember) {
        String libName = (String)this.aTemplate.getCopybooks().getLibrary().get(selectedMember.getLib() - 1);
        AdvancedCopybookEntry anEntry = new AdvancedCopybookEntry();
        anEntry.setCopybook(Member.parse((IPDHost)this.aTemplateResource.getSystem(), (String)libName, (String)selectedMember.getName()));
        if (selectedMember.getName01() != null && selectedMember.getName01().length() > 0) {
            anEntry.setInsert01(true);
            anEntry.setInsert01FieldName(selectedMember.getName01());
        } else {
            anEntry.setInsert01(false);
            anEntry.setInsert01FieldName(null);
        }
        if (selectedMember.getRedefine() != null) {
            Redefinetype redefine = selectedMember.getRedefine();
            if (redefine.isSetChglvl() && redefine.isChglvl()) {
                anEntry.setRedefinesCOBOLLevelChange(true);
            } else {
                anEntry.setRedefinesCOBOLLevelChange(false);
            }
            if (redefine.isSetOffset() && redefine.isOffset()) {
                anEntry.setRedefinesSetOffset(true);
            } else {
                anEntry.setRedefinesSetOffset(false);
            }
            if (redefine.getName() != null && !redefine.getName().equals("")) {
                anEntry.setRedefinesFieldName(redefine.getName());
            } else {
                anEntry.setRedefinesFieldName(null);
            }
            if (redefine.isSetLevel()) {
                anEntry.setRedefinesLevel(redefine.getLevel());
            } else {
                anEntry.setRedefinesLevel(0);
            }
        }
        if (selectedMember.getSourcerange() != null) {
            Sourcerangetype sourceRange = selectedMember.getSourcerange();
            if (sourceRange.isSetFromstmt()) {
                anEntry.setRangeFromStatement(sourceRange.getFromstmt());
                anEntry.setRangeFromString(sourceRange.getFromstr());
            } else {
                anEntry.setRangeFromStatement(0);
                anEntry.setRangeFromString(null);
            }
            if (sourceRange.isSetTostmt()) {
                anEntry.setRangeToStatement(sourceRange.getTostmt());
                anEntry.setRangeToString(sourceRange.getFromstr());
            } else {
                anEntry.setRangeToStatement(0);
                anEntry.setRangeToString(null);
            }
        }
        return anEntry;
    }

    private static void repopulateMemberInfo(AdvancedCopybookEntry anEntry, MemberType aMember) {
        if (anEntry.isInsert01()) {
            aMember.setName01(anEntry.getInsert01FieldName());
        } else {
            aMember.setName01("");
        }
        Redefinetype aRedefine = TemplateFactory.eINSTANCE.createRedefinetype();
        aMember.setRedefine(aRedefine);
        if (anEntry.isRedefinesCOBOLLevelChange()) {
            aRedefine.setChglvl(true);
        } else {
            aRedefine.setChglvl(false);
        }
        if (anEntry.isRedefinesSetOffset()) {
            aRedefine.setOffset(true);
        } else {
            aRedefine.setOffset(false);
        }
        if (anEntry.getRedefinesFieldName() != null && anEntry.getRedefinesFieldName().length() > 0) {
            aRedefine.setName(anEntry.getRedefinesFieldName());
        } else {
            aRedefine.setName("");
        }
        if (anEntry.getRedefinesLevel() > 0) {
            aRedefine.setLevel(anEntry.getRedefinesLevel());
        } else {
            aRedefine.setLevel(0);
        }
        Sourcerangetype sourceRange = TemplateFactory.eINSTANCE.createSourcerangetype();
        aMember.setSourcerange(sourceRange);
        if (anEntry.getRangeFromStatement() > 0) {
            sourceRange.setFromstmt(anEntry.getRangeFromStatement());
        } else {
            sourceRange.setFromstmt(0);
        }
        if (anEntry.getRangeFromString() != null && anEntry.getRangeFromString().length() > 0) {
            sourceRange.setFromstr(anEntry.getRangeFromString());
        } else {
            sourceRange.setFromstr("");
        }
        if (anEntry.getRangeToStatement() > 0) {
            sourceRange.setTostmt(anEntry.getRangeToStatement());
        } else {
            sourceRange.setTostmt(0);
        }
        if (anEntry.getRangeToString() != null && anEntry.getRangeToString().length() > 0) {
            sourceRange.setTostr(anEntry.getRangeToString());
        } else {
            sourceRange.setTostr("");
        }
    }

    private void createButtons(Composite parent) {
        GridData data = new GridData();
        data.widthHint = 100;
        Composite buttonsComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)true), (Object)GUI.grid.d.fillH((int)1));
        this.updateButton = GUI.button.push((Composite)buttonsComposite, (String)Messages.TE_infoCopybookUpdateButton, (Object)data);
        this.updateButton.setToolTipText(Messages.TE_infoCopybookUpdateButtonTip);
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompileType compOpts;
                if (TemplateSegmentsComposite1.this.libraryTable.getItemCount() > 12) {
                    PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.TE_infoCopybookUpdateTooManyLibErr, 12));
                    return;
                }
                if (TemplateSegmentsComposite1.this.libraryTable.getItemCount() == 0) {
                    PDDialogs.openErrorThreadSafe((String)Messages.TE_infoCopybookUpdateNoLibErr);
                    return;
                }
                if (FMHost.getSystem((IPDHost)TemplateSegmentsComposite1.this.aTemplateResource.getSystem()).getCompilerOptions() != null && FMHost.getSystem((IPDHost)TemplateSegmentsComposite1.this.aTemplateResource.getSystem()).getCompilerOptions().length() > 0 && (compOpts = CompilerOptionsUtil.load((String)FMHost.getSystem((IPDHost)TemplateSegmentsComposite1.this.aTemplateResource.getSystem()).getCompilerOptions(), (String)TemplateSegmentsComposite1.this.aTemplateResource.getSystem().getConnectionName())) != null && compOpts.isOverride()) {
                    if (TemplateSegmentsComposite1.this.aTemplate.getCopybooks().getCobol() != null) {
                        Coboltype cobType = TemplateFactory.eINSTANCE.createCoboltype();
                        TemplateSegmentsComposite1.this.aTemplate.getCopybooks().setCobol(cobType);
                    }
                    if (TemplateSegmentsComposite1.this.aTemplate.getCopybooks().getPli() != null) {
                        Plitype pliType = TemplateFactory.eINSTANCE.createPlitype();
                        TemplateSegmentsComposite1.this.aTemplate.getCopybooks().setPli(pliType);
                    }
                    if (TemplateSegmentsComposite1.this.aTemplate.getCopybooks().getAsm() != null) {
                        Asmtype asmType = TemplateFactory.eINSTANCE.createAsmtype();
                        TemplateSegmentsComposite1.this.aTemplate.getCopybooks().setAsm(asmType);
                    }
                }
                HashMap<MemberType, Integer> libNumberList = new HashMap<MemberType, Integer>();
                EList members = TemplateSegmentsComposite1.this.aTemplate.getCopybooks().getMember();
                int i = 0;
                while (i < members.size()) {
                    MemberType aMember = (MemberType)members.get(i);
                    libNumberList.put(aMember, aMember.getLib());
                    aMember.unsetLib();
                    ++i;
                }
                try {
                    Result<StringBuffer> result = TemplateSegmentsComposite1.this.editor.updateTemplate(null, true);
                    if (result.isSuccessfulWithoutWarnings()) {
                        TemplateSegmentsComposite1.this.editor.refreshGUI();
                        TemplateSegmentsComposite1.this.editor.libUpdated(false);
                        PDDialogs.openInfoThreadSafe((String)Messages.TE_infoCopybookUpdateSuccess);
                        return;
                    }
                    EList mems = TemplateSegmentsComposite1.this.aTemplate.getCopybooks().getMember();
                    int i2 = 0;
                    while (i2 < mems.size()) {
                        MemberType aMember = (MemberType)mems.get(i2);
                        Integer libNo = (Integer)libNumberList.get(aMember);
                        if (libNo != null) {
                            aMember.setLib(libNo.intValue());
                        }
                        ++i2;
                    }
                    PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.TE_infoCopybookUpdateError, TemplateSegmentsComposite1.this.aTemplateResource.getFormattedName()), (String)result.dumpOutputAndMessages(true), (String[])new String[]{Messages.OpenAsTemplate_GET_LIST}, (PDDialogWithText.ITextDialogRunnable[])new PDDialogWithText.ITextDialogRunnable[]{TemplateSegmentsComposite1.this.getRetrieveCompilerListingAction()});
                    return;
                }
                catch (Exception ex) {
                    String errMsg = MessageFormat.format(Messages.TE_infoCopybookUpdateError, TemplateSegmentsComposite1.this.aTemplateResource.getFormattedName());
                    logger.error((Object)errMsg, (Throwable)ex);
                    PDDialogs.openErrorThreadSafe((String)errMsg);
                    return;
                }
            }
        });
    }

    private PDDialogWithText.ITextDialogRunnable getRetrieveCompilerListingAction() {
        return new PDDialogWithText.ITextDialogRunnable(){

            public void run(PDDialogWithText dialog) {
                try {
                    PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.setTaskName(Messages.OpenAsTemplate_GET_LIST_OPS_NAME);
                            IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                            try {
                                IFile tmpFile = PDFileSystemUtil.getTempFile((String)"FM");
                                Result listResult = (this).TemplateSegmentsComposite1.this.session.getCompilerListing(howIsGoing, tmpFile);
                                if (listResult.getRC() == 0) {
                                    PDEditorManagement.openEditorFromWorkerThread((IFile)tmpFile, (IHowIsGoing)howIsGoing);
                                } else if (listResult.getMessagesCombined().toString().contains("FMNBI014 FMI_GetCompileList requires FMNPRINT to be allocated.")) {
                                    PDDialogs.openErrorThreadSafe((String)Messages.TemplateSegmentsComposite1_7);
                                } else {
                                    PDDialogs.openErrorThreadSafe((String)Messages.OpenAsTemplate_GET_LIST_ERR, (String)listResult.getMessagesCombined().toString());
                                }
                            }
                            catch (CoreException e) {
                                String errMsg = Messages.OpenAsTemplate_GET_LIST_ERR;
                                PDDialogs.openErrorThreadSafe((String)errMsg);
                                logger.error((Object)errMsg, (Throwable)e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    String errMsg = Messages.OpenAsTemplate_GET_LIST_ERR;
                    PDDialogs.openErrorThreadSafe((String)errMsg);
                    logger.error((Object)errMsg, (Throwable)e);
                }
            }
        };
    }

    private static void createLibraryTableColumns(TableViewer viewer) {
        FormattedEditorUtility.createTableViewerColumn("", 50, viewer, 0x1000000);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_infoCopybookTableColumnLibIndex, 100, viewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_infoCopybookTableColumnLib, 500, viewer, 16384);
    }

    private static void createMemberTableColumns(TableViewer viewer) {
        FormattedEditorUtility.createTableViewerColumn("", 50, viewer, 0x1000000);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_infoCopybookTableColumnMemberLibIndex, 100, viewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_infoCopybookTableColumnMember, 150, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TemplateSegmentsComposite1_8, 150, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TemplateSegmentsComposite1_9, 200, viewer, 16384);
    }

    private void showSegmentLayoutCopybookInfo(int segmentSelectionIndex) {
        if ("IMS".equals(this.aTemplate.getType())) {
            this.libraryTableViewer.setLabelProvider((IBaseLabelProvider)new TemplateSegmentsComposite1LibraryInformationLabelProvider((List<String>)this.aTemplate.getCopybooks().getLibrary()));
            this.libraryTableViewer.setInput((Object)this.aTemplate.getCopybooks().getLibrary());
            this.segmentTableViewer.setLabelProvider((IBaseLabelProvider)new TemplateSegmentsComposite1SegmentLabelProvider());
            this.segmentTableViewer.setInput(this.editor.getSegmentsAndLayouts().getSegments(this.editor.getEditorInput().getSessionIdentifer()));
            if (segmentSelectionIndex != -1) {
                this.segmentTable.setSelection(segmentSelectionIndex);
            }
            if (this.segmentTable.getSelectionIndex() != -1) {
                int selectionIndex = this.segmentTable.getSelectionIndex();
                TableItem item = this.segmentTable.getItem(selectionIndex);
                String segmentName = item.getText(0);
                this.setMembersForSegment(segmentName);
            } else {
                this.setMembersForSegment(null);
            }
        }
    }

    private static int addLibIfNew(EList<String> list, String newLibName) {
        int i = 0;
        while (i < list.size()) {
            String aLib = (String)list.get(i);
            if (aLib.equals(newLibName)) {
                return i + 1;
            }
            ++i;
        }
        list.add((Object)newLibName);
        return list.size();
    }

    private static void addMemIfNew(EList<MemberType> memList, int libNo, String memName, String segName) {
        MemberType aNewMember = TemplateFactory.eINSTANCE.createMemberType();
        aNewMember.setLib(libNo);
        aNewMember.setName(memName);
        aNewMember.setSegname(segName);
        memList.add((Object)aNewMember);
    }

    public void setNewTemplate(TemplateType newTemplate) {
        this.aTemplate = newTemplate;
        this.showSegmentLayoutCopybookInfo(-1);
    }

    private void createSegmentTable(Composite parent) {
        Composite compoiste = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.segmentTable = new Table(compoiste, 68354);
        this.segmentTable.setHeaderVisible(true);
        this.segmentTable.setLinesVisible(true);
        this.segmentTable.setLayoutData((Object)GUI.grid.d.fillAll());
        this.segmentTableViewer = new TableViewer(this.segmentTable);
        this.segmentTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TemplateSegmentsComposite1.createSegmentTableColumns(this.segmentTableViewer);
        this.segmentTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int selectionIndex = TemplateSegmentsComposite1.this.segmentTable.getSelectionIndex();
                TableItem item = TemplateSegmentsComposite1.this.segmentTable.getItem(selectionIndex);
                String segmentName = item.getText(0);
                TemplateSegmentsComposite1.this.setMembersForSegment(segmentName);
            }
        });
    }

    private void setMembersForSegment(String segmentName) {
        this.memberTableViewer.setLabelProvider((IBaseLabelProvider)new TemplateSegmentsComposite1MemberLabelProvider(segmentName));
        if (segmentName == null || segmentName.isEmpty()) {
            this.memberTableViewer.setInput(null);
        } else {
            EList members = this.aTemplate.getCopybooks().getMember();
            ArrayList<MemberType> memForSeg = new ArrayList<MemberType>();
            for (MemberType m : members) {
                if (!segmentName.equals(m.getSegname())) continue;
                memForSeg.add(m);
            }
            this.memberTableViewer.setInput(memForSeg);
        }
    }

    private static void createSegmentTableColumns(TableViewer viewer) {
        FormattedEditorUtility.createTableViewerColumn(Messages.TemplateSegmentsComposite1_14, 120, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TemplateSegmentsComposite1_10, 120, viewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.TemplateSegmentsComposite1_11, 120, viewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.TemplateSegmentsComposite1_12, 120, viewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.TemplateSegmentsComposite1_13, 120, viewer, 16384);
    }

    public Button getRebuildButton() {
        return this.updateButton;
    }
}

