/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template1;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionTemplate;
import com.ibm.etools.fm.core.model.IRetrieveCcsidSession;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.template.dialogs.CcsidSelectionDialog;
import com.ibm.etools.fm.editor.template.dialogs.DateTimeDialog;
import com.ibm.etools.fm.editor.template.dialogs.FieldAttributeDialog;
import com.ibm.etools.fm.editor.template1.ITemplateEditor1;
import com.ibm.etools.fm.editor.template1.SegmentAndLayoutIndex;
import com.ibm.etools.fm.editor.template1.StringArrayElementTableLabelProvider;
import com.ibm.etools.fm.editor.template1.TemplateEditorUtilities1;
import com.ibm.etools.fm.editor.template1.dialogs.ByFieldCriteriaSpecificationDialog1;
import com.ibm.etools.fm.editor.template1.dialogs.FreeCriteriaEntryDialog1;
import com.ibm.etools.fm.editor.template1.label.TemplateLayoutCompositeLabelProvider;
import com.ibm.etools.fm.jhost.core.version.FMFeature;
import com.ibm.etools.fm.model.template.Criteriatype;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.TypeType1;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.version.PDFeature;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class TemplateLayoutComposite1 {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(TemplateLayoutComposite1.class);
    private static final int INDEX_SEQUENCE_COLUMN = 2;
    private static final int INDEX_HOLD_COLUMN = 3;
    private static final int INDEX_SELECTED_COLUMN = 4;
    private static final int INDEX_TYPE_COLUMN = 9;
    private static final int INDEX_CCSID_COLUMN = 12;
    private AbstractSessionTemplate session = null;
    private TemplateType aTemplate = null;
    private IZRL aTemplateResource = null;
    private ITemplateEditor1 editor = null;
    private Combo currentSegmentCombo = null;
    private Combo currentLayoutCombo = null;
    private Text copybookNameText = null;
    private Button layoutSelectedCheckbox = null;
    private Text idCriteriaText = null;
    private Text selCriteriaText = null;
    private Button idCriteriaBuildButton = null;
    private Button idCriteriaWriteButton = null;
    private Button idCriteriaClearButton = null;
    private Button selCriteriaBuildButton = null;
    private Button selCriteriaWritedButton = null;
    private Button selCriteriaClearButton = null;
    private Text offsetText = null;
    private TabItem layoutTab = null;
    private Table fieldTable = null;
    private TableViewer fieldTableViewer = null;
    private TableCursor fieldTableCursor = null;
    private ControlEditor fieldTableCursorEditor = null;
    private Button specifyAttributeButton = null;
    private Button setHoldButton = null;
    private Button setSelectedButton = null;
    private Button setCcsidButton = null;
    private boolean updateInProgress = false;

    public TemplateLayoutComposite1(AbstractSessionTemplate session, TemplateType aTemplate, IZRL aTemplateResource, ITemplateEditor1 editor2) {
        this.session = session;
        this.aTemplate = aTemplate;
        this.aTemplateResource = aTemplateResource;
        this.editor = editor2;
    }

    public void createLayoutTab(TabFolder tabFolder) {
        this.layoutTab = new TabItem(tabFolder, 0);
        this.layoutTab.setText(Messages.TE_layoutTabName);
        Composite parent = GUI.composite((Composite)tabFolder, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        Composite layoutSelComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)layoutSelComposite, (String)Messages.TemplateLayoutComposite1_0, (Object)GUI.grid.d.left1(), (int)16384);
        this.currentSegmentCombo = GUI.combo.readOnly((Composite)layoutSelComposite, (Object)GUI.grid.d.fillH((int)3), (Object[])new String[0]);
        this.currentSegmentCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateLayoutComposite1.this.updateInProgress = true;
                TemplateLayoutComposite1.this.currentLayoutCombo.setItems(TemplateLayoutComposite1.this.editor.getSegmentsAndLayouts().getLayoutNames(TemplateLayoutComposite1.this.currentSegmentCombo.getText()));
                TemplateLayoutComposite1.this.setSegmentAndLayout(new SegmentAndLayoutIndex(TemplateLayoutComposite1.this.currentSegmentCombo.getSelectionIndex(), 0), 0);
                TemplateLayoutComposite1.this.updateInProgress = false;
            }
        });
        GUI.label((Composite)layoutSelComposite, (String)Messages.TE_LAYOUT, (Object)GUI.grid.d.left1(), (int)16384);
        this.currentLayoutCombo = GUI.combo.readOnly((Composite)layoutSelComposite, (Object)GUI.grid.d.fillH((int)1), (Object[])new String[0]);
        this.currentLayoutCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TemplateLayoutComposite1.this.updateInProgress = true;
                TemplateLayoutComposite1.this.setSegmentAndLayout(new SegmentAndLayoutIndex(TemplateLayoutComposite1.this.currentSegmentCombo.getSelectionIndex(), TemplateLayoutComposite1.this.currentLayoutCombo.getSelectionIndex()), 0);
                TemplateLayoutComposite1.this.updateInProgress = false;
            }
        });
        GUI.label((Composite)layoutSelComposite, (String)Messages.TemplateLayoutComposite_0, (Object)GUI.grid.d.left1(), (int)16384);
        this.copybookNameText = GUI.text.fieldReadOnly((Composite)layoutSelComposite, (Object)GUI.grid.d.fillH((int)1));
        this.copybookNameText.setToolTipText(Messages.TemplateLayoutComposite_1);
        Group layoutGroup = GUI.group((Composite)parent, (String)Messages.TE_LAYOUT_DETAILED_INFO, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        Composite layoutInfoComposite = GUI.composite((Composite)layoutGroup, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        if ("VIEW".equals(this.aTemplate.getType())) {
            this.layoutSelectedCheckbox = GUI.button.checkbox((Composite)layoutInfoComposite, (String)Messages.TE_LAYOUT_SELECTED, (Object)GUI.grid.d.fillH((int)3));
            this.layoutSelectedCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Layouttype currentLayout = TemplateLayoutComposite1.this.getCurrentlySelectedLayout();
                    if (TemplateLayoutComposite1.this.layoutSelectedCheckbox.getSelection()) {
                        currentLayout.setSegsel(true);
                        TemplateLayoutComposite1.this.editor.setEditorDirty();
                        return;
                    }
                    currentLayout.setSegsel(false);
                    TemplateLayoutComposite1.this.editor.setEditorDirty();
                }
            });
        }
        GridData buttonGridData = GUI.grid.d.left1();
        GUI.label((Composite)layoutInfoComposite, (String)Messages.TE_LAYOUT_ID_CRITERIA, (Object)GUI.grid.d.left1(), (int)16384);
        this.idCriteriaText = GUI.text.fieldReadOnly((Composite)layoutInfoComposite, (Object)GUI.grid.d.fillH((int)1));
        Composite idButtonsComposite = GUI.composite((Composite)layoutInfoComposite, (Layout)GUI.grid.l.noMargins((int)3, (boolean)false), (Object)GUI.grid.d.left1());
        this.idCriteriaBuildButton = GUI.button.push((Composite)idButtonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaWiz.gif"), (String)Messages.TE_LAYOUT_BuildCriteriaButton_ID, (Object)buttonGridData);
        this.idCriteriaBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateLayoutComposite1.this.offsetUpdated()) {
                    return;
                }
                TemplateLayoutComposite1.this.buildCriteria(TypeType1.ID);
            }
        });
        this.idCriteriaWriteButton = GUI.button.push((Composite)idButtonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaWriter.gif"), (String)Messages.TE_LAYOUT_WriteCriteriaButton_ID, (Object)buttonGridData);
        this.idCriteriaWriteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateLayoutComposite1.this.offsetUpdated()) {
                    return;
                }
                TemplateLayoutComposite1.this.writeCriteria(TypeType1.ID);
            }
        });
        this.idCriteriaClearButton = GUI.button.push((Composite)idButtonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaClear.gif"), (String)Messages.TE_LAYOUT_ClearCriteriaButton_ID, (Object)buttonGridData);
        this.idCriteriaClearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateLayoutComposite1.this.offsetUpdated()) {
                    return;
                }
                SegmentAndLayoutIndex index = TemplateLayoutComposite1.this.getCurrentSelection();
                Layouttype currentLayout = TemplateLayoutComposite1.this.editor.getSegmentsAndLayouts().getLayout(index);
                EList criteriaList = currentLayout.getCriteria();
                int i = 0;
                while (i < criteriaList.size()) {
                    Criteriatype aCriteria = (Criteriatype)criteriaList.get(i);
                    if (aCriteria.getType() == TypeType1.ID) {
                        TemplateLayoutComposite1.clearCriteriaSpec(aCriteria);
                        TemplateLayoutComposite1.this.editor.setEditorDirty();
                        TemplateType clearedTemplate = TemplateLayoutComposite1.this.clearCrietria();
                        if (clearedTemplate != null) {
                            TemplateLayoutComposite1.this.idCriteriaText.setText("");
                            TemplateLayoutComposite1.this.updateCriteria(clearedTemplate);
                            TemplateLayoutComposite1.this.updateInProgress = true;
                            TemplateLayoutComposite1.this.setSegmentAndLayout(index, TemplateLayoutComposite1.this.fieldTable.getSelectionIndex());
                            TemplateLayoutComposite1.this.updateInProgress = false;
                        }
                        return;
                    }
                    ++i;
                }
            }
        });
        GUI.label((Composite)layoutInfoComposite, (String)Messages.TE_LAYOUT_SEL_CRITERIA, (Object)GUI.grid.d.left1(), (int)16384);
        this.selCriteriaText = GUI.text.fieldReadOnly((Composite)layoutInfoComposite, (Object)GUI.grid.d.fillH((int)1));
        Composite selButtonsComposite = GUI.composite((Composite)layoutInfoComposite, (Layout)GUI.grid.l.noMargins((int)3, (boolean)false), (Object)GUI.grid.d.left1());
        this.selCriteriaBuildButton = GUI.button.push((Composite)selButtonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaWiz.gif"), (String)Messages.TE_LAYOUT_BuildCriteriaButton_SEL, (Object)buttonGridData);
        this.selCriteriaBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateLayoutComposite1.this.offsetUpdated()) {
                    return;
                }
                TemplateLayoutComposite1.this.buildCriteria(TypeType1.SEL);
            }
        });
        this.selCriteriaWritedButton = GUI.button.push((Composite)selButtonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaWriter.gif"), (String)Messages.TE_LAYOUT_WriteCriteriaButton_SEL, (Object)buttonGridData);
        this.selCriteriaWritedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateLayoutComposite1.this.offsetUpdated()) {
                    return;
                }
                TemplateLayoutComposite1.this.writeCriteria(TypeType1.SEL);
            }
        });
        this.selCriteriaClearButton = GUI.button.push((Composite)selButtonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaClear.gif"), (String)Messages.TE_LAYOUT_ClearCriteriaButton_SEL, (Object)buttonGridData);
        this.selCriteriaClearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateLayoutComposite1.this.offsetUpdated()) {
                    return;
                }
                SegmentAndLayoutIndex index = TemplateLayoutComposite1.this.getCurrentSelection();
                Layouttype currentLayout = TemplateLayoutComposite1.this.editor.getSegmentsAndLayouts().getLayout(index);
                EList criteriaList = currentLayout.getCriteria();
                int i = 0;
                while (i < criteriaList.size()) {
                    Criteriatype aCriteria = (Criteriatype)criteriaList.get(i);
                    if (aCriteria.getType() == TypeType1.SEL) {
                        TemplateLayoutComposite1.clearCriteriaSpec(aCriteria);
                        TemplateLayoutComposite1.this.editor.setEditorDirty();
                        TemplateType clearedTemplate = TemplateLayoutComposite1.this.clearCrietria();
                        if (clearedTemplate != null) {
                            TemplateLayoutComposite1.this.selCriteriaText.setText("");
                            TemplateLayoutComposite1.this.updateCriteria(clearedTemplate);
                            TemplateLayoutComposite1.this.updateInProgress = true;
                            TemplateLayoutComposite1.this.setSegmentAndLayout(index, TemplateLayoutComposite1.this.fieldTable.getSelectionIndex());
                            TemplateLayoutComposite1.this.updateInProgress = false;
                        }
                        return;
                    }
                    ++i;
                }
            }
        });
        GUI.label((Composite)layoutInfoComposite, (String)Messages.TE_LAYOUT_OFFSET, (Object)GUI.grid.d.left1(), (int)16384);
        this.offsetText = GUI.text.field((Composite)layoutInfoComposite, (Object)GUI.grid.d.fillH((int)2));
        NumberForcer nf = NumberForcer.addTo(this.offsetText);
        nf.setLowerBound(-32760, true);
        nf.setUpperBound(32760, true);
        this.offsetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TemplateLayoutComposite1.this.updateInProgress) {
                    return;
                }
                TemplateLayoutComposite1.this.editor.offsetUpdated();
                Layouttype currentLayout = TemplateLayoutComposite1.this.getCurrentlySelectedLayout();
                if (!TemplateLayoutComposite1.this.offsetText.getText().trim().isEmpty()) {
                    if (TemplateLayoutComposite1.this.offsetText.getText().trim().equals("-")) {
                        currentLayout.setOffset(0);
                        TemplateLayoutComposite1.this.editor.setEditorDirty();
                    } else {
                        currentLayout.setOffset(Integer.parseInt(TemplateLayoutComposite1.this.offsetText.getText().trim()));
                        TemplateLayoutComposite1.this.editor.setEditorDirty();
                    }
                } else {
                    currentLayout.setOffset(0);
                    TemplateLayoutComposite1.this.editor.setEditorDirty();
                }
            }
        });
        Composite tableComposite = GUI.composite((Composite)layoutGroup, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.fieldTable = new Table(tableComposite, 68354);
        this.fieldTable.setHeaderVisible(true);
        this.fieldTable.setLinesVisible(true);
        GridData fillAll = GUI.grid.d.fillAll();
        fillAll.heightHint = 300;
        this.fieldTable.setLayoutData((Object)fillAll);
        this.fieldTableViewer = new TableViewer(this.fieldTable);
        this.fieldTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.createFieldColumns(this.fieldTableViewer);
        this.fieldTableCursor = new TableCursor(this.fieldTable, 0);
        this.fieldTableCursor.setFont(JFaceResources.getDefaultFont());
        this.fieldTableCursorEditor = new ControlEditor((Composite)this.fieldTableCursor);
        this.fieldTableCursorEditor.grabHorizontal = true;
        this.fieldTableCursorEditor.grabVertical = true;
        this.addCursorListener();
        this.createButtonsComposite(tableComposite);
        this.layoutTab.setControl((Control)parent);
        this.initialiseGUI();
    }

    private void initialiseGUI() {
        this.updateInProgress = true;
        this.currentSegmentCombo.setItems(this.editor.getSegmentsAndLayouts().getSegmentNames());
        int initialSegmentIndex = this.editor.getEditorInput().getSegmentAndLayoutIndex().getSegmentIndex();
        this.currentSegmentCombo.select(initialSegmentIndex);
        this.currentLayoutCombo.setItems(this.editor.getSegmentsAndLayouts().getLayoutNames(this.currentSegmentCombo.getText()));
        int initialLayoutIndex = this.editor.getEditorInput().getSegmentAndLayoutIndex().getLayoutIndex();
        this.setSegmentAndLayout(new SegmentAndLayoutIndex(initialSegmentIndex, initialLayoutIndex), 0);
        this.enableControlsByTemplateType();
        this.updateInProgress = false;
    }

    private static void clearCriteriaSpec(Criteriatype aCriteria) {
        aCriteria.unsetByfield();
        aCriteria.unsetOr();
        aCriteria.unsetRelated01();
        aCriteria.setExp("");
        aCriteria.getByline().clear();
    }

    private void createFieldColumns(TableViewer viewer) {
        TableViewerColumn statusColumn = FormattedEditorUtility.createTableViewerColumn("", 10, viewer, 16384);
        TableViewerColumn referenceColumn = FormattedEditorUtility.createTableViewerColumn(Messages.TE_REFERENCE, 70, viewer, 131072);
        TableViewerColumn sequenceColumn = FormattedEditorUtility.createTableViewerColumn(Messages.TE_SEQUENCE, 70, viewer, 131072);
        TableViewerColumn holdColumn = FormattedEditorUtility.createTableViewerColumn(Messages.TE_HOLD, 70, viewer, 0x1000000);
        TableViewerColumn selectedColumn = FormattedEditorUtility.createTableViewerColumn(Messages.TE_SELECTED, 70, viewer, 0x1000000);
        TableViewerColumn levelColumn = FormattedEditorUtility.createTableViewerColumn(Messages.TE_LEVEL, 70, viewer, 131072);
        TableViewerColumn nameColumn = FormattedEditorUtility.createTableViewerColumn(Messages.TE_NAME, 150, viewer, 16384);
        TableViewerColumn additionalClauseColumn = FormattedEditorUtility.createTableViewerColumn(Messages.TE_CLAUSE, 250, viewer, 16384);
        TableViewerColumn pictureColumn = FormattedEditorUtility.createTableViewerColumn(Messages.TE_PICTURE, 70, viewer, 16384);
        TableViewerColumn typeColumn = FormattedEditorUtility.createTableViewerColumn(Messages.TE_TYPE, 70, viewer, 16384);
        TableViewerColumn startColumn = FormattedEditorUtility.createTableViewerColumn(Messages.TE_START, 70, viewer, 131072);
        TableViewerColumn lengthColumn = FormattedEditorUtility.createTableViewerColumn(Messages.TE_LENGTH, 70, viewer, 131072);
        if (this.aTemplateResource.getSystem().supports((PDFeature)FMFeature.TEMPLATE_FIELD_CCSID)) {
            TableViewerColumn tableViewerColumn = FormattedEditorUtility.createTableViewerColumn(Messages.CCSID, 70, viewer, 16384);
        }
        viewer.setLabelProvider((IBaseLabelProvider)new StringArrayElementTableLabelProvider());
    }

    private void addCursorListener() {
        this.fieldTableCursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TemplateLayoutComposite1.this.handleCursorSelection();
            }
        });
        this.fieldTableCursor.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                TemplateLayoutComposite1.this.handleCursorSelection();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.fieldTableCursor.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                Text text2;
                int index = TemplateLayoutComposite1.this.fieldTable.indexOf(TemplateLayoutComposite1.this.fieldTableCursor.getRow());
                if (index != -1) {
                    TemplateLayoutComposite1.this.fieldTable.setSelection(index);
                }
                if (TemplateLayoutComposite1.this.fieldTableCursor.getColumn() == 12 && !Character.isISOControl(e.character) && Character.isDigit(e.character) && (text2 = TemplateLayoutComposite1.this.createCcsidText()) != null) {
                    TemplateLayoutComposite1.this.fieldTableCursorEditor.setEditor((Control)text2);
                    text2.setText("" + e.character);
                    text2.setSelection(1);
                    text2.setFocus();
                }
            }
        });
    }

    private void handleCursorSelection() {
        if (this.updateInProgress) {
            return;
        }
        if (this.fieldTableCursor.getColumn() == 2) {
            Symboltype selectedSymbol;
            int selectionIndex = this.fieldTable.indexOf(this.fieldTableCursor.getRow());
            Layouttype currentLayout = this.getCurrentlySelectedLayout();
            Text text2 = this.prepareSequenceEditText(this.fieldTableCursor, currentLayout, selectedSymbol = (Symboltype)currentLayout.getSymbol().get(selectionIndex), selectionIndex);
            if (text2 != null) {
                this.fieldTableCursorEditor.setEditor((Control)text2);
                text2.setFocus();
            }
            return;
        }
        if (this.fieldTableCursor.getColumn() == 3) {
            if (!"VIEW".equals(this.aTemplate.getType())) {
                return;
            }
            int selectionIndex = this.fieldTable.indexOf(this.fieldTableCursor.getRow());
            SegmentAndLayoutIndex index = this.getCurrentSelection();
            Layouttype currentLayout = this.getCurrentlySelectedLayout();
            Symboltype selectedSymbol = (Symboltype)currentLayout.getSymbol().get(selectionIndex);
            if (selectedSymbol.isSetHold()) {
                selectedSymbol.setHold(!selectedSymbol.isHold());
            } else {
                selectedSymbol.setHold(true);
            }
            this.updateInProgress = true;
            this.setSegmentAndLayout(index, selectionIndex);
            this.updateInProgress = false;
            this.editor.setEditorDirty();
            return;
        }
        if (this.fieldTableCursor.getColumn() == 4) {
            if (!"VIEW".equals(this.aTemplate.getType())) {
                return;
            }
            int selectionIndex = this.fieldTable.indexOf(this.fieldTableCursor.getRow());
            Layouttype currentLayout = this.getCurrentlySelectedLayout();
            SegmentAndLayoutIndex index = this.getCurrentSelection();
            Symboltype selectedSymbol = (Symboltype)currentLayout.getSymbol().get(selectionIndex);
            if (selectedSymbol.isSetSel()) {
                selectedSymbol.setSel(!selectedSymbol.isSel());
            } else {
                selectedSymbol.setSel(true);
            }
            this.updateInProgress = true;
            this.setSegmentAndLayout(index, selectionIndex);
            this.updateInProgress = false;
            this.editor.setEditorDirty();
            return;
        }
        if (this.fieldTableCursor.getColumn() == 9) {
            int selectionIndex = this.fieldTable.indexOf(this.fieldTableCursor.getRow());
            Layouttype currentLayout = this.getCurrentlySelectedLayout();
            DateTimeDialog dialog = new DateTimeDialog((IRetrieveCcsidSession)this.session, this.aTemplateResource.getSystem(), currentLayout, selectionIndex);
            if (dialog.open() != 0) {
                return;
            }
            this.updateInProgress = true;
            this.justUpdateLayoutTableContents(currentLayout);
            this.updateInProgress = false;
            this.editor.setEditorDirty();
        } else if (this.fieldTableCursor.getColumn() == 12) {
            Text text3 = this.createCcsidText();
            if (text3 != null) {
                this.fieldTableCursorEditor.setEditor((Control)text3);
                text3.setFocus();
            }
        } else {
            return;
        }
    }

    private Text prepareSequenceEditText(TableCursor cursor, Layouttype currentLayout, final Symboltype selectedSymbol, final int selectionIndex) {
        final Text text2 = new Text((Composite)cursor, 0);
        text2.setEditable(true);
        NumberForcer nf = NumberForcer.addTo(text2);
        nf.setLowerBound(0, true);
        text2.setFont(JFaceResources.getTextFont());
        if (!selectedSymbol.isSetSeq()) {
            text2.setText("" + TemplateLayoutComposite1.getSmallestUnusedSequenceNumber(currentLayout));
        } else if (selectedSymbol.getSeq() == 0) {
            text2.setText("" + TemplateLayoutComposite1.getSmallestUnusedSequenceNumber(currentLayout));
        } else {
            text2.setText("" + selectedSymbol.getSeq());
        }
        text2.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    SegmentAndLayoutIndex index = TemplateLayoutComposite1.this.getCurrentSelection();
                    int value = 0;
                    value = text2.getText().trim().isEmpty() ? 0 : Integer.parseInt(text2.getText().trim());
                    text2.dispose();
                    selectedSymbol.setSeq(value);
                    TemplateLayoutComposite1.this.updateInProgress = true;
                    TemplateLayoutComposite1.this.setSegmentAndLayout(index, selectionIndex);
                    TemplateLayoutComposite1.this.updateInProgress = false;
                    TemplateLayoutComposite1.this.editor.setEditorDirty();
                } else if (e.character == '\u001b') {
                    text2.dispose();
                }
            }
        });
        text2.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SegmentAndLayoutIndex index = TemplateLayoutComposite1.this.getCurrentSelection();
                int value = 0;
                value = text2.getText().trim().isEmpty() ? 0 : Integer.parseInt(text2.getText().trim());
                text2.dispose();
                selectedSymbol.setSeq(value);
                TemplateLayoutComposite1.this.updateInProgress = true;
                TemplateLayoutComposite1.this.setSegmentAndLayout(index, selectionIndex);
                TemplateLayoutComposite1.this.updateInProgress = false;
                TemplateLayoutComposite1.this.editor.setEditorDirty();
            }
        });
        return text2;
    }

    private static int getSmallestUnusedSequenceNumber(Layouttype aLayout) {
        int i = 0;
        while (i < aLayout.getSymbol().size()) {
            if (!TemplateLayoutComposite1.isIndexUsed(aLayout, i + 1)) {
                return i + 1;
            }
            ++i;
        }
        return aLayout.getSymbol().size();
    }

    private static boolean isIndexUsed(Layouttype aLayout, int index) {
        int i = 0;
        while (i < aLayout.getSymbol().size()) {
            Symboltype aSymbol = (Symboltype)aLayout.getSymbol().get(i);
            if (aSymbol.isSetSeq() && aSymbol.getSeq() == index) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public SegmentAndLayoutIndex getCurrentSelection() {
        return new SegmentAndLayoutIndex(this.currentSegmentCombo.getSelectionIndex(), this.currentLayoutCombo.getSelectionIndex());
    }

    private void setSegmentAndLayout(SegmentAndLayoutIndex segLayoutIndex, int rowSelectionIndex) {
        this.currentSegmentCombo.setItems(this.editor.getSegmentsAndLayouts().getSegmentNames());
        this.currentSegmentCombo.select(segLayoutIndex.getSegmentIndex());
        this.currentLayoutCombo.setItems(this.editor.getSegmentsAndLayouts().getLayoutNames(this.currentSegmentCombo.getText()));
        this.currentLayoutCombo.select(segLayoutIndex.getLayoutIndex());
        Layouttype aLayout = this.getCurrentlySelectedLayout();
        if (aLayout == null) {
            return;
        }
        if (aLayout.getCopybook() != null) {
            this.copybookNameText.setText(aLayout.getCopybook());
        }
        if (aLayout.isSetOffset()) {
            this.offsetText.setText("" + aLayout.getOffset());
        } else {
            this.offsetText.setText("0");
        }
        if ("VIEW".equals(this.aTemplate.getType())) {
            if (aLayout.isSetSegsel()) {
                this.layoutSelectedCheckbox.setSelection(aLayout.isSegsel());
            } else {
                this.layoutSelectedCheckbox.setSelection(false);
            }
        }
        this.justUpdateLayoutTableContents(aLayout);
        if (this.fieldTable.getItemCount() > 0) {
            if (rowSelectionIndex < this.fieldTable.getItemCount()) {
                this.fieldTable.setSelection(rowSelectionIndex);
                currentColumn = this.fieldTableCursor.isVisible() ? this.fieldTableCursor.getColumn() : 2;
                this.fieldTableCursor.setSelection(rowSelectionIndex, currentColumn);
            } else {
                this.fieldTable.setSelection(0);
                currentColumn = this.fieldTableCursor.isVisible() ? this.fieldTableCursor.getColumn() : 2;
                this.fieldTableCursor.setSelection(0, currentColumn);
            }
        }
        this.idCriteriaText.setText("");
        this.selCriteriaText.setText("");
        EList criteriaList = aLayout.getCriteria();
        if (criteriaList != null && criteriaList.size() > 0) {
            for (Criteriatype aCriteria : criteriaList) {
                if (aCriteria.getType() == TypeType1.ID) {
                    this.idCriteriaText.setText(aCriteria.getExp() != null ? aCriteria.getExp() : "");
                    continue;
                }
                if (aCriteria.getType() == TypeType1.SEL) {
                    this.selCriteriaText.setText(aCriteria.getExp() != null ? aCriteria.getExp() : "");
                    continue;
                }
                logger.error((Object)("Unknown criteria type: " + aCriteria.getType().toString()));
            }
        }
    }

    private void justUpdateLayoutTableContents(Layouttype aLayout) {
        int[] selection = this.fieldTable.getSelectionIndices();
        this.fieldTableViewer.setLabelProvider((IBaseLabelProvider)new TemplateLayoutCompositeLabelProvider(aLayout, this.aTemplateResource));
        this.fieldTableViewer.setInput((Object)aLayout.getSymbol());
        this.fieldTable.setSelection(selection);
    }

    private void buildCriteria(TypeType1 type) {
        SegmentAndLayoutIndex segLayoutIndex = this.getCurrentSelection();
        Layouttype currentLayout = this.editor.getSegmentsAndLayouts().getLayout(segLayoutIndex);
        if (type != TypeType1.RID) {
            Criteriatype currentCriteria = null;
            for (Criteriatype ct : currentLayout.getCriteria()) {
                if (ct.getType() != type) continue;
                currentCriteria = ct;
                break;
            }
            if (!(currentCriteria == null || currentCriteria.isSetByfield() && currentCriteria.isByfield() || PDDialogs.openConfirm((String)Messages.TE_CriteriaChangeConfirm, (String)Messages.TE_FreeToByFieldWarning))) {
                return;
            }
        }
        ByFieldCriteriaSpecificationDialog1 dialog = null;
        dialog = new ByFieldCriteriaSpecificationDialog1(this.editor, this.session, this.aTemplateResource, this.aTemplate, segLayoutIndex, type);
        if (dialog.open() != 0) {
            return;
        }
        TemplateType templateWithNewCriteria = dialog.getTemplateWithNewCriteria();
        this.updateCriteria(templateWithNewCriteria);
        this.updateInProgress = true;
        this.setSegmentAndLayout(segLayoutIndex, this.fieldTable.getSelectionIndex());
        this.updateInProgress = false;
        this.editor.setEditorDirty();
    }

    private void updateCriteria(TemplateType templateWithNewCriteria) {
        int i = 0;
        while (i < templateWithNewCriteria.getLayout().size()) {
            Layouttype aLayout = (Layouttype)templateWithNewCriteria.getLayout().get(i);
            this.updateCriteriaForLayout(aLayout);
            ++i;
        }
    }

    private void updateCriteriaForLayout(Layouttype newLayout) {
        int i = 0;
        while (i < this.aTemplate.getLayout().size()) {
            Layouttype aLayout = (Layouttype)this.aTemplate.getLayout().get(i);
            if (aLayout.getId() == newLayout.getId()) {
                aLayout.getCriteria().clear();
                aLayout.getCriteria().addAll((Collection)newLayout.getCriteria());
                return;
            }
            ++i;
        }
    }

    private void writeCriteria(TypeType1 type) {
        SegmentAndLayoutIndex segLayoutIndex = this.getCurrentSelection();
        Layouttype currentLayout = this.editor.getSegmentsAndLayouts().getLayout(segLayoutIndex);
        Criteriatype currentCriteria = null;
        for (Criteriatype ct : currentLayout.getCriteria()) {
            if (ct.getType() != type) continue;
            if (type == TypeType1.RID) {
                if (ct.isSetRelated01()) continue;
                currentCriteria = ct;
                break;
            }
            currentCriteria = ct;
            break;
        }
        if (currentCriteria != null && currentCriteria.isSetByfield() && currentCriteria.isByfield() && !PDDialogs.openConfirm((String)Messages.TE_CriteriaChangeConfirm, (String)Messages.TE_ByFieldToFreeWarning)) {
            return;
        }
        FreeCriteriaEntryDialog1 dialog = new FreeCriteriaEntryDialog1(this.session, this.aTemplateResource, this.aTemplate, this.editor.getSegmentsAndLayouts().getLayout(segLayoutIndex), type);
        if (dialog.open() != 0) {
            return;
        }
        TemplateType templateWithNewCriteria = dialog.getTemplateWithNewCriteria();
        this.updateCriteria(templateWithNewCriteria);
        this.updateInProgress = true;
        this.setSegmentAndLayout(segLayoutIndex, this.fieldTable.getSelectionIndex());
        this.updateInProgress = false;
        this.editor.setEditorDirty();
    }

    private void createButtonsComposite(Composite parent) {
        Composite controlComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.left1());
        GridData buttonsGrid = GUI.grid.d.left1();
        this.specifyAttributeButton = GUI.button.push((Composite)controlComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/attributes.gif"), (String)Messages.TE_LAYOUT_SpecifyAttrButtonTip, (Object)buttonsGrid);
        this.specifyAttributeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int fieldIndex = TemplateLayoutComposite1.this.getSelectedFieldIndex();
                if (fieldIndex == -1) {
                    PDDialogs.openInfoThreadSafe((String)Messages.TE_LAYOUT_NoFieldSelForAction);
                    return;
                }
                if (fieldIndex == 0 && "DYNAMIC".equals(TemplateLayoutComposite1.this.aTemplate.getType())) {
                    PDDialogs.openInfoThreadSafe((String)Messages.TemplateLayoutComposite_7);
                    return;
                }
                Layouttype currentLayout = TemplateLayoutComposite1.this.getCurrentlySelectedLayout();
                FieldAttributeDialog dialog = new FieldAttributeDialog(TemplateLayoutComposite1.this.session, TemplateLayoutComposite1.this.aTemplateResource, TemplateLayoutComposite1.this.aTemplate, currentLayout, fieldIndex, false);
                if (dialog.open() != 0) {
                    if (dialog.validationErrorOccurred()) {
                        TemplateLayoutComposite1.this.editor.setEditorDirty();
                    }
                    return;
                }
                TemplateLayoutComposite1.this.editor.setEditorDirty();
            }
        });
        if ("VIEW".equals(this.aTemplate.getType())) {
            this.setHoldButton = GUI.button.push((Composite)controlComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/hold.gif"), (String)Messages.TE_LAYOUT_SetHoldTip, (Object)buttonsGrid);
            this.setHoldButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int[] selection = TemplateLayoutComposite1.this.fieldTable.getSelectionIndices();
                    if (selection == null || selection.length == 0) {
                        return;
                    }
                    Layouttype currentLayout = TemplateLayoutComposite1.this.getCurrentlySelectedLayout();
                    EList symbols = currentLayout.getSymbol();
                    int i = 0;
                    while (i < selection.length) {
                        Symboltype aSymbol = (Symboltype)symbols.get(selection[i]);
                        if (aSymbol.isSetHold() && aSymbol.isHold()) {
                            aSymbol.setHold(false);
                        } else {
                            aSymbol.setHold(true);
                        }
                        ++i;
                    }
                    TemplateLayoutComposite1.this.updateInProgress = true;
                    TemplateLayoutComposite1.this.justUpdateLayoutTableContents(currentLayout);
                    TemplateLayoutComposite1.this.updateInProgress = false;
                    TemplateLayoutComposite1.this.editor.setEditorDirty();
                }
            });
            this.setSelectedButton = GUI.button.push((Composite)controlComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/selection.gif"), (String)Messages.TE_LAYOUT_SetSelectedTip, (Object)buttonsGrid);
            this.setSelectedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int[] selection = TemplateLayoutComposite1.this.fieldTable.getSelectionIndices();
                    if (selection == null || selection.length == 0) {
                        return;
                    }
                    Layouttype currentLayout = TemplateLayoutComposite1.this.getCurrentlySelectedLayout();
                    EList symbols = currentLayout.getSymbol();
                    int i = 0;
                    while (i < selection.length) {
                        Symboltype aSymbol = (Symboltype)symbols.get(selection[i]);
                        if (aSymbol.isSetSel() && aSymbol.isSel()) {
                            aSymbol.setSel(false);
                        } else {
                            aSymbol.setSel(true);
                        }
                        ++i;
                    }
                    TemplateLayoutComposite1.this.updateInProgress = true;
                    TemplateLayoutComposite1.this.justUpdateLayoutTableContents(currentLayout);
                    TemplateLayoutComposite1.this.updateInProgress = false;
                    TemplateLayoutComposite1.this.editor.setEditorDirty();
                }
            });
        }
        if (this.aTemplateResource.getSystem().supports((PDFeature)FMFeature.TEMPLATE_FIELD_CCSID)) {
            this.setCcsidButton = GUI.button.push((Composite)controlComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/encoding.gif"), (String)Messages.TemplateLayoutComposite_9, (Object)buttonsGrid);
            this.setCcsidButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Layouttype currentLayout = TemplateLayoutComposite1.this.getCurrentlySelectedLayout();
                    CcsidSelectionDialog dialog = new CcsidSelectionDialog((IRetrieveCcsidSession)TemplateLayoutComposite1.this.session, TemplateLayoutComposite1.this.aTemplateResource.getSystem(), currentLayout, TemplateLayoutComposite1.this.fieldTable.getSelectionIndices());
                    if (dialog.open() != 0) {
                        return;
                    }
                    TemplateLayoutComposite1.this.updateInProgress = true;
                    TemplateLayoutComposite1.this.justUpdateLayoutTableContents(currentLayout);
                    TemplateLayoutComposite1.this.updateInProgress = false;
                    TemplateLayoutComposite1.this.editor.setEditorDirty();
                }
            });
        }
    }

    private int getSelectedFieldIndex() {
        if (this.fieldTableCursor.isVisible() && this.fieldTableCursor.getRow() != null) {
            int fieldIndex = -1;
            fieldIndex = this.fieldTable.indexOf(this.fieldTableCursor.getRow());
            if (fieldIndex == -1) {
                fieldIndex = this.fieldTable.getSelectionIndex();
            }
            return fieldIndex;
        }
        return this.fieldTable.getSelectionIndex();
    }

    private void enableControlsByTemplateType() {
        Control[] controls = null;
        controls = "VIEW".equals(this.aTemplate.getType()) ? new Control[]{this.currentSegmentCombo, this.currentLayoutCombo, this.copybookNameText, this.layoutSelectedCheckbox, this.idCriteriaText, this.selCriteriaText, this.idCriteriaBuildButton, this.idCriteriaWriteButton, this.idCriteriaClearButton, this.selCriteriaBuildButton, this.selCriteriaWritedButton, this.selCriteriaClearButton, this.offsetText, this.specifyAttributeButton, this.setHoldButton, this.setSelectedButton, this.setCcsidButton} : new Control[]{this.currentSegmentCombo, this.currentLayoutCombo, this.copybookNameText, this.idCriteriaText, this.selCriteriaText, this.idCriteriaBuildButton, this.idCriteriaWriteButton, this.idCriteriaClearButton, this.selCriteriaBuildButton, this.selCriteriaWritedButton, this.selCriteriaClearButton, this.offsetText, this.specifyAttributeButton, this.setCcsidButton};
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(this.fieldTableViewer.getInput() != null);
            ++n2;
        }
        if (this.aTemplate.getType().equalsIgnoreCase("IMS")) {
            this.selCriteriaBuildButton.setEnabled(false);
            this.selCriteriaWritedButton.setEnabled(false);
            this.selCriteriaClearButton.setEnabled(false);
        } else if (this.aTemplate.getType().equalsIgnoreCase("VIEW")) {
            this.idCriteriaBuildButton.setEnabled(false);
            this.idCriteriaWriteButton.setEnabled(false);
            this.idCriteriaClearButton.setEnabled(false);
        } else if (this.aTemplate.getType().equalsIgnoreCase("CRITERIA")) {
            this.selCriteriaBuildButton.setEnabled(false);
            this.selCriteriaWritedButton.setEnabled(false);
            this.selCriteriaClearButton.setEnabled(false);
            this.idCriteriaBuildButton.setEnabled(false);
            this.idCriteriaWriteButton.setEnabled(false);
            this.idCriteriaClearButton.setEnabled(false);
        }
    }

    public boolean isFieldTableEmpty() {
        return this.fieldTableViewer.getInput() == null;
    }

    public void setNewTemplate(TemplateType newTemplate) {
        this.aTemplate = newTemplate;
        this.initialiseGUI();
    }

    private boolean offsetUpdated() {
        if (this.editor.isOffsetUpdated()) {
            PDDialogs.openInfoThreadSafe((String)Messages.TE_LAYOUT_offsetModifiedMustSaveMsg);
            return true;
        }
        return false;
    }

    private TemplateType clearCrietria() {
        StringBuffer newTemplate;
        block6: {
            Result result;
            try {
                final StringBuffer xmlTemplate = TemplateSerializeUtils.save((TemplateType)this.aTemplate, (IZRL)this.aTemplateResource);
                result = new Result();
                newTemplate = new StringBuffer();
                try {
                    PlatformUI.getWorkbench().getProgressService().run(false, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask(Messages.CriteriaSpecDialog_CheckCriteriaWithHost, 1);
                            IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                            StringBuffer newXmlTemplate = TemplateLayoutComposite1.this.session.updateTemplate(xmlTemplate, howIsGoing, result, true, false);
                            newTemplate.append(newXmlTemplate);
                        }
                    });
                }
                catch (Exception e) {
                    PDDialogs.openErrorThreadSafe((String)Messages.CriteriaSpecDialog_ExceptionWhileValidatingCriteria, (String)result.dumpOutputAndMessages(true), (Throwable)e);
                    return null;
                }
            }
            catch (Exception e) {
                PDDialogs.openErrorThreadSafe((String)Messages.CriteriaSpecDialog_ExceptionWhileValidatingCriteria, (Throwable)e);
                TemplateEditorUtilities1.end(this.session);
                return null;
            }
            if (result.isSuccessfulWithoutWarnings()) break block6;
            PDDialogs.openErrorThreadSafe((String)Messages.CriteriaSpecDialog_CriteriaValidationErr, (String)result.dumpOutputAndMessages(true));
            return null;
        }
        return TemplateSerializeUtils.load((StringBuffer)newTemplate, (IZRL)this.aTemplateResource);
    }

    private Text createCcsidText() {
        final Text text2 = new Text((Composite)this.fieldTableCursor, 0);
        text2.setFont(JFaceResources.getTextFont());
        text2.setFocus();
        text2.setText(this.fieldTableCursor.getRow().getText(this.fieldTableCursor.getColumn()));
        text2.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    TemplateLayoutComposite1.this.updateCcsid(text2);
                    text2.dispose();
                } else if (e.keyCode == 27) {
                    text2.dispose();
                }
            }
        });
        text2.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent ve) {
                if (!Character.isISOControl(ve.character)) {
                    ve.doit = Character.isDigit(ve.character);
                }
            }
        });
        text2.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TemplateLayoutComposite1.this.updateCcsid(text2);
                text2.dispose();
            }
        });
        return text2;
    }

    private void updateCcsid(Text text2) {
        SegmentAndLayoutIndex index = this.getCurrentSelection();
        int selectionIndex = this.fieldTable.indexOf(this.fieldTableCursor.getRow());
        String newValue = text2.getText().trim();
        ((Symboltype)this.getCurrentlySelectedLayout().getSymbol().get(selectionIndex)).setCcsid(newValue);
        ((Symboltype)this.getCurrentlySelectedLayout().getSymbol().get(selectionIndex)).setCcside(null);
        text2.dispose();
        this.updateInProgress = true;
        this.setSegmentAndLayout(index, selectionIndex);
        this.updateInProgress = false;
        this.editor.setEditorDirty();
    }

    private Layouttype getCurrentlySelectedLayout() {
        if (this.currentSegmentCombo.getItemCount() == 0 || this.currentLayoutCombo.getItemCount() == 0) {
            return null;
        }
        return this.editor.getSegmentsAndLayouts().getLayout(this.currentSegmentCombo.getText(), this.currentLayoutCombo.getSelectionIndex());
    }
}

