/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template1;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.template1.ITemplateEditor1;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.text.MessageFormat;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class TemplateInfoComposite1 {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int NUMBER_OF_DESCRIPTION_TEXT = 5;
    private static final int LENGTH_OF_DESCRIPTION_TEXT = 54;
    private static final int NUMBER_OF_DBDLIB = 6;
    private ITemplateEditor1 templateEditor = null;
    private TemplateInfoComposite1Model model;
    private TabItem infoTab = null;
    private Text typeText = null;
    private Text langText = null;
    private Text creationDateText = null;
    private Text creationTimeText = null;
    private Text modifyDateText = null;
    private Text modifyTimeText = null;
    private Text[] descText = null;
    private Text imsIdName = null;
    private Text imsDbdLibName = null;
    private Text[] imsDbdLibs = null;
    private boolean updateInProgress = false;
    private String acbManagedImsId = null;

    public TemplateInfoComposite1(ITemplateEditor1 editor2, TemplateType aTemplate) {
        this.templateEditor = editor2;
        this.model = new TemplateInfoComposite1Model(aTemplate);
    }

    public void createInfoTab(TabFolder tabFolder, String acbManagedImsId) {
        this.acbManagedImsId = acbManagedImsId;
        this.infoTab = new TabItem(tabFolder, 0);
        this.infoTab.setText(Messages.TE_infoTabName);
        Composite parent = GUI.composite((Composite)tabFolder, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        this.createMiscInfoGroup(parent);
        this.createImsInfoGroup(parent);
        this.infoTab.setControl((Control)parent);
        this.setMiscInformation();
    }

    private void createImsInfoGroup(Composite parent) {
        boolean acbManaged;
        Group imsGroup = GUI.group((Composite)parent, (String)Messages.TemplateInfoComposite1_0, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        boolean bl = acbManaged = this.acbManagedImsId != null || this.model.isAcbManaged();
        if (acbManaged) {
            GUI.label((Composite)imsGroup, (String)Messages.TE_infoImsIdName, (Object)GUI.grid.d.left1(), (int)16384);
            this.imsIdName = GUI.text.fieldReadOnly((Composite)imsGroup, (Object)GUI.grid.d.fillH((int)3));
        }
        GUI.label((Composite)imsGroup, (String)Messages.TE_infoDbdName, (Object)GUI.grid.d.left1(), (int)16384);
        this.imsDbdLibName = GUI.text.fieldReadOnly((Composite)imsGroup, (Object)GUI.grid.d.fillH((int)3));
        if (!acbManaged) {
            this.imsDbdLibs = new Text[6];
            int i = 0;
            while (i < 6) {
                GUI.label((Composite)imsGroup, (String)MessageFormat.format(Messages.TE_infoDbdlib, i + 1), (Object)GUI.grid.d.left1(), (int)16384);
                this.imsDbdLibs[i] = GUI.text.fieldReadOnly((Composite)imsGroup, (Object)GUI.grid.d.fillH((int)1));
                ++i;
            }
        }
    }

    private static Text createLabelAndText(Group group, String labelText) {
        GUI.label((Composite)group, (String)labelText, (Object)GUI.grid.d.left1(), (int)16384);
        return GUI.text.fieldReadOnly((Composite)group, (Object)GUI.grid.d.fillH((int)1));
    }

    private void createMiscInfoGroup(Composite parent) {
        Group miscGroup = GUI.group((Composite)parent, (String)Messages.TE_infoMiscGroup, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.typeText = TemplateInfoComposite1.createLabelAndText(miscGroup, Messages.TE_infotypeText);
        this.langText = TemplateInfoComposite1.createLabelAndText(miscGroup, Messages.TE_infolangText);
        this.creationDateText = TemplateInfoComposite1.createLabelAndText(miscGroup, Messages.TE_infocreationDateText);
        this.creationTimeText = TemplateInfoComposite1.createLabelAndText(miscGroup, Messages.TE_infocreationTimeText);
        this.modifyDateText = TemplateInfoComposite1.createLabelAndText(miscGroup, Messages.TE_infomodifyDateText);
        this.modifyTimeText = TemplateInfoComposite1.createLabelAndText(miscGroup, Messages.TE_infomodifyTimeText);
        this.descText = new Text[5];
        int i = 0;
        while (i < 5) {
            GUI.label((Composite)miscGroup, (String)MessageFormat.format(Messages.TE_infodescText, i + 1), (Object)GUI.grid.d.left1(), (int)16384);
            this.descText[i] = GUI.text.field((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)3));
            this.descText[i].setTextLimit(54);
            this.descText[i].addModifyListener(this.createDescriptionModifyListener());
            this.descText[i].addVerifyListener(this.createDescriptionVerifyListener());
            ++i;
        }
    }

    private ModifyListener createDescriptionModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TemplateInfoComposite1.this.updateInProgress) {
                    return;
                }
                TemplateInfoComposite1.this.templateEditor.setEditorDirty();
                TemplateInfoComposite1.this.model.setDescriptions(TemplateInfoComposite1.this.descText);
            }
        };
    }

    private VerifyListener createDescriptionVerifyListener() {
        return new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (TemplateInfoComposite1.this.updateInProgress) {
                    return;
                }
                e.doit = StringUtils.isAsciiCharacters((String)e.text);
            }
        };
    }

    private void setMiscInformation() {
        this.updateInProgress = true;
        this.typeText.setText(this.model.getType());
        this.langText.setText(this.model.getLanguage());
        this.creationDateText.setText(this.model.getCreationDate());
        this.creationTimeText.setText(this.model.getCreationTime());
        this.modifyDateText.setText(this.model.getModifyDate());
        this.modifyTimeText.setText(this.model.getModifyTime());
        this.model.updateDescriptionsFromModel(this.descText);
        this.model.updateDBDFromModel(this.imsDbdLibName);
        if (this.imsIdName != null && (this.acbManagedImsId != null || this.model.isAcbManaged())) {
            this.model.updateImsIdFromModel(this.imsIdName, this.acbManagedImsId);
        } else {
            this.model.updateDBDLibsFromModel(this.imsDbdLibs);
        }
        this.updateInProgress = false;
    }

    public void setNewTemplate(TemplateType newTemplate) {
        this.model = new TemplateInfoComposite1Model(newTemplate);
        this.setMiscInformation();
    }

    private static class TemplateInfoComposite1Model {
        private TemplateType aTemplate;

        public String getType() {
            return this.aTemplate.getType();
        }

        public String getLanguage() {
            return this.aTemplate.getLang() != null ? this.aTemplate.getLang() : "";
        }

        public String getCreationDate() {
            return this.aTemplate.getCdate() != null ? this.aTemplate.getCdate() : "";
        }

        public String getCreationTime() {
            return this.aTemplate.getCtime() != null ? this.aTemplate.getCtime() : "";
        }

        public String getModifyDate() {
            return this.aTemplate.getCdate() != null ? this.aTemplate.getCdate() : "";
        }

        public String getModifyTime() {
            return this.aTemplate.getUtime() != null ? this.aTemplate.getUtime() : "";
        }

        public void setDescriptions(Text[] texts) {
            this.aTemplate.getDescribe().clear();
            Text[] textArray = texts;
            int n = texts.length;
            int n2 = 0;
            while (n2 < n) {
                Text text2 = textArray[n2];
                this.aTemplate.getDescribe().add((Object)text2.getText().trim());
                ++n2;
            }
        }

        public TemplateInfoComposite1Model(TemplateType aTemplate) {
            this.aTemplate = aTemplate;
        }

        public void updateDescriptionsFromModel(Text[] descriptions) {
            EList descList = this.aTemplate.getDescribe();
            if (descList != null) {
                int i = 0;
                while (i < descList.size()) {
                    descriptions[i].setText((String)descList.get(i));
                    ++i;
                }
            }
        }

        public boolean isAcbManaged() {
            String imsId = this.aTemplate.getImsid();
            return imsId != null && imsId.trim().length() > 0;
        }

        public void updateImsIdFromModel(Text text2, String acbManagedImsId) {
            String imsId = this.aTemplate.getImsid();
            if (imsId == null) {
                imsId = acbManagedImsId;
            }
            if (imsId != null) {
                text2.setText(imsId);
            }
        }

        public void updateDBDFromModel(Text text2) {
            String dbdName = this.aTemplate.getDbd();
            if (dbdName != null) {
                text2.setText(dbdName);
            }
        }

        public void updateDBDLibsFromModel(Text[] imsDbdLibs) {
            EList dbdLibs = this.aTemplate.getDbdlib();
            if (dbdLibs != null) {
                int i = 0;
                while (i < dbdLibs.size()) {
                    String aLibName = (String)dbdLibs.get(i);
                    if (aLibName != null) {
                        imsDbdLibs[i].setText(aLibName);
                    }
                    ++i;
                }
            }
        }
    }
}

