/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template1;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionTemplate;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.MessageQueue;
import com.ibm.etools.fm.core.model.MessageQueueManager;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsResource;
import com.ibm.etools.fm.core.model.db2.Db2Database;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.ims.SessionTemplate1;
import com.ibm.etools.fm.editor.template1.FMTemplateEditorInput1;
import com.ibm.etools.fm.editor.template1.ITemplateEditor1;
import com.ibm.etools.fm.model.template.CopybooksType;
import com.ibm.etools.fm.model.template.MemberType;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.MemberPresence;
import com.ibm.etools.fm.ui.dialog.TemplateResourceSaveAsDialog;
import com.ibm.etools.fm.ui.util.EditorManagement;
import com.ibm.etools.fm.ui.util.ZrlLoaderDialogUtils;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsTreeUpdater;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public class TemplateEditorUtilities1 {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public static boolean existsInCopybooks(String memberName, CopybooksType copybooks) {
        if (copybooks == null) {
            return false;
        }
        EList library = copybooks.getLibrary();
        EList members = copybooks.getMember();
        int i = 0;
        while (i < members.size()) {
            MemberType aMember = (MemberType)members.get(i);
            if (aMember.getLib() != 0 && memberName.equalsIgnoreCase((String)library.get(aMember.getLib() - 1) + "(" + aMember.getName() + ")")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Result<StringBuffer> updateTemplate(IHowIsGoing monitor, boolean updateFromCopybooks, final TemplateType currentTemplate, final IZRL aTemplateResource, final AbstractSessionTemplate session, final StringBuffer newXmlTemplateContents) throws CoreException, InterruptedException, InvocationTargetException {
        if (updateFromCopybooks) {
            currentTemplate.getLayout().clear();
        }
        if (monitor != null) {
            Result result = new Result();
            StringBuffer xmlTemplate = TemplateSerializeUtils.save((TemplateType)currentTemplate, (IZRL)aTemplateResource);
            StringBuffer newXmlTemplate = session.updateTemplate(xmlTemplate, monitor, result, true, false);
            if (!result.isSuccessfulWithoutWarnings()) {
                monitor.done();
                return result;
            }
            newXmlTemplateContents.append(newXmlTemplate.toString());
            return result;
        }
        final Result overallResult = new Result();
        PlatformUI.getWorkbench().getProgressService().run(false, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(MessageFormat.format(Messages.TemplateEditor_UPDATE_TEMPLATE_IN_PROGRESS, aTemplateResource.getFormattedName()), 1);
                IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                try {
                    Result result = new Result();
                    StringBuffer xmlTemplate = TemplateSerializeUtils.save((TemplateType)currentTemplate, (IZRL)aTemplateResource);
                    StringBuffer newXmlTemplate = session.updateTemplate(xmlTemplate, howIsGoing, result, true, false);
                    overallResult.addSubResult(result);
                    if (!result.isSuccessfulWithoutWarnings()) {
                        monitor.done();
                        return;
                    }
                    newXmlTemplateContents.append(newXmlTemplate.toString());
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
                monitor.done();
            }
        });
        return overallResult;
    }

    public static Result<StringBuffer> doSave(ITemplateEditor1 templateEditor, final AbstractSessionTemplate session, final IZRL aTemplate, final TemplateType currentTemplate, boolean libraryUpdated, final StringBuffer templateContentsAfterSave, boolean fromDialog, PDLogger logger) {
        if (libraryUpdated && !PDDialogs.openConfirm((String)Messages.Confirm, (String)Messages.TE_LibChangedConfirm)) {
            return null;
        }
        if (currentTemplate.getType().equals("BASE") && TemplateEditorUtilities1.existsInCopybooks(aTemplate.getFormattedName(), currentTemplate.getCopybooks())) {
            if (PDDialogs.openQuestion((String)MessageFormat.format(Messages.TemplateEditor_COPYBOOK_OVERWRITE, aTemplate.getFormattedName()))) {
                return TemplateEditorUtilities1.doSaveAs(templateEditor, session, aTemplate, currentTemplate, false, templateContentsAfterSave, fromDialog, logger);
            }
            return null;
        }
        CopybooksType copybooks = currentTemplate.getCopybooks();
        currentTemplate.setCopybooks(null);
        final Result overallResult = new Result((Object)new StringBuffer());
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.TemplateEditor_SAVE_IN_PROGRESS, aTemplate.getFormattedName()), 2);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    try {
                        Result updateResult = new Result();
                        StringBuffer xmlTemplate = TemplateSerializeUtils.save((TemplateType)currentTemplate, (IZRL)aTemplate);
                        session.updateTemplate(xmlTemplate, howIsGoing, updateResult, false, false);
                        overallResult.addSubResult(updateResult);
                        if (!updateResult.isSuccessfulWithoutWarnings()) {
                            PDDialogs.openErrorThreadSafe((String)Messages.TE_UpdateErrWhileSave, (String)updateResult.dumpOutputAndMessages(true));
                            return;
                        }
                        Result saveResult = session.save(howIsGoing);
                        overallResult.addSubResult(saveResult);
                        if (saveResult.getRC() > 4) {
                            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.TemplateEditor_SAVE_ERR_MSG, aTemplate.getFormattedName()), (String)saveResult.getMessagesCombined().toString());
                            return;
                        }
                        Result loadCurrentResult = new Result();
                        StringBuffer latestXMLContents = session.getCurrentTemplateContents(howIsGoing, loadCurrentResult);
                        overallResult.addSubResult(loadCurrentResult);
                        if (!loadCurrentResult.isSuccessfulWithoutWarnings()) {
                            PDDialogs.openErrorThreadSafe((String)Messages.TE_ErrGetLatestAfterSave, (String)loadCurrentResult.dumpOutputAndMessages(true));
                            return;
                        }
                        templateContentsAfterSave.append(latestXMLContents.toString());
                    }
                    catch (CoreException e1) {
                        overallResult.add((Throwable)e1);
                        overallResult.setRC(8);
                        PDDialogs.openErrorThreadSafe((String)Messages.TemplateEditorAction_EX, (Throwable)e1);
                        return;
                    }
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            PDDialogs.openErrorThreadSafe((String)Messages.TemplateEditor_SAVE_EX, (Throwable)e);
            overallResult.add(e);
            overallResult.setRC(8);
            currentTemplate.setCopybooks(copybooks);
            return overallResult;
        }
        catch (InterruptedException e) {
            PDDialogs.openInfoThreadSafe((String)Messages.TemplateEditor_ACTION_CANCEL);
            overallResult.add((Throwable)e);
            overallResult.setRC(8);
            currentTemplate.setCopybooks(copybooks);
            return overallResult;
        }
        if (overallResult.isSuccessfulWithoutWarnings()) {
            return overallResult;
        }
        currentTemplate.setCopybooks(copybooks);
        return overallResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Result<StringBuffer> doSaveAs(final ITemplateEditor1 templateEditor, final AbstractSessionTemplate session, final IZRL aTemplate, final TemplateType currentTemplate, boolean libraryUpdated, StringBuffer templateContentsAfterSave, final boolean fromDialog, final PDLogger logger) {
        IZRL target;
        IPDHost host;
        IZRL templateResource;
        block18: {
            if (libraryUpdated && !PDDialogs.openConfirm((String)Messages.Confirm, (String)Messages.TE_LibChangedConfirm)) {
                return null;
            }
            templateResource = aTemplate;
            host = session.getSystem();
            TemplateResourceSaveAsDialog dialog = new TemplateResourceSaveAsDialog(host, aTemplate, MemberPresence.Required);
            if (dialog.open() != 0) {
                return null;
            }
            target = dialog.getSelectedResource();
            if (templateResource.getFormattedName().equals(target.getFormattedName())) {
                if (!PDDialogs.openQuestion((String)Messages.TemplateEditor_SAVE_AS_SAME_TARGET)) return TemplateEditorUtilities1.doSaveAs(templateEditor, session, aTemplate, currentTemplate, libraryUpdated, templateContentsAfterSave, fromDialog, logger);
                return TemplateEditorUtilities1.doSave(templateEditor, session, aTemplate, currentTemplate, libraryUpdated, templateContentsAfterSave, fromDialog, logger);
            }
            if (currentTemplate.getType().equals("BASE") && TemplateEditorUtilities1.existsInCopybooks(target.getFormattedName(), currentTemplate.getCopybooks())) {
                if (!PDDialogs.openQuestion((String)MessageFormat.format(Messages.TemplateEditor_COPYBOOK_OVERWRITE, aTemplate.getFormattedName()))) return null;
                return TemplateEditorUtilities1.doSaveAs(templateEditor, session, aTemplate, currentTemplate, libraryUpdated, templateContentsAfterSave, fromDialog, logger);
            }
            if (FMUIPlugin.getDefault().templateEditSessionExist(target)) {
                PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.TemplateEditor_DUP_EDIT, target.getFormattedName()));
                return null;
            }
            try {
                Result<StringBuffer> checkDataSetResult = ZrlLoaderDialogUtils.retrieveInformation(target);
                if (!checkDataSetResult.isSuccessfulWithoutWarnings()) {
                    PDDialogs.openErrorThreadSafe((String)Messages.FMPlugin_ERROR_TITLE, (String)MessageFormat.format(Messages.TemplateEditor_SAVE_AS_TARGET_ERR, target.getFormattedName()), (String)checkDataSetResult.getMessagesCombined().toString());
                    return null;
                }
                if (target instanceof DataSetOrMember) {
                    DataSetOrMember dsom = (DataSetOrMember)target;
                    if (dsom.getConfirmedExists() && !PDDialogs.openQuestion((String)MessageFormat.format(Messages.TemplateEditor_SAVE_AS_TARGET_EXIST, target.getFormattedName()))) {
                        return null;
                    }
                    break block18;
                }
                if (!(target instanceof UssFile)) {
                    throw new IllegalArgumentException(MessageFormat.format(Messages.TemplateEditorUtilities_19, target.getFormattedName()));
                }
                UssFile ussFile = (UssFile)target;
                if (ussFile.getConfirmedExists()) {
                    if (!PDDialogs.openQuestion((String)MessageFormat.format(Messages.TemplateEditor_SAVE_AS_TARGET_EXIST, target.getFormattedName()))) {
                        return null;
                    }
                } else if (ussFile.isDirectory()) {
                    PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.TemplateEditorUtilities_18, target.getFormattedName()));
                    return null;
                }
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        final Result overallResult = new Result();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.TemplateEditor_SAVE_AS_IN_PROGRESS, target.getFormattedName()), 2);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    CopybooksType copybooks = currentTemplate.getCopybooks();
                    if (templateEditor.isDirty()) {
                        currentTemplate.setCopybooks(null);
                        try {
                            Result result = new Result();
                            StringBuffer xmlTemplate = TemplateSerializeUtils.save((TemplateType)currentTemplate, (IZRL)aTemplate);
                            session.updateTemplate(xmlTemplate, howIsGoing, result, false, false);
                            overallResult.addSubResult(result);
                            if (!result.isSuccessfulWithoutWarnings()) {
                                currentTemplate.setCopybooks(copybooks);
                                return;
                            }
                        }
                        catch (CoreException e1) {
                            currentTemplate.setCopybooks(copybooks);
                            overallResult.add((Throwable)e1);
                            overallResult.setRC(8);
                            String errMsg = Messages.TemplateEditorAction_EX;
                            logger.error((Object)errMsg, (Throwable)e1);
                            PDDialogs.openErrorThreadSafe((String)errMsg);
                            return;
                        }
                    }
                    Result saveAsResult = new Result((Object)new StringBuffer());
                    session.saveAs(target, howIsGoing, saveAsResult);
                    overallResult.addSubResult(saveAsResult);
                    IFile newTemplateFile = session.getFromCacheFile();
                    if (newTemplateFile == null || !saveAsResult.isSuccessfulWithoutWarnings()) {
                        currentTemplate.setCopybooks(copybooks);
                        PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.TemplateEditor_SAVE_AS_ERR_MSG, target.getFormattedName(), host.getConnectionName()), (String)saveAsResult.getMessagesCombined().toString());
                        return;
                    }
                    FMTemplateEditorInput1 fmiInput = new FMTemplateEditorInput1(newTemplateFile, target, (SessionTemplate1)session, true, null, null);
                    EditorManagement.openTemplateEditorFromWorkerThread(newTemplateFile, fmiInput, monitor, fromDialog);
                    FMUIPlugin.getDefault().addNewTemplateEditSession(target);
                    FMUIPlugin.getDefault().removeTemplateEditSession(templateResource);
                    PDSystemsTreeUpdater.refreshAllRelatedTo((Object)target);
                }
            });
            return overallResult;
        }
        catch (InvocationTargetException e) {
            PDDialogs.openErrorThreadSafe((String)Messages.TemplateEditorAction_EX, (Throwable)e);
            overallResult.add(e);
            overallResult.setRC(8);
            return overallResult;
        }
        catch (InterruptedException e) {
            PDDialogs.openInfoThreadSafe((String)Messages.TemplateEditorAction_CACELLED);
            overallResult.add((Throwable)e);
            overallResult.setRC(8);
            return overallResult;
        }
    }

    public static void openTemplateEditSession(IZRL template) {
        PDDialogs.openInfoThreadSafe((String)"Information!", (String)"Not Implemented yet!!");
    }

    public static void end(final AbstractSessionTemplate sessionToClose) {
        block4: {
            try {
                PlatformUI.getWorkbench().getProgressService().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.EndTemplateSession_0, 2);
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        monitor.worked(1);
                        if (sessionToClose == null) {
                            monitor.done();
                            return;
                        }
                        sessionToClose.end(howIsGoing);
                        monitor.worked(1);
                        monitor.done();
                    }
                });
            }
            catch (Exception e) {
                if (sessionToClose == null) break block4;
                try {
                    sessionToClose.closeConnection();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static String okAsTemplate(IZRL aTemplate, boolean mustExist, IHowIsGoing monitor) throws InvocationTargetException, InterruptedException {
        Objects.requireNonNull(aTemplate, "Must specify a non-null aTemplate.");
        if (aTemplate instanceof CicsResource) {
            return Messages.TemplateEditorUtilities_0;
        }
        if (aTemplate instanceof CicsAppl) {
            return Messages.TemplateEditorUtilities_1;
        }
        if (aTemplate instanceof Db2Database) {
            return Messages.TemplateEditorUtilities_2;
        }
        if (aTemplate instanceof Db2Subsystem) {
            return Messages.TemplateEditorUtilities_3;
        }
        if (aTemplate instanceof MessageQueue) {
            return Messages.TemplateEditorUtilities_4;
        }
        if (aTemplate instanceof MessageQueueManager) {
            return Messages.TemplateEditorUtilities_5;
        }
        if (aTemplate instanceof DataSetOrMember) {
            return TemplateEditorUtilities1.okAsTemplateDSOM((DataSetOrMember)aTemplate, mustExist, monitor);
        }
        if (aTemplate instanceof UssFile) {
            return TemplateEditorUtilities1.okAsTemplateUssFile((UssFile)aTemplate, mustExist, monitor);
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.TemplateEditorUtilities_6, aTemplate == null ? Messages.TemplateEditorUtilities_7 : aTemplate.getFormattedName()));
    }

    private static String okAsTemplateDSOM(final DataSetOrMember aTemplate, final boolean mustExist, IHowIsGoing monitor) throws InvocationTargetException, InterruptedException {
        if (aTemplate.getSystem().getHostType() != HostType.ZOS) {
            return Messages.TemplateEditorUtilities_8;
        }
        if (monitor != null) {
            return TemplateEditorUtilities1.okAsTemplateDSOMChild(aTemplate, mustExist, monitor);
        }
        final Result result = new Result();
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(MessageFormat.format(Messages.TemplateEditorUtilities_9, aTemplate.getFormattedName()), 1);
                IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                String s = TemplateEditorUtilities1.okAsTemplateDSOMChild(aTemplate, mustExist, howIsGoing);
                result.setOutput((Object)s);
            }
        });
        return (String)result.getOutput();
    }

    private static String okAsTemplateDSOMChild(DataSetOrMember aTemplate, boolean mustExist, IHowIsGoing monitor) throws InterruptedException {
        Result result = aTemplate.refreshSelf(monitor);
        if (!result.isSuccessfulWithoutWarnings()) {
            return result.dumpOutputAndMessages(true);
        }
        if (aTemplate.asMember() != null) {
            if (mustExist) {
                if (aTemplate.getConfirmedExists()) {
                    return null;
                }
                return Messages.TemplateEditorUtilities_10;
            }
            if (aTemplate.asDataSet().getType() == DataSetType.PDS || aTemplate.asDataSet().getType() == DataSetType.LIBRARY) {
                return null;
            }
            return Messages.TemplateEditorUtilities_11;
        }
        if (aTemplate.getConfirmedExists() && aTemplate.asDataSet().getType() == DataSetType.PS) {
            return null;
        }
        if (!aTemplate.getConfirmedExists()) {
            return Messages.TemplateEditorUtilities_12;
        }
        return Messages.TemplateEditorUtilities_13;
    }

    private static String okAsTemplateUssFile(final UssFile aTemplate, final boolean mustExist, IHowIsGoing monitor) throws InvocationTargetException, InterruptedException {
        if (aTemplate.getSystem().getHostType() == HostType.ZOS) {
            return Messages.TemplateEditorUtilities_14;
        }
        if (monitor != null) {
            return TemplateEditorUtilities1.okAsTemplateUssFileChild(aTemplate, mustExist, monitor);
        }
        final Result result = new Result();
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(MessageFormat.format(Messages.TemplateEditorUtilities_15, aTemplate.getFormattedName()), 1);
                IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                String s = TemplateEditorUtilities1.okAsTemplateUssFileChild(aTemplate, mustExist, howIsGoing);
                result.setOutput((Object)s);
            }
        });
        return (String)result.getOutput();
    }

    private static String okAsTemplateUssFileChild(UssFile aTemplate, boolean mustExist, IHowIsGoing monitor) throws InterruptedException {
        Result result = aTemplate.refreshSelf(monitor);
        if (!result.isSuccessfulWithoutWarnings()) {
            return result.dumpOutputAndMessages(true);
        }
        if (aTemplate.isDirectory()) {
            return Messages.TemplateEditorUtilities_16;
        }
        if (!mustExist) {
            return null;
        }
        if (aTemplate.getConfirmedExists()) {
            return null;
        }
        return Messages.TemplateEditorUtilities_17;
    }
}

