/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template1;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionTemplate;
import com.ibm.etools.fm.editor.template1.FMTemplateEditorInput1;
import com.ibm.etools.fm.editor.template1.ITemplateEditor1;
import com.ibm.etools.fm.editor.template1.SegmentsAndLayouts;
import com.ibm.etools.fm.editor.template1.TemplateEditorTabs1;
import com.ibm.etools.fm.editor.template1.TemplateEditorUtilities1;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.util.EditorManagement;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TemplateEditorDialog1
extends BaseTitleAreaDialog
implements ITemplateEditor1 {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int EDITOR_CLOSE = 100;
    private static final int SAVE_AS_CLOSE = 101;
    private static final PDLogger logger = PDLogger.get(TemplateEditorDialog1.class);
    private final FMTemplateEditorInput1 fmEditorInput;
    private AbstractSessionTemplate session;
    private SegmentsAndLayouts segmentsAndLayouts;
    private boolean libUpdated = false;
    private boolean offsetUpdated = false;
    private TemplateEditorTabs1 templateEditorTabs;
    private Button okButton;
    private Button cancelButton;
    private Button saveButton;
    private Button saveAsButton;
    private Button editorButton;

    public TemplateEditorDialog1(FMTemplateEditorInput1 input) {
        this.fmEditorInput = input;
    }

    public int open() {
        IFile localFile = this.fmEditorInput.getFile();
        IZRL zosResource = this.fmEditorInput.getResource();
        if (!(this.fmEditorInput.getSessionIdentifer() instanceof AbstractSessionTemplate)) {
            throw new IllegalArgumentException();
        }
        this.session = this.fmEditorInput.getSessionIdentifer();
        if (localFile == null) {
            FMUIPlugin.getDefault().removeTemplateEditSession(this.fmEditorInput.getResource());
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.TE_NoCachedFile, zosResource.getFormattedName()));
            this.close();
            return 1;
        }
        if (this.fmEditorInput.getLoadedTemplate() == null) {
            try {
                this.fmEditorInput.setTemplate(TemplateSerializeUtils.load((IFile)localFile, (IZRL)this.getTemplateResource()));
            }
            catch (Exception e) {
                FMUIPlugin.getDefault().removeTemplateEditSession(this.fmEditorInput.getResource());
                String errMsg = MessageFormat.format(Messages.TE_TemplateOpenError, this.fmEditorInput.getName());
                PDDialogs.openErrorThreadSafe((String)errMsg);
                logger.error((Object)errMsg, (Throwable)e);
                this.close();
                return 1;
            }
        } else if (this.fmEditorInput.isDirty()) {
            this.setEditorDirty();
        }
        if (!(this.fmEditorInput.getLoadedTemplate() == null || "IMS".equals(this.fmEditorInput.getLoadedTemplate().getType()) || "VIEW".equals(this.fmEditorInput.getLoadedTemplate().getType()) || "CRITERIA".equals(this.fmEditorInput.getLoadedTemplate().getType()))) {
            FMUIPlugin.getDefault().removeTemplateEditSession(this.fmEditorInput.getResource());
            String errMsg = MessageFormat.format(Messages.TemplateEditor_TypeNotSupportede, this.fmEditorInput.getName(), this.fmEditorInput.getLoadedTemplate().getType());
            PDDialogs.openErrorThreadSafe((String)errMsg);
            this.close();
            return 1;
        }
        this.segmentsAndLayouts = new SegmentsAndLayouts(this.fmEditorInput.getLoadedTemplate(), this.fmEditorInput.getSessionIdentifer());
        return super.open();
    }

    public IZRL getTemplateResource() {
        return this.fmEditorInput.getResource();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(MessageFormat.format(Messages.TemplateEditor_DialogTitle, this.getTemplateResource().getSystem(), this.getTemplateResource().getFormattedName()));
        if ("IMS".equals(this.fmEditorInput.getLoadedTemplate().getType())) {
            this.setMessage(Messages.TemplateEditorDialog1_0);
        } else if ("VIEW".equals(this.fmEditorInput.getLoadedTemplate().getType())) {
            this.setMessage(Messages.TemplateEditorDialog1_1);
        } else if ("CRITERIA".equals(this.fmEditorInput.getLoadedTemplate().getType())) {
            this.setMessage(Messages.TemplateEditorDialog1_2);
        }
        this.templateEditorTabs = new TemplateEditorTabs1();
        Control buildTemplateEditorTabs = this.templateEditorTabs.buildTemplateEditorTabs(parent, this);
        if (this.templateEditorTabs.getLayoutComposite().isFieldTableEmpty()) {
            this.templateEditorTabs.showSegmentsTab();
        }
        return buildTemplateEditorTabs;
    }

    @Override
    public boolean builtFromCopybook() {
        return TemplateEditorUtilities1.existsInCopybooks(this.fmEditorInput.getResource().getFormattedName(), this.fmEditorInput.getLoadedTemplate().getCopybooks());
    }

    @Override
    public boolean isDirty() {
        return this.fmEditorInput.isDirty();
    }

    @Override
    public void setEditorDirty() {
        this.setTitle(MessageFormat.format(Messages.TemplateEditor_DialogTitleDirty, this.getTemplateResource().getSystem(), this.getTemplateResource().getFormattedName()));
        this.fmEditorInput.setDirty(true);
    }

    public void setEditorDirty(boolean dirty) {
        this.fmEditorInput.setDirty(dirty);
        if (this.fmEditorInput.isDirty()) {
            this.setTitle(MessageFormat.format(Messages.TemplateEditor_DialogTitleDirty, this.getTemplateResource().getSystem(), this.getTemplateResource().getFormattedName()));
        } else {
            this.setTitle(MessageFormat.format(Messages.TemplateEditor_DialogTitle, this.getTemplateResource().getSystem(), this.getTemplateResource().getFormattedName()));
        }
    }

    @Override
    public boolean isOffsetUpdated() {
        return this.offsetUpdated;
    }

    @Override
    public void offsetUpdated() {
        this.setEditorDirty();
        this.offsetUpdated = true;
    }

    @Override
    public void libUpdated(boolean updated) {
        this.setEditorDirty();
        this.libUpdated = updated;
    }

    @Override
    public void refreshGUI() {
        this.segmentsAndLayouts = new SegmentsAndLayouts(this.fmEditorInput.getLoadedTemplate(), this.fmEditorInput.getSessionIdentifer());
        this.templateEditorTabs.setNewTemplate(this.fmEditorInput.getLoadedTemplate());
    }

    @Override
    public void updateTemplate(TemplateType newTemplate) {
        if (newTemplate == null) {
            return;
        }
        if (!this.templateEditorTabs.tabFolder.isDisposed()) {
            this.fmEditorInput.setTemplate(newTemplate);
            this.refreshGUI();
            this.setEditorDirty();
        }
    }

    @Override
    public Result<StringBuffer> updateTemplate(IHowIsGoing monitor, boolean updateFromCopybooks) throws CoreException, InterruptedException, InvocationTargetException {
        StringBuffer newTemplateContents = new StringBuffer();
        Result<StringBuffer> result = TemplateEditorUtilities1.updateTemplate(monitor, updateFromCopybooks, this.fmEditorInput.getLoadedTemplate(), this.getTemplateResource(), this.session, newTemplateContents);
        if (!result.isSuccessfulWithoutWarnings()) {
            return result;
        }
        this.fmEditorInput.setTemplate(TemplateSerializeUtils.load((StringBuffer)newTemplateContents, (IZRL)this.getTemplateResource()));
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData data = new GridData();
        data.widthHint = 100;
        this.okButton = GUI.button.push((Composite)parent, (String)JFaceResources.getString((String)"ok"), (Object)data, (String)Messages.TemplateEditor_OK_TIP);
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TemplateEditorDialog1.this.okPressed();
            }
        });
        this.cancelButton = GUI.button.push((Composite)parent, (String)JFaceResources.getString((String)"cancel"), (Object)data, (String)Messages.TemplateEditor_CANCEL_TIP);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TemplateEditorDialog1.this.cancelPressed();
            }
        });
        this.saveButton = GUI.button.push((Composite)parent, (String)Messages.TemplateEditor_SAVE, (Object)data, (String)Messages.TemplateEditor_SAVE_TIP);
        this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateEditorDialog1.this.doSave();
            }
        });
        this.saveButton.setEnabled(!this.templateEditorTabs.getLayoutComposite().isFieldTableEmpty());
        if (!this.saveButton.isEnabled() && this.templateEditorTabs.getSegmentsComposite() != null) {
            this.templateEditorTabs.getSegmentsComposite().getRebuildButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TemplateEditorDialog1.this.saveButton.setEnabled(!TemplateEditorDialog1.this.templateEditorTabs.getLayoutComposite().isFieldTableEmpty());
                }
            });
        }
        this.saveAsButton = GUI.button.push((Composite)parent, (String)Messages.TemplateEditor_SAVEAS, (Object)data, (String)Messages.TemplateEditor_SAVEAS_TIP);
        this.saveAsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateEditorDialog1.this.doSaveAs();
            }
        });
        this.saveAsButton.setEnabled(!this.templateEditorTabs.getLayoutComposite().isFieldTableEmpty());
        if (!this.saveAsButton.isEnabled() && this.templateEditorTabs.getSegmentsComposite() != null) {
            this.templateEditorTabs.getSegmentsComposite().getRebuildButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TemplateEditorDialog1.this.saveAsButton.setEnabled(!TemplateEditorDialog1.this.templateEditorTabs.getLayoutComposite().isFieldTableEmpty());
                }
            });
        }
        this.editorButton = GUI.button.push((Composite)parent, (String)Messages.TemplateEditor_EditorOpen, (Object)data, (String)Messages.TemplateEditor_EditorOpen_TIP);
        this.editorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateEditorDialog1.this.fmEditorInput.setInitialSegmentAndLayoutIndex(TemplateEditorDialog1.this.templateEditorTabs.getLayoutComposite().getCurrentSelection());
                EditorManagement.openTemplateEditorFromWorkerThread(TemplateEditorDialog1.this.session.getFromCacheFile(), TemplateEditorDialog1.this.fmEditorInput, (IProgressMonitor)new NullProgressMonitor(), false);
                TemplateEditorDialog1.this.setReturnCode(100);
                TemplateEditorDialog1.this.close();
            }
        });
        this.getShell().setDefaultButton(this.okButton);
    }

    public boolean close() {
        if (this.getReturnCode() == 1) {
            if (this.isDirty()) {
                if (!PDDialogs.openConfirm((String)Messages.Confirm, (String)Messages.TemplateEditor_DialogCancelConfirm)) {
                    return false;
                }
                this.closeSessionIfRequired();
                return super.close();
            }
            this.closeSessionIfRequired();
            return super.close();
        }
        if (this.getReturnCode() != 100 && this.getReturnCode() != 101 && this.isDirty()) {
            this.doSave();
        }
        this.closeSessionIfRequired();
        return super.close();
    }

    private void closeSessionIfRequired() {
        if (this.getReturnCode() != 100) {
            FMUIPlugin.getDefault().removeTemplateEditSession(this.fmEditorInput.getResource());
            try {
                this.session.deleteCache();
                if (this.getReturnCode() != 101) {
                    TemplateEditorUtilities1.end(this.session);
                }
            }
            catch (Exception e) {
                PDDialogs.openErrorThreadSafe((String)Messages.TemplateEditor_DISPOSE_ERR);
                logger.error((Object)"Failed to properly dispose of template editor", (Throwable)e);
            }
        }
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = GUI.composite((Composite)parent, (Layout)GUI.grid.l.customMargins((int)5, (boolean)false, (int)10, (int)15), (Object)new GridData(0x1000008, 4, true, false));
        this.createButtonsForButtonBar(buttonBar);
        return buttonBar;
    }

    public void doSave() {
        StringBuffer latestXMLContents = new StringBuffer();
        Result<StringBuffer> result = TemplateEditorUtilities1.doSave(this, this.session, this.getTemplateResource(), this.fmEditorInput.getLoadedTemplate(), this.libUpdated, latestXMLContents, true, logger);
        if (result == null) {
            return;
        }
        if (result.isSuccessfulWithoutWarnings()) {
            if (latestXMLContents.length() == 0) {
                this.setReturnCode(101);
                this.close();
                return;
            }
            try {
                this.fmEditorInput.setTemplate(TemplateSerializeUtils.load((StringBuffer)latestXMLContents, (IZRL)this.getTemplateResource()));
                this.offsetUpdated = false;
                this.refreshGUI();
                this.setEditorDirty(false);
            }
            catch (CoreException e) {
                String errMsg = Messages.TemplateEditor_SAVE_EX;
                logger.error((Object)errMsg, (Throwable)e);
                PDDialogs.openErrorThreadSafe((String)errMsg);
                return;
            }
        }
    }

    public void doSaveAs() {
        StringBuffer latestXMLContents = new StringBuffer();
        Result<StringBuffer> result = TemplateEditorUtilities1.doSaveAs(this, this.session, this.getTemplateResource(), this.fmEditorInput.getLoadedTemplate(), this.libUpdated, latestXMLContents, true, logger);
        if (result == null) {
            return;
        }
        if (result.isSuccessfulWithoutWarnings()) {
            this.setReturnCode(101);
            this.close();
        }
    }

    @Override
    public FMTemplateEditorInput1 getEditorInput() {
        return this.fmEditorInput;
    }

    @Override
    public SegmentsAndLayouts getSegmentsAndLayouts() {
        return this.segmentsAndLayouts;
    }
}

