/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template1;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionTemplate;
import com.ibm.etools.fm.editor.template1.FMTemplateEditorInput1;
import com.ibm.etools.fm.editor.template1.ITemplateEditor1;
import com.ibm.etools.fm.editor.template1.SegmentsAndLayouts;
import com.ibm.etools.fm.editor.template1.TemplateEditorTabs1;
import com.ibm.etools.fm.editor.template1.TemplateEditorUtilities1;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class TemplateEditor1
extends EditorPart
implements ITemplateEditor1 {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(TemplateEditor1.class);
    public static final String ID = "com.ibm.etools.fm.editor.template1.TemplateEditor1";
    private FMTemplateEditorInput1 fmEditorInput = null;
    private AbstractSessionTemplate session = null;
    private SegmentsAndLayouts segmentsAndLayouts = null;
    private boolean saveAsClosure = false;
    private boolean libUpdated = false;
    private boolean offsetUpdated = false;
    private TemplateEditorTabs1 templateEditorTabs = null;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof FMTemplateEditorInput1)) {
            String errMsg = MessageFormat.format(Messages.TE_InvalidInput, input != null ? input.getClass().getName() : null);
            logger.error((Object)errMsg);
            throw new PartInitException(errMsg);
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.fmEditorInput = (FMTemplateEditorInput1)input;
        IFile localFile = this.fmEditorInput.getFile();
        IZRL zosResource = this.fmEditorInput.getResource();
        if (!(this.fmEditorInput.getSessionIdentifer() instanceof AbstractSessionTemplate)) {
            throw new IllegalArgumentException();
        }
        this.session = this.fmEditorInput.getSessionIdentifer();
        if (localFile == null) {
            FMUIPlugin.getDefault().removeTemplateEditSession(this.fmEditorInput.getResource());
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.TE_NoCachedFile, zosResource.getFormattedName()));
            this.getSite().getPage().closeEditor((IEditorPart)this, false);
            return;
        }
        if (this.fmEditorInput.getLoadedTemplate() == null) {
            try {
                this.fmEditorInput.setTemplate(TemplateSerializeUtils.load((IFile)localFile, (IZRL)this.getTemplateResource()));
            }
            catch (Exception e) {
                FMUIPlugin.getDefault().removeTemplateEditSession(this.fmEditorInput.getResource());
                String errMsg = MessageFormat.format(Messages.TE_TemplateOpenError, this.fmEditorInput.getName());
                PDDialogs.openErrorThreadSafe((String)errMsg);
                logger.error((Object)errMsg, (Throwable)e);
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
                return;
            }
        } else if (this.fmEditorInput.isDirty()) {
            this.setEditorDirty();
        }
        if (!(this.fmEditorInput.getLoadedTemplate() == null || "IMS".equals(this.fmEditorInput.getLoadedTemplate().getType()) || "VIEW".equals(this.fmEditorInput.getLoadedTemplate().getType()) || "CRITERIA".equals(this.fmEditorInput.getLoadedTemplate().getType()))) {
            FMUIPlugin.getDefault().removeTemplateEditSession(this.fmEditorInput.getResource());
            String errMsg = MessageFormat.format(Messages.TemplateEditor1_TypeNotSupportede, this.fmEditorInput.getName(), this.fmEditorInput.getLoadedTemplate().getType());
            PDDialogs.openErrorThreadSafe((String)errMsg);
            this.getSite().getPage().closeEditor((IEditorPart)this, false);
            return;
        }
        this.segmentsAndLayouts = new SegmentsAndLayouts(this.fmEditorInput.getLoadedTemplate(), this.fmEditorInput.getSessionIdentifer());
        this.setPartName(input.getName());
    }

    public void createPartControl(Composite parent) {
        this.templateEditorTabs = new TemplateEditorTabs1();
        this.templateEditorTabs.buildTemplateEditorTabs(parent, this);
    }

    public void dispose() {
        FMUIPlugin.getDefault().removeTemplateEditSession(this.fmEditorInput.getResource());
        try {
            this.session.deleteCache();
            if (!this.saveAsClosure) {
                TemplateEditorUtilities1.end(this.session);
            }
        }
        catch (Exception e) {
            PDDialogs.openErrorThreadSafe((String)Messages.TemplateEditor_DISPOSE_ERR);
            logger.error((Object)"Failed to properly dispose of template editor", (Throwable)e);
        }
        super.dispose();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSave(IProgressMonitor arg0) {
        StringBuffer latestXMLContents = new StringBuffer();
        Result<StringBuffer> result = TemplateEditorUtilities1.doSave(this, this.session, this.getTemplateResource(), this.fmEditorInput.getLoadedTemplate(), this.libUpdated, latestXMLContents, false, logger);
        if (result == null) {
            return;
        }
        if (result.isSuccessfulWithoutWarnings()) {
            if (latestXMLContents.length() == 0) {
                this.saveAsClosure = true;
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
                return;
            }
            try {
                this.fmEditorInput.setTemplate(TemplateSerializeUtils.load((StringBuffer)latestXMLContents, (IZRL)this.getTemplateResource()));
                this.offsetUpdated = false;
                this.refreshGUI();
                this.fmEditorInput.setDirty(false);
                this.firePropertyChange(257);
            }
            catch (CoreException e) {
                String errMsg = Messages.TemplateEditor_SAVE_EX;
                logger.error((Object)errMsg, (Throwable)e);
                PDDialogs.openErrorThreadSafe((String)errMsg);
                return;
            }
        }
    }

    @Override
    public Result<StringBuffer> updateTemplate(IHowIsGoing monitor, boolean updateFromCopybooks) throws CoreException, InterruptedException, InvocationTargetException {
        StringBuffer newTemplateContents = new StringBuffer();
        Result<StringBuffer> result = TemplateEditorUtilities1.updateTemplate(monitor, updateFromCopybooks, this.fmEditorInput.getLoadedTemplate(), this.getTemplateResource(), this.session, newTemplateContents);
        if (!result.isSuccessfulWithoutWarnings()) {
            if (monitor != null) {
                monitor.done();
            }
            return result;
        }
        this.fmEditorInput.setTemplate(TemplateSerializeUtils.load((StringBuffer)newTemplateContents, (IZRL)this.getTemplateResource()));
        return result;
    }

    @Override
    public void updateTemplate(TemplateType newTemplate) {
        if (newTemplate == null) {
            return;
        }
        this.fmEditorInput.setTemplate(newTemplate);
        this.refreshGUI();
        this.fmEditorInput.setDirty(false);
        this.firePropertyChange(257);
    }

    @Override
    public void refreshGUI() {
        this.segmentsAndLayouts = new SegmentsAndLayouts(this.fmEditorInput.getLoadedTemplate(), this.fmEditorInput.getSessionIdentifer());
        this.templateEditorTabs.setNewTemplate(this.fmEditorInput.getLoadedTemplate());
    }

    public boolean isEditSession() {
        return this.fmEditorInput.isEditSession();
    }

    public IZRL getTemplateResource() {
        return this.fmEditorInput.getResource();
    }

    public void doSaveAs() {
        StringBuffer latestXMLContents = new StringBuffer();
        Result<StringBuffer> result = TemplateEditorUtilities1.doSaveAs(this, this.session, this.getTemplateResource(), this.fmEditorInput.getLoadedTemplate(), this.libUpdated, latestXMLContents, false, logger);
        if (result == null) {
            return;
        }
        if (result.isSuccessfulWithoutWarnings()) {
            this.saveAsClosure = true;
            this.getSite().getPage().closeEditor((IEditorPart)this, false);
        }
    }

    public void setFocus() {
        if (this.templateEditorTabs != null) {
            this.templateEditorTabs.setFocus();
        }
    }

    @Override
    public boolean isDirty() {
        return this.fmEditorInput.isDirty();
    }

    @Override
    public void setEditorDirty() {
        this.fmEditorInput.setDirty(true);
        this.firePropertyChange(257);
    }

    @Override
    public FMTemplateEditorInput1 getEditorInput() {
        return this.fmEditorInput;
    }

    public static String getFieldReferenceNumberForDisplay(Layouttype aLayout, Symboltype aSymbol, boolean withPrefix) {
        Objects.requireNonNull(aSymbol, "Must specify a non-null aSymbol.");
        if (withPrefix) {
            return "#" + (aSymbol.getRef() - aLayout.getId() + 1) + " ";
        }
        return "" + (aSymbol.getRef() - aLayout.getId() + 1);
    }

    @Override
    public void libUpdated(boolean updated) {
        this.libUpdated = updated;
    }

    @Override
    public void offsetUpdated() {
        this.offsetUpdated = true;
    }

    @Override
    public boolean isOffsetUpdated() {
        return this.offsetUpdated;
    }

    @Override
    public boolean builtFromCopybook() {
        return TemplateEditorUtilities1.existsInCopybooks(this.fmEditorInput.getResource().getFormattedName(), this.fmEditorInput.getLoadedTemplate().getCopybooks());
    }

    @Override
    public SegmentsAndLayouts getSegmentsAndLayouts() {
        return this.segmentsAndLayouts;
    }
}

