/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template1;

import com.ibm.etools.fm.core.model.ims.ImsDatabaseInfo;
import com.ibm.etools.fm.core.model.ims.ImsSegment;
import com.ibm.etools.fm.core.model.ims.SessionTemplate1;
import com.ibm.etools.fm.editor.template1.SegmentAndLayoutIndex;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class SegmentsAndLayouts {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final String[] segmentNames;
    private final Map<String, List<Layouttype>> segLayoutMap;
    private IPDHost pdHost = null;

    public SegmentsAndLayouts(TemplateType aTemplate, SessionTemplate1 aSession) {
        this.pdHost = aSession.getSystem();
        this.segLayoutMap = new HashMap<String, List<Layouttype>>();
        EList layouts = aTemplate.getLayout();
        ImsDatabaseInfo imsDbInfo = aSession.getDatabaseInfo();
        List segments = imsDbInfo.getSegments();
        this.segmentNames = new String[segments.size()];
        int i = 0;
        while (i < segments.size()) {
            this.segmentNames[i] = ((ImsSegment)segments.get(i)).getName();
            ArrayList<Layouttype> layoutsForSegment = new ArrayList<Layouttype>();
            for (Layouttype aLayout : layouts) {
                if (!this.segmentNames[i].equals(aLayout.getSegment())) continue;
                layoutsForSegment.add(aLayout);
            }
            this.segLayoutMap.put(this.segmentNames[i], layoutsForSegment);
            ++i;
        }
    }

    public String[] getSegmentNames() {
        return this.segmentNames;
    }

    public List<ImsSegment> getSegments(SessionTemplate1 aSession) {
        ImsDatabaseInfo imsDbInfo = aSession.getDatabaseInfo();
        return imsDbInfo.getSegments();
    }

    public String[] getLayoutNames(String segmentName) {
        List<Layouttype> layouts = this.segLayoutMap.get(segmentName);
        if (layouts == null) {
            return new String[0];
        }
        String[] layoutNames = new String[layouts.size()];
        int i = 0;
        while (i < layouts.size()) {
            layoutNames[i] = ((Symboltype)layouts.get(i).getSymbol().get(0)).getName(this.pdHost);
            ++i;
        }
        return layoutNames;
    }

    public int getFirstSelectedLayoutIndex(String segmentName) {
        List<Layouttype> layouts = this.segLayoutMap.get(segmentName);
        if (layouts == null) {
            return 0;
        }
        int i = 0;
        while (i < layouts.size()) {
            if (layouts.get(i).isSel()) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public Layouttype getLayout(String segmentName, int layoutIndex) {
        List<Layouttype> list = this.segLayoutMap.get(segmentName);
        return list == null ? null : list.get(layoutIndex);
    }

    public Layouttype getLayout(SegmentAndLayoutIndex index) {
        List<Layouttype> list = this.segLayoutMap.get(this.segmentNames[index.getSegmentIndex()]);
        return list == null ? null : list.get(index.getLayoutIndex());
    }
}

