/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.nattable.provider;

import com.ibm.etools.fm.editor.template.TemplateLayoutComposite;
import com.ibm.etools.fm.editor.template.dialogs.DateTimeDialog;
import com.ibm.etools.fm.editor.template.nattable.config.TemplateEditorConfiguration;
import com.ibm.etools.fm.editor.template.nattable.converter.CcsidDisplayConverter;
import com.ibm.etools.fm.editor.template.nattable.provider.ColumnDataProvider;
import com.ibm.etools.fm.editor.template.nattable.util.RDFCSetting;
import com.ibm.etools.fm.editor.template.nattable.util.Utils;
import com.ibm.etools.fm.model.template.Criteriatype;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TypeType;
import com.ibm.etools.fm.model.template.TypeType1;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.data.validate.ValidationFailedException;

public class SymbolDataProvider
implements IDataProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2018, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final boolean allowCcsId;
    private CcsidDisplayConverter ccsIdConverter = null;
    private final TemplateLayoutComposite tlc;

    public SymbolDataProvider(TemplateLayoutComposite tlc, boolean allowCcsId) {
        this.allowCcsId = allowCcsId;
        this.tlc = tlc;
    }

    public Symboltype getSymbolValue(int rowIndex) {
        return (Symboltype)((Layouttype)this.tlc.getTemplateType().getLayout().get(this.tlc.getSelectedLayoutIndex())).getSymbol().get(rowIndex);
    }

    public int getIndexOf(Symboltype symbol) {
        return ((Layouttype)this.tlc.getTemplateType().getLayout().get(this.tlc.getSelectedLayoutIndex())).getSymbol().indexOf((Object)symbol);
    }

    public Object getDataValue(int columnIndex, int rowIndex) {
        Symboltype symbol = (Symboltype)((Layouttype)this.tlc.getTemplateType().getLayout().get(this.tlc.getSelectedLayoutIndex())).getSymbol().get(rowIndex);
        Objects.requireNonNull(symbol, "Symbol not found!");
        switch (columnIndex) {
            case 0: {
                return symbol.getSeq();
            }
            case 1: {
                if (symbol.isSetHold() && symbol.isHold()) {
                    return true;
                }
                return false;
            }
            case 2: {
                if (symbol.isSetSel() && symbol.isSel()) {
                    return true;
                }
                return false;
            }
            case 3: {
                return symbol.getLvl();
            }
            case 4: {
                return symbol.getName(this.tlc.getSession().getSystem());
            }
            case 5: {
                return symbol.getLongname() == null ? "" : symbol.getLongname();
            }
            case 6: {
                return symbol.getPicture() == null ? "" : symbol.getPicture();
            }
            case 7: {
                if (DateTimeDialog.DeletedDateTime(symbol.getDatetime())) {
                    return Utils.reduceType(symbol.getType());
                }
                return "DT";
            }
            case 8: {
                return symbol.getStart();
            }
            case 9: {
                return symbol.getLength();
            }
            case 10: {
                boolean rdf = symbol.isSetAllowrdf() && symbol.isAllowrdf();
                RDFCSetting rdfc = new RDFCSetting(this.getRdfc(symbol));
                rdfc.setAllowed(rdf);
                return rdfc;
            }
            case 11: {
                if (this.ccsIdConverter != null) {
                    return symbol.getCcsid() == null ? "" : this.ccsIdConverter.canonicalToDisplayValue(symbol.getCcsid()).toString();
                }
                return symbol.getCcsid() == null ? "" : symbol.getCcsid();
            }
        }
        return null;
    }

    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        Symboltype symbol = (Symboltype)((Layouttype)this.tlc.getTemplateType().getLayout().get(this.tlc.getSelectedLayoutIndex())).getSymbol().get(rowIndex);
        Objects.requireNonNull(symbol, "Symbol not found!");
        boolean changed = false;
        switch (columnIndex) {
            case 0: {
                if (newValue == null || !(newValue instanceof Integer)) break;
                symbol.setSeq(((Integer)newValue).intValue());
                changed = true;
                break;
            }
            case 1: {
                if (newValue == null || !(newValue instanceof Boolean)) break;
                symbol.setHold(((Boolean)newValue).booleanValue());
                changed = true;
                break;
            }
            case 2: {
                if (newValue == null || !(newValue instanceof Boolean)) break;
                symbol.setSel(((Boolean)newValue).booleanValue());
                changed = true;
                break;
            }
            case 3: {
                if (newValue == null || !(newValue instanceof Integer)) break;
                symbol.setLvl(((Integer)newValue).intValue());
                changed = true;
                break;
            }
            case 4: {
                symbol.setName(newValue == null ? "" : newValue.toString());
                changed = true;
                break;
            }
            case 5: {
                symbol.setLongname(newValue == null ? "" : newValue.toString());
                changed = true;
                break;
            }
            case 6: {
                symbol.setPicture(newValue == null ? "" : newValue.toString());
                changed = true;
                break;
            }
            case 7: {
                if (!DateTimeDialog.DeletedDateTime(symbol.getDatetime())) break;
                symbol.setType(newValue == null ? null : TypeType.get((String)newValue.toString()));
                changed = true;
                this.validateTypeChange(symbol, columnIndex, rowIndex);
                break;
            }
            case 8: {
                if (newValue == null || !(newValue instanceof Integer)) break;
                symbol.setStart(((Integer)newValue).intValue());
                changed = true;
                break;
            }
            case 9: {
                if (newValue == null || !(newValue instanceof Integer)) break;
                symbol.setLength(((Integer)newValue).intValue());
                changed = true;
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                if (this.ccsIdConverter != null && newValue != null && newValue.toString().length() > 0) {
                    symbol.setCcsid(this.ccsIdConverter.displayToCanonicalValue(newValue.toString()).toString());
                    symbol.setCcside(null);
                } else {
                    symbol.setCcsid(newValue == null ? "" : newValue.toString());
                    symbol.setCcside(null);
                }
                changed = true;
                break;
            }
            default: {
                return;
            }
        }
        if (changed) {
            this.tlc.getEditor().setEditorDirty();
        }
    }

    public int getColumnCount() {
        return this.allowCcsId ? ColumnDataProvider.COLUMN_NAMES.length : ColumnDataProvider.COLUMN_NAMES.length - 1;
    }

    public int getRowCount() {
        return ((Layouttype)this.tlc.getTemplateType().getLayout().get(this.tlc.getSelectedLayoutIndex())).getSymbol().size();
    }

    public void setCcsIds(String[] ccsIds) {
        this.ccsIdConverter = new CcsidDisplayConverter(ccsIds);
    }

    private Criteriatype getRdfc(Symboltype symbol) {
        EList criteria = ((Layouttype)this.tlc.getTemplateType().getLayout().get(this.tlc.getSelectedLayoutIndex())).getCriteria();
        for (Criteriatype c : criteria) {
            if (c.getType() != TypeType1.RDF || c.getFref() != symbol.getRef()) continue;
            return c;
        }
        return null;
    }

    private void validateTypeChange(Symboltype symbol, int columnIndex, int rowIndex) {
        IDataValidator lengthValidator;
        block15: {
            IDataValidator startValidator = TemplateEditorConfiguration.getStartValidator();
            lengthValidator = this.tlc.getTemplateEditorConfiguration().getLengthValidator();
            boolean validStart = false;
            try {
                try {
                    validStart = startValidator.validate(8, rowIndex, (Object)symbol.getStart());
                }
                catch (ValidationFailedException validationFailedException) {
                    if (!validStart) {
                        this.setDataValue(8, rowIndex, 1);
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (!validStart) {
                    this.setDataValue(8, rowIndex, 1);
                }
                throw throwable;
            }
            if (!validStart) {
                this.setDataValue(8, rowIndex, 1);
            }
        }
        boolean validLength = false;
        try {
            try {
                validLength = lengthValidator.validate(9, rowIndex, (Object)symbol.getLength());
            }
            catch (ValidationFailedException validationFailedException) {
                if (!validLength) {
                    this.setDataValue(9, rowIndex, this.tlc.getTemplateEditorConfiguration().getDefaultLengthValue(symbol.getType().toString()));
                }
            }
        }
        finally {
            if (!validLength) {
                this.setDataValue(9, rowIndex, this.tlc.getTemplateEditorConfiguration().getDefaultLengthValue(symbol.getType().toString()));
            }
        }
    }
}

