/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.nattable.menu;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.IRetrieveCcsidSession;
import com.ibm.etools.fm.editor.template.TemplateLayoutComposite;
import com.ibm.etools.fm.editor.template.dialogs.DateTimeDialog;
import com.ibm.etools.fm.editor.template.dialogs.DefineDynamicFieldDialog;
import com.ibm.etools.fm.editor.template.dialogs.FieldAttributeDialog;
import com.ibm.etools.fm.editor.template.dialogs.TemplateMappingDialog;
import com.ibm.etools.fm.editor.template.nattable.NatTableWrapper;
import com.ibm.etools.fm.editor.template.nattable.util.Utils;
import com.ibm.etools.fm.model.template.Criteriatype;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.TypeType1;
import com.ibm.etools.fm.model.template.util.TemplateModelUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import org.eclipse.emf.common.util.EList;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemProvider;
import org.eclipse.nebula.widgets.nattable.ui.menu.MenuItemProviders;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class TemplateMenuItemProviders {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2018, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public static IMenuItemProvider mappingMenuItemProvider(final NatTableWrapper wrapper) {
        return new IMenuItemProvider(){

            public void addMenuItem(NatTable natTable, Menu popupMenu) {
                MenuItem setAttributesItem = new MenuItem(popupMenu, 8);
                setAttributesItem.setText(Messages.TE_LAYOUT_fieldMapButtonTip);
                setAttributesItem.setImage(FMUIPlugin.getDefault().getImageRegistry().get("icons/map.gif"));
                setAttributesItem.setEnabled(true);
                setAttributesItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        if (wrapper.getTemplateLayoutComposite().getEditor().isDirty() && !PDDialogs.openConfirm((String)Messages.Confirm, (String)Messages.TE_LAYOUT_editorDirtyBeforeMapping)) {
                            return;
                        }
                        TemplateMappingDialog dialog = new TemplateMappingDialog(null, wrapper.getTemplateLayoutComposite().getTemplateResource());
                        if (dialog.open() != 0) {
                            return;
                        }
                        TemplateType newTemplate = dialog.getToTemplateIfModified();
                        IZRL aTemplate = dialog.getToTemplateResource();
                        if (newTemplate != null && wrapper.getTemplateLayoutComposite().getTemplateResource().equals(dialog.getToTemplateResource())) {
                            wrapper.updateBody();
                            wrapper.getTemplateLayoutComposite().getEditor().updateTemplate(newTemplate, aTemplate);
                        }
                    }
                });
            }
        };
    }

    public static IMenuItemProvider setAttributesMenuItemProvider(final NatTableWrapper wrapper) {
        return new IMenuItemProvider(){

            public void addMenuItem(NatTable natTable, Menu popupMenu) {
                MenuItem setAttributesItem = new MenuItem(popupMenu, 8);
                setAttributesItem.setText(Messages.TE_LAYOUT_SpecifyAttrButtonTip);
                setAttributesItem.setImage(FMUIPlugin.getDefault().getImageRegistry().get("icons/attributes.gif"));
                setAttributesItem.setEnabled(true);
                setAttributesItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        int fieldIndex = MenuItemProviders.getNatEventData((SelectionEvent)event).getRowPosition() - 2;
                        if (fieldIndex == -1) {
                            PDDialogs.openInfoThreadSafe((String)Messages.TE_LAYOUT_NoFieldSelForAction);
                            return;
                        }
                        if (fieldIndex == 0 && "DYNAMIC".equals(wrapper.getTemplateLayoutComposite().getTemplateType().getType())) {
                            PDDialogs.openInfoThreadSafe((String)Messages.TemplateLayoutComposite_7);
                            return;
                        }
                        Layouttype currentLayout = (Layouttype)wrapper.getTemplateLayoutComposite().getTemplateType().getLayout().get(wrapper.getLayoutIndex());
                        FieldAttributeDialog dialog = new FieldAttributeDialog(wrapper.getTemplateLayoutComposite().getSession(), wrapper.getTemplateLayoutComposite().getTemplateResource(), wrapper.getTemplateLayoutComposite().getTemplateType(), currentLayout, MenuItemProviders.getNatEventData((SelectionEvent)event).getRowPosition() - 2, false);
                        if (dialog.open() != 0) {
                            if (dialog.validationErrorOccurred()) {
                                wrapper.getTemplateLayoutComposite().getEditor().setEditorDirty();
                            }
                            return;
                        }
                        wrapper.getTemplateLayoutComposite().getEditor().setEditorDirty();
                        wrapper.updateBody();
                    }
                });
            }
        };
    }

    public static IMenuItemProvider addNewFieldMenuItemProvider(final NatTableWrapper wrapper) {
        return new IMenuItemProvider(){

            public void addMenuItem(NatTable natTable, Menu popupMenu) {
                MenuItem addFieldItem = new MenuItem(popupMenu, 8);
                addFieldItem.setText(Messages.TE_LAYOUT_AddFieldButtonTip);
                addFieldItem.setImage(FMUIPlugin.getDefault().getImageRegistry().get("icons/add.gif"));
                addFieldItem.setEnabled(true);
                addFieldItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        int fieldIndex = wrapper.getLayoutIndex();
                        if (fieldIndex == -1) {
                            PDDialogs.openInfoThreadSafe((String)Messages.TE_LAYOUT_NoFieldSelForAction);
                            return;
                        }
                        Layouttype currentLayout = (Layouttype)wrapper.getTemplateLayoutComposite().getTemplateType().getLayout().get(wrapper.getLayoutIndex());
                        if (!Utils.checkFreeFormatCriteria(wrapper.getTemplateLayoutComposite().getTemplateType(), currentLayout)) {
                            return;
                        }
                        DefineDynamicFieldDialog dialog = new DefineDynamicFieldDialog(Display.getCurrent().getActiveShell(), TemplateModelUtils.createNewDynamicField((Layouttype)currentLayout), wrapper.getTemplateLayoutComposite().getSession().getSystem());
                        if (dialog.open() != 0) {
                            return;
                        }
                        Symboltype aSymbol = dialog.getSymbol();
                        TemplateModelUtils.addDynamicFieldToLayout((Layouttype)currentLayout, (Symboltype)aSymbol, (IPDHost)wrapper.getTemplateLayoutComposite().getSession().getSystem());
                        wrapper.getTemplateLayoutComposite().setUpdateInProgress(true);
                        wrapper.getTemplateLayoutComposite().setLayoutInformation(wrapper.getLayoutIndex(), fieldIndex);
                        wrapper.getTemplateLayoutComposite().setUpdateInProgress(false);
                        wrapper.getTemplateLayoutComposite().getEditor().setEditorDirty();
                        wrapper.getTemplateLayoutComposite().setSymbolsUpdated();
                        wrapper.getNatTable().refresh();
                        wrapper.updateBody();
                    }
                });
            }
        };
    }

    public static IMenuItemProvider modifyFieldMenuItemProvider(final NatTableWrapper wrapper) {
        return new IMenuItemProvider(){

            public void addMenuItem(NatTable natTable, Menu popupMenu) {
                MenuItem modifyFieldItem = new MenuItem(popupMenu, 8);
                modifyFieldItem.setText(Messages.TE_LAYOUT_ModifyFieldButtonTip);
                modifyFieldItem.setImage(FMUIPlugin.getDefault().getImageRegistry().get("icons/editfield.gif"));
                modifyFieldItem.setEnabled(true);
                modifyFieldItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        int fieldIndex = MenuItemProviders.getNatEventData((SelectionEvent)event).getRowPosition() - 2;
                        if (fieldIndex == -1) {
                            PDDialogs.openInfoThreadSafe((String)Messages.TE_LAYOUT_NoFieldSelForAction);
                            return;
                        }
                        Layouttype currentLayout = (Layouttype)wrapper.getTemplateLayoutComposite().getTemplateType().getLayout().get(wrapper.getLayoutIndex());
                        Symboltype aSymbol = (Symboltype)currentLayout.getSymbol().get(fieldIndex);
                        DefineDynamicFieldDialog dialog = new DefineDynamicFieldDialog(Display.getCurrent().getActiveShell(), aSymbol, wrapper.getTemplateLayoutComposite().getSession().getSystem());
                        if (dialog.open() != 0) {
                            return;
                        }
                        TemplateModelUtils.updateChangedDynamicField((Layouttype)currentLayout, (Symboltype)aSymbol, (IPDHost)wrapper.getTemplateLayoutComposite().getSession().getSystem());
                        wrapper.getTemplateLayoutComposite().setUpdateInProgress(true);
                        wrapper.getTemplateLayoutComposite().setLayoutInformation(wrapper.getLayoutIndex(), fieldIndex);
                        wrapper.getTemplateLayoutComposite().setUpdateInProgress(false);
                        wrapper.getTemplateLayoutComposite().getEditor().setEditorDirty();
                        wrapper.getTemplateLayoutComposite().setSymbolsUpdated();
                        wrapper.updateBody();
                    }
                });
            }
        };
    }

    public static IMenuItemProvider removeFieldMenuItemProvider(final NatTableWrapper wrapper) {
        return new IMenuItemProvider(){

            public void addMenuItem(NatTable natTable, Menu popupMenu) {
                MenuItem removeFieldItem = new MenuItem(popupMenu, 8);
                removeFieldItem.setText(Messages.TE_LAYOUT_RemoveFieldButtonTip);
                removeFieldItem.setImage(FMUIPlugin.getDefault().getImageRegistry().get("icons/delete.gif"));
                removeFieldItem.setEnabled(true);
                removeFieldItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        int fieldIndex = MenuItemProviders.getNatEventData((SelectionEvent)event).getRowPosition() - 2;
                        if (fieldIndex == -1) {
                            PDDialogs.openInfoThreadSafe((String)Messages.TE_infoTabName, (String)Messages.TE_LAYOUT_NoFieldSelForAction);
                            return;
                        }
                        if (fieldIndex == 0) {
                            return;
                        }
                        Layouttype currentLayout = (Layouttype)wrapper.getTemplateLayoutComposite().getTemplateType().getLayout().get(wrapper.getLayoutIndex());
                        if (!Utils.checkFreeFormatCriteria(wrapper.getTemplateLayoutComposite().getTemplateType(), currentLayout)) {
                            return;
                        }
                        Symboltype aSymbol = (Symboltype)currentLayout.getSymbol().get(fieldIndex);
                        TemplateModelUtils.removeDynamicFieldFromLayout((Layouttype)currentLayout, (Symboltype)aSymbol, (IPDHost)wrapper.getTemplateLayoutComposite().getSession().getSystem());
                        wrapper.getTemplateLayoutComposite().setUpdateInProgress(true);
                        wrapper.getTemplateLayoutComposite().setLayoutInformation(wrapper.getLayoutIndex(), fieldIndex);
                        wrapper.getTemplateLayoutComposite().setUpdateInProgress(false);
                        wrapper.getTemplateLayoutComposite().getEditor().setEditorDirty();
                        wrapper.getTemplateLayoutComposite().setSymbolsUpdated();
                        wrapper.getNatTable().refresh();
                        wrapper.updateBody();
                    }
                });
            }
        };
    }

    public static IMenuItemProvider clearRedefinesCriteriaMenuItemProvider(final NatTableWrapper wrapper) {
        return new IMenuItemProvider(){

            public void addMenuItem(NatTable natTable, Menu popupMenu) {
                MenuItem clearItem = new MenuItem(popupMenu, 8);
                clearItem.setText(Messages.TE_LAYOUT_RedefinesClearCriteriaButton);
                clearItem.setImage(FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaClear.gif"));
                clearItem.setEnabled(true);
                clearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        if (wrapper.getTemplateLayoutComposite().isSynchWithHostRequired() && !wrapper.getTemplateLayoutComposite().synchSymbolsWithHost()) {
                            return;
                        }
                        if (wrapper.getTemplateLayoutComposite().offsetUpdated()) {
                            return;
                        }
                        int layoutIndex = wrapper.getLayoutIndex();
                        int fieldIndex = MenuItemProviders.getNatEventData((SelectionEvent)event).getRowPosition() - 2;
                        int reference = ((Symboltype)((Layouttype)wrapper.getTemplateLayoutComposite().getTemplateType().getLayout().get(layoutIndex)).getSymbol().get(fieldIndex)).getRef();
                        Layouttype currentLayout = (Layouttype)wrapper.getTemplateLayoutComposite().getTemplateType().getLayout().get(layoutIndex);
                        EList criteriaList = currentLayout.getCriteria();
                        boolean found = false;
                        Criteriatype removeMe = null;
                        int i = 0;
                        while (i < criteriaList.size()) {
                            Criteriatype aCriteria = (Criteriatype)criteriaList.get(i);
                            if (aCriteria.getType() == TypeType1.RDF && aCriteria.getFref() == reference) {
                                found = true;
                                removeMe = aCriteria;
                                break;
                            }
                            ++i;
                        }
                        if (found) {
                            wrapper.getTemplateLayoutComposite().getEditor().setEditorDirty();
                            TemplateLayoutComposite.clearCriteriaSpec(removeMe);
                            wrapper.getTemplateLayoutComposite().getEditor().setEditorDirty();
                            TemplateType clearedTemplate = wrapper.getTemplateLayoutComposite().clearCriteria();
                            if (clearedTemplate != null) {
                                wrapper.getTemplateLayoutComposite().updateCriteria(clearedTemplate);
                                wrapper.getTemplateLayoutComposite().setUpdateInProgress(true);
                                wrapper.getTemplateLayoutComposite().setLayoutInformation(layoutIndex, fieldIndex);
                                wrapper.getTemplateLayoutComposite().setUpdateInProgress(false);
                            }
                        }
                    }
                });
            }
        };
    }

    public static IMenuItemProvider addFieldRedefinesCriteriaMenuItemProvider(final NatTableWrapper wrapper) {
        return new IMenuItemProvider(){

            public void addMenuItem(NatTable natTable, Menu popupMenu) {
                MenuItem fieldRedefinesItem = new MenuItem(popupMenu, 8);
                fieldRedefinesItem.setText(Messages.TE_LAYOUT_RedefinesBuildCriteriaButton);
                fieldRedefinesItem.setImage(FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaWiz.gif"));
                fieldRedefinesItem.setEnabled(true);
                fieldRedefinesItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        if (wrapper.getTemplateLayoutComposite().isSynchWithHostRequired() && !wrapper.getTemplateLayoutComposite().synchSymbolsWithHost()) {
                            return;
                        }
                        if (wrapper.getTemplateLayoutComposite().offsetUpdated()) {
                            return;
                        }
                        int fieldIndex = MenuItemProviders.getNatEventData((SelectionEvent)event).getRowPosition() - 2;
                        int reference = ((Symboltype)((Layouttype)wrapper.getTemplateLayoutComposite().getTemplateType().getLayout().get(wrapper.getLayoutIndex())).getSymbol().get(fieldIndex)).getRef();
                        wrapper.getTemplateLayoutComposite().buildCriteria(TypeType1.RDF, reference);
                    }
                });
            }
        };
    }

    public static IMenuItemProvider addFreeRedefinesCriteriaMenuItemProvider(final NatTableWrapper wrapper) {
        return new IMenuItemProvider(){

            public void addMenuItem(NatTable natTable, Menu popupMenu) {
                MenuItem freeRedefinesItem = new MenuItem(popupMenu, 8);
                freeRedefinesItem.setText(Messages.TE_LAYOUT_RedefinesWriteCriteriaButton);
                freeRedefinesItem.setImage(FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaWriter.gif"));
                freeRedefinesItem.setEnabled(true);
                freeRedefinesItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        if (wrapper.getTemplateLayoutComposite().isSynchWithHostRequired() && !wrapper.getTemplateLayoutComposite().synchSymbolsWithHost()) {
                            return;
                        }
                        if (wrapper.getTemplateLayoutComposite().offsetUpdated()) {
                            return;
                        }
                        EList symbols = ((Layouttype)wrapper.getTemplateLayoutComposite().getTemplateType().getLayout().get(wrapper.getLayoutIndex())).getSymbol();
                        int selectionIndex = MenuItemProviders.getNatEventData((SelectionEvent)event).getRowPosition() - 2;
                        int reference = ((Symboltype)symbols.get(selectionIndex)).getRef();
                        wrapper.getTemplateLayoutComposite().writeCriteria(TypeType1.RDF, reference);
                    }
                });
            }
        };
    }

    public static IMenuItemProvider setDateTimeMenuItemProvider(final NatTableWrapper wrapper) {
        return new IMenuItemProvider(){

            public void addMenuItem(NatTable natTable, Menu popupMenu) {
                MenuItem setAttributesItem = new MenuItem(popupMenu, 8);
                setAttributesItem.setText(Messages.DateTimeDialog_Msg);
                setAttributesItem.setImage(FMUIPlugin.getDefault().getImageRegistry().get("icons/dates.gif"));
                setAttributesItem.setEnabled(true);
                setAttributesItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        int fieldIndex = MenuItemProviders.getNatEventData((SelectionEvent)event).getRowPosition() - 2;
                        if (fieldIndex == -1) {
                            PDDialogs.openInfoThreadSafe((String)Messages.TE_LAYOUT_NoFieldSelForAction);
                            return;
                        }
                        Layouttype currentLayout = (Layouttype)wrapper.getTemplateLayoutComposite().getTemplateType().getLayout().get(wrapper.getLayoutIndex());
                        do {
                            DateTimeDialog dialog;
                            if ((dialog = new DateTimeDialog((IRetrieveCcsidSession)wrapper.getTemplateLayoutComposite().getSession(), wrapper.getTemplateLayoutComposite().getTemplateResource().getSystem(), currentLayout, fieldIndex)).open() != 0) {
                                return;
                            }
                            wrapper.getTemplateLayoutComposite().getEditor().setEditorDirty();
                            wrapper.getTemplateLayoutComposite().setLayoutInformation(wrapper.getLayoutIndex(), fieldIndex);
                            wrapper.getTemplateLayoutComposite().setSymbolsUpdated();
                        } while (!wrapper.getTemplateLayoutComposite().synchSymbolsWithHost());
                    }
                });
            }
        };
    }
}

