/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.nattable.converter;

import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.data.convert.ConversionFailedException;
import org.eclipse.nebula.widgets.nattable.data.convert.DisplayConverter;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

public class SequenceDisplayConverter
extends DisplayConverter {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected NumberFormat nf = NumberFormat.getInstance();

    public Object canonicalToDisplayValue(Object canonicalValue) {
        block5: {
            Integer seq;
            block7: {
                block6: {
                    try {
                        if (!ObjectUtils.isNotNull((Object)canonicalValue)) break block5;
                        if (canonicalValue instanceof Integer) break block6;
                        return null;
                    }
                    catch (Exception e) {
                        return canonicalValue;
                    }
                }
                seq = (Integer)canonicalValue;
                if (seq != 0) break block7;
                return "";
            }
            if (this.nf != null) {
                return this.nf.format(seq);
            }
            return canonicalValue.toString();
        }
        return null;
    }

    public Object displayToCanonicalValue(Object displayValue) {
        block5: {
            try {
                if (displayValue != null) break block5;
                return null;
            }
            catch (Exception e) {
                throw new ConversionFailedException(Messages.getString((String)"NumericDisplayConverter.failure", (Object[])new Object[]{displayValue}), (Throwable)e);
            }
        }
        if (displayValue.toString().isEmpty()) {
            return 0;
        }
        if (ObjectUtils.isNotNull((Object)displayValue) && ObjectUtils.isNotEmpty((String)displayValue.toString())) {
            return this.convertToInteger(displayValue.toString().trim());
        }
        return null;
    }

    protected Integer convertToInteger(String value) {
        if (this.nf != null) {
            try {
                return this.nf.parse(value).intValue();
            }
            catch (ParseException e) {
                throw new NumberFormatException(e.getLocalizedMessage());
            }
        }
        return Integer.valueOf(value);
    }

    public NumberFormat getNumberFormat() {
        return this.nf;
    }
}

