/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.nattable.config;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.template.nattable.NatTableWrapper;
import com.ibm.etools.fm.editor.template.nattable.converter.CcsidDisplayConverter;
import com.ibm.etools.fm.editor.template.nattable.converter.RedefinesCriteriaDisplayConverter;
import com.ibm.etools.fm.editor.template.nattable.converter.SequenceDisplayConverter;
import com.ibm.etools.fm.editor.template.nattable.converter.TypeDisplayConverter;
import com.ibm.etools.fm.model.template.TypeType;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultBooleanDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultIntegerDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.validate.DataValidator;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.data.validate.ValidationFailedException;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.config.DialogErrorHandling;
import org.eclipse.nebula.widgets.nattable.edit.editor.CheckBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.painter.cell.CheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ComboBoxPainter;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;

public class TemplateEditorConfiguration
extends AbstractRegistryConfiguration {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2018, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final boolean canUpdateSymbols;
    private final boolean allowCcsId;
    private final String[] ccsIds;
    private final NatTableWrapper wrapper;

    public TemplateEditorConfiguration(NatTableWrapper wrapper, boolean canUpdateSymbols, boolean allowCcsId, String[] ccsIds) {
        this.canUpdateSymbols = canUpdateSymbols;
        this.wrapper = wrapper;
        this.allowCcsId = allowCcsId;
        if (ccsIds != null) {
            this.ccsIds = new String[ccsIds.length + 1];
            this.ccsIds[0] = "";
            int i = 1;
            while (i <= ccsIds.length) {
                this.ccsIds[i] = ccsIds[i - 1];
                ++i;
            }
        } else {
            this.ccsIds = new String[]{""};
        }
    }

    public void configureRegistry(IConfigRegistry configRegistry) {
        this.registerEditors(configRegistry);
    }

    private void registerEditors(IConfigRegistry configRegistry) {
        TemplateEditorConfiguration.registerSequenceEditor(configRegistry, 0);
        TemplateEditorConfiguration.registerBooleanEditor(configRegistry, 1);
        TemplateEditorConfiguration.registerBooleanEditor(configRegistry, 2);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.NEVER_EDITABLE, DisplayMode.EDIT, "COLUMN_3");
        this.registerStringEditor(configRegistry, 4);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.NEVER_EDITABLE, DisplayMode.EDIT, "COLUMN_5");
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.NEVER_EDITABLE, DisplayMode.EDIT, "COLUMN_6");
        configRegistry.registerConfigAttribute(EditConfigAttributes.SUPPORT_MULTI_EDIT, (Object)Boolean.TRUE, DisplayMode.EDIT, "COLUMN_1");
        configRegistry.registerConfigAttribute(EditConfigAttributes.SUPPORT_MULTI_EDIT, (Object)Boolean.TRUE, DisplayMode.EDIT, "COLUMN_2");
        this.registerTypeEditor(configRegistry, 7);
        this.registerIntegerEditor(configRegistry, 8);
        this.registerIntegerEditor(configRegistry, 9);
        TemplateEditorConfiguration.registerRedefinesCriteriaEditor(configRegistry, 10);
        if (this.allowCcsId) {
            this.registerCcsIdEditor(configRegistry, 11);
        }
        TemplateEditorConfiguration.registerStartValidator(configRegistry);
        this.registerLengthValidator(configRegistry);
    }

    private static void registerRedefinesCriteriaEditor(IConfigRegistry configRegistry, int columnIndex) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.NEVER_EDITABLE, DisplayMode.EDIT, "COLUMN_" + columnIndex);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new RedefinesCriteriaDisplayConverter(), DisplayMode.NORMAL, "COLUMN_" + columnIndex);
    }

    private void registerTypeEditor(IConfigRegistry configRegistry, int columnIndex) {
        if (this.canUpdateSymbols) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, DisplayMode.EDIT, "COLUMN_" + columnIndex);
            ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor(Arrays.asList(TypeType.AN, TypeType.AX, TypeType.BI, TypeType.BT, TypeType.DB, TypeType.FE, TypeType.FP, TypeType.G, TypeType.PD, TypeType.VB, TypeType.VC, TypeType.VD, TypeType.VG, TypeType.Z2, TypeType.ZA, TypeType.ZC, TypeType.ZD, TypeType.ZG));
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)comboBoxCellEditor, DisplayMode.EDIT, "COLUMN_" + columnIndex);
        }
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new TypeDisplayConverter(), DisplayMode.NORMAL, "COLUMN_" + columnIndex);
    }

    private void registerStringEditor(IConfigRegistry configRegistry, int columnIndex) {
        if (this.canUpdateSymbols) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, DisplayMode.EDIT, "COLUMN_" + columnIndex);
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new TextCellEditor(true, true), DisplayMode.NORMAL, "COLUMN_" + columnIndex);
        }
    }

    private void registerCcsIdEditor(IConfigRegistry configRegistry, int columnIndex) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, DisplayMode.EDIT, "ALLOWED_CCSID");
        ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor(Arrays.asList(this.ccsIds));
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)comboBoxCellEditor, DisplayMode.EDIT, "ALLOWED_CCSID");
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new CcsidDisplayConverter(this.ccsIds), DisplayMode.NORMAL, "ALLOWED_CCSID");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new ComboBoxPainter(), DisplayMode.NORMAL, "ALLOWED_CCSID");
    }

    private static void registerBooleanEditor(IConfigRegistry configRegistry, int columnIndex) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, DisplayMode.EDIT, "COLUMN_" + columnIndex);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new CheckBoxCellEditor(), DisplayMode.EDIT, "COLUMN_" + columnIndex);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CheckBoxPainter(), DisplayMode.NORMAL, "COLUMN_" + columnIndex);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultBooleanDisplayConverter(), DisplayMode.NORMAL, "COLUMN_" + columnIndex);
    }

    private static void registerSequenceEditor(IConfigRegistry configRegistry, int columnIndex) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, DisplayMode.EDIT, "COLUMN_" + columnIndex);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new TextCellEditor(true, true), DisplayMode.NORMAL, "COLUMN_" + columnIndex);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new SequenceDisplayConverter(), DisplayMode.NORMAL, "COLUMN_" + columnIndex);
    }

    private void registerIntegerEditor(IConfigRegistry configRegistry, int columnIndex) {
        if (this.canUpdateSymbols) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, DisplayMode.EDIT, "COLUMN_" + columnIndex);
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new TextCellEditor(true, true), DisplayMode.NORMAL, "COLUMN_" + columnIndex);
        }
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultIntegerDisplayConverter(), DisplayMode.NORMAL, "COLUMN_" + columnIndex);
    }

    private static void registerStartValidator(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)TemplateEditorConfiguration.getStartValidator(), DisplayMode.EDIT, "COLUMN_8");
        configRegistry.registerConfigAttribute(EditConfigAttributes.VALIDATION_ERROR_HANDLER, (Object)new DialogErrorHandling(), DisplayMode.EDIT, "COLUMN_8");
    }

    private void registerLengthValidator(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)this.getLengthValidator(), DisplayMode.EDIT, "COLUMN_9");
        configRegistry.registerConfigAttribute(EditConfigAttributes.VALIDATION_ERROR_HANDLER, (Object)new DialogErrorHandling(), DisplayMode.EDIT, "COLUMN_9");
    }

    public int getDefaultLengthValue(String type) {
        switch (type) {
            case "B": 
            case "C": 
            case "AN": 
            case "AX": 
            case "BI": 
            case "BT": 
            case "PD": 
            case "VB": 
            case "VC": 
            case "ZC": 
            case "ZD": {
                return 1;
            }
            case "G": 
            case "DB": 
            case "VD": 
            case "VG": 
            case "Z2": 
            case "ZG": {
                return 2;
            }
            case "FE": {
                return 7;
            }
            case "FP": {
                return 4;
            }
        }
        return 1;
    }

    public IDataValidator getLengthValidator() {
        return new DataValidator(){

            public boolean validate(int columnIndex, int rowIndex, Object newValue) {
                if (!(newValue instanceof Integer)) {
                    return false;
                }
                Integer length = (Integer)newValue;
                if (length < 1) {
                    throw new ValidationFailedException(Messages.DefineDynamicFieldDialog_LENGTH_ERROR);
                }
                Object value = TemplateEditorConfiguration.this.wrapper.getNatTable().getDataValueByPosition(8, rowIndex + 1);
                if (value == null || !(value instanceof TypeType)) {
                    return true;
                }
                TypeType type = (TypeType)value;
                switch (type.toString()) {
                    case "C": 
                    case "AN": 
                    case "AX": {
                        return true;
                    }
                    case "B": 
                    case "BI": {
                        if (length != 1 && length != 2 && length != 4 && length != 8) {
                            throw new ValidationFailedException(MessageFormat.format(Messages.DefineDynamicFieldDialog_LENGTH_BIERROR, type.toString()));
                        }
                        return true;
                    }
                    case "BT": 
                    case "VB": 
                    case "VC": 
                    case "ZC": {
                        if (length <= 0) {
                            throw new ValidationFailedException(MessageFormat.format(Messages.DefineDynamicFieldDialog_LENGTH_IS_ZERO_ERROR, type.toString()));
                        }
                        return true;
                    }
                    case "G": 
                    case "DB": 
                    case "VD": 
                    case "VG": 
                    case "Z2": 
                    case "ZG": {
                        if (length <= 0 || length % 2 != 0) {
                            throw new ValidationFailedException(MessageFormat.format(Messages.DefineDynamicFieldDialog_LENGTH_EVEN_ERROR, type.toString()));
                        }
                        return true;
                    }
                    case "FE": {
                        if (length < 7 || length > 23) {
                            throw new ValidationFailedException(MessageFormat.format(Messages.DefineDynamicFieldDialog_LENGTH_RANGE_ERROR, type.toString(), 7, 23));
                        }
                        return true;
                    }
                    case "FP": {
                        if (length != 4 || length != 8) {
                            throw new ValidationFailedException(MessageFormat.format(Messages.DefineDynamicFieldDialog_LENGTH_FPERROR, type.toString()));
                        }
                        return true;
                    }
                    case "P": 
                    case "PD": {
                        if (length <= 0 || length > 16) {
                            throw new ValidationFailedException(MessageFormat.format(Messages.DefineDynamicFieldDialog_LENGTH_RANGE_ERROR, type.toString(), 1, 16));
                        }
                        return true;
                    }
                    case "ZD": {
                        if (length < 1 || length > 32) {
                            throw new ValidationFailedException(MessageFormat.format(Messages.DefineDynamicFieldDialog_LENGTH_RANGE_ERROR, type.toString(), 1, 32));
                        }
                        return true;
                    }
                }
                return true;
            }
        };
    }

    public static IDataValidator getStartValidator() {
        return new DataValidator(){

            public boolean validate(int columnIndex, int rowIndex, Object newValue) {
                if (newValue instanceof Integer) {
                    Integer start = (Integer)newValue;
                    if (start == 0) {
                        throw new ValidationFailedException(Messages.DefineDynamicFieldDialog_START_IS_ZERO_ERROR);
                    }
                } else {
                    throw new ValidationFailedException(Messages.DefineDynamicFieldDialog_START_IS_ZERO_ERROR);
                }
                return true;
            }
        };
    }
}

