/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.nattable.accumulator;

import com.ibm.etools.fm.editor.template.TemplateLayoutComposite;
import com.ibm.etools.fm.editor.template.nattable.provider.SymbolDataProvider;
import com.ibm.etools.fm.model.template.Criteriatype;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TypeType;
import com.ibm.etools.fm.model.template.TypeType1;
import org.eclipse.emf.common.util.EList;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;

public class TemplateLabelAccumulator
implements IConfigLabelAccumulator {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final SymbolDataProvider provider;
    public static final String ALLOWED_CCSID = "ALLOWED_CCSID";
    public static final String NOT_ALLOWED_CCSID = "NOT_ALLOWED_CCSID";
    public static final String ALLOWED_RDFC = "ALLOWED_RDFC";
    public static final String NOT_ALLOWED_RDFC = "NOT_ALLOWED_RDFC";
    public static final String HAS_RDFC = "HAS_RDFC";
    private final TemplateLayoutComposite tlc;

    public TemplateLabelAccumulator(SymbolDataProvider provider, TemplateLayoutComposite tlc) {
        this.provider = provider;
        this.tlc = tlc;
    }

    public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
        Symboltype symbol = this.provider.getSymbolValue(rowPosition);
        if (columnPosition == 11) {
            TypeType type = symbol.getType();
            if (type == TypeType.AN || type == TypeType.C || type == TypeType.AX || type == TypeType.VC) {
                configLabels.addLabel(ALLOWED_CCSID);
            } else {
                configLabels.addLabel(NOT_ALLOWED_CCSID);
            }
        } else if (columnPosition == 10) {
            if (this.hasRdfc(symbol) && !configLabels.hasLabel(HAS_RDFC)) {
                configLabels.addLabel(HAS_RDFC);
            }
            if (symbol.isSetAllowrdf() && symbol.isAllowrdf() && !configLabels.hasLabel(ALLOWED_RDFC)) {
                configLabels.addLabel(ALLOWED_RDFC);
            } else {
                configLabels.addLabel(NOT_ALLOWED_RDFC);
            }
        }
        configLabels.addLabel("COLUMN_" + columnPosition);
    }

    private boolean hasRdfc(Symboltype symbol) {
        EList criteria = ((Layouttype)this.tlc.getTemplateType().getLayout().get(this.tlc.getSelectedLayoutIndex())).getCriteria();
        for (Criteriatype c : criteria) {
            if (c.getType() != TypeType1.RDF || c.getFref() != symbol.getRef()) continue;
            return true;
        }
        return false;
    }
}

