/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.nattable;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.template.TemplateLayoutComposite;
import com.ibm.etools.fm.editor.template.dialogs.AbstractCcsidSelectionDialog;
import com.ibm.etools.fm.editor.template.nattable.accumulator.TemplateLabelAccumulator;
import com.ibm.etools.fm.editor.template.nattable.config.FilterRowConfiguration;
import com.ibm.etools.fm.editor.template.nattable.config.TemplateEditorConfiguration;
import com.ibm.etools.fm.editor.template.nattable.config.TemplateStyleConfiguration;
import com.ibm.etools.fm.editor.template.nattable.config.TemplateUiBindingConfiguration;
import com.ibm.etools.fm.editor.template.nattable.provider.ColumnDataProvider;
import com.ibm.etools.fm.editor.template.nattable.provider.SymbolDataProvider;
import com.ibm.etools.fm.jhost.core.version.FMFeature;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.util.TemplateModelUtils;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.version.PDFeature;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.DefaultGlazedListsStaticFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowHeaderComposite;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.reorder.command.RowReorderEndCommand;
import org.eclipse.nebula.widgets.nattable.reorder.command.RowReorderStartCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.InitializeAutoResizeColumnsCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.InitializeAutoResizeRowsCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectCellCommand;
import org.eclipse.nebula.widgets.nattable.util.GCFactory;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NatTableWrapper {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2018, 2020, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private TemplateLayoutComposite tlc;
    private NatTable table;
    private ConfigRegistry registry = new ConfigRegistry();
    private final SymbolDataProvider dataProvider;
    private final ColumnDataProvider headerProvider;
    private String[] ccsIds = null;
    private boolean canUpdateSymbols;
    private boolean allowCcsId;
    private int layoutSelectionIndex;
    private TemplateEditorConfiguration templateEditorConfiguration;
    private int fromPosition;
    private int toPosition;
    final DataLayer bodyDataLayer;
    private BodyLayerStack<Symboltype> bodyLayerStack;

    public NatTableWrapper(TemplateLayoutComposite tlc, Composite parent) {
        this.tlc = tlc;
        this.canUpdateSymbols = "DYNAMIC".equals(tlc.getTemplateType().getType());
        this.allowCcsId = tlc.getTemplateResource().getSystem().supports((PDFeature)FMFeature.TEMPLATE_FIELD_CCSID);
        this.layoutSelectionIndex = tlc.getSelectedLayoutIndex();
        if (this.layoutSelectionIndex < 0) {
            this.layoutSelectionIndex = 0;
        }
        this.dataProvider = new SymbolDataProvider(tlc, this.allowCcsId);
        this.bodyDataLayer = new DataLayer((IDataProvider)this.dataProvider);
        this.headerProvider = new ColumnDataProvider(this.allowCcsId);
        final List<String> colNames = Arrays.asList(ColumnDataProvider.COLUMN_NAMES);
        IColumnPropertyAccessor<Symboltype> columnPropertyAccessor = new IColumnPropertyAccessor<Symboltype>(){

            public int getColumnCount() {
                return colNames.size();
            }

            public Object getDataValue(Symboltype rowObject, int columnIndex) {
                return NatTableWrapper.this.dataProvider.getDataValue(columnIndex, NatTableWrapper.this.dataProvider.getIndexOf(rowObject));
            }

            public void setDataValue(Symboltype rowObject, int columnIndex, Object newValue) {
                NatTableWrapper.this.dataProvider.setDataValue(columnIndex, NatTableWrapper.this.dataProvider.getIndexOf(rowObject), newValue);
            }

            public int getColumnIndex(String propertyName) {
                return colNames.indexOf(propertyName);
            }

            public String getColumnProperty(int columnIndex) {
                return null;
            }
        };
        ArrayList<Symboltype> values = new ArrayList<Symboltype>();
        int i = 0;
        while (i < this.dataProvider.getRowCount()) {
            values.add(this.dataProvider.getSymbolValue(i));
            ++i;
        }
        TemplateLabelAccumulator templateLabelAccumulator = new TemplateLabelAccumulator(this.dataProvider, tlc);
        this.bodyLayerStack = new BodyLayerStack(values, columnPropertyAccessor, templateLabelAccumulator);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)this.headerProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, this.bodyLayerStack, this.bodyLayerStack.getSelectionLayer());
        DefaultGlazedListsStaticFilterStrategy filterStrategy = new DefaultGlazedListsStaticFilterStrategy(this.bodyLayerStack.getFilterList(), (IColumnAccessor)columnPropertyAccessor, (IConfigRegistry)this.registry);
        FilterRowHeaderComposite filterRowHeaderLayer = new FilterRowHeaderComposite((IFilterStrategy)filterStrategy, (ILayer)columnHeaderLayer, columnHeaderDataLayer.getDataProvider(), (IConfigRegistry)this.registry);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(this.bodyLayerStack.getBodyDataProvider());
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, this.bodyLayerStack, this.bodyLayerStack.getSelectionLayer());
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)this.headerProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)filterRowHeaderLayer);
        GridLayer gridLayer = new GridLayer(this.bodyLayerStack, (ILayer)filterRowHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        this.table = new NatTable(parent, (ILayer)gridLayer, false);
        this.configureTable((DefaultGlazedListsStaticFilterStrategy<Symboltype>)filterStrategy);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.table);
        this.resizeTableOnLoad(parent);
    }

    private void configureTable(DefaultGlazedListsStaticFilterStrategy<Symboltype> filterStrategy) {
        this.table.setConfigRegistry((IConfigRegistry)this.registry);
        this.table.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        this.table.addConfiguration((IConfiguration)new TemplateStyleConfiguration());
        if (this.allowCcsId) {
            this.ccsIds = this.fetchCcsIds();
        }
        this.attachDragReordering();
        this.templateEditorConfiguration = new TemplateEditorConfiguration(this, this.canUpdateSymbols, this.allowCcsId, this.ccsIds);
        this.table.addConfiguration((IConfiguration)this.templateEditorConfiguration);
        this.table.addConfiguration((IConfiguration)new TemplateUiBindingConfiguration(this));
        this.table.addConfiguration((IConfiguration)new FilterRowConfiguration());
        this.dataProvider.setCcsIds(this.ccsIds);
        this.table.setBackground(new Color((Device)Display.getDefault(), 255, 255, 255));
        this.table.configure();
        new DefaultToolTip((Control)this.table, 2, false){

            protected Object getToolTipArea(Event event) {
                int x = NatTableWrapper.this.table.getColumnPositionByX(event.x);
                int y = NatTableWrapper.this.table.getRowPositionByY(event.y);
                return new Point(x, y);
            }

            protected String getText(Event event) {
                int y;
                int x = NatTableWrapper.this.table.getColumnPositionByX(event.x);
                ILayerCell cell = NatTableWrapper.this.table.getCellByPosition(x, y = NatTableWrapper.this.table.getRowPositionByY(event.y));
                if (cell == null) {
                    return null;
                }
                int col = cell.getColumnIndex();
                String tooltip = null;
                switch (col) {
                    case 1: {
                        tooltip = Messages.NatTableWrapperHoldTooltip;
                        break;
                    }
                    case 2: {
                        tooltip = Messages.NatTableWrapperSelectedTooltip;
                        break;
                    }
                }
                return tooltip;
            }

            protected boolean shouldCreateToolTip(Event event) {
                if (this.getText(event) != null) {
                    return super.shouldCreateToolTip(event);
                }
                return false;
            }
        };
    }

    private void attachDragReordering() {
        if (this.canUpdateSymbols) {
            this.bodyDataLayer.registerCommandHandler((ILayerCommandHandler)new ILayerCommandHandler<RowReorderStartCommand>(){

                public Class<RowReorderStartCommand> getCommandClass() {
                    return RowReorderStartCommand.class;
                }

                public boolean doCommand(ILayer targetLayer, RowReorderStartCommand command) {
                    NatTableWrapper.this.fromPosition = command.getFromRowPosition() - 1;
                    return true;
                }
            });
            this.bodyDataLayer.registerCommandHandler((ILayerCommandHandler)new ILayerCommandHandler<RowReorderEndCommand>(){

                public Class<RowReorderEndCommand> getCommandClass() {
                    return RowReorderEndCommand.class;
                }

                public boolean doCommand(ILayer targetLayer, RowReorderEndCommand command) {
                    NatTableWrapper.this.toPosition = command.getToRowPosition() - 1;
                    TemplateLayoutComposite tlc = NatTableWrapper.this.getTemplateLayoutComposite();
                    if (tlc != null) {
                        Symboltype fromSymbol = (Symboltype)((Layouttype)tlc.getTemplateType().getLayout().get(tlc.getSelectedLayoutIndex())).getSymbol().get(NatTableWrapper.this.fromPosition);
                        if (NatTableWrapper.this.fromPosition > NatTableWrapper.this.toPosition) {
                            int i = 0;
                            while (i < NatTableWrapper.this.fromPosition - NatTableWrapper.this.toPosition) {
                                TemplateModelUtils.moveDynamicFieldUp((Layouttype)((Layouttype)tlc.getTemplateType().getLayout().get(tlc.getSelectedLayoutIndex())), (Symboltype)fromSymbol, (IPDHost)tlc.getSession().getSystem());
                                ++i;
                            }
                        } else if (NatTableWrapper.this.toPosition > NatTableWrapper.this.fromPosition) {
                            int i = 0;
                            while (i < NatTableWrapper.this.toPosition - NatTableWrapper.this.fromPosition) {
                                TemplateModelUtils.moveDynamicFieldDown((Layouttype)((Layouttype)tlc.getTemplateType().getLayout().get(tlc.getSelectedLayoutIndex())), (Symboltype)fromSymbol, (IPDHost)tlc.getSession().getSystem());
                                ++i;
                            }
                        }
                        NatTableWrapper.this.getTemplateLayoutComposite().getEditor().setEditorDirty();
                        NatTableWrapper.this.getTemplateLayoutComposite().setSymbolsUpdated();
                        NatTableWrapper.this.getTemplateLayoutComposite().synchSymbolsWithHost();
                    }
                    return true;
                }
            });
        }
    }

    private void resizeTableOnLoad(final Composite parent) {
        this.table.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                int i = 0;
                while (i < NatTableWrapper.this.table.getColumnCount()) {
                    InitializeAutoResizeColumnsCommand columnCommand = new InitializeAutoResizeColumnsCommand((ILayer)NatTableWrapper.this.table, i, NatTableWrapper.this.table.getConfigRegistry(), new GCFactory((Drawable)NatTableWrapper.this.table));
                    NatTableWrapper.this.table.doCommand((ILayerCommand)columnCommand);
                    ++i;
                }
                i = 0;
                while (i < NatTableWrapper.this.table.getRowCount()) {
                    InitializeAutoResizeRowsCommand rowCommand = new InitializeAutoResizeRowsCommand((ILayer)NatTableWrapper.this.table, i, NatTableWrapper.this.table.getConfigRegistry(), new GCFactory((Drawable)NatTableWrapper.this.table));
                    NatTableWrapper.this.table.doCommand((ILayerCommand)rowCommand);
                    ++i;
                }
                NatTableWrapper.this.table.removeListener(9, (Listener)this);
                Composite p1 = parent.getParent();
                Monitor primary = p1.getMonitor();
                NatTableWrapper.this.table.layout(true, true);
                while (p1 != null && !(p1 instanceof CTabFolder)) {
                    p1.layout(true, true);
                    if (p1 instanceof Shell) {
                        Shell shell = (Shell)p1;
                        shell.layout(true, true);
                        Rectangle bounds = primary.getBounds();
                        Rectangle rect = shell.getBounds();
                        Point newSize = shell.computeSize(NatTableWrapper.this.table.getPreferredWidth(), -1, true);
                        newSize.x = NatTableWrapper.this.table.getPreferredWidth() + 100;
                        newSize.y += NatTableWrapper.this.table.getPreferredHeight() - NatTableWrapper.this.table.getHeight();
                        if (newSize.y > bounds.height - 20) {
                            newSize.y = bounds.height - 20;
                        }
                        shell.setSize(newSize);
                        rect = shell.getBounds();
                        int x = bounds.x + (bounds.width - rect.width) / 2;
                        int y = bounds.y + (bounds.height - rect.height) / 2;
                        shell.setLocation(x, y);
                        break;
                    }
                    p1 = p1.getParent();
                }
            }
        });
    }

    public String[] fetchCcsIds() {
        final Result overallResult = new Result();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.AbstractCcsidSelectionDialog_0, 2);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    monitor.worked(1);
                    Result result = NatTableWrapper.this.tlc.getSession().retrieveSupportedCcsids(howIsGoing);
                    overallResult.copy(result);
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e1) {
            PDDialogs.openErrorThreadSafe((String)Messages.AbstractCcsidSelectionDialog_1, (Throwable)e1);
            return null;
        }
        catch (InterruptedException e1) {
            PDDialogs.openInfoThreadSafe((String)Messages.AbstractCcsidSelectionDialog_2);
            return null;
        }
        if (overallResult.isSuccessfulWithoutWarnings()) {
            StringBuffer output = (StringBuffer)overallResult.getOutput();
            if (output != null) {
                return AbstractCcsidSelectionDialog.parseCcsids(output.toString());
            }
        } else {
            PDDialogs.openErrorThreadSafe((String)Messages.Error, (String)Messages.AbstractCcsidSelectionDialog_3, (String)overallResult.dumpOutputAndMessages(true));
        }
        return null;
    }

    public void setFocus() {
        this.table.setFocus();
    }

    public void setLayoutIndex(int selectionIndex) {
        this.layoutSelectionIndex = selectionIndex;
        if (selectionIndex >= 0) {
            this.updateBody();
        }
    }

    public int getLayoutIndex() {
        return this.layoutSelectionIndex;
    }

    public NatTable getNatTable() {
        return this.table;
    }

    public TemplateLayoutComposite getTemplateLayoutComposite() {
        return this.tlc;
    }

    public void setSelectionIndex(int rowSelectionIndex) {
        SelectCellCommand cmd = new SelectCellCommand((ILayer)this.table, 0, rowSelectionIndex, false, false);
        this.table.doCommand((ILayerCommand)cmd);
    }

    public void updateBody() {
        this.bodyLayerStack.updateList((List<Symboltype>)((Layouttype)this.tlc.getTemplateType().getLayout().get(this.tlc.getSelectedLayoutIndex())).getSymbol());
        this.table.refresh(true);
    }

    public TemplateEditorConfiguration getTemplateEditorConfiguration() {
        return this.templateEditorConfiguration;
    }

    public void dispose() {
        this.table.dispose();
        this.table = null;
        this.registry = null;
        this.tlc = null;
        this.templateEditorConfiguration = null;
    }

    class BodyLayerStack<T>
    extends AbstractLayerTransform {
        private final FilterList<Symboltype> filterList;
        private final IDataProvider bodyDataProvider;
        private final SelectionLayer selectionLayer;
        private TransformedList<Symboltype, Symboltype> rowObjectsGlazedList = null;

        public BodyLayerStack(List<Symboltype> values, IColumnPropertyAccessor<Symboltype> columnPropertyAccessor, TemplateLabelAccumulator templateLabelAccumulator) {
            EventList eventList = GlazedLists.eventList(values);
            this.rowObjectsGlazedList = GlazedLists.threadSafeList((EventList)eventList);
            SortedList sortedList = new SortedList(this.rowObjectsGlazedList, null);
            this.filterList = new FilterList((EventList)sortedList);
            this.bodyDataProvider = new ListDataProvider(this.filterList, columnPropertyAccessor);
            DataLayer bodyDataLayer = new DataLayer(this.getBodyDataProvider());
            bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)templateLabelAccumulator);
            GlazedListsEventLayer glazedListsEventLayer = new GlazedListsEventLayer((IUniqueIndexLayer)bodyDataLayer, this.filterList);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)glazedListsEventLayer);
            ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.getSelectionLayer());
            this.setUnderlyingLayer((ILayer)viewportLayer);
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }

        public FilterList<Symboltype> getFilterList() {
            return this.filterList;
        }

        public IDataProvider getBodyDataProvider() {
            return this.bodyDataProvider;
        }

        public void updateList(List<Symboltype> updatedValues) {
            this.rowObjectsGlazedList.clear();
            updatedValues.size();
            int i = 0;
            while (i < updatedValues.size()) {
                this.rowObjectsGlazedList.add((Object)updatedValues.get(i));
                ++i;
            }
        }
    }
}

