/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionTemplate;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.editor.formatted.EditorActionManager;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.template.TemplateEditor;
import com.ibm.etools.fm.editor.template.TemplateEditorUtilities;
import com.ibm.etools.fm.editor.template.TemplateLayoutComposite;
import com.ibm.etools.fm.editor.template.dialogs.FieldAttributeDialog;
import com.ibm.etools.fm.editor.template.dialogs.FieldSelectionDialog;
import com.ibm.etools.fm.editor.template.dialogs.LayoutSelectionDialog;
import com.ibm.etools.fm.editor.template1.StringArrayElementTableLabelProvider;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.MemberPresence;
import com.ibm.etools.fm.ui.dialog.TemplateResourceSaveAsDialog;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.util.ZrlLoaderDialogUtils;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class TemplateMappingDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int TABLE_COLUMN_COUNT = 6;
    private static final int INDEX_REF_COLUMN = 0;
    private static final int INDEX_LEVEL_COLUMN = 1;
    private static final int INDEX_FIELD_COLUMN = 2;
    private static final int INDEX_TYPE_COLUMN = 3;
    private static final int INDEX_START_COLUMN = 4;
    private static final int INDEX_LEN_COLUMN = 5;
    private static final int INDEX_DB2_REF_COLUMN = 0;
    private static final int INDEX_DB2_COLUMN_NAME_COLUMN = 1;
    private static final int INDEX_DB2_DATA_TYPE_COLUMN = 2;
    private static final int INDEX_DB2_EMPTY1_COLUMN = 3;
    private static final int INDEX_DB2_EMPTY2_COLUMN = 4;
    private static final int INDEX_DB2_EMPTY3_COLUMN = 5;
    private IZRL fromTemplateResource;
    private TemplateType fromTemplate;
    private IZRL toTemplateResource;
    private TemplateType toTemplate;
    private AbstractSessionTemplate session;
    private Combo toTemplateNameCombo;
    private Combo toTemplateLayoutCombo;
    private Text toTemplateSearchText;
    private Table toMappingTable;
    private TableViewer toMappingTableViewer;
    private TableViewerColumn[] toTableColumns;
    private ScrollBar toTableScrollBar;
    private Button toTemplateLookupButton;
    private Combo fromTemplateNameCombo;
    private Text fromTemplateLayoutText;
    private Text fromTemplateSearchText;
    private Table fromMappingTable;
    private TableViewer fromMappingTableViewer;
    private TableViewerColumn[] fromTableColumns;
    private ScrollBar fromTableScrollBar;
    private Button fromTemplateLookupButton;
    private Button fromTemplateLayoutSelectButton;
    private Layouttype fromSelectedLayout;
    private Button mapButton;
    private Button unmapButton;
    private Button attributeButton;
    private Button loadTemplateButton;
    private Button generateMappingButton;
    private Button saveButton;
    private Button saveAsButton;
    private boolean isDirty = false;
    private IDoubleClickListener mappingTableListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            TemplateMappingDialog.this.mapFields();
        }
    };
    private static String[] EMPTY_INFO = new String[6];

    static {
        int i = 0;
        while (i < 6) {
            TemplateMappingDialog.EMPTY_INFO[i] = "";
            ++i;
        }
    }

    public TemplateMappingDialog(IZRL fromTemplateResource, IZRL toTemplateResource) {
        this.fromTemplateResource = fromTemplateResource;
        this.fromTemplate = null;
        this.toTemplateResource = toTemplateResource;
        this.toTemplate = null;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.TM_dialog_title);
        this.setMessage(Messages.TemplateMappingDialog_TM_DIALOG_MESSAGE);
        Composite buttonsComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.left1());
        this.createButtonsComposite(buttonsComposite);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group toGroup = GUI.group((Composite)composite, (String)Messages.TM_TO_TEMPLATE_GROUP, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.createMappingButtonsComposite(composite);
        Group fromGroup = GUI.group((Composite)composite, (String)Messages.TM_FROM_TEMPLATE_GROUP, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.createTemplateInfoComposite(toGroup, fromGroup);
        this.createMappingTableComposite(toGroup, fromGroup);
        if (this.toTemplateResource != null && this.fromTemplateResource == null) {
            this.fromTemplateResource = this.toTemplateResource;
        }
        if (this.toTemplateResource == null && this.fromTemplateResource != null) {
            this.toTemplateResource = this.fromTemplateResource;
        }
        this.clearMappingInformation();
        if (this.toTemplateResource != null) {
            this.toTemplateNameCombo.setText(this.toTemplateResource.getFormattedName());
        }
        if (this.fromTemplateResource != null) {
            this.fromTemplateNameCombo.setText(this.fromTemplateResource.getFormattedName());
        }
        this.setComplete(false);
        return composite;
    }

    private void createTemplateInfoComposite(Group toGroup, Group fromGroup) {
        Composite toComposite = GUI.composite((Composite)toGroup, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)toComposite, (String)Messages.TM_TEMPLATE, (Object)GUI.grid.d.left1(), (int)16384);
        this.toTemplateNameCombo = GUI.combo.editable((Composite)toComposite, (Object)GUI.grid.d.fillH((int)1));
        this.toTemplateLookupButton = LookupButton.createLookupTemplateButtonLeft1(toComposite);
        LookupDialogFactory.defaults(this.toTemplateLookupButton, this.toTemplateNameCombo, (IHostProvider)this.toTemplateResource).types(FMHost.getPermittedTemplateResourceType((IPDHost)this.toTemplateResource.getSystem())).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                TemplateMappingDialog.this.setErrorMessage(null);
                TemplateMappingDialog.this.clearMappingInformation();
                TemplateMappingDialog.this.toTemplateResource = zrl;
                TemplateMappingDialog.this.toTemplate = null;
                if (TemplateMappingDialog.this.fromTemplateResource == null) {
                    TemplateMappingDialog.this.fromTemplateResource = TemplateMappingDialog.this.toTemplateResource;
                    TemplateMappingDialog.this.fromTemplateNameCombo.setText(TemplateMappingDialog.this.fromTemplateResource.getFormattedName());
                    TemplateMappingDialog.this.fromTemplate = null;
                }
            }
        }).addResourceContentProposals(TemplateMappingDialog.class.getName() + "toTemplate").create();
        this.toTemplateNameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TemplateMappingDialog.this.toTemplateNameCombo.isEnabled();
            }
        });
        GUI.label((Composite)toComposite, (String)Messages.TM_LAYOUT, (Object)GUI.grid.d.left1(), (int)16384);
        this.toTemplateLayoutCombo = GUI.combo.readOnly((Composite)toComposite, (Object)GUI.grid.d.fillH((int)1), (Object[])new String[0]);
        this.toTemplateLayoutCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TemplateMappingDialog.this.setErrorMessage(null);
                TemplateMappingDialog.this.populateMappingInformation(TemplateMappingDialog.this.toTemplateLayoutCombo.getSelectionIndex());
            }
        });
        GUI.button.push((Composite)toComposite, (String)"", (Object)GUI.grid.d.left1()).setVisible(false);
        GUI.label((Composite)toComposite, (String)Messages.Locate, (Object)GUI.grid.d.left1(), (int)16384);
        this.toTemplateSearchText = GUI.text.field((Composite)toComposite, (Object)GUI.grid.d.fillH((int)1));
        this.toTemplateSearchText.setMessage(Messages.Locate_Tooltip);
        this.toTemplateSearchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TemplateMappingDialog.this.toMappingTableViewer.setFilters(new ViewerFilter[]{TemplateEditorUtilities.createLocateFilter(TemplateMappingDialog.this.toTemplateSearchText.getText())});
            }
        });
        Composite fromComposite = GUI.composite((Composite)fromGroup, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)fromComposite, (String)Messages.TM_TEMPLATE, (Object)GUI.grid.d.left1(), (int)16384);
        this.fromTemplateNameCombo = GUI.combo.editable((Composite)fromComposite, (Object)GUI.grid.d.fillH((int)1));
        this.fromTemplateLookupButton = LookupButton.createLookupTemplateButtonLeft1(fromComposite);
        LookupDialogFactory.defaults(this.fromTemplateLookupButton, this.fromTemplateNameCombo, (IHostProvider)this.toTemplateResource).types(FMHost.getPermittedTemplateResourceType((IPDHost)this.toTemplateResource.getSystem())).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                TemplateMappingDialog.this.setErrorMessage(null);
                TemplateMappingDialog.this.clearMappingInformation();
                TemplateMappingDialog.this.fromTemplateResource = zrl;
                TemplateMappingDialog.this.fromTemplate = null;
                if (TemplateMappingDialog.this.toTemplateResource == null) {
                    TemplateMappingDialog.this.toTemplateResource = TemplateMappingDialog.this.fromTemplateResource;
                    TemplateMappingDialog.this.toTemplateNameCombo.setText(TemplateMappingDialog.this.toTemplateResource.getFormattedName());
                    TemplateMappingDialog.this.toTemplate = null;
                }
            }
        }).addResourceContentProposals(TemplateMappingDialog.class.getName() + "fromTemplate").create();
        this.fromTemplateNameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        GUI.label((Composite)fromComposite, (String)Messages.TM_LAYOUT, (Object)GUI.grid.d.left1(), (int)16384);
        this.fromTemplateLayoutText = GUI.text.fieldReadOnly((Composite)fromComposite, (Object)GUI.grid.d.fillH((int)1));
        this.fromTemplateLayoutSelectButton = GUI.button.push((Composite)fromComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/duplicate.gif"), (String)Messages.TM_SELECT_LAYOUT_TIP, (Object)GUI.grid.d.left1());
        this.fromTemplateLayoutSelectButton.setEnabled(false);
        this.fromTemplateLayoutSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TemplateMappingDialog.this.setErrorMessage(null);
                if (TemplateMappingDialog.this.toTemplateResource == null || TemplateMappingDialog.this.fromTemplateResource == null) {
                    TemplateMappingDialog.this.setErrorMessage(Messages.TM_LAYOUT_SEL_DIALOG_NO_TEMPLATE);
                    return;
                }
                if (TemplateMappingDialog.this.toTemplate == null || TemplateMappingDialog.this.fromTemplate == null) {
                    TemplateMappingDialog.this.setErrorMessage(Messages.TM_LAYOUT_SEL_DIALOG_NO_TEMPLATE_LOADED);
                    return;
                }
                LayoutSelectionDialog dialog = new LayoutSelectionDialog(TemplateMappingDialog.this.fromTemplateResource, (List<Layouttype>)TemplateMappingDialog.this.fromTemplate.getLayout(), -1);
                if (dialog.open() != 0) {
                    return;
                }
                int selectedLayoutIndex = dialog.getSelectedLayoutIndex();
                if (!TemplateMappingDialog.this.confirmLayoutMatchChange(selectedLayoutIndex)) {
                    return;
                }
                TemplateMappingDialog.this.setDirty(true);
                TemplateMappingDialog.this.fromSelectedLayout = (Layouttype)TemplateMappingDialog.this.fromTemplate.getLayout().get(selectedLayoutIndex);
                TemplateMappingDialog.this.fromTemplateLayoutText.setText(((Symboltype)TemplateMappingDialog.this.fromSelectedLayout.getSymbol().get(0)).getName(TemplateMappingDialog.this.toTemplateResource.getSystem()));
                Layouttype toLayout = (Layouttype)TemplateMappingDialog.this.toTemplate.getLayout().get(TemplateMappingDialog.this.toTemplateLayoutCombo.getSelectionIndex());
                ((Symboltype)toLayout.getSymbol().get(0)).setFrom(((Symboltype)TemplateMappingDialog.this.fromSelectedLayout.getSymbol().get(0)).getRef());
                TemplateMappingDialog.this.populateMappingInformation(TemplateMappingDialog.this.toTemplateLayoutCombo.getSelectionIndex());
            }
        });
        GUI.label((Composite)fromComposite, (String)Messages.Locate, (Object)GUI.grid.d.left1(), (int)16384);
        this.fromTemplateSearchText = GUI.text.field((Composite)fromComposite, (Object)GUI.grid.d.fillH((int)1));
        this.fromTemplateSearchText.setMessage(Messages.Locate_Tooltip);
        this.fromTemplateSearchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TemplateMappingDialog.this.fromMappingTableViewer.setFilters(new ViewerFilter[]{TemplateEditorUtilities.createLocateFilter(TemplateMappingDialog.this.fromTemplateSearchText.getText())});
            }
        });
    }

    private boolean confirmLayoutMatchChange(int proposedFromTemplateIndex) {
        Symboltype aSymbol;
        boolean mapExist = false;
        Layouttype toLayout = (Layouttype)this.toTemplate.getLayout().get(this.toTemplateLayoutCombo.getSelectionIndex());
        int i = 0;
        while (i < toLayout.getSymbol().size()) {
            int fromLayoutIndex;
            aSymbol = (Symboltype)toLayout.getSymbol().get(i);
            if (aSymbol.isSetFrom() && aSymbol.getFrom() > 0 && (fromLayoutIndex = this.getLayoutIDOfFromTemplate(aSymbol.getFrom())) != proposedFromTemplateIndex) {
                mapExist = true;
                break;
            }
            ++i;
        }
        if (mapExist) {
            if (PDDialogs.openConfirm((String)Messages.Confirm, (String)Messages.TM_LAYOUT_SEL_DIALOG_other_mapping_exit)) {
                i = 0;
                while (i < toLayout.getSymbol().size()) {
                    aSymbol = (Symboltype)toLayout.getSymbol().get(i);
                    aSymbol.setFrom(0);
                    ++i;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private void createMappingTableComposite(Group toGroup, Group fromGroup) {
        this.toMappingTable = new Table((Composite)toGroup, 68354);
        this.toMappingTable.setHeaderVisible(true);
        this.toMappingTable.setLinesVisible(true);
        this.toMappingTable.setLayoutData((Object)GUI.grid.d.fillAll());
        this.toMappingTableViewer = new TableViewer(this.toMappingTable);
        this.toMappingTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.toMappingTableViewer.addDoubleClickListener(this.mappingTableListener);
        this.addMappingTableContentMenu(this.toMappingTableViewer);
        this.toTableColumns = new TableViewerColumn[6];
        TemplateMappingDialog.createMappingTableColumns(this.toMappingTableViewer, this.toTableColumns);
        this.toTableScrollBar = this.toMappingTable.getVerticalBar();
        this.fromMappingTable = new Table((Composite)fromGroup, 68354);
        this.fromMappingTable.setHeaderVisible(true);
        this.fromMappingTable.setLinesVisible(true);
        this.fromMappingTable.setLayoutData((Object)GUI.grid.d.fillAll());
        this.fromMappingTableViewer = new TableViewer(this.fromMappingTable);
        this.fromMappingTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fromMappingTableViewer.addDoubleClickListener(this.mappingTableListener);
        this.fromTableColumns = new TableViewerColumn[6];
        TemplateMappingDialog.createMappingTableColumns(this.fromMappingTableViewer, this.fromTableColumns);
        this.fromTableScrollBar = this.fromMappingTable.getVerticalBar();
    }

    private void addMappingTableContentMenu(TableViewer viewer) {
        EditorActionManager manager = new EditorActionManager();
        final MenuManager popupMenu = manager.getPopupMenu();
        popupMenu.setRemoveAllWhenShown(true);
        final Action addMapping = new Action(Messages.TemplateMappingDialog_1){

            public void run() {
                TemplateMappingDialog.this.mapFields();
            }
        };
        addMapping.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.mapButton.getImage()));
        final Action deleteMapping = new Action(Messages.TemplateMappingDialog_2){

            public void run() {
                TemplateMappingDialog.this.unmapFields();
            }
        };
        deleteMapping.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.unmapButton.getImage()));
        final Action editAttributes = new Action(Messages.TemplateMappingDialog_3){

            public void run() {
                TemplateMappingDialog.this.editAttributes();
            }
        };
        editAttributes.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.attributeButton.getImage()));
        Menu menu = popupMenu.createContextMenu((Control)viewer.getTable());
        popupMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)TemplateMappingDialog.this.toMappingTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    popupMenu.add((IAction)addMapping);
                    popupMenu.add((IAction)deleteMapping);
                    popupMenu.add((IAction)editAttributes);
                }
            }
        });
        viewer.getTable().setMenu(menu);
    }

    private void keepTableSelectionInSynch() {
        this.toMappingTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TemplateMappingDialog.this.setErrorMessage(null);
                TemplateMappingDialog.this.fromMappingTable.setSelection(TemplateMappingDialog.this.toMappingTable.getSelectionIndex());
            }
        });
        this.fromMappingTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TemplateMappingDialog.this.setErrorMessage(null);
                TemplateMappingDialog.this.toMappingTable.setSelection(TemplateMappingDialog.this.fromMappingTable.getSelectionIndex());
            }
        });
        this.toTableScrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TemplateMappingDialog.this.setErrorMessage(null);
                TemplateMappingDialog.this.fromTableScrollBar.setSelection(TemplateMappingDialog.this.toTableScrollBar.getSelection());
                int topIndex = TemplateMappingDialog.this.toMappingTable.getTopIndex();
                TemplateMappingDialog.this.toMappingTable.setSelection(topIndex);
                TemplateMappingDialog.this.fromMappingTable.setSelection(topIndex);
                TemplateMappingDialog.this.fromMappingTable.setTopIndex(topIndex);
                TemplateMappingDialog.this.toMappingTable.setTopIndex(topIndex);
            }
        });
        this.fromTableScrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TemplateMappingDialog.this.setErrorMessage(null);
                TemplateMappingDialog.this.toTableScrollBar.setSelection(TemplateMappingDialog.this.fromTableScrollBar.getSelection());
                int topIndex = TemplateMappingDialog.this.fromMappingTable.getTopIndex();
                TemplateMappingDialog.this.toMappingTable.setSelection(topIndex);
                TemplateMappingDialog.this.fromMappingTable.setSelection(topIndex);
                TemplateMappingDialog.this.toMappingTable.setTopIndex(topIndex);
                TemplateMappingDialog.this.fromMappingTable.setTopIndex(topIndex);
            }
        });
    }

    private static void createMappingTableColumns(TableViewer viewer, TableViewerColumn[] columns) {
        columns[0] = FormattedEditorUtility.createTableViewerColumn("", 60, viewer, 131072);
        columns[1] = FormattedEditorUtility.createTableViewerColumn("", 60, viewer, 131072);
        columns[2] = FormattedEditorUtility.createTableViewerColumn("", 150, viewer, 16384);
        columns[3] = FormattedEditorUtility.createTableViewerColumn("", 60, viewer, 16384);
        columns[4] = FormattedEditorUtility.createTableViewerColumn("", 60, viewer, 131072);
        columns[5] = FormattedEditorUtility.createTableViewerColumn("", 60, viewer, 131072);
        viewer.setLabelProvider((IBaseLabelProvider)new StringArrayElementTableLabelProvider());
    }

    private static void adjustColumnHeader(TableViewerColumn[] columns, String type) {
        if ("BASE".equals(type) || "DYNAMIC".equals(type)) {
            TemplateMappingDialog.adjustColumnHeaderBase(columns);
        } else if ("DB2".equals(type)) {
            TemplateMappingDialog.adjustColumnHeaderDB2(columns);
        } else {
            logger.error((Object)("Unknown template type: " + type));
            TemplateMappingDialog.adjustColumnHeaderBase(columns);
        }
    }

    private static void adjustColumnHeaderBase(TableViewerColumn[] columns) {
        TemplateMappingDialog.adjustColumn(columns, 0, 60, 16384, Messages.TM_REF_COLUMN);
        TemplateMappingDialog.adjustColumn(columns, 1, 60, 16384, Messages.TM_LEVEL_COLUMN);
        TemplateMappingDialog.adjustColumn(columns, 2, 150, 131072, Messages.TM_FIELD_COLUMN);
        TemplateMappingDialog.adjustColumn(columns, 3, 60, 131072, Messages.TM_TYPE_COLUMN);
        TemplateMappingDialog.adjustColumn(columns, 4, 60, 16384, Messages.TM_START_COLUMN);
        TemplateMappingDialog.adjustColumn(columns, 5, 60, 16384, Messages.TM_LEN_COLUMN);
    }

    private static void adjustColumnHeaderDB2(TableViewerColumn[] columns) {
        TemplateMappingDialog.adjustColumn(columns, 0, 50, 131072, Messages.TE_COLUMN_NUMBER);
        TemplateMappingDialog.adjustColumn(columns, 1, 150, 16384, Messages.TE_COLUMN_NAME);
        TemplateMappingDialog.adjustColumn(columns, 2, 250, 16384, Messages.TE_DATA_TYPE);
        TemplateMappingDialog.adjustColumn(columns, 3, 0, 131072, "");
        TemplateMappingDialog.adjustColumn(columns, 4, 0, 131072, "");
        TemplateMappingDialog.adjustColumn(columns, 5, 0, 131072, "");
    }

    private static void adjustColumn(TableViewerColumn[] columns, int index, int width, int alignment, String text2) {
        columns[index].getColumn().setWidth(width);
        columns[index].getColumn().setAlignment(alignment);
        columns[index].getColumn().setText(text2);
    }

    private void createButtonsComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)4, (boolean)true), (Object)GUI.grid.d.fillH((int)2));
        this.loadTemplateButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/load_mapping.gif"), (String)Messages.TM_LOAD_TEMPLATE_TIP, (Object)GUI.grid.d.left1());
        this.loadTemplateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TemplateMappingDialog.this.setDirty(false);
                TemplateMappingDialog.this.setErrorMessage(null);
                if (!ZRLs.isParseable((IPDHost)TemplateMappingDialog.this.toTemplateResource.getSystem(), (String)TemplateMappingDialog.this.fromTemplateNameCombo.getText().trim())) {
                    TemplateMappingDialog.this.setErrorMessage(Messages.TM_InvalidFromTemplateName);
                    TemplateMappingDialog.this.fromTemplateNameCombo.setFocus();
                    return;
                }
                TemplateMappingDialog.this.fromTemplateResource = ZRLs.parseZRL((IPDHost)TemplateMappingDialog.this.toTemplateResource.getSystem(), (String)TemplateMappingDialog.this.fromTemplateNameCombo.getText().trim());
                if (!ZRLs.isParseable((IPDHost)TemplateMappingDialog.this.toTemplateResource.getSystem(), (String)TemplateMappingDialog.this.toTemplateNameCombo.getText())) {
                    TemplateMappingDialog.this.setErrorMessage(Messages.TM_InvalidToTemplateName);
                    TemplateMappingDialog.this.toTemplateNameCombo.setFocus();
                    return;
                }
                TemplateMappingDialog.this.toTemplateResource = ZRLs.parseZRL((IPDHost)TemplateMappingDialog.this.toTemplateResource.getSystem(), (String)TemplateMappingDialog.this.toTemplateNameCombo.getText().trim());
                if (!TemplateMappingDialog.this.validateTemplateName(TemplateMappingDialog.this.toTemplateResource)) {
                    return;
                }
                if (!TemplateMappingDialog.this.toTemplateResource.getFormattedName().equals(TemplateMappingDialog.this.fromTemplateResource.getFormattedName()) && !TemplateMappingDialog.this.validateTemplateName(TemplateMappingDialog.this.fromTemplateResource)) {
                    return;
                }
                TemplateMappingDialog.this.session = AbstractSessionTemplate.createTemplateEditSession((IZRL)TemplateMappingDialog.this.fromTemplateResource, (IZRL)TemplateMappingDialog.this.toTemplateResource);
                if (TemplateMappingDialog.this.session == null) {
                    return;
                }
                try {
                    Result<StringBuffer> result1 = TemplateMappingDialog.this.startMappingSession(false);
                    if (!result1.isSuccessfulWithoutWarnings()) {
                        TemplateMappingDialog.this.session.unlock();
                        if (!PDDialogs.openQuestion((String)Messages.Error, (String)MessageFormat.format(Messages.TM_Template_mapping_start_error_no_overwrite, TemplateMappingDialog.this.toTemplateResource.getFormattedName(), TemplateMappingDialog.this.fromTemplateResource.getFormattedName()), (String)result1.dumpOutputAndMessages(true))) {
                            TemplateMappingDialog.this.reInitialiseDialog();
                            return;
                        }
                        Result<StringBuffer> result2 = TemplateMappingDialog.this.startMappingSession(true);
                        if (!result2.isSuccessfulWithoutWarnings()) {
                            TemplateMappingDialog.this.session.unlock();
                            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.TM_Template_mapping_start_error, TemplateMappingDialog.this.toTemplateResource.getFormattedName(), TemplateMappingDialog.this.fromTemplateResource.getFormattedName()), (String)result2.dumpOutputAndMessages(true));
                            TemplateMappingDialog.this.reInitialiseDialog();
                            return;
                        }
                        TemplateMappingDialog.this.setDirty(true);
                    }
                }
                catch (InvocationTargetException e) {
                    String errMsg = MessageFormat.format(Messages.TM_Template_mapping_ex, TemplateMappingDialog.this.toTemplateResource.getFormattedName(), TemplateMappingDialog.this.fromTemplateResource.getFormattedName());
                    logger.error((Object)errMsg, (Throwable)e);
                    TemplateMappingDialog.this.setErrorMessage(errMsg);
                    TemplateMappingDialog.this.reInitialiseDialog();
                    return;
                }
                catch (InterruptedException e) {
                    TemplateMappingDialog.this.setErrorMessage(Messages.TM_Template_mapping_load_cancel);
                    TemplateMappingDialog.this.reInitialiseDialog();
                    return;
                }
                TemplateMappingDialog.this.loadTemplateButton.setEnabled(false);
                TemplateMappingDialog.this.fromTemplateLookupButton.setEnabled(false);
                TemplateMappingDialog.this.fromTemplateNameCombo.setEnabled(false);
                TemplateMappingDialog.this.toTemplateLookupButton.setEnabled(false);
                TemplateMappingDialog.this.toTemplateNameCombo.setEnabled(false);
                TemplateMappingDialog.this.generateMappingButton.setEnabled(true);
                TemplateMappingDialog.this.saveButton.setEnabled(true);
                TemplateMappingDialog.this.saveAsButton.setEnabled(true);
                TemplateMappingDialog.this.mapButton.setEnabled(true);
                TemplateMappingDialog.this.unmapButton.setEnabled(true);
                TemplateMappingDialog.this.attributeButton.setEnabled(true);
                TemplateMappingDialog.this.fromTemplateLayoutSelectButton.setEnabled(true);
                TemplateMappingDialog.this.setComplete(true);
                TemplateMappingDialog.this.setMessage(Messages.TM_dialog_desc);
                TemplateMappingDialog.this.fromTemplate = TemplateMappingDialog.this.loadTemplate(TemplateMappingDialog.this.fromTemplateResource, TemplateMappingDialog.this.session.getFromCacheFile());
                if (TemplateMappingDialog.this.fromTemplate == null) {
                    TemplateMappingDialog.this.reInitialiseDialog();
                    return;
                }
                TemplateMappingDialog.this.toTemplate = TemplateMappingDialog.this.loadTemplate(TemplateMappingDialog.this.toTemplateResource, TemplateMappingDialog.this.session.getToCacheFile());
                if (TemplateMappingDialog.this.toTemplate == null) {
                    TemplateMappingDialog.this.reInitialiseDialog();
                    return;
                }
                TemplateMappingDialog.adjustColumnHeader(TemplateMappingDialog.this.toTableColumns, TemplateMappingDialog.this.toTemplate.getType());
                TemplateMappingDialog.adjustColumnHeader(TemplateMappingDialog.this.fromTableColumns, TemplateMappingDialog.this.fromTemplate.getType());
                TemplateMappingDialog.this.populateMappingInformation(0);
            }
        });
        this.generateMappingButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/regenerate_mapping.gif"), (String)Messages.TM_GENERATE_MAPPING_TIP, (Object)GUI.grid.d.left1());
        this.generateMappingButton.setEnabled(false);
        this.generateMappingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TemplateMappingDialog.this.setErrorMessage(null);
                if (TemplateMappingDialog.this.session == null) {
                    TemplateMappingDialog.this.setErrorMessage(Messages.TM_REGEN_NO_SESSION);
                    return;
                }
                TemplateMappingDialog.this.setDirty(true);
                TemplateMappingDialog.this.clearMappingInformation();
                final Result result = new Result();
                final StringBuffer newContentsInXML = new StringBuffer();
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask(MessageFormat.format(Messages.TM_GENERATE_MAPPING_IN_Progress, (this).TemplateMappingDialog.this.toTemplateResource.getFormattedName(), (this).TemplateMappingDialog.this.fromTemplateResource.getFormattedName()), 3);
                            IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                            Result regenResult = (this).TemplateMappingDialog.this.session.generateMapping(howIsGoing);
                            monitor.worked(1);
                            if (!regenResult.isSuccessfulWithoutWarnings()) {
                                return;
                            }
                            if (monitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                            result.addSubResult(regenResult);
                            Result getTemplResult = new Result();
                            StringBuffer newContents = (this).TemplateMappingDialog.this.session.getTOTemplate(howIsGoing, getTemplResult);
                            result.addSubResult(getTemplResult);
                            if (!getTemplResult.isSuccessfulWithoutWarnings()) {
                                return;
                            }
                            newContentsInXML.append(newContents);
                            monitor.worked(1);
                            if (monitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                            monitor.worked(1);
                            monitor.done();
                        }
                    });
                }
                catch (InterruptedException ie) {
                    TemplateMappingDialog.this.setErrorMessage(Messages.TM_REGEN_cacenl);
                    TemplateMappingDialog.this.reInitialiseDialog();
                    return;
                }
                catch (Exception e) {
                    String errMsg = MessageFormat.format(Messages.TM_REGEN_ERROR, TemplateMappingDialog.this.toTemplateResource.getFormattedName(), TemplateMappingDialog.this.fromTemplateResource.getFormattedName());
                    logger.error((Object)errMsg, (Throwable)e);
                    TemplateMappingDialog.this.setErrorMessage(errMsg);
                    TemplateMappingDialog.this.reInitialiseDialog();
                    return;
                }
                if (!result.isSuccessfulWithoutWarnings()) {
                    String errMsg = MessageFormat.format(Messages.TM_REGEN_PROBLEM, TemplateMappingDialog.this.toTemplateResource.getFormattedName(), TemplateMappingDialog.this.fromTemplateResource.getFormattedName());
                    TemplateMappingDialog.this.setErrorMessage(errMsg);
                    PDDialogs.openErrorThreadSafe((String)errMsg, (String)result.dumpOutputAndMessages(true));
                    return;
                }
                try {
                    TemplateMappingDialog.this.toTemplate = TemplateSerializeUtils.load((StringBuffer)newContentsInXML, (IZRL)TemplateMappingDialog.this.toTemplateResource);
                }
                catch (Exception e) {
                    String errMsg = MessageFormat.format(Messages.TM_REGEN_ERROR, TemplateMappingDialog.this.toTemplateResource.getFormattedName(), TemplateMappingDialog.this.fromTemplateResource.getFormattedName());
                    logger.error((Object)errMsg, (Throwable)e);
                    TemplateMappingDialog.this.setErrorMessage(errMsg);
                    TemplateMappingDialog.this.reInitialiseDialog();
                    return;
                }
                TemplateMappingDialog.this.populateMappingInformation(0);
            }
        });
        this.saveButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/save_edit.gif"), (String)Messages.TM_SAVE_MAPPING_TIP, (Object)GUI.grid.d.left1());
        this.saveButton.setEnabled(false);
        this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateMappingDialog.this.setErrorMessage(null);
                if (TemplateMappingDialog.this.isDirty()) {
                    if (!TemplateMappingDialog.this.saveToTemplate()) {
                        return;
                    }
                    TemplateMappingDialog.this.setDirty(false);
                }
            }
        });
        this.saveAsButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/saveas_edit.gif"), (String)Messages.TM_SAVEAS_MAPPING_TIP, (Object)GUI.grid.d.left1());
        this.saveAsButton.setEnabled(false);
        this.saveAsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateMappingDialog.this.saveAsToTemplate();
            }
        });
    }

    private Result<StringBuffer> startMappingSession(final boolean overwriteOldMapping) throws InvocationTargetException, InterruptedException {
        final Result result = new Result();
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(Messages.TM_LOADING_TEMPLATE_MSG, 3);
                monitor.subTask(MessageFormat.format(Messages.TM_LOADING_TEMPLATE_MSG_SUB, TemplateMappingDialog.this.toTemplateResource.getFormattedName(), TemplateMappingDialog.this.fromTemplateResource.getFormattedName()));
                monitor.worked(1);
                Result startResult = TemplateMappingDialog.this.session.startMappingSession(PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor), overwriteOldMapping);
                monitor.worked(1);
                result.copy(startResult);
                monitor.worked(1);
                monitor.done();
            }
        });
        return result;
    }

    private void createMappingButtonsComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.left1());
        this.mapButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/map.gif"), (String)Messages.TM_MAP_TIP, (Object)GUI.grid.d.left1());
        this.mapButton.setEnabled(false);
        this.mapButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TemplateMappingDialog.this.mapFields();
            }
        });
        this.unmapButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/unmap.gif"), (String)Messages.TM_UNMAP_TIP, (Object)GUI.grid.d.left1());
        this.unmapButton.setEnabled(false);
        this.unmapButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TemplateMappingDialog.this.unmapFields();
            }
        });
        this.attributeButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/attributes.gif"), (String)Messages.TM_ATTRIBUTE_TIP, (Object)GUI.grid.d.left1());
        this.attributeButton.setEnabled(false);
        this.attributeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateMappingDialog.this.editAttributes();
            }
        });
    }

    private void mapFields() {
        this.setErrorMessage(null);
        this.toMappingTableViewer.resetFilters();
        if (this.fromTemplate == null || this.toTemplate == null) {
            this.setErrorMessage(Messages.TM_MAP_NO_TEMPLATE);
            return;
        }
        if (this.fromSelectedLayout == null) {
            this.setErrorMessage(Messages.TM_MAP_NO_FROM_LAYOUT);
            return;
        }
        int[] selectionIndex = this.toMappingTable.getSelectionIndices();
        if (selectionIndex.length == 0) {
            this.setErrorMessage(Messages.TM_MAP_NO_TO_FIELD_SELECTED);
            return;
        }
        FieldSelectionDialog dialog = new FieldSelectionDialog(this.toTemplate.getType(), this.toTemplateResource, (Layouttype)this.toTemplate.getLayout().get(this.toTemplateLayoutCombo.getSelectionIndex()), this.toMappingTable.getSelectionIndices(), this.fromTemplate.getType(), this.fromTemplateResource, this.fromSelectedLayout);
        if (dialog.open() != 0) {
            return;
        }
        this.setDirty(true);
        Symboltype selectedSymbol = dialog.getSelectedSymbol();
        Layouttype toLayout = (Layouttype)this.toTemplate.getLayout().get(this.toTemplateLayoutCombo.getSelectionIndex());
        int i = 0;
        while (i < selectionIndex.length) {
            ((Symboltype)toLayout.getSymbol().get(selectionIndex[i])).setFrom(selectedSymbol.getRef());
            ++i;
        }
        this.populateMappingInformation(this.toTemplateLayoutCombo.getSelectionIndex());
    }

    private void unmapFields() {
        this.setErrorMessage(null);
        if (this.fromTemplate == null || this.toTemplate == null) {
            this.setErrorMessage(Messages.TM_UNMAP_NO_TEMPLATE);
            return;
        }
        int[] fieldIndex = this.toMappingTable.getSelectionIndices();
        if (fieldIndex.length == 0) {
            this.setErrorMessage(Messages.TM_UNMAP_NO_TO_FIELD_SELECTED);
            return;
        }
        if (fieldIndex[0] == 0) {
            if (!PDDialogs.openConfirm((String)Messages.Confirm, (String)Messages.TM_LEVEL1_UNMAP_CONFIRM)) {
                return;
            }
            Layouttype toLayout = (Layouttype)this.toTemplate.getLayout().get(this.toTemplateLayoutCombo.getSelectionIndex());
            int i = 0;
            while (i < toLayout.getSymbol().size()) {
                ((Symboltype)toLayout.getSymbol().get(i)).setFrom(0);
                ++i;
            }
            this.populateMappingInformation(this.toTemplateLayoutCombo.getSelectionIndex());
            return;
        }
        this.setDirty(true);
        Layouttype toLayout = (Layouttype)this.toTemplate.getLayout().get(this.toTemplateLayoutCombo.getSelectionIndex());
        int i = 0;
        while (i < fieldIndex.length) {
            ((Symboltype)toLayout.getSymbol().get(fieldIndex[i])).setFrom(0);
            ++i;
        }
        this.populateMappingInformation(this.toTemplateLayoutCombo.getSelectionIndex());
    }

    private void editAttributes() {
        this.setErrorMessage(null);
        int selAttrIndex = this.toMappingTable.getSelectionIndex();
        if (selAttrIndex == -1) {
            this.setErrorMessage(Messages.TM_ATTR_NO_SEL_UPDATE);
            return;
        }
        FieldAttributeDialog dialog = new FieldAttributeDialog(this.session, this.toTemplateResource, this.toTemplate, (Layouttype)this.toTemplate.getLayout().get(this.toTemplateLayoutCombo.getSelectionIndex()), selAttrIndex, true);
        if (dialog.open() != 0) {
            if (dialog.validationErrorOccurred()) {
                this.setDirty(true);
            }
            return;
        }
        this.setDirty(true);
    }

    private boolean validateTemplateName(IZRL aTemplate) {
        String result;
        block4: {
            result = TemplateEditorUtilities.okAsTemplate(aTemplate, true, null);
            if (result != null) break block4;
            return true;
        }
        try {
            this.setErrorMessage(result);
            return false;
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(MessageFormat.format(Messages.TM_Template_check_ex, aTemplate.getFormattedName()));
            return false;
        }
        catch (InterruptedException e) {
            this.setErrorMessage(MessageFormat.format(Messages.TM_Template_check_cancel, aTemplate.getFormattedName()));
            return false;
        }
    }

    private TemplateType loadTemplate(IZRL aTemplate, IFile aFile) {
        try {
            return TemplateSerializeUtils.load((IFile)aFile, (IZRL)aTemplate);
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.TM_loadTemplateErr, aTemplate.getFormattedName());
            logger.error((Object)errMsg, (Throwable)e);
            this.setErrorMessage(errMsg);
            this.reInitialiseDialog();
            return null;
        }
    }

    private void clearMappingInformation() {
        ArrayList<String[]> dummyInput = new ArrayList<String[]>();
        String[] info = TemplateMappingDialog.getEmptyValue();
        int i = 0;
        while (i < 10) {
            dummyInput.add(info);
            ++i;
        }
        this.fromTemplateLayoutText.setText("");
        this.fromSelectedLayout = null;
        this.fromMappingTableViewer.setInput(dummyInput);
        this.toTemplateLayoutCombo.setItems(new String[0]);
        this.toMappingTableViewer.setInput(dummyInput);
        this.fromTemplateLayoutText.setEnabled(false);
        this.fromMappingTable.setEnabled(false);
        this.toTemplateLayoutCombo.setEnabled(false);
        this.toMappingTable.setEnabled(false);
    }

    private void populateMappingInformation(int toTemplateIndex) {
        this.setErrorMessage(null);
        if (this.toTemplate == null || this.fromTemplate == null) {
            return;
        }
        this.toTemplateLayoutCombo.setEnabled(true);
        this.toMappingTable.setEnabled(true);
        this.fromTemplateLayoutText.setEnabled(true);
        this.fromMappingTable.setEnabled(true);
        this.toTemplateLayoutCombo.setItems(TemplateLayoutComposite.getLayoutNames(this.toTemplate, this.toTemplateResource.getSystem()));
        this.toTemplateLayoutCombo.select(toTemplateIndex);
        this.populateTable(this.toMappingTableViewer, this.toTemplate, toTemplateIndex);
        this.populateFromTableWithToSelection(toTemplateIndex);
        this.toMappingTable.select(toTemplateIndex);
    }

    private void populateFromTableWithToSelection(int toLayoutIndex) {
        Layouttype toLayout = (Layouttype)this.toTemplate.getLayout().get(toLayoutIndex);
        int fromTemplateLayoutIndex = this.getFromTemplateLayoutIndex(toLayout);
        if (fromTemplateLayoutIndex == -1) {
            this.fromTemplateLayoutText.setText("");
            this.fromSelectedLayout = null;
            ArrayList<String[]> fromTableContents = new ArrayList<String[]>();
            int i = 0;
            while (i < toLayout.getSymbol().size()) {
                fromTableContents.add(TemplateMappingDialog.getEmptyValue());
                ++i;
            }
            this.fromMappingTableViewer.setInput(fromTableContents);
            this.fromMappingTable.setEnabled(false);
        } else {
            Layouttype fromLayout = (Layouttype)this.fromTemplate.getLayout().get(fromTemplateLayoutIndex);
            this.fromTemplateLayoutText.setText(((Symboltype)fromLayout.getSymbol().get(0)).getName(this.toTemplateResource.getSystem()));
            this.fromSelectedLayout = fromLayout;
            ArrayList<String[]> fromTableContents = new ArrayList<String[]>();
            int i = 0;
            while (i < toLayout.getSymbol().size()) {
                Symboltype fromSymboltype;
                Symboltype aToSymbol = (Symboltype)toLayout.getSymbol().get(i);
                String[] info = aToSymbol.isSetFrom() && aToSymbol.getFrom() != 0 ? ((fromSymboltype = this.getFromTemplateSymbol(fromTemplateLayoutIndex, aToSymbol.getFrom())) == null ? TemplateMappingDialog.getEmptyValue() : this.prepareValue(fromLayout, fromSymboltype, this.fromTemplate.getType())) : TemplateMappingDialog.getEmptyValue();
                fromTableContents.add(info);
                ++i;
            }
            this.fromMappingTableViewer.setInput(fromTableContents);
        }
    }

    private int getFromTemplateLayoutIndex(Layouttype toLayout) {
        int i = 0;
        while (i < toLayout.getSymbol().size()) {
            Symboltype aSymbol = (Symboltype)toLayout.getSymbol().get(i);
            if (aSymbol.isSetFrom() && aSymbol.getFrom() != 0) {
                int fromFieldIndex = aSymbol.getFrom();
                return this.getLayoutIDOfFromTemplate(fromFieldIndex);
            }
            ++i;
        }
        return -1;
    }

    private int getLayoutIDOfFromTemplate(int symbolIndex) {
        int i = 0;
        while (i < this.fromTemplate.getLayout().size()) {
            Layouttype aLayout = (Layouttype)this.fromTemplate.getLayout().get(i);
            int j = 0;
            while (j < aLayout.getSymbol().size()) {
                Symboltype aSymbol = (Symboltype)aLayout.getSymbol().get(j);
                if (aSymbol.getRef() == symbolIndex) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    private Symboltype getFromTemplateSymbol(int layoutID, int symbolID) {
        Layouttype aLayout = (Layouttype)this.fromTemplate.getLayout().get(layoutID);
        int i = 0;
        while (i < aLayout.getSymbol().size()) {
            Symboltype aSymbol = (Symboltype)aLayout.getSymbol().get(i);
            if (aSymbol.getRef() == symbolID) {
                return aSymbol;
            }
            ++i;
        }
        return null;
    }

    private boolean isDirty() {
        return this.isDirty;
    }

    private void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    protected void okPressed() {
        this.setErrorMessage(null);
        if (this.isDirty() && !this.saveToTemplate()) {
            return;
        }
        if (this.session != null) {
            this.quitSessionInJob();
        }
        this.setDirty(false);
        super.okPressed();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void cancelPressed() {
        this.setErrorMessage(null);
        if (this.isDirty()) {
            if (!PDDialogs.openQuestion((String)Messages.Confirm, (String)Messages.TM_CONFIRM_CANCEL_WITHOUT_SAVE)) return;
            this.setDirty(false);
            super.cancelPressed();
            return;
        } else {
            super.cancelPressed();
        }
    }

    public boolean close() {
        if (this.isDirty()) {
            if (PDDialogs.openQuestion((String)Messages.Confirm, (String)Messages.TM_CONFIRM_CANCEL_WITHOUT_SAVE)) {
                this.setDirty(false);
                return super.close();
            }
            return false;
        }
        return super.close();
    }

    private boolean saveToTemplate() {
        this.setErrorMessage(null);
        if (this.fromTemplate == null || this.toTemplate == null) {
            this.setErrorMessage(Messages.TM_MAP_NO_TEMPLATE_SAVE);
            return false;
        }
        if (TemplateEditorUtilities.existsInCopybooks(this.toTemplateResource.getFormattedName(), this.toTemplate.getCopybooks())) {
            if (PDDialogs.openQuestion((String)MessageFormat.format(Messages.TemplateEditor_COPYBOOK_OVERWRITE, this.toTemplateResource.getFormattedName()))) {
                return this.saveAsToTemplate();
            }
            return false;
        }
        this.toTemplate.setCopybooks(null);
        final Result overallResult = new Result((Object)new StringBuffer());
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.TemplateEditor_SAVE_IN_PROGRESS, TemplateMappingDialog.this.toTemplateResource.getFormattedName()), 5);
                    monitor.worked(1);
                    try {
                        TemplateType newTemplate;
                        Result result = new Result();
                        StringBuffer xmlTemplate = TemplateSerializeUtils.save((TemplateType)TemplateMappingDialog.this.toTemplate, (IZRL)TemplateMappingDialog.this.toTemplateResource);
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        StringBuffer newXmlTemplate = TemplateMappingDialog.this.session.updateTOTemplate(xmlTemplate, howIsGoing, result);
                        overallResult.addSubResult(result);
                        monitor.worked(1);
                        if (!result.isSuccessfulWithoutWarnings()) {
                            return;
                        }
                        TemplateMappingDialog.this.toTemplate = newTemplate = TemplateSerializeUtils.load((StringBuffer)newXmlTemplate, (IZRL)TemplateMappingDialog.this.toTemplateResource);
                        overallResult.addSubResult(TemplateMappingDialog.this.session.saveTO(howIsGoing));
                        monitor.worked(1);
                        monitor.done();
                    }
                    catch (CoreException e1) {
                        overallResult.add((Throwable)e1);
                        overallResult.setRC(8);
                        PDDialogs.openErrorThreadSafe((String)Messages.TemplateEditorAction_EX, (Throwable)e1);
                        return;
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            PDDialogs.openErrorThreadSafe((String)Messages.TemplateEditor_SAVE_EX, (Throwable)e);
            this.reInitialiseDialog();
            return false;
        }
        catch (InterruptedException e) {
            PDDialogs.openInfoThreadSafe((String)Messages.TemplateEditor_ACTION_CANCEL);
            this.reInitialiseDialog();
            return false;
        }
        if (overallResult.getRC() <= 4) {
            return true;
        }
        PDDialogs.openErrorThreadSafe((String)Messages.Error, (String)Messages.TM_ERROR_WHILE_SAVE_TO_TEMPLATE, (String)overallResult.dumpOutputAndMessages(true));
        return false;
    }

    private boolean saveAsToTemplate() {
        IZRL target;
        block18: {
            this.setErrorMessage(null);
            if (this.fromTemplate == null || this.toTemplate == null) {
                this.setErrorMessage(Messages.TM_MAP_NO_TEMPLATE_SAVEAS);
                return false;
            }
            TemplateResourceSaveAsDialog dialog = new TemplateResourceSaveAsDialog(this.toTemplateResource.getSystem(), null, MemberPresence.Required);
            if (dialog.open() != 0) {
                return false;
            }
            target = dialog.getSelectedResource();
            if (this.toTemplateResource.getFormattedName().equals(target.getFormattedName())) {
                if (PDDialogs.openQuestion((String)MessageFormat.format(Messages.TM_MAP_SAVE_TARGET_TEMPLATE_FOR_SAVEAS, this.toTemplateResource.getFormattedName()))) {
                    return this.saveToTemplate();
                }
                return this.saveAsToTemplate();
            }
            if (TemplateEditorUtilities.existsInCopybooks(target.getFormattedName(), this.toTemplate.getCopybooks())) {
                if (PDDialogs.openQuestion((String)MessageFormat.format(Messages.TemplateEditor_COPYBOOK_OVERWRITE, target.getFormattedName()))) {
                    return this.saveAsToTemplate();
                }
                return false;
            }
            try {
                Result<StringBuffer> infoResult = ZrlLoaderDialogUtils.retrieveInformation(target);
                if (infoResult.isSuccessfulWithoutWarnings()) {
                    if (target instanceof DataSetOrMember) {
                        DataSetOrMember dsom = (DataSetOrMember)target;
                        if (dsom.getConfirmedExists() && !PDDialogs.openQuestion((String)MessageFormat.format(Messages.TM_MAP_SAVEAS_TARGET_EXIST_OVERWRITE_CONFIRM, target.getFormattedName()))) {
                            return this.saveAsToTemplate();
                        }
                        break block18;
                    }
                    if (target instanceof UssFile) {
                        UssFile ussFile = (UssFile)target;
                        if (ussFile.isDirectory()) {
                            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.TemplateMappingDialog_0, target.getFormattedName()));
                            return this.saveAsToTemplate();
                        }
                        if (ussFile.getConfirmedExists() && !PDDialogs.openQuestion((String)MessageFormat.format(Messages.TM_MAP_SAVEAS_TARGET_EXIST_OVERWRITE_CONFIRM, target.getFormattedName()))) {
                            return this.saveAsToTemplate();
                        }
                        break block18;
                    }
                    throw new IllegalArgumentException("Specified target type is not supported: " + target.getFormattedName());
                }
                this.setErrorMessage(MessageFormat.format(Messages.TM_MAP_SAVEAS_TARGET_NOT_EXIST_ERR_MSG, target.getFormattedName()));
                return false;
            }
            catch (InterruptedException e) {
                this.setErrorMessage(MessageFormat.format(Messages.TM_MAP_SAVEAS_TARGET_CHECK_CANCEL, target.getFormattedName()));
                return false;
            }
        }
        final Result overallResult = new Result();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.TemplateEditor_SAVEAS_IN_PROGRESS, target.getFormattedName()), 3);
                    try {
                        TemplateType newTemplate;
                        Result updateResult = new Result();
                        StringBuffer xmlTemplate = TemplateSerializeUtils.save((TemplateType)TemplateMappingDialog.this.toTemplate, (IZRL)target);
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        StringBuffer newXmlTemplate = TemplateMappingDialog.this.session.updateTOTemplate(xmlTemplate, howIsGoing, updateResult);
                        overallResult.addSubResult(updateResult);
                        monitor.worked(1);
                        if (!updateResult.isSuccessfulWithoutWarnings()) {
                            return;
                        }
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        Result saveAsResult = new Result();
                        TemplateMappingDialog.this.session.saveTOAs(target, howIsGoing, saveAsResult);
                        monitor.worked(1);
                        if (!saveAsResult.isSuccessfulWithoutWarnings()) {
                            return;
                        }
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        TemplateMappingDialog.this.toTemplateResource = target;
                        TemplateMappingDialog.this.toTemplate = newTemplate = TemplateSerializeUtils.load((StringBuffer)newXmlTemplate, (IZRL)TemplateMappingDialog.this.toTemplateResource);
                        overallResult.addSubResult(saveAsResult);
                    }
                    catch (CoreException ce) {
                        throw new InvocationTargetException(ce);
                    }
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e1) {
            PDDialogs.openErrorThreadSafe((String)Messages.TemplateEditor_SAVEAS_EX, (Throwable)e1);
            this.reInitialiseDialog();
            return false;
        }
        catch (InterruptedException e1) {
            PDDialogs.openInfoThreadSafe((String)Messages.TemplateEditor_ACTION_CANCEL);
            this.reInitialiseDialog();
            return false;
        }
        if (overallResult.isSuccessfulWithoutWarnings()) {
            this.toTemplateNameCombo.setText(this.toTemplateResource.getFormattedName());
            this.populateMappingInformation(0);
            this.setDirty(false);
            return true;
        }
        PDDialogs.openErrorThreadSafe((String)Messages.TM_MAP_SAVEAS_ERROR, (String)overallResult.getMessagesCombined().toString());
        return false;
    }

    public TemplateType getToTemplateIfModified() {
        return this.toTemplate;
    }

    public IZRL getToTemplateResource() {
        return this.toTemplateResource;
    }

    private void populateTable(TableViewer aTableViewer, TemplateType aTemplate, int layoutIndex) {
        ArrayList<String[]> fieldList = new ArrayList<String[]>();
        Layouttype aLayout = (Layouttype)aTemplate.getLayout().get(layoutIndex);
        for (Symboltype aSymbol : aLayout.getSymbol()) {
            String[] info = this.prepareValue(aLayout, aSymbol, aTemplate.getType());
            fieldList.add(info);
        }
        aTableViewer.setInput(fieldList);
    }

    private String[] prepareValue(Layouttype aLayout, Symboltype aSymbol, String templateType) {
        if ("BASE".equals(templateType) || "DYNAMIC".equals(templateType)) {
            return this.prepareValueBASE(aLayout, aSymbol, templateType);
        }
        if ("DB2".equals(templateType)) {
            return this.prepareValueDB2(aSymbol, templateType);
        }
        logger.error((Object)("Unknown template type: " + templateType));
        return this.prepareValueBASE(aLayout, aSymbol, templateType);
    }

    private static String[] getEmptyValue() {
        return EMPTY_INFO;
    }

    private String[] prepareValueBASE(Layouttype aLayout, Symboltype aSymbol, String templateType) {
        String[] info = new String[]{TemplateEditor.getFieldReferenceNumberForDisplay(aLayout, aSymbol, false), "" + aSymbol.getLvl(), aSymbol.getName(this.toTemplateResource.getSystem()), aSymbol.getType().getName(), "" + aSymbol.getStart(), "" + aSymbol.getLength()};
        return info;
    }

    private String[] prepareValueDB2(Symboltype aSymbol, String templateType) {
        String[] info = new String[]{"" + aSymbol.getDb2col(), aSymbol.getName(this.toTemplateResource.getSystem()), aSymbol.getDb2typ(), "", "", ""};
        return info;
    }

    private void reInitialiseDialog() {
        this.isDirty = false;
        if (this.session != null) {
            this.quitSessionInJob();
        }
        this.session = null;
        this.toTemplate = null;
        this.fromTemplate = null;
        this.loadTemplateButton.setEnabled(true);
        this.fromTemplateLookupButton.setEnabled(true);
        this.fromTemplateNameCombo.setEnabled(true);
        this.toTemplateLookupButton.setEnabled(true);
        this.toTemplateNameCombo.setEnabled(true);
    }

    private void quitSessionInJob() {
        if (this.session == null) {
            return;
        }
        TemplateEditorUtilities.end(this.session);
        this.session = null;
    }
}

