/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class StatusMarker
extends Composite {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final Image ERROR_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
    protected static final Image WARNING_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
    protected static final Image INFO_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
    protected Image image;
    protected Label label;
    protected IStatus status;

    public StatusMarker(Composite parent) {
        super(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.setBackground(parent.getBackground());
    }

    public boolean isShowingStatus() {
        return this.label != null && !this.label.isDisposed();
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        if (this.isShowingStatus()) {
            this.label.setToolTipText(string);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return this.computeSize();
    }

    protected Point computeSize() {
        if (this.image != null) {
            return new Point(this.image.getBounds().width, this.image.getBounds().height);
        }
        return new Point(StatusMarker.ERROR_IMAGE.getBounds().width, StatusMarker.ERROR_IMAGE.getBounds().height);
    }

    public String getToolTipText(IStatus status) {
        StringBuffer toolTip = new StringBuffer();
        if (status.isMultiStatus()) {
            IStatus[] stati;
            String message = status.getMessage();
            if (message != null && message.length() > 0) {
                toolTip.append(message);
            }
            if ((stati = ((MultiStatus)status).getChildren()) != null) {
                int i = 0;
                while (i < stati.length) {
                    if (i == 0 && toolTip.length() < 1) {
                        toolTip.append("- ");
                    } else {
                        toolTip.append("\n- ");
                    }
                    toolTip.append(stati[i].getMessage());
                    ++i;
                }
            }
        } else {
            toolTip.append(status.getMessage());
        }
        return toolTip.toString();
    }

    protected void setImage(Image image) {
        this.label.setImage(image);
    }

    public void setStatus(IStatus status) {
        if (this.isDisposed()) {
            return;
        }
        if (status != null && status.getSeverity() == 0) {
            status = null;
        }
        this.status = status;
        if (status == null) {
            this.setToolTipText(null);
            if (this.isShowingStatus()) {
                this.label.dispose();
            }
            this.label = null;
            this.layout(true);
        } else if (status.getSeverity() == 4) {
            if (!this.isShowingStatus()) {
                this.label = new Label((Composite)this, 0);
            }
            this.setImage(ERROR_IMAGE);
            this.setToolTipText(this.getToolTipText(status));
            this.layout(true);
        } else if (status.getSeverity() == 2) {
            if (!this.isShowingStatus()) {
                this.label = new Label((Composite)this, 0);
            }
            this.setImage(WARNING_IMAGE);
            this.setToolTipText(this.getToolTipText(status));
            this.layout(true);
        } else if (status.getSeverity() == 1) {
            if (!this.isShowingStatus()) {
                this.label = new Label((Composite)this, 0);
            }
            this.setImage(INFO_IMAGE);
            this.setToolTipText(this.getToolTipText(status));
            this.layout(true);
        }
    }

    public IStatus getStatus() {
        return this.status;
    }
}

