/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.dialogs;

import com.ibm.etools.fm.editor.template.dialogs.listeners.IRangeSelectListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class RangeSelectComposite
extends Composite
implements ISelectionChangedListener {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private String contents;
    private int startRow;
    private int endRow;
    private SourceViewer viewer;
    private Font font;
    private ListenerList rangeSelectListeners;
    private boolean doNotify;

    public RangeSelectComposite(Composite parent) {
        super(parent, 2048);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.setLayout((Layout)gl);
        this.font = new Font((Device)Display.getCurrent(), "Courier New", 10, 0);
        CompositeRuler verticalRuler = new CompositeRuler();
        LineNumberRulerColumn lineNumberRulerColumn = new LineNumberRulerColumn();
        lineNumberRulerColumn.setFont(this.font);
        verticalRuler.addDecorator(0, (IVerticalRulerColumn)lineNumberRulerColumn);
        this.viewer = new SourceViewer((Composite)this, (IVerticalRuler)verticalRuler, 778);
        this.viewer.configure(new SourceViewerConfiguration());
        this.viewer.getTextWidget().setFont(this.font);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.startRow = 0;
        this.endRow = 0;
        this.rangeSelectListeners = new ListenerList();
        this.doNotify = true;
    }

    public void dispose() {
        this.font.dispose();
        super.dispose();
    }

    public void setContents(String contents) {
        this.contents = contents;
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            Document doc = new Document(contents);
            this.viewer.setDocument((IDocument)doc);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Point sel = this.viewer.getSelectedRange();
        this.computeSelectedRows(sel.x, sel.y);
        this.notifyRangeSelectListeners();
    }

    private void computeSelectedRows(int offset, int length) {
        if (length < 1) {
            this.startRow = 0;
            this.endRow = 0;
        } else {
            int tempOffset = 0;
            this.startRow = 1;
            while (tempOffset < offset) {
                if ((tempOffset = this.contents.indexOf(10, tempOffset) + 1) <= 0 || tempOffset > offset) break;
                ++this.startRow;
            }
            tempOffset = offset;
            this.endRow = this.startRow;
            while (tempOffset < offset + length) {
                if ((tempOffset = this.contents.indexOf(10, tempOffset) + 1) <= 0 || tempOffset >= offset + length) break;
                ++this.endRow;
            }
        }
    }

    public void setSelectionRange(Integer fromRow, Integer toRow, String fromString, String toString) {
        this.doNotify = false;
        Point sel = this.computeSelectionRange(fromRow, toRow, fromString, toString);
        this.viewer.setSelectedRange(sel.x, sel.y);
        this.doNotify = true;
    }

    private Point computeSelectionRange(Integer fromRow, Integer toRow, String fromString, String toString) {
        int stringOffset;
        int startOffset = 0;
        int endOffset = 0;
        if (fromRow == null && toRow == null && fromString == null && toString == null) {
            return new Point(0, 0);
        }
        if (fromRow == null) {
            fromRow = fromString == null ? 1 : this.getRowCount();
        }
        if (toRow == null) {
            toRow = this.getRowCount();
        }
        int row = 1;
        while (row < fromRow) {
            stringOffset = this.contents.length();
            if (fromString != null && (stringOffset = this.contents.indexOf(fromString, startOffset)) < 0) {
                stringOffset = this.contents.length();
            }
            int oldStartOffset = startOffset;
            if ((startOffset = this.contents.indexOf(10, startOffset) + 1) == 0) {
                startOffset = this.contents.length();
            }
            if (stringOffset < startOffset) {
                startOffset = oldStartOffset;
                fromRow = row;
                break;
            }
            if (startOffset >= this.contents.length()) break;
            ++row;
        }
        endOffset = startOffset;
        row = fromRow;
        while (row <= toRow) {
            stringOffset = this.contents.length();
            if (toString != null && (stringOffset = this.contents.indexOf(toString, endOffset)) < 0) {
                stringOffset = this.contents.length();
            }
            if ((endOffset = this.contents.indexOf(10, endOffset) + 1) == 0) {
                endOffset = this.contents.length();
            }
            if (stringOffset < endOffset || endOffset >= this.contents.length()) break;
            ++row;
        }
        return new Point(startOffset, endOffset - startOffset);
    }

    private int getRowCount() {
        int rows = 0;
        if (this.contents != null) {
            int index = 0;
            rows = 1;
            while (index < this.contents.length()) {
                if ((index = this.contents.indexOf(10, index) + 1) == 0) {
                    index = this.contents.length();
                    break;
                }
                ++rows;
            }
        }
        return rows;
    }

    public void addRangeSelectListener(IRangeSelectListener listener) {
        this.rangeSelectListeners.add((Object)listener);
    }

    public void removeRangeSelectListener(IRangeSelectListener listener) {
        this.rangeSelectListeners.remove((Object)listener);
    }

    private void notifyRangeSelectListeners() {
        Object[] listeners;
        Object[] objectArray = listeners = this.rangeSelectListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IRangeSelectListener && this.doNotify) {
                ((IRangeSelectListener)o).rangeSelected((Object)this, this.startRow, this.endRow);
            }
            ++n2;
        }
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int getEndRow() {
        return this.endRow;
    }
}

