/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionTemplate;
import com.ibm.etools.fm.core.model.BaseEditorOptions;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.editor.template.TemplateEditorUtilities;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateFactory;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.TypeType;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.views.systems.handlers.CreateTemplate;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDFileSystemUtil;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.PDDialogWithText;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDEditorManagement;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class NewDynamicTemplateDialog
extends BaseTitleAreaDialog {
    private IPDHost aHost;
    private IZRL initDSN;
    private IZRL newTemplate;
    private TemplateType newDynamicTemplate;
    private TemplateType modelTemplate;
    private Combo newTemplateCombo;
    private Combo modelTemplateCombo;
    private Combo modelLayoutCombo;

    public NewDynamicTemplateDialog(IPDHost aHost, IZRL initDSN) {
        this.aHost = aHost;
        this.initDSN = initDSN;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.NewDynamicTemplateDialog_Title);
        this.setMessage(Messages.NewDynamicTemplateDialog_SPECIFYMSG);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)5, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)composite, (String)Messages.NewDynamicTemplateDialog_NewTemplateName, (Object)GUI.grid.d.left1());
        this.newTemplateCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)3));
        LookupDialogFactory.defaults(LookupButton.createLookupTemplateButtonLeft1(composite), this.newTemplateCombo, (IHostProvider)this.aHost).types(FMHost.getPermittedTemplateResourceType((IPDHost)this.aHost)).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "NewTemplate").create();
        if (this.initDSN != null) {
            this.newTemplateCombo.setText(this.initDSN.getFormattedName());
        }
        this.newTemplateCombo.setFocus();
        GUI.label.left((Composite)composite, (String)Messages.NewDynamicTemplateDialog_ModelTemplateName, (Object)GUI.grid.d.left1());
        this.modelTemplateCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        if (this.initDSN != null) {
            this.modelTemplateCombo.setText(this.initDSN.getFormattedName());
        }
        LookupDialogFactory.defaults(LookupButton.createLookupTemplateButtonLeft1(composite), this.modelTemplateCombo, (IHostProvider)this.aHost).types(FMHost.getPermittedTemplateResourceType((IPDHost)this.aHost)).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "ModelTemplate").create();
        this.modelTemplateCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NewDynamicTemplateDialog.this.modelTemplateCombo.getText().trim().isEmpty()) {
                    NewDynamicTemplateDialog.this.modelTemplate = null;
                    NewDynamicTemplateDialog.this.setModelLayout(NewDynamicTemplateDialog.this.modelTemplate);
                }
            }
        });
        Button loadModelButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/load.gif"), (String)Messages.NewDynamicTemplateDialog_LoadModelTip, (Object)GUI.grid.d.left1());
        loadModelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String modelTemplateName = NewDynamicTemplateDialog.this.modelTemplateCombo.getText().trim();
                if (!ZRLs.isParseable((IPDHost)NewDynamicTemplateDialog.this.aHost, (String)modelTemplateName)) {
                    NewDynamicTemplateDialog.this.setErrorMessage(MessageFormat.format(Messages.NewDynamicTemplateDialog_InvalidModelTemplateName, modelTemplateName));
                    NewDynamicTemplateDialog.this.modelTemplateCombo.setFocus();
                    return;
                }
                IZRL modelTemplateResource = ZRLs.parseZRL((IPDHost)NewDynamicTemplateDialog.this.aHost, (String)NewDynamicTemplateDialog.this.modelTemplateCombo.getText().trim());
                NewDynamicTemplateDialog.this.modelTemplate = NewDynamicTemplateDialog.loadModelTemplate(modelTemplateResource);
                if (NewDynamicTemplateDialog.this.modelTemplate == null) {
                    return;
                }
                if (!NewDynamicTemplateDialog.this.modelTemplate.getType().equals("DYNAMIC") && !NewDynamicTemplateDialog.this.modelTemplate.getType().equals("BASE")) {
                    PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.NewDynamicTemplateDialog_1, NewDynamicTemplateDialog.this.modelTemplate.getType()));
                    return;
                }
                NewDynamicTemplateDialog.this.setModelLayout(NewDynamicTemplateDialog.this.modelTemplate);
            }
        });
        Button editTemplateButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/templateEditor.gif"), (String)Messages.__EDIT_TEMPLATE, (Object)GUI.grid.d.left1());
        editTemplateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String aTemplateName = NewDynamicTemplateDialog.this.modelTemplateCombo.getText().trim();
                if (!aTemplateName.isEmpty()) {
                    if (ZRLs.isParseable((IPDHost)NewDynamicTemplateDialog.this.aHost, (String)aTemplateName)) {
                        IZRL modelTemplateResource = ZRLs.parseZRL((IPDHost)NewDynamicTemplateDialog.this.aHost, (String)aTemplateName);
                        TemplateEditorUtilities.openTemplateEditSession(modelTemplateResource);
                        return;
                    }
                    PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.EditorOptionDialog_TemplateEditInvalidTemplate, aTemplateName));
                    return;
                }
                PDDialogs.openErrorThreadSafe((String)Messages.EditorOptionDialog_TemplateEditNoTemplate);
            }
        });
        GUI.label.left((Composite)composite, (String)Messages.NewDynamicTemplateDialog_ModelTemplateLayout, (Object)GUI.grid.d.left1());
        this.modelLayoutCombo = GUI.combo.readOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)2), (Object[])new Object[0]);
        this.modelLayoutCombo.setEnabled(false);
        return composite;
    }

    protected void okPressed() {
        if (this.validateNewTemplateName()) {
            if (!this.validateTemplateModel()) {
                return;
            }
            this.newDynamicTemplate = this.constructDynamicTemplate();
            super.okPressed();
        }
    }

    private boolean validateNewTemplateName() {
        String value = this.newTemplateCombo.getText().trim();
        if (value.isEmpty() || !ZRLs.isParseable((IPDHost)this.aHost, (String)value)) {
            this.setErrorMessage(MessageFormat.format(Messages.NewDynamicTemplateDialog_InvalidNewTemplateName, value));
            this.newTemplateCombo.setFocus();
            return false;
        }
        this.newTemplate = ZRLs.parseZRL((IPDHost)this.aHost, (String)value);
        try {
            String result = TemplateEditorUtilities.okAsTemplate(this.newTemplate, false, null);
            if (result != null) {
                this.setErrorMessage(result);
                this.newTemplateCombo.setFocus();
                return false;
            }
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(MessageFormat.format(Messages.NewDynamicTemplateDialog_2, this.newTemplate.getFormattedName()));
            this.newTemplateCombo.setFocus();
            return false;
        }
        catch (InterruptedException e) {
            this.setErrorMessage(Messages.NewDynamicTemplateDialog_NewTemplateNameValidationCancel);
            this.newTemplateCombo.setFocus();
            return false;
        }
        if (this.newTemplate instanceof DataSetOrMember) {
            DataSetOrMember dsom = (DataSetOrMember)this.newTemplate;
            if (dsom.asMember() != null && dsom.asMember().getConfirmedExists()) {
                return PDDialogs.openQuestion((String)MessageFormat.format(Messages.NewDynamicTemplateDialog_0, this.newTemplate.getFormattedName()));
            }
            if (dsom.asDataSet().getConfirmedExists()) {
                if (dsom.asMember() == null) {
                    return PDDialogs.openQuestion((String)MessageFormat.format(Messages.NewDynamicTemplateDialog_3, this.newTemplate.getFormattedName()));
                }
                return true;
            }
            this.setErrorMessage(MessageFormat.format(Messages.NewDynamicTemplateDialog_NewTemplateNameValidationErr, this.newTemplate.getFormattedName()));
            return false;
        }
        if (this.newTemplate instanceof UssFile) {
            UssFile aFile = (UssFile)this.newTemplate;
            if (aFile.isDirectory()) {
                this.setErrorMessage(Messages.NewDynamicTemplateDialog_4);
                return false;
            }
            if (aFile.getConfirmedExists()) {
                return PDDialogs.openQuestion((String)MessageFormat.format(Messages.NewDynamicTemplateDialog_5, this.newTemplate.getFormattedName()));
            }
            return true;
        }
        throw new IllegalArgumentException(Messages.NewDynamicTemplateDialog_6 + this.newTemplate.getFormattedName());
    }

    private boolean validateTemplateModel() {
        String modelTemplateName = this.modelTemplateCombo.getText().trim();
        if (!ZRLs.isParseable((IPDHost)this.aHost, (String)modelTemplateName)) {
            this.setErrorMessage(MessageFormat.format(Messages.NewDynamicTemplateDialog_InvalidModelTemplateName, modelTemplateName));
            this.modelTemplateCombo.setFocus();
            return false;
        }
        IZRL modelTemplateResource = ZRLs.parseZRL((IPDHost)this.aHost, (String)this.modelTemplateCombo.getText().trim());
        if (!this.doesResourceExist(modelTemplateResource)) {
            return PDDialogs.openQuestion((String)Messages.NewDynamicTemplateDialog_ModelTemplateDoesNotExist);
        }
        return this.modelTemplate != null || PDDialogs.openQuestion((String)Messages.NewDynamicTemplateDialog_Msg);
    }

    private boolean doesResourceExist(IZRL zosResource) {
        if (zosResource instanceof DataSetOrMember) {
            DataSetOrMember dataSetOrMember = (DataSetOrMember)zosResource;
            try {
                dataSetOrMember.refreshExistence(PDUtils.getNoopHowIsGoing());
            }
            catch (InterruptedException e) {
                logger.error((Throwable)e);
                return false;
            }
            Member member = dataSetOrMember.asMember();
            return member != null ? member.getConfirmedExists() : dataSetOrMember.asDataSet().getConfirmedExists();
        }
        return false;
    }

    public IZRL getNewTemplateName() {
        return this.newTemplate;
    }

    public TemplateType getNewTemplateContents() {
        return this.newDynamicTemplate;
    }

    private static TemplateType loadModelTemplate(final IZRL templateResource) {
        final AbstractSessionTemplate session = AbstractSessionTemplate.createTemplateEditSession((IZRL)templateResource);
        StringBuffer errMsgs = new StringBuffer();
        final Result overallResult = new Result((Object)new StringBuffer());
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.CreateTemplateDynamicPage_CHECK_EXIST, templateResource.getFormattedName()), 1);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    Result result = session.start(howIsGoing);
                    overallResult.copy(result);
                    monitor.done();
                }
            });
            if (!overallResult.isSuccessfulWithoutWarnings()) {
                NewDynamicTemplateDialog.displayCreateTemplateErrCompilerListing(session, templateResource, (Result<StringBuffer>)overallResult, true);
                return null;
            }
        }
        catch (Exception e) {
            if (errMsgs.length() > 0) {
                PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.CreateTemplateWizard_OPEN_TMPLE_ERR, templateResource.getFormattedName()), (String)errMsgs.toString(), (Throwable)e);
            }
            return null;
        }
        finally {
            TemplateEditorUtilities.end(session);
        }
        if (errMsgs.length() > 0 || session.getFromCacheFile() == null) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.CreateTemplateWizard_OPEN_TMPLE_ERR, templateResource.getFormattedName()), (String)errMsgs.toString());
            return null;
        }
        try {
            return TemplateSerializeUtils.load((IFile)session.getFromCacheFile(), (IZRL)templateResource);
        }
        catch (Exception e) {
            String errString = MessageFormat.format(Messages.CreateTemplateWizard_OPEN_TMPLE_FILE_EXE, templateResource.getFormattedName(), session.getFromCacheFile().getLocation().toString());
            PDDialogs.openErrorThreadSafe((String)errString);
            logger.error((Object)errString, (Throwable)e);
            return null;
        }
    }

    private void setModelLayout(TemplateType modelTemplate) {
        if (modelTemplate != null) {
            EList layoutList = modelTemplate.getLayout();
            String[] layoutNames = new String[layoutList.size()];
            int i = 0;
            while (i < layoutList.size()) {
                layoutNames[i] = ((Symboltype)((Layouttype)layoutList.get(i)).getSymbol().get(0)).getName(this.aHost);
                ++i;
            }
            this.modelLayoutCombo.setEnabled(true);
            this.modelLayoutCombo.setItems(layoutNames);
            this.modelLayoutCombo.select(0);
        } else {
            this.modelLayoutCombo.setItems(new String[0]);
            this.modelLayoutCombo.setEnabled(false);
        }
    }

    public static void displayCreateTemplateErrCompilerListing(final AbstractSessionTemplate session, final IZRL templateResource, final Result<StringBuffer> overallResult, final boolean releaseSession) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PDDialogWithText.ITextDialogRunnable action = new PDDialogWithText.ITextDialogRunnable(){

                    public void run(PDDialogWithText dialog) {
                        try {
                            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    monitor.setTaskName(Messages.OpenAsTemplate_GET_LIST_OPS_NAME);
                                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                                    IFile tmpFile = null;
                                    try {
                                        tmpFile = PDFileSystemUtil.getTempFile((String)"FM");
                                        Result listResult = session.getCompilerListing(howIsGoing, tmpFile);
                                        if (listResult.getRC() == 0) {
                                            PDEditorManagement.openEditorFromWorkerThread((IFile)tmpFile, (IHowIsGoing)howIsGoing);
                                        } else {
                                            PDDialogs.openErrorThreadSafe((String)Messages.OpenAsTemplate_GET_LIST_ERR, (String)listResult.getMessagesCombined().toString());
                                        }
                                    }
                                    catch (CoreException e) {
                                        String errMsg = Messages.OpenAsTemplate_GET_LIST_ERR;
                                        PDDialogs.openErrorThreadSafe((String)errMsg);
                                        logger.error((Object)errMsg, (Throwable)e);
                                    }
                                }
                            });
                        }
                        catch (InvocationTargetException e) {
                            String errMsg = Messages.OpenAsTemplate_GET_LIST_ERR;
                            PDDialogs.openErrorThreadSafe((String)errMsg);
                            logger.error((Object)errMsg, (Throwable)e);
                            session.unlock();
                        }
                        catch (InterruptedException e1) {
                            PDDialogs.openInfoThreadSafe((String)Messages.TemplateEditorAction_LISTING_CANCEL);
                            session.unlock();
                        }
                    }
                };
                String errMsg = MessageFormat.format(Messages.TemplateEditorAction_COMPILE_ERR, templateResource.getFormattedName());
                PDDialogs.openErrorThreadSafe((String)Messages.FMPlugin_ERROR_TITLE, (String)errMsg, (String)overallResult.getMessagesCombined().toString(), (String[])new String[]{Messages.OpenAsTemplate_GET_LIST}, (PDDialogWithText.ITextDialogRunnable[])new PDDialogWithText.ITextDialogRunnable[]{action});
                if (releaseSession) {
                    TemplateEditorUtilities.end(session);
                }
            }
        });
    }

    private TemplateType constructDynamicTemplate() {
        TemplateType template = TemplateFactory.eINSTANCE.createTemplateType();
        template.setType("DYNAMIC");
        if (this.modelTemplate == null) {
            Layouttype layout = TemplateFactory.eINSTANCE.createLayouttype();
            layout.setId(1);
            template.getLayout().add((Object)layout);
            Symboltype symbol01 = TemplateFactory.eINSTANCE.createSymboltype();
            symbol01.setLvl(1);
            symbol01.setName("DYN01");
            symbol01.setRef(2);
            symbol01.setType(TypeType.AN);
            symbol01.setStart(1);
            symbol01.setLength(1);
            symbol01.setSeglen(false);
            layout.getSymbol().add((Object)symbol01);
            return template;
        }
        int i = 0;
        while (i < this.modelTemplate.getLayout().size()) {
            this.constructDynamicTemplate(template, (Layouttype)this.modelTemplate.getLayout().get(i));
            if (this.modelTemplate.isFmix()) {
                template.setFmix(true);
            }
            ++i;
        }
        return template;
    }

    private void constructDynamicTemplate(TemplateType aTemplate, Layouttype aLayout) {
        Layouttype layout = TemplateFactory.eINSTANCE.createLayouttype();
        aTemplate.getLayout().add((Object)layout);
        Symboltype symbol01 = TemplateFactory.eINSTANCE.createSymboltype();
        symbol01.setLvl(1);
        if (aLayout != null && aLayout.getSymbol().size() > 0) {
            symbol01.setName(((Symboltype)aLayout.getSymbol().get(0)).getName(this.aHost));
        } else {
            symbol01.setName("DYN01");
        }
        symbol01.setRef(2);
        symbol01.setType(TypeType.AN);
        symbol01.setStart(1);
        symbol01.setLength(1);
        symbol01.setSeglen(false);
        layout.getSymbol().add((Object)symbol01);
        if (aLayout != null) {
            int currentRef = 3;
            int finalLen = 1;
            for (Symboltype s : aLayout.getSymbol()) {
                if (s.getLvl() == 1) continue;
                Symboltype symbol = TemplateFactory.eINSTANCE.createSymboltype();
                symbol.setLvl(2);
                symbol.setName(s.getName(this.aHost));
                symbol.setRef(currentRef);
                symbol.setType(s.getType());
                symbol.setStart(s.getStart());
                symbol.setLength(s.getLength());
                symbol.setSeglen(false);
                layout.getSymbol().add((Object)symbol);
                finalLen = Math.max(finalLen, symbol.getStart() + symbol.getLength() - 1);
                ++currentRef;
            }
            symbol01.setLength(finalLen);
        }
    }

    public static IZRL showCreateTemplateWizard(BaseEditorOptions option, IPDHost system) {
        NewDynamicTemplateDialog dialog = new NewDynamicTemplateDialog(system, null);
        IZRL newTemplateResource = null;
        if (dialog.open() == 0) {
            TemplateType newDynamicTemplate = dialog.getNewTemplateContents();
            newTemplateResource = dialog.getNewTemplateName();
            CreateTemplate.createNewTemplate(newTemplateResource, newDynamicTemplate, option);
        }
        return newTemplateResource;
    }
}

