/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.template.TemplateLayoutComposite;
import com.ibm.etools.fm.editor.template.dialogs.LayoutSelectionTableLabelProvider;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class LayoutSelectionDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private IZRL templateResource = null;
    private List<Layouttype> layouts = null;
    private int invalidLayoutIndex = -1;
    private Combo templateLayoutCombo = null;
    private Table layoutTable = null;
    private TableViewer layoutTableViewer = null;
    private int selectedLayoutIndex = 0;

    public LayoutSelectionDialog(IZRL templateResource, List<Layouttype> layouts, int invalidLayoutIndex) {
        this.templateResource = templateResource;
        this.layouts = layouts;
        this.invalidLayoutIndex = invalidLayoutIndex;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.TM_LAYOUT_SEL_DIALOG_TITLE);
        this.setMessage(Messages.TM_LAYOUT_SEL_DIALOG_DESC);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        this.createToGroup(composite);
        this.templateLayoutCombo.select(0);
        this.layoutTableViewer.setInput((Object)this.layouts.get(0).getSymbol());
        this.isComplete();
        this.templateLayoutCombo.setFocus();
        return composite;
    }

    private void createToGroup(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)composite, (String)Messages.TM_LAYOUT_SEL_DIALOG_TEMPLATE, (Object)GUI.grid.d.left1(), (int)16384);
        Text templateNameText = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        templateNameText.setText(this.templateResource.getFormattedName());
        GUI.label((Composite)composite, (String)Messages.TM_LAYOUT_SEL_DIALOG_LAYOUT, (Object)GUI.grid.d.left1(), (int)16384);
        this.templateLayoutCombo = GUI.combo.readOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1), (Object[])TemplateLayoutComposite.getLayoutNames(this.layouts, this.templateResource.getSystem()));
        this.templateLayoutCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LayoutSelectionDialog.this.selectedLayoutIndex = LayoutSelectionDialog.this.templateLayoutCombo.getSelectionIndex();
                LayoutSelectionDialog.this.layoutTableViewer.setInput((Object)LayoutSelectionDialog.this.layouts.get(LayoutSelectionDialog.this.selectedLayoutIndex).getSymbol());
                LayoutSelectionDialog.this.isComplete();
            }
        });
        this.layoutTable = new Table(parent, 2820);
        this.layoutTable.setHeaderVisible(true);
        this.layoutTable.setLinesVisible(true);
        this.layoutTable.setLayoutData((Object)GUI.grid.d.fillAll());
        this.layoutTableViewer = new TableViewer(this.layoutTable);
        this.layoutTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.createMappingTableColumns(this.layoutTableViewer);
    }

    private void createMappingTableColumns(TableViewer viewer) {
        FormattedEditorUtility.createTableViewerColumn(Messages.TM_LEVEL_COLUMN, 60, viewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.TM_FIELD_COLUMN, 300, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TM_TYPE_COLUMN, 80, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TM_LEN_COLUMN, 80, viewer, 131072);
        viewer.setLabelProvider((IBaseLabelProvider)new LayoutSelectionTableLabelProvider(this.templateResource));
    }

    public int getSelectedLayoutIndex() {
        return this.selectedLayoutIndex;
    }

    public boolean isComplete() {
        boolean isComplete = this.invalidLayoutIndex == -1 || this.templateLayoutCombo.getSelectionIndex() != this.invalidLayoutIndex;
        this.setComplete(isComplete);
        return isComplete;
    }
}

