/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.template.TemplateEditor;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;

public class LayoutAssistProposalProvider
extends SimpleContentProposalProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private Layouttype currentLayout;
    private IZRL aTemplate = null;

    public LayoutAssistProposalProvider(Layouttype currentLayout, IZRL aTemplate) {
        super(LayoutAssistProposalProvider.getSymbols(currentLayout, aTemplate));
        this.currentLayout = currentLayout;
        this.aTemplate = aTemplate;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        ArrayList<SymbolContentProposal> list = new ArrayList<SymbolContentProposal>();
        String prefix = LayoutAssistProposalProvider.getPrefix(contents, position);
        int i = 0;
        while (i < this.currentLayout.getSymbol().size()) {
            Symboltype aSymbol = (Symboltype)this.currentLayout.getSymbol().get(i);
            String refName = TemplateEditor.getFieldReferenceNumberForDisplay(this.currentLayout, aSymbol, true);
            if (refName.startsWith(prefix)) {
                list.add(new SymbolContentProposal(this.currentLayout, (Symboltype)this.currentLayout.getSymbol().get(i), position, prefix, this.aTemplate));
            }
            ++i;
        }
        IContentProposal[] proposals = new SymbolContentProposal[list.size()];
        int i2 = 0;
        while (i2 < list.size()) {
            proposals[i2] = (SymbolContentProposal)list.get(i2);
            ++i2;
        }
        return proposals;
    }

    private static String getPrefix(String contents, int position) {
        Object prefix = "";
        int i = position;
        while (i != 0) {
            char c = contents.charAt(i - 1);
            if (c == ' ') {
                return prefix;
            }
            prefix = c + (String)prefix;
            --i;
        }
        return prefix;
    }

    private static String[] getSymbols(Layouttype aLayout, IZRL aTemplate) {
        String[] symbols = new String[aLayout.getSymbol().size()];
        int i = 0;
        while (i < aLayout.getSymbol().size()) {
            Symboltype aSymbol = (Symboltype)aLayout.getSymbol().get(i);
            symbols[i] = TemplateEditor.getFieldReferenceNumberForDisplay(aLayout, aSymbol, true) + ": " + aSymbol.getName(aTemplate != null ? aTemplate.getSystem() : null);
            ++i;
        }
        return symbols;
    }

    public void changeLayout(Layouttype newLayout) {
        this.currentLayout = newLayout;
        this.setProposals(LayoutAssistProposalProvider.getSymbols(this.currentLayout, this.aTemplate));
    }

    private static class SymbolContentProposal
    implements IContentProposal {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private Layouttype aLayout;
        private Symboltype aSymbol = null;
        private int cursorPosition = 0;
        private int selectedItemLength = 0;
        private String prefix = "";
        private IZRL aTemplate = null;

        public SymbolContentProposal(Layouttype aLayout, Symboltype aSymbol, int cursorPosition, String prefix, IZRL aTemplate) {
            this.aLayout = aLayout;
            this.aSymbol = aSymbol;
            this.cursorPosition = cursorPosition;
            this.prefix = prefix;
            this.aTemplate = aTemplate;
        }

        public String getContent() {
            String value = TemplateEditor.getFieldReferenceNumberForDisplay(this.aLayout, this.aSymbol, true);
            value = value.substring(this.prefix.length());
            this.selectedItemLength = value.length();
            return value;
        }

        public int getCursorPosition() {
            return this.cursorPosition + this.selectedItemLength;
        }

        public String getDescription() {
            StringBuffer sb = new StringBuffer();
            sb.append(MessageFormat.format(Messages.LayoutAssistProposalProvider_REF_COLUMN, TemplateEditor.getFieldReferenceNumberForDisplay(this.aLayout, this.aSymbol, true)) + "\n");
            sb.append(MessageFormat.format(Messages.LayoutAssistProposalProvider_LEVEL_COLUMN, this.aSymbol.getLvl()) + "\n");
            sb.append(MessageFormat.format(Messages.LayoutAssistProposalProvider_FIELD_COLUMN, this.aSymbol.getName(this.aTemplate != null ? this.aTemplate.getSystem() : null)) + "\n");
            sb.append(MessageFormat.format(Messages.LayoutAssistProposalProvider_TYPE_COLUMN, this.aSymbol.getType().getLiteral()) + "\n");
            sb.append(MessageFormat.format(Messages.LayoutAssistProposalProvider_START_COLUMN, this.aSymbol.getStart()) + "\n");
            sb.append(MessageFormat.format(Messages.LayoutAssistProposalProvider_LEN_COLUMN, this.aSymbol.getLength()) + "\n");
            return sb.toString();
        }

        public String getLabel() {
            return TemplateEditor.getFieldReferenceNumberForDisplay(this.aLayout, this.aSymbol, true) + ": " + this.aSymbol.getName(this.aTemplate != null ? this.aTemplate.getSystem() : null);
        }
    }
}

