/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionTemplate;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.template.TemplateEditor;
import com.ibm.etools.fm.editor.template.TemplateEditorUtilities;
import com.ibm.etools.fm.editor.template.dialogs.FreeCriteriaEntryDialogTableLabelProvider;
import com.ibm.etools.fm.editor.template.dialogs.LayoutAssistProposalProvider;
import com.ibm.etools.fm.model.template.Criteriatype;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateFactory;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.TypeType1;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class FreeCriteriaEntryDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private Text criteriaEntryText = null;
    private Text templateNameText = null;
    private Text templateLayoutText = null;
    private Text templateSearchText = null;
    private Text ridLayoutText = null;
    private Button ridOrButton = null;
    private Table layoutTable = null;
    private TableViewer layoutTableViewer = null;
    private LayoutAssistProposalProvider proposalProvider = null;
    private AbstractSessionTemplate session = null;
    private IZRL templateResource = null;
    private TemplateType currentTemplate = null;
    private int selectedLayoutIndex = 0;
    private int ridLayoutIndex = 0;
    private TypeType1 criteriaType = TypeType1.ID;
    private String criteriaExpressionString = null;
    private TemplateType templateWithNewCriteria = null;
    private int referenceId;

    public FreeCriteriaEntryDialog(AbstractSessionTemplate session, IZRL templateResource, TemplateType currentTemplate, int selectedLayoutIndex, TypeType1 criteriaType, int ridLayoutIndex, int referenceId) {
        this.session = session;
        this.templateResource = templateResource;
        this.currentTemplate = currentTemplate;
        this.selectedLayoutIndex = selectedLayoutIndex;
        this.criteriaType = criteriaType;
        this.ridLayoutIndex = ridLayoutIndex;
        this.referenceId = referenceId;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.FreeCriteriaEntryDialog_Title);
        this.setMessage(Messages.FreeCriteriaEntryDialog_Msg);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.createEntryTextComposite(composite);
        this.createLayoutComposite(composite);
        this.criteriaEntryText.setFocus();
        this.addContentProposal();
        return composite;
    }

    private void createEntryTextComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)composite, (String)Messages.FreeCriteriaEntryDialog_CriteriaEntryText, (Object)GUI.grid.d.left1(), (int)16384);
        this.criteriaEntryText = GUI.text.field((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        Criteriatype criteria = this.getCriteriaForEdit();
        if (criteria != null && criteria.getExp() != null && criteria.getExp().length() > 0) {
            this.criteriaEntryText.setText(criteria.getExp());
        }
    }

    private void addContentProposal() {
        Layouttype currentLayout = (Layouttype)this.currentTemplate.getLayout().get(this.selectedLayoutIndex);
        if (this.proposalProvider != null) {
            this.proposalProvider.changeLayout(currentLayout);
        } else {
            TextContentAdapter contentAdapter = new TextContentAdapter();
            this.proposalProvider = new LayoutAssistProposalProvider(currentLayout, this.templateResource);
            this.proposalProvider.setFiltering(true);
            KeyStroke ks = KeyStroke.getInstance((int)262144, (int)32);
            new ContentProposalAdapter((Control)this.criteriaEntryText, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)this.proposalProvider, ks, null);
        }
    }

    private void createLayoutComposite(Composite parent) {
        Group templateGroup = GUI.group((Composite)parent, (String)Messages.FreeCriteriaEntryDialog_LayoutInfoGroup, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Composite templateComposite = GUI.composite((Composite)templateGroup, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)templateComposite, (String)Messages.FreeCriteriaEntryDialog_TemplateName, (Object)GUI.grid.d.left1(), (int)16384);
        this.templateNameText = GUI.text.fieldReadOnly((Composite)templateComposite, (Object)GUI.grid.d.fillH((int)1));
        this.templateNameText.setText(this.templateResource.getFormattedName());
        GUI.label((Composite)templateComposite, (String)Messages.FreeCriteriaEntryDialog_Layout_name, (Object)GUI.grid.d.left1(), (int)16384);
        this.templateLayoutText = GUI.text.fieldReadOnly((Composite)templateComposite, (Object)GUI.grid.d.fillH((int)1));
        this.templateLayoutText.setText(((Symboltype)((Layouttype)this.currentTemplate.getLayout().get(this.selectedLayoutIndex)).getSymbol().get(0)).getName(this.session.getSystem()));
        if (this.criteriaType == TypeType1.RID) {
            GUI.label((Composite)templateComposite, (String)Messages.FreeCriteriaEntryDialog_0, (Object)GUI.grid.d.left1(), (int)16384);
            this.ridLayoutText = GUI.text.fieldReadOnly((Composite)templateComposite, (Object)GUI.grid.d.fillH((int)1));
            this.ridLayoutText.setText(((Symboltype)((Layouttype)this.currentTemplate.getLayout().get(this.ridLayoutIndex)).getSymbol().get(0)).getName(this.session.getSystem()));
            this.ridOrButton = GUI.button.checkbox((Composite)templateComposite, (String)Messages.ByFieldCriteriaSpecificationDialog_1, (Object)GUI.grid.d.fillH((int)2));
            this.ridOrButton.setToolTipText(Messages.ByFieldCriteriaSpecificationDialog_2);
            Criteriatype criteria = this.getCriteriaForEdit();
            if (criteria != null) {
                this.ridOrButton.setSelection(criteria.isSetOr() || criteria.isOr());
            }
        }
        GUI.label((Composite)templateComposite, (String)Messages.Locate, (Object)GUI.grid.d.left1(), (int)16384);
        this.templateSearchText = GUI.text.field((Composite)templateComposite, (Object)GUI.grid.d.fillH((int)1));
        this.templateSearchText.setMessage(Messages.Locate_Tooltip);
        this.templateSearchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FreeCriteriaEntryDialog.this.layoutTableViewer.setFilters(new ViewerFilter[]{TemplateEditorUtilities.createLocateFilter(FreeCriteriaEntryDialog.this.templateSearchText.getText())});
            }
        });
        GridData tableGridData = GUI.grid.d.fillAll();
        tableGridData.heightHint = 300;
        Composite tableComposite = GUI.composite((Composite)templateGroup, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)tableGridData);
        this.layoutTable = new Table(tableComposite, 68356);
        this.layoutTable.setHeaderVisible(true);
        this.layoutTable.setLinesVisible(true);
        this.layoutTable.setLayoutData((Object)GUI.grid.d.fillAll());
        this.layoutTableViewer = new TableViewer(this.layoutTable);
        this.layoutTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.createMappingTableColumns(this.layoutTableViewer);
        this.layoutTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                FreeCriteriaEntryDialog.this.insertSymbolToCriteriaEntryText();
            }
        });
        this.layoutTableViewer.setInput((Object)((Layouttype)this.currentTemplate.getLayout().get(this.selectedLayoutIndex)).getSymbol());
        this.layoutTable.select(0);
    }

    private void insertSymbolToCriteriaEntryText() {
        Layouttype aLayout = (Layouttype)this.currentTemplate.getLayout().get(this.selectedLayoutIndex);
        Symboltype aSymbol = (Symboltype)aLayout.getSymbol().get(this.layoutTable.getSelectionIndex());
        String value = TemplateEditor.getFieldReferenceNumberForDisplay(aLayout, aSymbol, true);
        String currentValue = this.criteriaEntryText.getText();
        int caretPos = this.criteriaEntryText.getCaretPosition();
        if (caretPos > -1 && caretPos < currentValue.length()) {
            String begin = currentValue.substring(0, caretPos);
            String end = currentValue.substring(caretPos);
            this.criteriaEntryText.setText(begin + value + end);
            this.criteriaEntryText.setSelection((begin + value).length(), (begin + value).length());
        } else {
            this.criteriaEntryText.append(value);
        }
    }

    private void createMappingTableColumns(TableViewer viewer) {
        FormattedEditorUtility.createTableViewerColumn("", 30, viewer, 0x1000000);
        FormattedEditorUtility.createTableViewerColumn(Messages.FreeCriteriaEntryDialog_REF_COLUMN, 60, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.FreeCriteriaEntryDialog_LEVEL_COLUMN, 60, viewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.FreeCriteriaEntryDialog_FIELD_COLUMN, 200, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.FreeCriteriaEntryDialog_TYPE_COLUMN, 80, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.FreeCriteriaEntryDialog_START_COLUMN, 80, viewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.FreeCriteriaEntryDialog_LEN_COLUMN, 80, viewer, 131072);
        viewer.setLabelProvider((IBaseLabelProvider)new FreeCriteriaEntryDialogTableLabelProvider((Layouttype)this.currentTemplate.getLayout().get(this.selectedLayoutIndex), this.templateResource));
    }

    protected void okPressed() {
        this.setErrorMessage(null);
        this.layoutTableViewer.resetFilters();
        if (!this.validateCriteria()) {
            this.criteriaEntryText.setFocus();
            return;
        }
        this.criteriaExpressionString = this.criteriaEntryText.getText().trim();
        super.okPressed();
    }

    public String getCriteriaExpression() {
        return this.criteriaExpressionString;
    }

    private boolean validateCriteria() {
        StringBuffer newTemplateContents;
        block12: {
            String criteriaExpression;
            block11: {
                try {
                    this.templateWithNewCriteria = null;
                    criteriaExpression = this.criteriaEntryText.getText().trim();
                    if (!criteriaExpression.isEmpty()) break block11;
                    this.setErrorMessage(Messages.FreeCriteriaEntryDialog_EmptyExpression);
                    return false;
                }
                catch (Exception e) {
                    String errMsg = MessageFormat.format(Messages.FreeCriteriaEntryDialog_ExceptionWhileValidation, this.templateResource.getFormattedName(), this.criteriaEntryText.getText().trim());
                    logger.error((Object)errMsg, (Throwable)e);
                    PDDialogs.openErrorThreadSafe((String)errMsg);
                    return false;
                }
            }
            TemplateType newTemplate = TemplateFactory.eINSTANCE.createTemplateType();
            if (this.currentTemplate.isSetSegmented() && this.currentTemplate.isSegmented()) {
                newTemplate.setSegmented(true);
            }
            Layouttype oldLayout = (Layouttype)this.currentTemplate.getLayout().get(this.selectedLayoutIndex);
            Layouttype newLayout = TemplateFactory.eINSTANCE.createLayouttype();
            newLayout.setId(oldLayout.getId());
            if (oldLayout.isSetOffset()) {
                newLayout.setOffset(oldLayout.getOffset());
            }
            newLayout.setSel(oldLayout.isSel());
            Criteriatype newCriteria = TemplateFactory.eINSTANCE.createCriteriatype();
            newCriteria.setType(this.criteriaType);
            newCriteria.setExp(criteriaExpression);
            newCriteria.setByfield(false);
            newLayout.getCriteria().add((Object)newCriteria);
            newTemplate.getLayout().add((Object)newLayout);
            if (this.criteriaType == TypeType1.RID) {
                newCriteria.setRelated01(((Layouttype)this.currentTemplate.getLayout().get(this.ridLayoutIndex)).getId());
                newCriteria.setOr(this.ridOrButton.getSelection());
            }
            if (this.criteriaType == TypeType1.RDF) {
                newCriteria.setFref(this.referenceId);
            }
            final StringBuffer xmlTemplate = TemplateSerializeUtils.save((TemplateType)newTemplate, (IZRL)this.templateResource);
            final Result result = new Result();
            newTemplateContents = new StringBuffer();
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.FreeCriteriaEntryDialog_CheckCriteriaWithHost, 1);
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        StringBuffer newXmlTemplate = FreeCriteriaEntryDialog.this.session.updateTemplate(xmlTemplate, howIsGoing, result, true, false);
                        newTemplateContents.append(newXmlTemplate);
                    }
                });
            }
            catch (Exception e) {
                String errMsg = MessageFormat.format(Messages.FreeCriteriaEntryDialog_ExceptionWhileValidation, this.templateResource.getFormattedName(), this.criteriaEntryText.getText().trim());
                logger.error((Object)errMsg, (Throwable)e);
                PDDialogs.openErrorThreadSafe((String)errMsg);
                return false;
            }
            if (result.isSuccessfulWithoutWarnings()) break block12;
            PDDialogs.openErrorThreadSafe((String)Messages.FreeCriteriaEntryDialog_CriteriaValidationErr, (String)result.dumpOutputAndMessages(true));
            this.setErrorMessage(Messages.FreeCriteriaEntryDialog_CriteriaValidationErrShort);
            return false;
        }
        this.templateWithNewCriteria = TemplateSerializeUtils.load((StringBuffer)newTemplateContents, (IZRL)this.templateResource);
        return true;
    }

    public TemplateType getTemplateWithNewCriteria() {
        return this.templateWithNewCriteria;
    }

    private Criteriatype getCriteriaForEdit() {
        for (Criteriatype ct : ((Layouttype)this.currentTemplate.getLayout().get(this.selectedLayoutIndex)).getCriteria()) {
            if (ct.getType() != this.criteriaType) continue;
            if (this.criteriaType == TypeType1.RID) {
                if (!ct.isSetRelated01() || ct.getRelated01() != ((Layouttype)this.currentTemplate.getLayout().get(this.ridLayoutIndex)).getId()) continue;
                return ct;
            }
            if (this.criteriaType == TypeType1.RDF) {
                if (ct.getFref() != this.referenceId) continue;
                return ct;
            }
            return ct;
        }
        return null;
    }
}

