/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.template.TemplateEditorUtilities;
import com.ibm.etools.fm.editor.template.dialogs.FieldSelectionDialogTableLabelProviderBase;
import com.ibm.etools.fm.editor.template.dialogs.FieldSelectionDialogTableLabelProviderDb2;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import java.util.Arrays;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class FieldSelectionDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private String toTemplateType;
    private IZRL toTemplateDS = null;
    private Layouttype toLayout = null;
    private int[] toSelectedFieldIndices = null;
    private String fromTemplateType;
    private IZRL fromTemplateDS = null;
    private Layouttype fromLayout = null;
    private Text toTemplateNameText = null;
    private Text toTemplateLayoutText = null;
    private Table toLayoutTable = null;
    private TableViewer toLayoutTableViewer = null;
    private Text fromTemplateNameText = null;
    private Text fromTemplateLayoutText = null;
    private Text fromTemplateSearchText = null;
    private Table fromLayoutTable = null;
    private TableViewer fromLayoutTableViewer = null;
    private Symboltype selectedSymbol = null;

    public FieldSelectionDialog(String toTemplateType, IZRL toTemplateDS, Layouttype toLayout, int[] toSelectedFieldIndices, String fromTemplateType, IZRL fromTemplateDS, Layouttype fromLayout) {
        this.toTemplateType = toTemplateType;
        this.toTemplateDS = toTemplateDS;
        this.toLayout = toLayout;
        this.toSelectedFieldIndices = Arrays.copyOf(toSelectedFieldIndices, toSelectedFieldIndices.length);
        this.fromTemplateType = fromTemplateType;
        this.fromTemplateDS = fromTemplateDS;
        this.fromLayout = fromLayout;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.TM_FIELD_SEL_DIALOG_TITLE);
        this.setMessage(Messages.TM_FIELD_SEL_DIALOG_DESC);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        this.createToGroup(composite);
        this.createMappingTableComposite(composite);
        this.populateTable(this.fromLayoutTableViewer, this.fromLayout, this.fromTemplateType);
        this.setComplete(false);
        return composite;
    }

    private void highlightFirstSelectedField(Layouttype layoutType) {
        for (Symboltype aSymbol : layoutType.getSymbol()) {
            if (!this.isSelected(aSymbol.getRef(), layoutType)) continue;
            int firstToSelected = layoutType.getSymbol().indexOf((Object)aSymbol);
            if (firstToSelected < 0 || firstToSelected > this.toLayoutTable.getItemCount()) break;
            this.toLayoutTable.setSelection(firstToSelected);
            break;
        }
    }

    private void createToGroup(Composite parent) {
        Group toGroup = GUI.group((Composite)parent, (String)Messages.TM_FIELD_SEL_DIALOG_TO_GROUP_NAME, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Composite toComposite = GUI.composite((Composite)toGroup, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)toComposite, (String)Messages.TM_FIELD_SEL_DIALOG_TO_TemplateName, (Object)GUI.grid.d.left1(), (int)16384);
        this.toTemplateNameText = GUI.text.fieldReadOnly((Composite)toComposite, (Object)GUI.grid.d.fillH((int)1));
        this.toTemplateNameText.setText(this.toTemplateDS.getFormattedName());
        GUI.label((Composite)toComposite, (String)Messages.TM_FIELD_SEL_DIALOG_TO_Layout_name, (Object)GUI.grid.d.left1(), (int)16384);
        this.toTemplateLayoutText = GUI.text.fieldReadOnly((Composite)toComposite, (Object)GUI.grid.d.fillH((int)1));
        this.toTemplateLayoutText.setText(((Symboltype)this.toLayout.getSymbol().get(0)).getName(this.toTemplateDS.getSystem()));
        this.toLayoutTable = new Table((Composite)toGroup, 2816);
        this.toLayoutTable.setHeaderVisible(true);
        this.toLayoutTable.setLinesVisible(true);
        GridData data = GUI.grid.d.fillAll();
        data.heightHint = 100;
        this.toLayoutTable.setLayoutData((Object)data);
        this.toLayoutTableViewer = new TableViewer(this.toLayoutTable);
        this.toLayoutTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.createMappingTableColumns(this.toLayoutTableViewer, this.toTemplateType);
        this.populateTable(this.toLayoutTableViewer, this.toLayout, this.toTemplateType);
        this.highlightFirstSelectedField(this.toLayout);
    }

    private void createMappingTableComposite(Composite parent) {
        Group fromGroup = GUI.group((Composite)parent, (String)Messages.TM_FIELD_SEL_DIALOG_FROM_GROUP_NAME, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Composite fromComposite = GUI.composite((Composite)fromGroup, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)fromComposite, (String)Messages.TM_FIELD_SEL_DIALOG_TO_TemplateName, (Object)GUI.grid.d.left1(), (int)16384);
        this.fromTemplateNameText = GUI.text.fieldReadOnly((Composite)fromComposite, (Object)GUI.grid.d.fillH((int)1));
        this.fromTemplateNameText.setText(this.fromTemplateDS.getFormattedName());
        GUI.label((Composite)fromComposite, (String)Messages.TM_FIELD_SEL_DIALOG_TO_Layout_name, (Object)GUI.grid.d.left1(), (int)16384);
        this.fromTemplateLayoutText = GUI.text.fieldReadOnly((Composite)fromComposite, (Object)GUI.grid.d.fillH((int)1));
        this.fromTemplateLayoutText.setText(((Symboltype)this.fromLayout.getSymbol().get(0)).getName(this.fromTemplateDS.getSystem()));
        this.fromLayoutTable = new Table((Composite)fromGroup, 68356);
        this.fromLayoutTable.setHeaderVisible(true);
        this.fromLayoutTable.setLinesVisible(true);
        GridData data = GUI.grid.d.fillAll();
        data.heightHint = 100;
        this.fromLayoutTable.setLayoutData((Object)data);
        this.fromLayoutTableViewer = new TableViewer(this.fromLayoutTable);
        this.fromLayoutTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        GUI.label((Composite)fromComposite, (String)Messages.Locate, (Object)GUI.grid.d.left1(), (int)16384);
        this.fromTemplateSearchText = GUI.text.field((Composite)fromComposite, (Object)GUI.grid.d.fillH((int)1));
        this.fromTemplateSearchText.setMessage(Messages.Locate_Tooltip);
        this.fromTemplateSearchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FieldSelectionDialog.this.fromLayoutTableViewer.setFilters(new ViewerFilter[]{TemplateEditorUtilities.createLocateFilter(FieldSelectionDialog.this.fromTemplateSearchText.getText())});
            }
        });
        this.createMappingTableColumns(this.fromLayoutTableViewer, this.fromTemplateType);
        this.fromLayoutTable.setFocus();
        this.fromLayoutTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectedIndex = FieldSelectionDialog.this.fromLayoutTable.getSelectionIndex();
                if (selectedIndex <= FieldSelectionDialog.this.fromLayout.getSymbol().size()) {
                    FieldSelectionDialog.this.setComplete(true);
                }
            }
        });
    }

    private void createMappingTableColumns(TableViewer viewer, String templateType) {
        if ("BASE".equals(templateType) || "DYNAMIC".equals(templateType)) {
            FieldSelectionDialog.createMappingTableColumnsForBase(viewer);
        } else if (templateType.equals("DB2")) {
            FieldSelectionDialog.createMappingTableColumnsForDb2(viewer);
        } else {
            logger.error((Object)("Unknown FROM template type: " + this.toTemplateType));
            FieldSelectionDialog.createMappingTableColumnsForBase(viewer);
        }
    }

    protected void okPressed() {
        this.fromLayoutTableViewer.resetFilters();
        this.selectedSymbol = (Symboltype)this.fromLayout.getSymbol().get(this.fromLayoutTable.getSelectionIndex());
        super.okPressed();
    }

    private static void createMappingTableColumnsForBase(TableViewer viewer) {
        FormattedEditorUtility.createTableViewerColumn("", 30, viewer, 0x1000000);
        FormattedEditorUtility.createTableViewerColumn(Messages.TM_LEVEL_COLUMN, 60, viewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.TM_FIELD_COLUMN, 300, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TM_TYPE_COLUMN, 80, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TM_LEN_COLUMN, 80, viewer, 131072);
    }

    private static void createMappingTableColumnsForDb2(TableViewer viewer) {
        FormattedEditorUtility.createTableViewerColumn("", 30, viewer, 0x1000000);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_COLUMN_NUMBER, 60, viewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_COLUMN_NAME, 200, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TM_TYPE_COLUMN, 300, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn("", 10, viewer, 131072);
    }

    private void populateTable(TableViewer aTableViewer, Layouttype aLayout, String layoutType) {
        if ("BASE".equals(layoutType) || "DYNAMIC".equals(layoutType)) {
            this.populateTableBase(aTableViewer, aLayout);
        } else if (layoutType.equals("DB2")) {
            this.populateTableDB2(aTableViewer, aLayout);
        } else {
            logger.error((Object)("Unknown template type: " + layoutType));
            this.populateTableBase(aTableViewer, aLayout);
        }
    }

    private void populateTableBase(TableViewer aTableViewer, Layouttype aLayout) {
        aTableViewer.setLabelProvider((IBaseLabelProvider)new FieldSelectionDialogTableLabelProviderBase(aTableViewer, aLayout, aTableViewer == this.toLayoutTableViewer, this.toSelectedFieldIndices, this.toTemplateDS));
        aTableViewer.setInput((Object)aLayout.getSymbol());
    }

    private void populateTableDB2(TableViewer aTableViewer, Layouttype aLayout) {
        aTableViewer.setLabelProvider((IBaseLabelProvider)new FieldSelectionDialogTableLabelProviderDb2(aTableViewer, aLayout, aTableViewer == this.toLayoutTableViewer, this.toSelectedFieldIndices, this.toTemplateDS));
        aTableViewer.setInput((Object)aLayout.getSymbol());
    }

    private boolean isSelected(int currentRef, Layouttype aLayout) {
        int i = 0;
        while (i < this.toSelectedFieldIndices.length) {
            if (currentRef == ((Symboltype)aLayout.getSymbol().get(this.toSelectedFieldIndices[i])).getRef()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Symboltype getSelectedSymbol() {
        return this.selectedSymbol;
    }
}

