/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.model.template.CreateType;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Lenfldtype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateFactory;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class FieldAttributeDialogUseAttributeComposite {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int HEADING_MAXLEN = 20;
    private TabItem useAttriTab;
    private Combo headingCombo;
    private Combo outputWidthCombo;
    private Button leadingZeroButton;
    private TemplateType aTemplate;
    private Layouttype selectedLayout;
    private int symbolIndex = 0;
    private Button notLengthFieldButton;
    private Button inclusiveLengthFieldButton;
    private Button exclusiveLengthFieldButton;

    public FieldAttributeDialogUseAttributeComposite(TemplateType aTemplate, Layouttype selectedLayout, int symbolIndex) {
        this.aTemplate = aTemplate;
        this.selectedLayout = selectedLayout;
        this.symbolIndex = symbolIndex;
    }

    public void createUseAttributeTab(TabFolder tabFolder) {
        this.useAttriTab = new TabItem(tabFolder, 0);
        this.useAttriTab.setText(Messages.FieldAttributeDialog_UseAttrGroupName);
        Composite composite = GUI.composite((Composite)tabFolder, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)composite, (String)Messages.FieldAttributeDialog_UseAttrHeading, (Object)GUI.grid.d.left1());
        this.headingCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.headingCombo, this.getClass().getCanonicalName() + "headingValue");
        this.headingCombo.setTextLimit(20);
        GUI.label.left((Composite)composite, (String)Messages.FieldAttributeDialog_UseAttrOutputWidth, (Object)GUI.grid.d.left1());
        this.outputWidthCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.outputWidthCombo, this.getClass().getCanonicalName() + "outputWidth");
        NumberForcer.addTo(this.outputWidthCombo, this.getClass().getCanonicalName() + "outputWidth");
        CreateType type = ((Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex)).getCreate();
        if (type == CreateType.NU) {
            this.leadingZeroButton = GUI.button.checkbox((Composite)composite, (String)Messages.FieldAttributeDialog_UseAttrLeadingZero, (Object)GUI.grid.d.fillH((int)2));
        }
        this.createLengthFieldComposite(composite);
        this.useAttriTab.setControl((Control)composite);
        this.setUseAttributeValues();
    }

    private void createLengthFieldComposite(Composite parent) {
        if (!this.aTemplate.isSetSegmented() || !this.aTemplate.isSegmented()) {
            return;
        }
        Symboltype aSymbol = (Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex);
        if (!aSymbol.isSeglen()) {
            return;
        }
        Group lenGroup = GUI.group((Composite)parent, (String)Messages.FieldAttributeDialog_UseLenFieldGroup, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)2));
        this.notLengthFieldButton = GUI.button.radio((Composite)lenGroup, (String)Messages.FieldAttributeDialog_NotLenField, (Object)GUI.grid.d.left1());
        this.inclusiveLengthFieldButton = GUI.button.radio((Composite)lenGroup, (String)Messages.FieldAttributeDialog_InclusiveLenField, (Object)GUI.grid.d.left1());
        this.exclusiveLengthFieldButton = GUI.button.radio((Composite)lenGroup, (String)Messages.FieldAttributeDialog_ExclusiveLenField, (Object)GUI.grid.d.left1());
    }

    private void setUseAttributeValues() {
        CreateType type;
        Symboltype aSymbol = (Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex);
        if (aSymbol.getHeading() != null) {
            this.headingCombo.setText(aSymbol.getHeading());
        }
        if (aSymbol.isSetWidth()) {
            this.outputWidthCombo.setText("" + aSymbol.getWidth());
        }
        if ((type = ((Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex)).getCreate()) == CreateType.NU && aSymbol.isSetLzero()) {
            this.leadingZeroButton.setSelection(aSymbol.isLzero());
        }
        if (!(this.aTemplate.isSetSegmented() && this.aTemplate.isSegmented() && aSymbol.isSeglen())) {
            return;
        }
        Lenfldtype lenField = aSymbol.getLenfld();
        if (lenField != null) {
            if (lenField.isExcl()) {
                this.notLengthFieldButton.setSelection(false);
                this.exclusiveLengthFieldButton.setSelection(true);
                this.inclusiveLengthFieldButton.setSelection(false);
            } else {
                this.notLengthFieldButton.setSelection(false);
                this.exclusiveLengthFieldButton.setSelection(false);
                this.inclusiveLengthFieldButton.setSelection(true);
            }
        } else {
            this.notLengthFieldButton.setSelection(true);
            this.exclusiveLengthFieldButton.setSelection(false);
            this.inclusiveLengthFieldButton.setSelection(false);
        }
    }

    public boolean validateFields() {
        return true;
    }

    public boolean updateAndFinish() {
        if (!this.validateFields()) {
            return false;
        }
        Symboltype aSymbol = (Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex);
        if (!this.headingCombo.getText().trim().isEmpty()) {
            aSymbol.setHeading(this.headingCombo.getText().trim());
        } else {
            aSymbol.setHeading("");
        }
        if (!this.outputWidthCombo.getText().trim().isEmpty()) {
            aSymbol.setWidth(Integer.parseInt(this.outputWidthCombo.getText().trim()));
        } else {
            aSymbol.setWidth(0);
        }
        CreateType type = ((Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex)).getCreate();
        if (type == CreateType.NU) {
            aSymbol.setLzero(this.leadingZeroButton.getSelection());
        }
        if (!(this.aTemplate.isSetSegmented() && this.aTemplate.isSegmented() && aSymbol.isSeglen())) {
            return true;
        }
        Lenfldtype lenField = aSymbol.getLenfld();
        if (lenField == null) {
            lenField = TemplateFactory.eINSTANCE.createLenfldtype();
            aSymbol.setLenfld(lenField);
        }
        if (this.exclusiveLengthFieldButton.getSelection()) {
            lenField.setExcl(true);
        } else if (this.inclusiveLengthFieldButton.getSelection()) {
            lenField.setExcl(false);
        } else {
            lenField.unsetExcl();
        }
        return true;
    }
}

