/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.editor.template.dialogs.EditScrambleValuesDialog;
import com.ibm.etools.fm.editor.template.dialogs.FieldAttributeDialog;
import com.ibm.etools.fm.model.template.CreateType;
import com.ibm.etools.fm.model.template.Exitprogtype;
import com.ibm.etools.fm.model.template.Rangetype;
import com.ibm.etools.fm.model.template.Scrambletype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateFactory;
import com.ibm.etools.fm.model.template.Translatetype;
import com.ibm.etools.fm.model.template.Valuetype;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.callback.ISelectedValueFormatter;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.dialog.lookup.filter.ILookupFilterProvider;
import com.ibm.etools.fm.ui.util.ZrlLoaderDialogUtils;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.etools.fm.ui.widget.ResourceContentProposals;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.text.MessageFormat;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class FieldAttributeDialogScrambleComposite {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int INDENT = 20;
    private static final int PROGRAMNAME_LEN = 8;
    private static final int PARAMETERS_LEN = 79;
    private TabItem scrambleAttrTab;
    private Button scrambleTypeNoneButton;
    private Button scrambleTypeRandomButton;
    private Button scrambleTypeRepeatableButton;
    private Button scrambleTypeTranslateButton;
    private Button scrambleTypeExitButton;
    private Button scrambleTypeODPPButton;
    private Composite stackComposite;
    private StackLayout stackLayout;
    private Composite noneComposite;
    private Composite randomRepeatableComposite;
    private Composite translateComposite;
    private Composite exitComposite;
    private Composite ODPPComposite;
    private Button randRepProvideValues;
    private Button randRepProvideViaDS;
    private Button randRepProvideViaList;
    private Button randRepProvideViaRange;
    private Text randRepOutputFieldStartColumn;
    private Combo randRepValuesDataSet;
    private Button randRepBrowse;
    private List randRepValuesList;
    private Button randRepEdit;
    private Text minRangeText;
    private Text maxRangeText;
    private Text translateInputFieldStartColumn;
    private Text translateOutputFieldStartColumn;
    private Combo translateValuesDataSet;
    private Combo exitProgramName;
    private Combo exitParameters;
    private Text ODPPCommand;
    private FieldAttributeDialog dialog;
    private int symbolIndex = 0;

    public FieldAttributeDialogScrambleComposite(FieldAttributeDialog dialog, int symbolIndex) {
        this.dialog = dialog;
        this.symbolIndex = symbolIndex;
    }

    public void createComposite(TabFolder tabFolder) {
        this.scrambleAttrTab = new TabItem(tabFolder, 0);
        this.scrambleAttrTab.setText(Messages.FieldAttributeDialog_ScrambleAttrGroupName);
        Composite composite = GUI.composite((Composite)tabFolder, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillH((int)1));
        this.createScrambleTypeComposite(composite);
        this.stackComposite = GUI.composite((Composite)composite, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stackLayout);
        this.noneComposite = FieldAttributeDialogScrambleComposite.createNoneComposite(this.stackComposite);
        this.randomRepeatableComposite = this.createRandomRepeatableComposite(this.stackComposite);
        this.translateComposite = this.createTranslateComposite(this.stackComposite);
        this.exitComposite = this.createExitComposite(this.stackComposite);
        this.ODPPComposite = this.createODPPComposite(this.stackComposite);
        this.stackLayout.topControl = this.noneComposite;
        this.scrambleAttrTab.setControl((Control)composite);
        this.initialiseValues();
    }

    private void createScrambleTypeComposite(Composite parent) {
        Group scrambleTypeGroup = GUI.group((Composite)parent, (String)Messages.FieldAttributeDialog_ScrambleAttrGroupName, (Layout)GUI.grid.l.noMargins((int)6, (boolean)true), (Object)GUI.grid.d.fillH((int)1));
        this.scrambleTypeNoneButton = GUI.button.radio((Composite)scrambleTypeGroup, (String)Messages.FieldAttributeDialog_ScrambleAttrNone, (Object)GUI.grid.d.left1());
        this.scrambleTypeNoneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FieldAttributeDialogScrambleComposite.this.scrambleTypeNoneButton.getSelection()) {
                    FieldAttributeDialogScrambleComposite.this.stackLayout.topControl = FieldAttributeDialogScrambleComposite.this.noneComposite;
                    FieldAttributeDialogScrambleComposite.this.stackComposite.layout();
                }
            }
        });
        this.scrambleTypeRandomButton = GUI.button.radio((Composite)scrambleTypeGroup, (String)Messages.FieldAttributeDialog_ScrambleAttrRandom, (Object)GUI.grid.d.left1());
        this.scrambleTypeRandomButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FieldAttributeDialogScrambleComposite.this.scrambleTypeRandomButton.getSelection()) {
                    FieldAttributeDialogScrambleComposite.this.stackLayout.topControl = FieldAttributeDialogScrambleComposite.this.randomRepeatableComposite;
                    if (FieldAttributeDialogScrambleComposite.this.randRepProvideValues != null && !FieldAttributeDialogScrambleComposite.this.randRepProvideValues.isDisposed()) {
                        FieldAttributeDialogScrambleComposite.this.enableRandomRepeatableControls(FieldAttributeDialogScrambleComposite.this.randRepProvideValues.getSelection());
                        FieldAttributeDialogScrambleComposite.this.stackComposite.layout();
                    }
                }
            }
        });
        this.scrambleTypeRepeatableButton = GUI.button.radio((Composite)scrambleTypeGroup, (String)Messages.FieldAttributeDialog_ScrambleAttrRepeatable, (Object)GUI.grid.d.left1());
        this.scrambleTypeRepeatableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FieldAttributeDialogScrambleComposite.this.scrambleTypeRepeatableButton.getSelection()) {
                    FieldAttributeDialogScrambleComposite.this.stackLayout.topControl = FieldAttributeDialogScrambleComposite.this.randomRepeatableComposite;
                    if (FieldAttributeDialogScrambleComposite.this.randRepProvideValues != null && !FieldAttributeDialogScrambleComposite.this.randRepProvideValues.isDisposed()) {
                        FieldAttributeDialogScrambleComposite.this.enableRandomRepeatableControls(FieldAttributeDialogScrambleComposite.this.randRepProvideValues.getSelection());
                        FieldAttributeDialogScrambleComposite.this.stackComposite.layout();
                    }
                }
            }
        });
        this.scrambleTypeTranslateButton = GUI.button.radio((Composite)scrambleTypeGroup, (String)Messages.FieldAttributeDialog_ScrambleAttrTranslate, (Object)GUI.grid.d.left1());
        this.scrambleTypeTranslateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FieldAttributeDialogScrambleComposite.this.scrambleTypeTranslateButton.getSelection()) {
                    FieldAttributeDialogScrambleComposite.this.stackLayout.topControl = FieldAttributeDialogScrambleComposite.this.translateComposite;
                    FieldAttributeDialogScrambleComposite.this.stackComposite.layout();
                }
            }
        });
        this.scrambleTypeExitButton = GUI.button.radio((Composite)scrambleTypeGroup, (String)Messages.FieldAttributeDialog_ScrambleAttrExit, (Object)GUI.grid.d.left1());
        this.scrambleTypeExitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FieldAttributeDialogScrambleComposite.this.scrambleTypeExitButton.getSelection()) {
                    FieldAttributeDialogScrambleComposite.this.stackLayout.topControl = FieldAttributeDialogScrambleComposite.this.exitComposite;
                    FieldAttributeDialogScrambleComposite.this.stackComposite.layout();
                }
            }
        });
        this.scrambleTypeODPPButton = GUI.button.radio((Composite)scrambleTypeGroup, (String)Messages.FieldAttributeDialog_ScrambleAttrODPP, (Object)GUI.grid.d.left1());
        this.scrambleTypeODPPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FieldAttributeDialogScrambleComposite.this.scrambleTypeODPPButton.getSelection()) {
                    FieldAttributeDialogScrambleComposite.this.stackLayout.topControl = FieldAttributeDialogScrambleComposite.this.ODPPComposite;
                    FieldAttributeDialogScrambleComposite.this.stackComposite.layout();
                }
            }
        });
        this.scrambleTypeODPPButton.setEnabled(this.dialog.getTemplate().isOdpp());
    }

    private static Composite createNoneComposite(Composite parent) {
        return GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
    }

    private Composite createRandomRepeatableComposite(Composite parent) {
        Composite container = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.randRepProvideValues = GUI.button.checkbox((Composite)container, (String)Messages.TemplateEditor_SCRAMBLE_VALUE, (Object)GUI.grid.d.left1());
        Composite valuesComposite = this.createRandomRepeatableValuesComposite(container);
        GridData gd = new GridData(1808);
        gd.horizontalIndent = 20;
        valuesComposite.setLayoutData((Object)gd);
        this.randRepProvideValues.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = FieldAttributeDialogScrambleComposite.this.randRepProvideValues.getSelection();
                FieldAttributeDialogScrambleComposite.this.enableRandomRepeatableControls(selected);
            }
        });
        return container;
    }

    private Composite createRandomRepeatableValuesComposite(Composite parent) {
        Composite valuesComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.randRepProvideViaDS = GUI.button.radio((Composite)valuesComposite, (String)Messages.TemplateEditor_SCRAMBLE_DS, (Object)GUI.grid.d.fillH((int)1));
        this.randRepProvideViaDS.setSelection(true);
        GridData indentCompGridData = GUI.grid.d.fillH((int)1);
        indentCompGridData.horizontalIndent = 20;
        Composite randRepDSContainer = GUI.composite((Composite)valuesComposite, (Layout)GUI.grid.l.noMargins((int)3, (boolean)false), (Object)indentCompGridData);
        GUI.label.left((Composite)randRepDSContainer, (String)Messages.TemplateEditor_SCRAMBLE_COLUMN_OUT, (Object)GUI.grid.d.left1());
        this.randRepOutputFieldStartColumn = GUI.text.field((Composite)randRepDSContainer, (Object)GUI.grid.d.fillH((int)2));
        NumberForcer.addTo(this.randRepOutputFieldStartColumn);
        GUI.label.left((Composite)randRepDSContainer, (String)Messages.TemplateEditor_SCRAMBLE_DSN, (Object)GUI.grid.d.left1());
        this.randRepValuesDataSet = GUI.combo.editable((Composite)randRepDSContainer, (Object)GUI.grid.d.fillH((int)1));
        ResourceContentProposals.addTo(this.randRepValuesDataSet, (IHostProvider)this.dialog.getTemplateResouce().getSystem(), this.getClass().getCanonicalName() + "randRepValuesDataSet", Member.class);
        this.randRepBrowse = LookupButton.createLookupResourceButtonLeft1(randRepDSContainer);
        this.randRepProvideViaList = GUI.button.radio((Composite)valuesComposite, (String)Messages.TemplateEditor_SCRAMBLE_LIST, (Object)GUI.grid.d.fillH((int)1));
        this.randRepProvideViaDS.setSelection(false);
        GridData indentListCompGridData = GUI.grid.d.fillAll();
        indentListCompGridData.horizontalIndent = 20;
        Composite randRepListComposite = GUI.composite((Composite)valuesComposite, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)indentListCompGridData);
        this.randRepValuesList = new List(randRepListComposite, 2564);
        GridData listData = GUI.grid.d.fillAll();
        this.randRepValuesList.setLayoutData((Object)listData);
        this.randRepEdit = GUI.button.push((Composite)randRepListComposite, (String)Messages.ScrambleValuesDialog_TITLE, (Object)GUI.grid.d.left1());
        this.randRepProvideViaDS.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FieldAttributeDialogScrambleComposite.this.randRepProvideViaDS.getSelection()) {
                    FieldAttributeDialogScrambleComposite.this.randRepOutputFieldStartColumn.setEnabled(true);
                    FieldAttributeDialogScrambleComposite.this.randRepValuesDataSet.setEnabled(true);
                    FieldAttributeDialogScrambleComposite.this.randRepBrowse.setEnabled(true);
                    FieldAttributeDialogScrambleComposite.this.randRepValuesList.setEnabled(false);
                    FieldAttributeDialogScrambleComposite.this.randRepEdit.setEnabled(false);
                    if (FieldAttributeDialogScrambleComposite.this.randRepProvideViaRange != null) {
                        FieldAttributeDialogScrambleComposite.this.minRangeText.setEnabled(false);
                        FieldAttributeDialogScrambleComposite.this.maxRangeText.setEnabled(false);
                    }
                }
            }
        });
        this.randRepProvideViaList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FieldAttributeDialogScrambleComposite.this.randRepProvideViaList.getSelection()) {
                    FieldAttributeDialogScrambleComposite.this.randRepOutputFieldStartColumn.setEnabled(false);
                    FieldAttributeDialogScrambleComposite.this.randRepValuesDataSet.setEnabled(false);
                    FieldAttributeDialogScrambleComposite.this.randRepBrowse.setEnabled(false);
                    FieldAttributeDialogScrambleComposite.this.randRepValuesList.setEnabled(true);
                    FieldAttributeDialogScrambleComposite.this.randRepEdit.setEnabled(true);
                    if (FieldAttributeDialogScrambleComposite.this.randRepProvideViaRange != null) {
                        FieldAttributeDialogScrambleComposite.this.minRangeText.setEnabled(false);
                        FieldAttributeDialogScrambleComposite.this.maxRangeText.setEnabled(false);
                    }
                }
            }
        });
        LookupDialogFactory.defaults(this.randRepBrowse, this.randRepValuesDataSet, (IHostProvider)this.dialog.getTemplateResouce()).types(DataSet.class, Member.class).filter(new ILookupFilterProvider(){

            @Override
            public String getInitialFilter(Combo combo2) {
                return combo2.getText().trim();
            }
        }).create();
        this.randRepEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditScrambleValuesDialog dlg = new EditScrambleValuesDialog(Display.getCurrent().getActiveShell(), FieldAttributeDialogScrambleComposite.this.randRepValuesList.getItems(), null);
                if (dlg.open() == 0) {
                    FieldAttributeDialogScrambleComposite.this.randRepValuesList.setItems(dlg.getItems());
                }
            }
        });
        CreateType type = ((Symboltype)this.dialog.getSelectedLayout().getSymbol().get(this.symbolIndex)).getCreate();
        if (type == CreateType.NU) {
            this.randRepProvideViaRange = GUI.button.radio((Composite)valuesComposite, (String)Messages.TemplateEditor_SCRAMBLE_VALUE_RANGE, (Object)GUI.grid.d.fillH((int)1));
            this.randRepProvideViaRange.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FieldAttributeDialogScrambleComposite.this.randRepProvideViaRange.getSelection()) {
                        FieldAttributeDialogScrambleComposite.this.randRepOutputFieldStartColumn.setEnabled(false);
                        FieldAttributeDialogScrambleComposite.this.randRepValuesDataSet.setEnabled(false);
                        FieldAttributeDialogScrambleComposite.this.randRepBrowse.setEnabled(false);
                        FieldAttributeDialogScrambleComposite.this.randRepValuesList.setEnabled(false);
                        FieldAttributeDialogScrambleComposite.this.randRepEdit.setEnabled(false);
                        FieldAttributeDialogScrambleComposite.this.minRangeText.setEnabled(true);
                        FieldAttributeDialogScrambleComposite.this.maxRangeText.setEnabled(true);
                    }
                }
            });
            indentCompGridData.horizontalIndent = 20;
            Composite rangeContainer = GUI.composite((Composite)valuesComposite, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false), (Object)indentCompGridData);
            GUI.label.left((Composite)rangeContainer, (String)Messages.TemplateEditor_SCRAMBLE_VALUE_RANGE_min, (Object)GUI.grid.d.left1());
            this.minRangeText = GUI.text.field((Composite)rangeContainer, (Object)GUI.grid.d.fillH((int)1));
            GUI.label.left((Composite)rangeContainer, (String)Messages.TemplateEditor_SCRAMBLE_VALUE_RANGE_max, (Object)GUI.grid.d.left1());
            this.maxRangeText = GUI.text.field((Composite)rangeContainer, (Object)GUI.grid.d.fillH((int)1));
        }
        return valuesComposite;
    }

    private void enableRandomRepeatableControls(boolean enable) {
        this.randRepProvideViaDS.setEnabled(enable);
        this.randRepProvideViaList.setEnabled(enable);
        this.randRepOutputFieldStartColumn.setEnabled(enable && this.randRepProvideViaDS.getSelection());
        this.randRepValuesDataSet.setEnabled(enable && this.randRepProvideViaDS.getSelection());
        this.randRepBrowse.setEnabled(enable && this.randRepProvideViaDS.getSelection());
        this.randRepValuesList.setEnabled(enable && this.randRepProvideViaList.getSelection());
        this.randRepEdit.setEnabled(enable && this.randRepProvideViaList.getSelection());
        CreateType type = ((Symboltype)this.dialog.getSelectedLayout().getSymbol().get(this.symbolIndex)).getCreate();
        if (type == CreateType.NU) {
            this.randRepProvideViaRange.setEnabled(enable);
            this.minRangeText.setEnabled(enable && this.randRepProvideViaRange.getSelection());
            this.maxRangeText.setEnabled(enable && this.randRepProvideViaRange.getSelection());
        }
    }

    private Composite createTranslateComposite(Composite parent) {
        Composite container = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)container, (String)Messages.TemplateEditor_SCRAMBLE_COLUMN_IN, (Object)GUI.grid.d.left1());
        this.translateInputFieldStartColumn = GUI.text.field((Composite)container, (Object)GUI.grid.d.fillH((int)2));
        NumberForcer.addTo(this.translateInputFieldStartColumn);
        GUI.label.left((Composite)container, (String)Messages.TemplateEditor_SCRAMBLE_COLUMN_OUT, (Object)GUI.grid.d.left1());
        this.translateOutputFieldStartColumn = GUI.text.field((Composite)container, (Object)GUI.grid.d.fillH((int)2));
        NumberForcer.addTo(this.translateOutputFieldStartColumn);
        GUI.label.left((Composite)container, (String)Messages.TemplateEditor_SCRAMBLE_DSN, (Object)GUI.grid.d.left1());
        this.translateValuesDataSet = GUI.combo.editable((Composite)container, (Object)GUI.grid.d.fillH((int)1));
        LookupDialogFactory.defaults(LookupButton.createLookupResourceButtonLeft1(container), this.translateValuesDataSet, (IHostProvider)this.dialog.getTemplateResouce()).types(DataSet.class, Member.class).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                FieldAttributeDialogScrambleComposite.this.translateValuesDataSet.setText(zrl.getFormattedName());
            }
        }).addResourceContentProposals(this.getClass().getCanonicalName() + "translateValuesDataSet").create();
        return container;
    }

    private Composite createExitComposite(Composite parent) {
        Composite container = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)container, (String)Messages.TemplateEditor_SCRAMBLE_EXIT_PROGRAM_NAME, (Object)GUI.grid.d.left1());
        this.exitProgramName = GUI.combo.editable((Composite)container, (Object)GUI.grid.d.fillH((int)1));
        this.exitProgramName.setTextLimit(8);
        LookupDialogFactory.defaults(LookupButton.createLookupResourceButtonLeft1(container), this.exitProgramName, (IHostProvider)this.dialog.getTemplateResouce()).types(Member.class).formatter(new ISelectedValueFormatter(){

            @Override
            public String getNewValue(IPDHost selectedHost, IZRL zrl) {
                return ((DataSetOrMember)zrl).asMember().getName();
            }
        }).addResourceContentProposals(this.getClass().getCanonicalName() + "exitProgramName").create();
        GUI.label.left((Composite)container, (String)Messages.TemplateEditor_SCRAMBLE_EXIT_PARAMETERS, (Object)GUI.grid.d.left1());
        this.exitParameters = GUI.combo.editable((Composite)container, (Object)GUI.grid.d.fillH((int)2));
        this.exitParameters.setTextLimit(79);
        return container;
    }

    private Composite createODPPComposite(Composite parent) {
        Composite container = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)container, (String)Messages.TemplateEditor_SCRAMBLE_ODPP_COMMAND, (Object)GUI.grid.d.left1());
        this.ODPPCommand = GUI.text.field((Composite)container, (Object)GUI.grid.d.fillH((int)1));
        return container;
    }

    public boolean validateFields() {
        if (this.scrambleTypeNoneButton.getSelection()) {
            return true;
        }
        if (this.scrambleTypeRandomButton.getSelection() || this.scrambleTypeRepeatableButton.getSelection()) {
            if (!this.randRepProvideValues.getSelection()) {
                return true;
            }
            if (this.randRepProvideViaDS.getSelection()) {
                if (this.randRepOutputFieldStartColumn.getText().trim().isEmpty()) {
                    this.dialog.setErrorMessage(Messages.FieldAttributeDialogScrambleComposite_randomNoStartColumn);
                    return false;
                }
                if (this.randRepValuesDataSet.getText().trim().isEmpty()) {
                    this.dialog.setErrorMessage(Messages.FieldAttributeDialogScrambleComposite_randomNoValuesDSN);
                    return false;
                }
                if (!Member.isParseable((String)this.randRepValuesDataSet.getText().trim(), (boolean)false, (String)this.dialog.getTemplateResouce().getSystem().getCodePage())) {
                    this.dialog.setErrorMessage(Messages.FieldAttributeDialogScrambleComposite_randomInvalidValuesDSN);
                    return false;
                }
                return true;
            }
            if (this.randRepProvideViaList.getSelection()) {
                if (this.randRepValuesList.getItemCount() == 0) {
                    this.dialog.setErrorMessage(Messages.FieldAttributeDialogScrambleComposite_randomNoValueList);
                    return false;
                }
                return true;
            }
            if (this.randRepProvideViaRange != null && this.randRepProvideViaRange.getSelection()) {
                if (this.minRangeText.getText().trim().isEmpty() || !FieldAttributeDialogScrambleComposite.isValidFloat(this.minRangeText.getText().trim())) {
                    this.dialog.setErrorMessage(Messages.FieldAttributeDialogScrambleComposite_randomNoRangeMin);
                    this.minRangeText.setFocus();
                    return false;
                }
                if (this.maxRangeText.getText().trim().isEmpty() || !FieldAttributeDialogScrambleComposite.isValidFloat(this.maxRangeText.getText().trim())) {
                    this.dialog.setErrorMessage(Messages.FieldAttributeDialogScrambleComposite_randomNoRangeMax);
                    this.maxRangeText.setFocus();
                    return false;
                }
                return true;
            }
            CreateType type = ((Symboltype)this.dialog.getSelectedLayout().getSymbol().get(this.symbolIndex)).getCreate();
            if (type == CreateType.NU) {
                this.dialog.setErrorMessage(Messages.FieldAttributeDialogScrambleComposite_randomNoValueSpecNumeric);
            } else if (type == CreateType.AN) {
                this.dialog.setErrorMessage(Messages.FieldAttributeDialogScrambleComposite_randomNoValueSpec);
            }
            return false;
        }
        if (this.scrambleTypeTranslateButton.getSelection()) {
            if (this.translateInputFieldStartColumn.getText().trim().isEmpty()) {
                this.dialog.setErrorMessage(Messages.FieldAttributeDialogScrambleComposite_translateNoInputStart);
                return false;
            }
            if (this.translateOutputFieldStartColumn.getText().trim().isEmpty()) {
                this.dialog.setErrorMessage(Messages.FieldAttributeDialogScrambleComposite_translateNoOutputStart);
                return false;
            }
            if (this.translateValuesDataSet.getText().trim().isEmpty()) {
                this.dialog.setErrorMessage(Messages.FieldAttributeDialogScrambleComposite_translateNoValuesDSN);
                return false;
            }
            return this.validateDSN();
        }
        if (this.scrambleTypeODPPButton.getSelection()) {
            return false;
        }
        if (Member.isValidName((String)this.exitProgramName.getText().trim(), (String)this.dialog.getTemplateResouce().getSystem().getCodePage())) {
            return true;
        }
        this.dialog.setErrorMessage(Messages.FieldAttributeDialogScrambleComposite_exitNoDSN);
        return false;
    }

    private boolean validateDSN() {
        Result<StringBuffer> result;
        DataSetOrMember dsom;
        block15: {
            block16: {
                String dsn = this.translateValuesDataSet.getText().trim();
                if (dsn.indexOf(40) != -1) {
                    Result<StringBuffer> result2;
                    DataSetOrMember dsom2;
                    block14: {
                        if (!Member.isParseable((String)dsn, (boolean)true, (String)this.dialog.getTemplateResouce().getSystem().getCodePage())) {
                            this.dialog.setErrorMessage(Messages.FieldAttributeDialogScrambleComposite_translateNoValuesDSN);
                            this.translateValuesDataSet.setFocus();
                            return false;
                        }
                        dsom2 = Member.parse((IPDHost)this.dialog.getTemplateResouce().getSystem(), (String)dsn);
                        result2 = ZrlLoaderDialogUtils.refreshDataSetProperties(dsom2);
                        if (!result2.isSuccessfulWithoutWarnings()) break block14;
                        if (!dsom2.getConfirmedExists()) {
                            this.dialog.setErrorMessage(MessageFormat.format(Messages.FieldAttributeDialogScrambleComposite_0, dsom2));
                            return false;
                        }
                        return true;
                    }
                    try {
                        PDDialogs.openErrorThreadSafe((String)Messages.Error, (String)MessageFormat.format(Messages.FieldAttributeDialogScrambleComposite_1, dsom2), (String)((StringBuffer)result2.getOutput()).toString());
                        return false;
                    }
                    catch (InterruptedException ie) {
                        this.dialog.setErrorMessage(MessageFormat.format(Messages.FieldAttributeDialogScrambleComposite_2, dsom2));
                        return false;
                    }
                    catch (Exception e) {
                        this.dialog.setErrorMessage(MessageFormat.format(Messages.FieldAttributeDialogScrambleComposite_3, dsom2));
                        return false;
                    }
                }
                if (!DataSet.isValidName((String)dsn, (String)this.dialog.getTemplateResouce().getSystem().getCodePage())) {
                    this.dialog.setErrorMessage(Messages.FieldAttributeDialogScrambleComposite_translateNoValuesDSN);
                    this.translateValuesDataSet.setFocus();
                    return false;
                }
                dsom = Member.parse((IPDHost)this.dialog.getTemplateResouce().getSystem(), (String)dsn);
                result = ZrlLoaderDialogUtils.refreshDataSetProperties(dsom);
                if (!result.isSuccessfulWithoutWarnings()) break block15;
                if (dsom.asDataSet().getType() != DataSetType.PDS && dsom.asDataSet().getType() != DataSetType.LIBRARY) break block16;
                this.dialog.setErrorMessage(Messages.FieldAttributeDialogScrambleComposite_4);
                return false;
            }
            if (!dsom.getConfirmedExists()) {
                this.dialog.setErrorMessage(MessageFormat.format(Messages.FieldAttributeDialogScrambleComposite_5, dsom));
                return false;
            }
            return true;
        }
        try {
            PDDialogs.openErrorThreadSafe((String)Messages.Error, (String)MessageFormat.format(Messages.FieldAttributeDialogScrambleComposite_6, dsom), (String)((StringBuffer)result.getOutput()).toString());
            return false;
        }
        catch (InterruptedException ie) {
            this.dialog.setErrorMessage(MessageFormat.format(Messages.FieldAttributeDialogScrambleComposite_7, dsom));
            return false;
        }
        catch (Exception e) {
            this.dialog.setErrorMessage(MessageFormat.format(Messages.FieldAttributeDialogScrambleComposite_8, dsom));
            return false;
        }
    }

    private static boolean isValidFloat(String value) {
        try {
            Float.parseFloat(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean updateAndFinish() {
        if (!this.validateFields()) {
            return false;
        }
        Symboltype aSymbol = (Symboltype)this.dialog.getSelectedLayout().getSymbol().get(this.symbolIndex);
        Scrambletype scrambleSpec = aSymbol.getScramble();
        if (scrambleSpec == null) {
            scrambleSpec = TemplateFactory.eINSTANCE.createScrambletype();
            aSymbol.setScramble(scrambleSpec);
        }
        FieldAttributeDialogScrambleComposite.clearAllScrambleAttributes(scrambleSpec);
        if (this.scrambleTypeNoneButton.getSelection()) {
            scrambleSpec.setType(0);
            return true;
        }
        if (this.scrambleTypeRandomButton.getSelection() || this.scrambleTypeRepeatableButton.getSelection()) {
            if (this.scrambleTypeRandomButton.getSelection()) {
                scrambleSpec.setType(1);
            } else {
                scrambleSpec.setType(2);
            }
            if (!this.randRepProvideValues.getSelection()) {
                scrambleSpec.setValue(null);
                return true;
            }
            if (this.randRepProvideViaDS.getSelection()) {
                Valuetype valueSpec = TemplateFactory.eINSTANCE.createValuetype();
                scrambleSpec.setValue(valueSpec);
                valueSpec.setOutcol(Integer.parseInt(this.randRepOutputFieldStartColumn.getText().trim()));
                valueSpec.setDsn(this.randRepValuesDataSet.getText().trim());
                return true;
            }
            if (this.randRepProvideViaList.getSelection()) {
                Valuetype valueSpec = TemplateFactory.eINSTANCE.createValuetype();
                scrambleSpec.setValue(valueSpec);
                valueSpec.getSval().clear();
                int i = 0;
                while (i < this.randRepValuesList.getItemCount()) {
                    valueSpec.getSval().add((Object)this.randRepValuesList.getItem(i));
                    ++i;
                }
                return true;
            }
            if (this.randRepProvideViaRange != null && this.randRepProvideViaRange.getSelection()) {
                Rangetype aRange = TemplateFactory.eINSTANCE.createRangetype();
                scrambleSpec.setRange(aRange);
                aRange.setMax(Float.parseFloat(this.maxRangeText.getText().trim()));
                aRange.setMin(Float.parseFloat(this.minRangeText.getText().trim()));
                return true;
            }
            this.dialog.setErrorMessage(Messages.FieldAttributeDialogScrambleComposite_InvalidRandomOrRepeat);
            return false;
        }
        if (this.scrambleTypeTranslateButton.getSelection()) {
            scrambleSpec.setType(3);
            Translatetype transType = scrambleSpec.getTranslate();
            if (transType == null) {
                transType = TemplateFactory.eINSTANCE.createTranslatetype();
                scrambleSpec.setTranslate(transType);
            }
            transType.setIncol(Integer.parseInt(this.translateInputFieldStartColumn.getText().trim()));
            transType.setOutcol(Integer.parseInt(this.translateOutputFieldStartColumn.getText().trim()));
            transType.setDsn(this.translateValuesDataSet.getText().trim());
            return true;
        }
        if (this.scrambleTypeODPPButton.getSelection()) {
            scrambleSpec.setType(5);
            return true;
        }
        scrambleSpec.setType(4);
        Exitprogtype exitProg = scrambleSpec.getExitprog();
        if (exitProg == null) {
            exitProg = TemplateFactory.eINSTANCE.createExitprogtype();
            scrambleSpec.setExitprog(exitProg);
        }
        exitProg.setName(this.exitProgramName.getText().trim());
        exitProg.setParm(this.exitParameters.getText().trim());
        return true;
    }

    private static void clearAllScrambleAttributes(Scrambletype scrambleSpec) {
        Rangetype rangeType;
        Exitprogtype exitType;
        Translatetype transType;
        scrambleSpec.setType(0);
        Valuetype valueType = scrambleSpec.getValue();
        if (valueType != null) {
            scrambleSpec.setValue(null);
        }
        if ((transType = scrambleSpec.getTranslate()) != null) {
            scrambleSpec.setTranslate(null);
        }
        if ((exitType = scrambleSpec.getExitprog()) != null) {
            scrambleSpec.setExitprog(null);
        }
        if ((rangeType = scrambleSpec.getRange()) != null) {
            scrambleSpec.setRange(null);
        }
    }

    private void initialiseValues() {
        Symboltype aSymbol = (Symboltype)this.dialog.getSelectedLayout().getSymbol().get(this.symbolIndex);
        Scrambletype scrambleSpec = aSymbol.getScramble();
        if (scrambleSpec == null || scrambleSpec.getType() == 0) {
            this.scrambleTypeNoneButton.setSelection(true);
            this.stackLayout.topControl = this.noneComposite;
            this.stackComposite.layout();
            return;
        }
        if (scrambleSpec.getType() == 1 || scrambleSpec.getType() == 2) {
            if (scrambleSpec.getType() == 1) {
                this.scrambleTypeRandomButton.setSelection(true);
                this.stackLayout.topControl = this.randomRepeatableComposite;
                this.stackComposite.layout();
            } else {
                this.scrambleTypeRepeatableButton.setSelection(true);
                this.stackLayout.topControl = this.randomRepeatableComposite;
                this.stackComposite.layout();
            }
            if (scrambleSpec.getValue() != null) {
                this.randRepProvideValues.setSelection(true);
                this.enableRandomRepeatableControls(true);
                Valuetype valueType = scrambleSpec.getValue();
                if (valueType.getSval().isEmpty()) {
                    this.randRepProvideViaDS.setSelection(true);
                    if (valueType.isSetOutcol()) {
                        this.randRepOutputFieldStartColumn.setText("" + valueType.getOutcol());
                    }
                    if (valueType.getDsn() != null) {
                        this.randRepValuesDataSet.setText(valueType.getDsn());
                    }
                    this.randRepOutputFieldStartColumn.setEnabled(true);
                    this.randRepValuesDataSet.setEnabled(true);
                    this.randRepBrowse.setEnabled(true);
                    this.randRepValuesList.setEnabled(false);
                    this.randRepEdit.setEnabled(false);
                    if (this.randRepProvideViaRange != null) {
                        this.minRangeText.setEnabled(false);
                        this.maxRangeText.setEnabled(false);
                    }
                    return;
                }
                this.randRepProvideViaList.setSelection(true);
                int i = 0;
                while (i < valueType.getSval().size()) {
                    this.randRepValuesList.add((String)valueType.getSval().get(i));
                    ++i;
                }
                this.randRepValuesList.redraw();
                this.randRepOutputFieldStartColumn.setEnabled(false);
                this.randRepValuesDataSet.setEnabled(false);
                this.randRepBrowse.setEnabled(false);
                this.randRepValuesList.setEnabled(true);
                this.randRepEdit.setEnabled(true);
                if (this.randRepProvideViaRange != null) {
                    this.minRangeText.setEnabled(false);
                    this.maxRangeText.setEnabled(false);
                }
                return;
            }
            if (scrambleSpec.getRange() != null) {
                this.randRepProvideValues.setSelection(true);
                this.randRepProvideViaRange.setSelection(true);
                this.enableRandomRepeatableControls(true);
                Rangetype aRange = scrambleSpec.getRange();
                if (aRange.isSetMax()) {
                    this.maxRangeText.setText("" + aRange.getMax());
                }
                if (aRange.isSetMin()) {
                    this.minRangeText.setText("" + aRange.getMin());
                }
                this.randRepOutputFieldStartColumn.setEnabled(false);
                this.randRepValuesDataSet.setEnabled(false);
                this.randRepBrowse.setEnabled(false);
                this.randRepValuesList.setEnabled(false);
                this.randRepEdit.setEnabled(false);
                this.minRangeText.setEnabled(true);
                this.maxRangeText.setEnabled(true);
            } else {
                this.randRepProvideValues.setSelection(false);
                this.enableRandomRepeatableControls(false);
            }
            return;
        }
        if (scrambleSpec.getType() == 3) {
            this.scrambleTypeTranslateButton.setSelection(true);
            this.stackLayout.topControl = this.translateComposite;
            this.stackComposite.layout();
            if (scrambleSpec.getTranslate() != null) {
                Translatetype transType = scrambleSpec.getTranslate();
                if (transType.isSetIncol()) {
                    this.translateInputFieldStartColumn.setText("" + transType.getIncol());
                }
                if (transType.isSetOutcol()) {
                    this.translateOutputFieldStartColumn.setText("" + transType.getOutcol());
                }
                this.translateValuesDataSet.setText(transType.getDsn());
            }
            return;
        }
        if (scrambleSpec.getType() == 4) {
            this.scrambleTypeExitButton.setSelection(true);
            this.stackLayout.topControl = this.exitComposite;
            this.stackComposite.layout();
            if (scrambleSpec.getExitprog() != null) {
                Exitprogtype exitProg = scrambleSpec.getExitprog();
                this.exitProgramName.setText(exitProg.getName());
                if (exitProg.getParm() != null) {
                    this.exitParameters.setText(exitProg.getParm());
                }
            }
            return;
        }
        if (scrambleSpec.getType() == 5) {
            this.scrambleTypeODPPButton.setSelection(true);
            this.stackLayout.topControl = this.ODPPComposite;
            this.stackComposite.layout();
            return;
        }
        this.scrambleTypeNoneButton.setSelection(true);
        this.stackLayout.topControl = this.noneComposite;
        this.stackComposite.layout();
    }
}

