/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.template.dialogs.FieldAttributeDialog;
import com.ibm.etools.fm.model.template.ActType;
import com.ibm.etools.fm.model.template.CreateCtype;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateFactory;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class FieldAttributeDialogCreateAttributeTextComposite {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int FILLER_MAXLEN = 7;
    private static final int STARTCHAR_MAXLEN = 1;
    private static final int PATTERN_MAXLEN = 52;
    private static final String[] CREATE_ACTIONS = new String[]{"", ActType.FX.getLiteral(), ActType.RA.getLiteral(), ActType.RO.getLiteral(), ActType.RP.getLiteral(), ActType.SL.getLiteral(), ActType.SR.getLiteral(), ActType.TL.getLiteral(), ActType.TR.getLiteral(), ActType.WV.getLiteral()};
    private TabItem createAttrTab;
    private Combo fillerCombo;
    private Combo actionCombo;
    private Combo startCharCombo;
    private Combo patternCombo;
    private Button repeatUserPatternButton;
    private FieldAttributeDialog dialog;
    private Layouttype selectedLayout;
    private int symbolIndex = 0;
    private String codepage;

    public FieldAttributeDialogCreateAttributeTextComposite(FieldAttributeDialog dialog, Layouttype selectedLayout, int symbolIndex, String codepage) {
        this.dialog = dialog;
        this.selectedLayout = selectedLayout;
        this.symbolIndex = symbolIndex;
        this.codepage = codepage;
    }

    public void createCreateAttributeTab(TabFolder tabFolder) {
        this.createAttrTab = new TabItem(tabFolder, 0);
        this.createAttrTab.setText(Messages.FieldAttributeDialog_CreateAttrGroupName);
        Composite composite = GUI.composite((Composite)tabFolder, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)composite, (String)Messages.FieldAttributeDialog_CreateAttrFiller, (Object)GUI.grid.d.left1());
        this.fillerCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.fillerCombo, this.getClass().getCanonicalName() + "fillerValue");
        this.fillerCombo.setTextLimit(7);
        this.fillerCombo.addVerifyListener(this.CreateDBCSVerifyListener());
        GUI.label.left((Composite)composite, (String)Messages.FieldAttributeDialog_CreateAttrAction, (Object)GUI.grid.d.left1());
        this.actionCombo = GUI.combo.readOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1), (Object[])CREATE_ACTIONS);
        this.actionCombo.select(0);
        GUI.label.left((Composite)composite, (String)Messages.FieldAttributeDialog_CreateAttrStartChar, (Object)GUI.grid.d.left1());
        this.startCharCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.startCharCombo, this.getClass().getCanonicalName() + "startCharValue");
        this.startCharCombo.setTextLimit(1);
        this.startCharCombo.addVerifyListener(this.CreateDBCSVerifyListener());
        GUI.label.left((Composite)composite, (String)Messages.FieldAttributeDialog_CreateAttrPattern, (Object)GUI.grid.d.left1());
        this.patternCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.patternCombo, this.getClass().getCanonicalName() + "patternValue");
        this.patternCombo.setTextLimit(52);
        this.patternCombo.addVerifyListener(this.CreateDBCSVerifyListener());
        this.repeatUserPatternButton = GUI.button.checkbox((Composite)composite, (String)Messages.FieldAttributeDialog_CreateAttrRepeatUserPattern, (Object)GUI.grid.d.fillH((int)2));
        this.createAttrTab.setControl((Control)composite);
        this.setCreateAttributeValues();
    }

    private VerifyListener CreateDBCSVerifyListener() {
        return new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (StringUtils.convertToHex((String)e.text, (String)FieldAttributeDialogCreateAttributeTextComposite.this.codepage).length() <= 2) {
                    e.doit = true;
                    FieldAttributeDialogCreateAttributeTextComposite.this.dialog.setErrorMessage(null);
                } else {
                    e.doit = false;
                    FieldAttributeDialogCreateAttributeTextComposite.this.dialog.setErrorMessage(Messages.FieldAttributeDialogCreateAttributeTextComposite_DBCS_Forbidden);
                }
            }
        };
    }

    private void setCreateAttributeValues() {
        Symboltype aSymbol = (Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex);
        if (aSymbol.getCreateC() != null) {
            CreateCtype cType = aSymbol.getCreateC();
            if (cType.getFiller() != null) {
                this.fillerCombo.setText(cType.getFiller());
            }
            if (cType.isSetAct()) {
                this.actionCombo.select(cType.getAct().getValue() + 1);
            }
            if (cType.getPattern() != null) {
                this.patternCombo.setText(cType.getPattern());
            }
            if (cType.getStart() != null) {
                this.startCharCombo.setText(cType.getStart());
            }
            if (cType.isSetRepeat() && cType.isRepeat()) {
                this.repeatUserPatternButton.setSelection(true);
            } else {
                this.repeatUserPatternButton.setSelection(false);
            }
        }
    }

    public boolean validateFields() {
        Symboltype aSymbol = (Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex);
        if (aSymbol.getCreateC() == null && !this.valueModified()) {
            return true;
        }
        if (this.repeatUserPatternButton.getSelection() && this.patternCombo.getText().trim().isEmpty()) {
            this.dialog.setErrorMessage(Messages.FieldAttributeDialogCreateAttributeComposite_NoPattern);
            this.patternCombo.setFocus();
            return false;
        }
        return true;
    }

    public boolean updateAndFinish() {
        if (!this.validateFields()) {
            return false;
        }
        Symboltype aSymbol = (Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex);
        if (aSymbol.getCreateC() == null && !this.valueModified()) {
            return true;
        }
        CreateCtype cType = aSymbol.getCreateC();
        if (cType == null) {
            cType = TemplateFactory.eINSTANCE.createCreateCtype();
            aSymbol.setCreateC(cType);
        }
        cType.setFiller(this.fillerCombo.getText().trim());
        if (!this.actionCombo.getText().trim().isEmpty()) {
            cType.setAct(ActType.get((String)this.actionCombo.getText()));
        } else {
            cType.unsetAct();
        }
        if (!this.startCharCombo.getText().trim().isEmpty()) {
            cType.setStart(this.startCharCombo.getText().trim());
        } else {
            cType.setStart(null);
        }
        if (!this.patternCombo.getText().trim().isEmpty()) {
            cType.setPattern(this.patternCombo.getText().trim());
        } else if (!this.repeatUserPatternButton.getSelection()) {
            cType.setPattern(null);
        }
        if (this.repeatUserPatternButton.getSelection()) {
            if (this.patternCombo.getText().trim().isEmpty()) {
                this.dialog.setErrorMessage(Messages.FieldAttributeDialogCreateAttributeComposite_NoPattern);
                return false;
            }
            cType.setRepeat(true);
        } else {
            cType.setRepeat(false);
        }
        return true;
    }

    private boolean valueModified() {
        if (!this.fillerCombo.getText().trim().isEmpty()) {
            return true;
        }
        if (!this.actionCombo.getText().trim().isEmpty()) {
            return true;
        }
        if (!this.startCharCombo.getText().trim().isEmpty()) {
            return true;
        }
        if (!this.patternCombo.getText().trim().isEmpty()) {
            return true;
        }
        return !this.repeatUserPatternButton.getSelection();
    }
}

