/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.template.dialogs.FieldAttributeDialog;
import com.ibm.etools.fm.model.template.CreateNtype;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateFactory;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class FieldAttributeDialogCreateAttributeNumericComposite {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private TabItem createAttrTab;
    private Combo startValueCombo;
    private Combo endValueCombo;
    private Combo incrementCombo;
    private Combo cycleCombo;
    private FieldAttributeDialog dialog;
    private Layouttype selectedLayout;
    private int symbolIndex = 0;

    public FieldAttributeDialogCreateAttributeNumericComposite(FieldAttributeDialog dialog, Layouttype selectedLayout, int symbolIndex) {
        this.dialog = dialog;
        this.selectedLayout = selectedLayout;
        this.symbolIndex = symbolIndex;
    }

    public void createCreateAttributeTab(TabFolder tabFolder) {
        this.createAttrTab = new TabItem(tabFolder, 0);
        this.createAttrTab.setText(Messages.FieldAttributeDialog_CreateAttrGroupName);
        Composite composite = GUI.composite((Composite)tabFolder, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)composite, (String)Messages.FieldAttributeDialog_StartValue, (Object)GUI.grid.d.left1());
        this.startValueCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.startValueCombo, this.getClass().getCanonicalName() + "startValue");
        GUI.label.left((Composite)composite, (String)Messages.FieldAttributeDialog_EndValue, (Object)GUI.grid.d.left1());
        this.endValueCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.endValueCombo, this.getClass().getCanonicalName() + "endValue");
        GUI.label.left((Composite)composite, (String)Messages.FieldAttributeDialog_Increment, (Object)GUI.grid.d.left1());
        this.incrementCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.incrementCombo, this.getClass().getCanonicalName() + "incrementValue");
        GUI.label.left((Composite)composite, (String)Messages.FieldAttributeDialog_Cycle, (Object)GUI.grid.d.left1());
        this.cycleCombo = GUI.combo.editable((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.cycleCombo, this.getClass().getCanonicalName() + "cycleValue");
        this.createAttrTab.setControl((Control)composite);
        this.setCreateAttributeValues();
    }

    private void setCreateAttributeValues() {
        Symboltype aSymbol = (Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex);
        if (aSymbol.getCreateN() != null) {
            CreateNtype nType = aSymbol.getCreateN();
            if (nType.isSetStart()) {
                this.startValueCombo.setText("" + nType.getStart());
            }
            if (nType.isSetEnd()) {
                this.endValueCombo.setText("" + nType.getEnd());
            }
            if (nType.isSetInc()) {
                this.incrementCombo.setText("" + nType.getInc());
            }
            if (nType.isSetCycle()) {
                this.cycleCombo.setText("" + nType.getCycle());
            }
        }
    }

    public boolean validateFields() {
        String aValue = this.startValueCombo.getText().trim();
        if (aValue.length() > 0 && !FieldAttributeDialogCreateAttributeNumericComposite.isValidFloat(aValue)) {
            this.dialog.setErrorMessage(Messages.FieldAttributeDialog_StartValueError);
            this.startValueCombo.setFocus();
            return false;
        }
        aValue = this.endValueCombo.getText().trim();
        if (aValue.length() > 0 && !FieldAttributeDialogCreateAttributeNumericComposite.isValidFloat(aValue)) {
            this.dialog.setErrorMessage(Messages.FieldAttributeDialog_EndValueError);
            this.endValueCombo.setFocus();
            return false;
        }
        aValue = this.incrementCombo.getText().trim();
        if (aValue.length() > 0 && !FieldAttributeDialogCreateAttributeNumericComposite.isValidFloat(aValue)) {
            this.dialog.setErrorMessage(Messages.FieldAttributeDialog_IncrementError);
            this.incrementCombo.setFocus();
            return false;
        }
        aValue = this.cycleCombo.getText().trim();
        if (aValue.length() > 0 && !FieldAttributeDialogCreateAttributeNumericComposite.isValidFloat(aValue)) {
            this.dialog.setErrorMessage(Messages.FieldAttributeDialog_CycleError);
            this.cycleCombo.setFocus();
            return false;
        }
        return true;
    }

    private static boolean isValidFloat(String aValue) {
        try {
            Float.parseFloat(aValue);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean updateAndFinish() {
        String aValue;
        if (!this.validateFields()) {
            return false;
        }
        Symboltype aSymbol = (Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex);
        CreateNtype nType = aSymbol.getCreateN();
        if (nType == null) {
            nType = TemplateFactory.eINSTANCE.createCreateNtype();
            aSymbol.setCreateN(nType);
        }
        if (!(aValue = this.startValueCombo.getText().trim()).isEmpty()) {
            nType.setStart(Float.parseFloat(aValue));
        } else {
            nType.unsetStart();
        }
        aValue = this.endValueCombo.getText().trim();
        if (!aValue.isEmpty()) {
            nType.setEnd(Float.parseFloat(aValue));
        } else {
            nType.unsetEnd();
        }
        aValue = this.incrementCombo.getText().trim();
        if (!aValue.isEmpty()) {
            nType.setInc(Float.parseFloat(aValue));
        } else {
            nType.unsetInc();
        }
        aValue = this.cycleCombo.getText().trim();
        if (!aValue.isEmpty()) {
            nType.setCycle(Float.parseFloat(aValue));
        } else {
            nType.unsetCycle();
        }
        return true;
    }
}

