/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionTemplate;
import com.ibm.etools.fm.editor.template.dialogs.FieldAttributeDialogCreateAttributeDateComposite;
import com.ibm.etools.fm.editor.template.dialogs.FieldAttributeDialogCreateAttributeNoneComposite;
import com.ibm.etools.fm.editor.template.dialogs.FieldAttributeDialogCreateAttributeNumericComposite;
import com.ibm.etools.fm.editor.template.dialogs.FieldAttributeDialogCreateAttributeTextComposite;
import com.ibm.etools.fm.editor.template.dialogs.FieldAttributeDialogScrambleComposite;
import com.ibm.etools.fm.editor.template.dialogs.FieldAttributeDialogUseAttributeComposite;
import com.ibm.etools.fm.model.template.CopybooksType;
import com.ibm.etools.fm.model.template.CreateType;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class FieldAttributeDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private Text fieldNameText;
    private Text fieldTypeText;
    private Text fieldStartText;
    private Text fieldLengthText;
    private TabFolder tabFolder;
    private FieldAttributeDialogCreateAttributeTextComposite createAttributeTextComposite;
    private FieldAttributeDialogCreateAttributeNumericComposite createAttributeNumberComposite;
    private FieldAttributeDialogCreateAttributeDateComposite createAttributeDateComposite;
    private FieldAttributeDialogCreateAttributeNoneComposite createAttributeNoneComposite;
    private FieldAttributeDialogUseAttributeComposite useAttributeComposite;
    private FieldAttributeDialogScrambleComposite scrambleAttributeComposite;
    private AbstractSessionTemplate session;
    private IZRL templateResource;
    private TemplateType aTemplate;
    private Layouttype selectedLayout;
    private int symbolIndex = 0;
    private String codepage;
    private boolean updateToTemplate = false;
    private boolean hostValidationFailure = false;

    public FieldAttributeDialog(AbstractSessionTemplate session, IZRL templateResource, TemplateType aTemplate, Layouttype selectedLayout, int symbolIndex, boolean updateToTemplate) {
        this.session = session;
        this.templateResource = templateResource;
        this.aTemplate = aTemplate;
        this.selectedLayout = selectedLayout;
        this.symbolIndex = symbolIndex;
        this.updateToTemplate = updateToTemplate;
        this.codepage = session.getSystem().getCodePage();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.FieldAttributeDialog_Title);
        this.setMessage(Messages.FieldAttributeDialog_Msg);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.createFixedAttributeComposite(composite);
        this.tabFolder = new TabFolder(composite, 128);
        this.tabFolder.setLayoutData((Object)GUI.grid.d.fillAll());
        this.useAttributeComposite = new FieldAttributeDialogUseAttributeComposite(this.aTemplate, this.selectedLayout, this.symbolIndex);
        this.useAttributeComposite.createUseAttributeTab(this.tabFolder);
        CreateType type = ((Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex)).getCreate();
        if (type == CreateType.AN) {
            this.createAttributeTextComposite = new FieldAttributeDialogCreateAttributeTextComposite(this, this.selectedLayout, this.symbolIndex, this.codepage);
            this.createAttributeTextComposite.createCreateAttributeTab(this.tabFolder);
        } else if (type == CreateType.VC) {
            this.createAttributeTextComposite = new FieldAttributeDialogCreateAttributeTextComposite(this, this.selectedLayout, this.symbolIndex, this.codepage);
            this.createAttributeTextComposite.createCreateAttributeTab(this.tabFolder);
        } else if (type == CreateType.NU) {
            this.createAttributeNumberComposite = new FieldAttributeDialogCreateAttributeNumericComposite(this, this.selectedLayout, this.symbolIndex);
            this.createAttributeNumberComposite.createCreateAttributeTab(this.tabFolder);
        } else if (type == CreateType.DT) {
            this.createAttributeDateComposite = new FieldAttributeDialogCreateAttributeDateComposite(this, this.selectedLayout, this.symbolIndex);
            this.createAttributeDateComposite.createCreateAttributeTab(this.tabFolder);
        } else {
            this.createAttributeNoneComposite = new FieldAttributeDialogCreateAttributeNoneComposite();
            this.createAttributeNoneComposite.createCreateAttributeTab(this.tabFolder);
        }
        if (type == CreateType.AN || type == CreateType.VC || type == CreateType.NU) {
            this.scrambleAttributeComposite = new FieldAttributeDialogScrambleComposite(this, this.symbolIndex);
            this.scrambleAttributeComposite.createComposite(this.tabFolder);
        }
        return composite;
    }

    private void createFixedAttributeComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)composite, (String)Messages.FieldAttributeDialog_FieldName, (Object)GUI.grid.d.left1());
        this.fieldNameText = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)composite, (String)Messages.FieldAttributeDialog_FieldType, (Object)GUI.grid.d.left1());
        this.fieldTypeText = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)composite, (String)Messages.FieldAttributeDialog_FieldStart, (Object)GUI.grid.d.left1());
        this.fieldStartText = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)composite, (String)Messages.FieldAttributeDialog_FieldLength, (Object)GUI.grid.d.left1());
        this.fieldLengthText = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        this.setFixedAttributeValues();
    }

    private void setFixedAttributeValues() {
        Symboltype aSymbol = (Symboltype)this.selectedLayout.getSymbol().get(this.symbolIndex);
        this.fieldNameText.setText(aSymbol.getName(this.session.getSystem()));
        this.fieldTypeText.setText(aSymbol.getType().getLiteral());
        this.fieldStartText.setText("" + aSymbol.getStart());
        this.fieldLengthText.setText("" + aSymbol.getLength());
    }

    public boolean validateFields() {
        if (!this.useAttributeComposite.validateFields()) {
            return false;
        }
        if (this.createAttributeTextComposite != null && !this.createAttributeTextComposite.validateFields()) {
            return false;
        }
        if (this.createAttributeNumberComposite != null && !this.createAttributeNumberComposite.validateFields()) {
            return false;
        }
        if (this.createAttributeDateComposite != null && !this.createAttributeDateComposite.validateFields()) {
            return false;
        }
        if (this.createAttributeNoneComposite != null && !this.createAttributeNoneComposite.validateFields()) {
            return false;
        }
        return this.scrambleAttributeComposite.validateFields();
    }

    protected void okPressed() {
        if (!this.validateFields()) {
            return;
        }
        if (!this.useAttributeComposite.updateAndFinish()) {
            return;
        }
        if (this.createAttributeTextComposite != null && !this.createAttributeTextComposite.updateAndFinish()) {
            return;
        }
        if (this.createAttributeNumberComposite != null && !this.createAttributeNumberComposite.updateAndFinish()) {
            return;
        }
        if (this.createAttributeDateComposite != null && !this.createAttributeDateComposite.updateAndFinish()) {
            return;
        }
        if (this.createAttributeNoneComposite != null && !this.createAttributeNoneComposite.updateAndFinish()) {
            return;
        }
        if (!this.scrambleAttributeComposite.updateAndFinish()) {
            return;
        }
        if (!this.validateAttributres()) {
            this.hostValidationFailure = true;
            return;
        }
        super.okPressed();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void cancelPressed() {
        if (this.hostValidationFailure) {
            if (!PDDialogs.openConfirm((String)Messages.Warning, (String)Messages.FieldAttributeDialog_CancelWithHostValidationErr)) return;
            super.cancelPressed();
            return;
        } else {
            super.cancelPressed();
        }
    }

    private boolean validateAttributres() {
        Result result;
        CopybooksType copybooks;
        try {
            copybooks = this.aTemplate.getCopybooks();
            this.aTemplate.setCopybooks(null);
            final StringBuffer xmlTemplate = TemplateSerializeUtils.save((TemplateType)this.aTemplate, (IZRL)this.templateResource);
            result = new Result();
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.FieldAttributeDialog_ValidateAttributes, 1);
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        FieldAttributeDialog.this.session.updateTemplate(xmlTemplate, howIsGoing, result, false, FieldAttributeDialog.this.updateToTemplate);
                    }
                });
            }
            catch (Exception e) {
                PDDialogs.openErrorThreadSafe((String)Messages.FieldAttributeDialog_ValidationEx, (String)result.dumpOutputAndMessages(true), (Throwable)e);
                this.aTemplate.setCopybooks(copybooks);
                return false;
            }
        }
        catch (Exception e) {
            PDDialogs.openErrorThreadSafe((String)Messages.FieldAttributeDialog_ValidationEx, (Throwable)e);
            return false;
        }
        this.aTemplate.setCopybooks(copybooks);
        if (!result.isSuccessfulWithoutWarnings()) {
            PDDialogs.openErrorThreadSafe((String)Messages.FieldAttributeDialog_ValidationError, (String)result.dumpOutputAndMessages(true));
            return false;
        }
        return true;
    }

    public boolean validationErrorOccurred() {
        return this.hostValidationFailure;
    }

    public TemplateType getTemplate() {
        return this.aTemplate;
    }

    public IZRL getTemplateResouce() {
        return this.templateResource;
    }

    public Layouttype getSelectedLayout() {
        return this.selectedLayout;
    }
}

