/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.core.model.BaseEditorOptions;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.data.DataSetProperties;
import com.ibm.etools.fm.editor.formatted.FMEditSessionProperties;
import com.ibm.etools.fm.editor.template.dialogs.AdvancedCopybookEntry;
import com.ibm.etools.fm.editor.template.dialogs.RangeSelectComposite;
import com.ibm.etools.fm.editor.template.dialogs.listeners.IRangeSelectListener;
import com.ibm.etools.fm.editor.template.dialogs.listeners.NumericVerifyListener;
import com.ibm.etools.fm.model.formatted.EditType;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.etools.fm.model.formatted.util.EditorDataSerializeUtils;
import com.ibm.etools.fm.ui.prefs.FormattedEditorPreferencePage;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EditAdvancedSelectionCopybookDialog
extends TitleAreaDialog
implements ModifyListener,
IRangeSelectListener {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(EditAdvancedSelectionCopybookDialog.class);
    private static final int TEXTWIDGETLEN = 20;
    private AdvancedCopybookEntry entry;
    private Text copybookText;
    private Button insert01;
    private Text insert01FieldName;
    private Text redefinesLevel;
    private Text redefinesFieldName;
    private Button redefinesSetOffset;
    private Button redefinesCobolLevelChange;
    private Text fromStatement;
    private Text fromString;
    private Text toStatement;
    private Text toString;
    private RangeSelectComposite rangeSelector;
    private boolean updatingTextFromSelection = false;

    public EditAdvancedSelectionCopybookDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.EditAdvancedSelectionCopybookDialog_TITLE);
        this.setMessage(Messages.EditAdvancedSelectionCopybookDialog_MESSAGE);
        Composite container = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Composite miscComposite = GUI.composite((Composite)container, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)miscComposite, (String)Messages.EditAdvancedSelectionCopybookDialog_Copybook, (Object)GUI.grid.d.left1());
        this.copybookText = GUI.text.fieldReadOnly((Composite)miscComposite, (Object)GUI.grid.d.fillH((int)1));
        this.copybookText.setText(this.entry.getCopybook().getFormattedName());
        this.insert01 = GUI.button.checkbox((Composite)miscComposite, (String)Messages.EditAdvancedSelectionCopybookDialog_INSERT01, (Object)GUI.grid.d.fillH((int)2));
        Composite insert01FieldNameComp = GUI.composite((Composite)miscComposite, (Layout)GUI.grid.l.customMargins((int)2, (boolean)false, (int)20, (int)6), (Object)GUI.grid.d.fillH((int)2));
        GUI.label.left((Composite)insert01FieldNameComp, (String)Messages.EditAdvancedSelectionCopybookDialog_INSERT01_FIELD, (Object)GUI.grid.d.left1());
        this.insert01FieldName = GUI.text.field((Composite)insert01FieldNameComp, (Object)GUI.grid.d.fillH((int)1));
        GUI.setTextWidthHint((Text)this.insert01FieldName, (int)20);
        Group redefinesGroup = new Group(container, 0);
        redefinesGroup.setText(Messages.EditAdvancedSelectionCopybookDialog_GENERATE_MULTIPLE);
        redefinesGroup.setLayoutData((Object)new GridData(768));
        redefinesGroup.setLayout((Layout)new GridLayout(2, false));
        Label redefinesLevelLabel = new Label((Composite)redefinesGroup, 0);
        redefinesLevelLabel.setText(Messages.EditAdvancedSelectionCopybookDialog_REDEFINES_LEVEL);
        this.redefinesLevel = new Text((Composite)redefinesGroup, 2052);
        GUI.setTextWidthHint((Text)this.redefinesLevel, (int)20);
        this.redefinesLevel.addVerifyListener((VerifyListener)new NumericVerifyListener());
        Label redefinesFieldNameLabel = new Label((Composite)redefinesGroup, 0);
        redefinesFieldNameLabel.setText(Messages.EditAdvancedSelectionCopybookDialog_REDEFINES_FIELD_NAME);
        this.redefinesFieldName = new Text((Composite)redefinesGroup, 2052);
        GUI.setTextWidthHint((Text)this.redefinesFieldName, (int)20);
        this.redefinesSetOffset = new Button((Composite)redefinesGroup, 32);
        this.redefinesSetOffset.setText(Messages.EditAdvancedSelectionCopybookDialog_REDEFINES_SET_OFFSET);
        GridData gdOffset = new GridData();
        gdOffset.horizontalSpan = 2;
        this.redefinesSetOffset.setLayoutData((Object)gdOffset);
        this.redefinesCobolLevelChange = new Button((Composite)redefinesGroup, 32);
        this.redefinesCobolLevelChange.setText(Messages.EditAdvancedSelectionCopybookDialog_REDEFINES_COBOLLEVEL);
        GridData gdLevelChange = new GridData();
        gdLevelChange.horizontalSpan = 2;
        this.redefinesCobolLevelChange.setLayoutData((Object)gdLevelChange);
        Group rangeSelectComposite = new Group(container, 0);
        rangeSelectComposite.setText(Messages.EditAdvancedSelectionCopybookDialog_SOURCE_RANGE);
        rangeSelectComposite.setLayoutData((Object)new GridData(1808));
        rangeSelectComposite.setLayout((Layout)new GridLayout());
        Composite rangeControlComposite = new Composite((Composite)rangeSelectComposite, 0);
        rangeControlComposite.setLayoutData((Object)new GridData(768));
        GridLayout rccLayout = new GridLayout(2, true);
        rccLayout.marginWidth = 0;
        rangeControlComposite.setLayout((Layout)rccLayout);
        Composite rccSubComp1 = new Composite(rangeControlComposite, 0);
        GridData gd1 = new GridData();
        gd1.widthHint = 250;
        rccSubComp1.setLayoutData((Object)gd1);
        GridLayout rccSub1Layout = new GridLayout(2, false);
        rccSub1Layout.marginWidth = 0;
        rccSubComp1.setLayout((Layout)rccSub1Layout);
        Label fromLabel = new Label(rccSubComp1, 0);
        fromLabel.setText(Messages.EditAdvancedSelectionCopybookDialog_FROM_STATEMENT);
        this.fromStatement = new Text(rccSubComp1, 2052);
        GUI.setTextWidthHint((Text)this.fromStatement, (int)20);
        this.fromStatement.addVerifyListener((VerifyListener)new NumericVerifyListener());
        Label toLabel = new Label(rccSubComp1, 0);
        toLabel.setText(Messages.EditAdvancedSelectionCopybookDialog_TO_STATEMENT);
        this.toStatement = new Text(rccSubComp1, 2052);
        GUI.setTextWidthHint((Text)this.toStatement, (int)20);
        this.toStatement.addVerifyListener((VerifyListener)new NumericVerifyListener());
        Composite rccSubComp2 = new Composite(rangeControlComposite, 0);
        GridData gd2 = new GridData();
        gd2.widthHint = 250;
        rccSubComp2.setLayoutData((Object)gd1);
        GridLayout rccSub2Layout = new GridLayout(2, false);
        rccSub2Layout.marginWidth = 0;
        rccSubComp2.setLayout((Layout)rccSub2Layout);
        Label fromStringLabel = new Label(rccSubComp2, 0);
        fromStringLabel.setText(Messages.EditAdvancedSelectionCopybookDialog_FROM_STRING);
        this.fromString = new Text(rccSubComp2, 2052);
        GUI.setTextWidthHint((Text)this.fromString, (int)20);
        Label toStringLabel = new Label(rccSubComp2, 0);
        toStringLabel.setText(Messages.EditAdvancedSelectionCopybookDialog_TO_STRING);
        this.toString = new Text(rccSubComp2, 2052);
        GUI.setTextWidthHint((Text)this.toString, (int)20);
        this.rangeSelector = new RangeSelectComposite((Composite)rangeSelectComposite);
        GridData gd = new GridData(1808);
        gd.minimumHeight = 250;
        gd.minimumWidth = 600;
        this.rangeSelector.setLayoutData(gd);
        if (this.entry != null) {
            this.insert01.setSelection(this.entry.isInsert01());
            if (this.entry.getInsert01FieldName() != null) {
                this.insert01FieldName.setText(this.entry.getInsert01FieldName());
            }
            if (this.entry.getRedefinesLevel() > 0) {
                this.redefinesLevel.setText(String.valueOf(this.entry.getRedefinesLevel()));
            }
            if (this.entry.getRedefinesFieldName() != null) {
                this.redefinesFieldName.setText(this.entry.getRedefinesFieldName());
            }
            this.redefinesSetOffset.setSelection(this.entry.isRedefinesSetOffset());
            this.redefinesCobolLevelChange.setSelection(this.entry.isRedefinesCOBOLLevelChange());
            if (this.entry.getRangeFromStatement() > 0) {
                this.fromStatement.setText(String.valueOf(this.entry.getRangeFromStatement()));
            }
            if (this.entry.getRangeToStatement() > 0) {
                this.toStatement.setText(String.valueOf(this.entry.getRangeToStatement()));
            }
            if (this.entry.getRangeFromString() != null) {
                this.fromString.setText(this.entry.getRangeFromString());
            }
            if (this.entry.getRangeToString() != null) {
                this.toString.setText(this.entry.getRangeToString());
            }
            DataSetOrMember tempCopyBook = this.entry.getCopybook();
            String codePage = null;
            String communicationCodePage = null;
            String tempContents = this.entry.getContents();
            if (tempContents != null) {
                IPDHost pdHost;
                if (tempCopyBook != null && (pdHost = tempCopyBook.getSystem()) != null) {
                    codePage = pdHost.getCodePage();
                    communicationCodePage = pdHost.getHostType().getCommunicationEncoding();
                    if (codePage != null && !communicationCodePage.equals(codePage)) {
                        try {
                            tempContents = new String(tempContents.getBytes(communicationCodePage), codePage);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                this.rangeSelector.setContents(tempContents);
                if (this.entry.getRangeFromStatement() > 0 && this.entry.getRangeToStatement() > 0 && this.entry.getRangeToStatement() >= this.entry.getRangeFromStatement()) {
                    this.rangeSelector.setSelectionRange(this.entry.getRangeFromStatement(), this.entry.getRangeToStatement(), this.entry.getRangeFromString(), this.entry.getRangeToString());
                }
            }
        }
        this.fromStatement.addModifyListener((ModifyListener)this);
        this.toStatement.addModifyListener((ModifyListener)this);
        this.fromString.addModifyListener((ModifyListener)this);
        this.toString.addModifyListener((ModifyListener)this);
        this.rangeSelector.addRangeSelectListener(this);
        return container;
    }

    protected void okPressed() {
        this.entry.setInsert01(this.insert01.getSelection());
        this.entry.setInsert01FieldName(this.insert01FieldName.getText().trim().isEmpty() ? null : this.insert01FieldName.getText().trim());
        this.entry.setRedefinesLevel(this.redefinesLevel.getText().trim().isEmpty() ? 0 : Integer.parseInt(this.redefinesLevel.getText().trim()));
        this.entry.setRedefinesFieldName(this.redefinesFieldName.getText().trim().isEmpty() ? null : this.redefinesFieldName.getText().trim());
        this.entry.setRedefinesSetOffset(this.redefinesSetOffset.getSelection());
        this.entry.setRedefinesCOBOLLevelChange(this.redefinesCobolLevelChange.getSelection());
        this.entry.setRangeFromStatement(this.fromStatement.getText().trim().isEmpty() ? 0 : Integer.parseInt(this.fromStatement.getText().trim()));
        this.entry.setRangeToStatement(this.toStatement.getText().trim().isEmpty() ? 0 : Integer.parseInt(this.toStatement.getText().trim()));
        this.entry.setRangeFromString(this.fromString.getText().trim().isEmpty() ? null : this.fromString.getText().trim());
        this.entry.setRangeToString(this.toString.getText().trim().isEmpty() ? null : this.toString.getText().trim());
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.EditAdvancedSelectionCopybookDialog_WINDOW_TITLE);
    }

    public void setCopybookEntry(AdvancedCopybookEntry entry) {
        this.entry = entry;
        if (entry.getContents() == null) {
            try {
                entry.setContents(EditAdvancedSelectionCopybookDialog.readResourceContents(entry.getCopybook()));
                if (this.rangeSelector != null && !this.rangeSelector.isDisposed()) {
                    this.rangeSelector.setContents(entry.getContents());
                }
            }
            catch (Exception e) {
                String errorMessage = MessageFormat.format(Messages.CRRZF2015e, entry.getCopybook().getFormattedName());
                Status errorStatus = new Status(4, "com.ibm.etools.fm.ui", errorMessage, (Throwable)e);
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.TemplateLayoutSelectionComposite_ERROR, null, (IStatus)errorStatus);
                logger.error((Object)("The Create Template wizard failed to load " + entry.getCopybook().getFormattedName()));
            }
        }
    }

    public AdvancedCopybookEntry getCopybookEntry() {
        return this.entry;
    }

    public void modifyText(ModifyEvent event) {
        if (event.widget == this.fromStatement) {
            if (!this.updatingTextFromSelection) {
                this.updateRangeSelection();
            }
        } else if (event.widget == this.toStatement) {
            if (!this.updatingTextFromSelection) {
                this.updateRangeSelection();
            }
        } else if (event.widget == this.fromString) {
            if (!this.updatingTextFromSelection) {
                this.updateRangeSelection();
            }
        } else if (event.widget == this.toString && !this.updatingTextFromSelection) {
            this.updateRangeSelection();
        }
    }

    private void updateRangeSelection() {
        String toStmt;
        String fromStmt;
        String errorMessage = null;
        boolean update = true;
        int from = 0;
        int to = 0;
        if (update && !(fromStmt = this.fromStatement.getText().trim()).equals("")) {
            try {
                from = Integer.parseInt(fromStmt);
                if (from <= 0) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                errorMessage = Messages.EditAdvancedSelectionCopybookDialog_FROM_STATEMENT_NUMERIC;
                update = false;
            }
        }
        if (update && !(toStmt = this.toStatement.getText().trim()).equals("")) {
            try {
                to = Integer.parseInt(toStmt);
                if (to <= 0) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                errorMessage = Messages.EditAdvancedSelectionCopybookDialog_TO_STATEMENT_NUMERIC;
                update = false;
            }
        }
        if (update && to > 0 && from > to) {
            errorMessage = Messages.EditAdvancedSelectionCopybookDialog_FROM_GREATER_THAN_TO;
            update = false;
        }
        if (update) {
            this.rangeSelector.setSelectionRange(from <= 0 ? null : Integer.valueOf(from), to <= 0 ? null : Integer.valueOf(to), this.fromString.getText().trim().equals("") ? null : this.fromString.getText().trim(), this.toString.getText().trim().equals("") ? null : this.toString.getText().trim());
        }
        this.setErrorMessage(errorMessage);
        if (this.getButton(0) != null && !this.getButton(0).isDisposed()) {
            this.getButton(0).setEnabled(errorMessage == null);
        }
    }

    @Override
    public void rangeSelected(Object source, int startRow, int endRow) {
        if (source == this.rangeSelector) {
            this.updatingTextFromSelection = true;
            this.fromStatement.setText(startRow <= 0 ? "" : Integer.valueOf(startRow).toString());
            this.toStatement.setText(endRow <= 0 ? "" : Integer.valueOf(endRow).toString());
            this.fromString.setText("");
            this.toString.setText("");
            this.updatingTextFromSelection = false;
        }
    }

    private static String readResourceContents(final DataSetOrMember resource) throws Exception {
        final AtomicReference sb = new AtomicReference();
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(MessageFormat.format(Messages.TE_infoCopybookEditReadCopybookInProgress, resource.getFormattedName()), 5);
                IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                monitor.worked(1);
                DataSetProperties props = resource.asDataSet().getProperties();
                FMEditSessionProperties properties = new FMEditSessionProperties(props);
                BaseEditorOptions options = new BaseEditorOptions((IZRL)resource, null, false);
                AbstractSessionFormatted session = AbstractSessionFormatted.createFormattedEditSession((BaseEditorOptions)options, (FMEditSessionProperties)properties);
                Result result = session.startBase(howIsGoing, FormattedEditorPreferencePage.getEditorInitSettings());
                monitor.worked(3);
                if (result.getRC() != 0) {
                    return;
                }
                Result readResult = new Result((Object)new StringBuffer());
                IFile file = session.readAllBytes(howIsGoing, readResult);
                if (file != null && readResult.isSuccessfulWithoutWarnings()) {
                    sb.set(file.getLocation().toString());
                } else {
                    PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.EditAdvancedSelectionCopybookDialog_READ_RES_ERR, resource.getFormattedName()), (String)readResult.getMessagesCombined().toString());
                }
                session.end(howIsGoing);
            }
        });
        if (sb.get() != null) {
            StringBuffer copybookContents = new StringBuffer();
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileInputStream inStream = new FileInputStream((String)sb.get());){
                EditType contents = EditorDataSerializeUtils.load((InputStream)inStream, (IZRL)resource);
                EList records = contents.getRec();
                int i = 0;
                while (i < records.size()) {
                    String aRecLine = StringUtils.parseHexString((String)((RecType)records.get(i)).getHex(), (String)resource.getSystem().getCodePage());
                    if (aRecLine != null) {
                        if (i == 0) {
                            copybookContents.append(aRecLine);
                        } else {
                            copybookContents.append("\n" + aRecLine);
                        }
                    }
                    ++i;
                }
                return copybookContents.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return null;
    }
}

