/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.template.dialogs.StatusMarker;
import com.ibm.etools.fm.editor.template.dialogs.listeners.DynamicStartVerifyListener;
import com.ibm.etools.fm.editor.template.dialogs.listeners.NumericVerifyListener;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TypeType;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class DefineDynamicFieldDialog
extends TitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private int FIELDNAME_MAXLEN = 30;
    private static final TypeType[] DYNAMIC_TYPES = new TypeType[]{TypeType.AN, TypeType.AX, TypeType.B, TypeType.BI, TypeType.BT, TypeType.C, TypeType.DB, TypeType.FE, TypeType.FP, TypeType.G, TypeType.P, TypeType.PD, TypeType.VB, TypeType.VC, TypeType.VD, TypeType.VG, TypeType.Z2, TypeType.ZC, TypeType.ZD, TypeType.ZG};
    private Symboltype symbol;
    private IPDHost pdHost = null;
    private Text name;
    private Combo type;
    private Text start;
    private Text length;
    private HashMap<Widget, StatusMarker> widgetToStatusMarkerMap;

    public DefineDynamicFieldDialog(Shell parentShell, Symboltype symbol, IPDHost pdHost) {
        super(parentShell);
        this.symbol = symbol;
        this.pdHost = pdHost;
        this.widgetToStatusMarkerMap = new HashMap();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.DefineDynamicFieldDialog_TITLE);
        this.setMessage(Messages.DefineDynamicFieldDialog_MESSAGE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.fmi.cshelp.template_editor");
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(3, false));
        Label l2 = new Label(composite, 0);
        l2.setText(Messages.FieldTableViewer_NAME);
        StatusMarker marker = new StatusMarker(composite);
        this.name = new Text(composite, 2052);
        this.name.setTextLimit(this.FIELDNAME_MAXLEN);
        GUI.setTextWidthHint((Text)this.name, (int)this.FIELDNAME_MAXLEN);
        this.widgetToStatusMarkerMap.put((Widget)this.name, marker);
        l2 = new Label(composite, 0);
        l2.setText(Messages.FieldTableViewer_TYPE);
        marker = new StatusMarker(composite);
        this.type = new Combo(composite, 12);
        TypeType[] typeTypeArray = DYNAMIC_TYPES;
        int n = DYNAMIC_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            TypeType t = typeTypeArray[n2];
            this.type.add(t.getLiteral());
            this.type.setData(t.getLiteral(), (Object)t);
            ++n2;
        }
        this.widgetToStatusMarkerMap.put((Widget)this.type, marker);
        l2 = new Label(composite, 0);
        l2.setText(Messages.FieldTableViewer_START);
        marker = new StatusMarker(composite);
        this.start = new Text(composite, 2052);
        this.start.setTextLimit(6);
        GUI.setTextWidthHint((Text)this.start, (int)6);
        this.start.addVerifyListener((VerifyListener)new DynamicStartVerifyListener());
        this.widgetToStatusMarkerMap.put((Widget)this.start, marker);
        l2 = new Label(composite, 0);
        l2.setText(Messages.FieldTableViewer_LENGTH);
        marker = new StatusMarker(composite);
        this.length = new Text(composite, 2052);
        this.length.setTextLimit(6);
        GUI.setTextWidthHint((Text)this.length, (int)6);
        this.length.addVerifyListener((VerifyListener)new NumericVerifyListener());
        this.widgetToStatusMarkerMap.put((Widget)this.length, marker);
        this.populateControls();
        ValidateNotifier notifier = new ValidateNotifier();
        this.start.addModifyListener((ModifyListener)notifier);
        this.type.addSelectionListener((SelectionListener)notifier);
        this.name.addModifyListener((ModifyListener)notifier);
        this.length.addModifyListener((ModifyListener)notifier);
        return composite;
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.validate();
        return c;
    }

    private void validate() {
        String errMsg = null;
        StatusMarker marker = this.widgetToStatusMarkerMap.get(this.type);
        Status status = new Status(0, "com.ibm.etools.fm.ui", "");
        int vbIndex = this.type.indexOf(TypeType.VB.getLiteral());
        int vcIndex = this.type.indexOf(TypeType.VC.getLiteral());
        int vdIndex = this.type.indexOf(TypeType.VD.getLiteral());
        int vgIndex = this.type.indexOf(TypeType.VG.getLiteral());
        if (this.type.getSelectionIndex() == vbIndex || this.type.getSelectionIndex() == vcIndex || this.type.getSelectionIndex() == vdIndex || this.type.getSelectionIndex() == vgIndex) {
            status = new Status(2, "com.ibm.etools.fm.ui", Messages.DefineDynamicFieldDialog_VARYING_TYPE_WARNING);
        }
        if (marker != null && !marker.isDisposed()) {
            marker.setStatus((IStatus)status);
        }
        if (errMsg == null && status.matches(4)) {
            errMsg = status.getMessage();
        }
        marker = this.widgetToStatusMarkerMap.get(this.start);
        status = new Status(0, "com.ibm.etools.fm.ui", "");
        if (this.start.getText().trim().length() < 1) {
            status = new Status(4, "com.ibm.etools.fm.ui", Messages.DefineDynamicFieldDialog_START_IS_ZERO_ERROR);
        } else {
            String val = this.start.getText().trim();
            boolean allZeros = true;
            int i = 0;
            while (i < val.length()) {
                if (val.charAt(i) != '0') {
                    allZeros = false;
                    break;
                }
                ++i;
            }
            if (allZeros) {
                status = new Status(4, "com.ibm.etools.fm.ui", Messages.DefineDynamicFieldDialog_START_IS_ZERO_ERROR);
            }
        }
        if (marker != null && !marker.isDisposed()) {
            marker.setStatus((IStatus)status);
        }
        if (errMsg == null && status.matches(4)) {
            errMsg = status.getMessage();
        }
        marker = this.widgetToStatusMarkerMap.get(this.length);
        status = new Status(0, "com.ibm.etools.fm.ui", "");
        if (this.length.getText().trim().length() < 1) {
            status = new Status(4, "com.ibm.etools.fm.ui", Messages.DefineDynamicFieldDialog_LENGTH_ERROR);
        } else {
            int val = Integer.valueOf(this.length.getText().trim());
            int typeIndex = this.type.getSelectionIndex();
            if (TypeType.B.equals((Object)DYNAMIC_TYPES[typeIndex]) || TypeType.BI.equals((Object)DYNAMIC_TYPES[typeIndex])) {
                if (val != 1 && val != 2 && val != 4 && val != 8) {
                    status = new Status(4, "com.ibm.etools.fm.ui", MessageFormat.format(Messages.DefineDynamicFieldDialog_LENGTH_BIERROR, DYNAMIC_TYPES[typeIndex].getLiteral()));
                }
            } else if (TypeType.BT.equals((Object)DYNAMIC_TYPES[typeIndex]) || TypeType.VB.equals((Object)DYNAMIC_TYPES[typeIndex]) || TypeType.VC.equals((Object)DYNAMIC_TYPES[typeIndex]) || TypeType.ZC.equals((Object)DYNAMIC_TYPES[typeIndex])) {
                if (val <= 0) {
                    status = new Status(4, "com.ibm.etools.fm.ui", MessageFormat.format(Messages.DefineDynamicFieldDialog_LENGTH_IS_ZERO_ERROR, DYNAMIC_TYPES[typeIndex].getLiteral()));
                }
            } else if (TypeType.DB.equals((Object)DYNAMIC_TYPES[typeIndex]) || TypeType.G.equals((Object)DYNAMIC_TYPES[typeIndex]) || TypeType.VD.equals((Object)DYNAMIC_TYPES[typeIndex]) || TypeType.VG.equals((Object)DYNAMIC_TYPES[typeIndex]) || TypeType.Z2.equals((Object)DYNAMIC_TYPES[typeIndex]) || TypeType.ZG.equals((Object)DYNAMIC_TYPES[typeIndex])) {
                if (val <= 0 || val % 2 != 0) {
                    status = new Status(4, "com.ibm.etools.fm.ui", MessageFormat.format(Messages.DefineDynamicFieldDialog_LENGTH_EVEN_ERROR, DYNAMIC_TYPES[typeIndex].getLiteral()));
                }
            } else if (TypeType.FE.equals((Object)DYNAMIC_TYPES[typeIndex])) {
                if (val < 7 || val > 23) {
                    status = new Status(4, "com.ibm.etools.fm.ui", MessageFormat.format(Messages.DefineDynamicFieldDialog_LENGTH_RANGE_ERROR, DYNAMIC_TYPES[typeIndex].getLiteral(), 7, 23));
                }
            } else if (TypeType.FP.equals((Object)DYNAMIC_TYPES[typeIndex])) {
                if (val != 4 && val != 8) {
                    status = new Status(4, "com.ibm.etools.fm.ui", MessageFormat.format(Messages.DefineDynamicFieldDialog_LENGTH_FPERROR, DYNAMIC_TYPES[typeIndex].getLiteral()));
                }
            } else if (TypeType.P.equals((Object)DYNAMIC_TYPES[typeIndex]) || TypeType.PD.equals((Object)DYNAMIC_TYPES[typeIndex])) {
                if (val <= 0 || val > 16) {
                    status = new Status(4, "com.ibm.etools.fm.ui", MessageFormat.format(Messages.DefineDynamicFieldDialog_LENGTH_RANGE_ERROR, DYNAMIC_TYPES[typeIndex].getLiteral(), 1, 16));
                }
            } else if (TypeType.ZD.equals((Object)DYNAMIC_TYPES[typeIndex]) && (val <= 0 || val > 32)) {
                status = new Status(4, "com.ibm.etools.fm.ui", MessageFormat.format(Messages.DefineDynamicFieldDialog_LENGTH_RANGE_ERROR, DYNAMIC_TYPES[typeIndex].getLiteral(), 1, 32));
            }
        }
        if (marker != null && !marker.isDisposed()) {
            marker.setStatus((IStatus)status);
        }
        if (errMsg == null && status.matches(4)) {
            errMsg = status.getMessage();
        }
        this.setErrorMessage(errMsg);
        Button okButton = this.getButton(0);
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(errMsg == null);
        }
    }

    private void populateControls() {
        this.name.setText(this.symbol.getName(this.pdHost));
        if (this.type.indexOf(this.symbol.getType().getLiteral()) >= 0) {
            this.type.select(this.type.indexOf(this.symbol.getType().getLiteral()));
        }
        this.start.setText((String)(this.symbol.isOffset() ? "+" + String.valueOf(this.symbol.getStart()) : (this.symbol.getStart() > 0 ? String.valueOf(this.symbol.getStart()) : "")));
        this.length.setText(this.symbol.isSetLength() ? String.valueOf(this.symbol.getLength()) : "");
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.DefineDynamicFieldDialog_WINDOW_TITLE);
    }

    protected void okPressed() {
        String strt;
        TypeType newType;
        int newLength = Integer.valueOf(this.length.getText().trim());
        int typeIndex = this.type.getSelectionIndex();
        TypeType typeType = newType = typeIndex >= 0 ? DYNAMIC_TYPES[typeIndex] : null;
        if (this.symbol.getDatetime() != null && (this.symbol.getLength() != newLength || newType != null && newType != this.symbol.getType())) {
            if (!PDDialogs.openConfirm((String)Messages.Warning, (String)Messages.DateTime_Loss_Warning)) {
                return;
            }
            this.symbol.setDatetime(null);
        }
        this.symbol.setName(this.name.getText().trim());
        if (newType != null) {
            this.symbol.setType(newType);
        }
        if ((strt = this.start.getText().trim()).startsWith("+")) {
            this.symbol.setOffset(true);
            strt = strt.substring(1);
            if (strt.isEmpty()) {
                this.symbol.setStart(0);
            } else {
                this.symbol.setStart(Integer.valueOf(strt).intValue());
            }
        } else {
            this.symbol.setOffset(false);
            this.symbol.setStart(Integer.valueOf(strt).intValue());
        }
        this.symbol.setLength(newLength);
        super.okPressed();
    }

    public Symboltype getSymbol() {
        return this.symbol;
    }

    private class ValidateNotifier
    extends SelectionAdapter
    implements ModifyListener {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private ValidateNotifier() {
        }

        public void widgetSelected(SelectionEvent e) {
            DefineDynamicFieldDialog.this.validate();
        }

        public void modifyText(ModifyEvent event) {
            DefineDynamicFieldDialog.this.validate();
        }
    }
}

