/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.IRetrieveCcsidSession;
import com.ibm.etools.fm.editor.template.dialogs.AbstractDateTimeDialog;
import com.ibm.etools.fm.model.template.Datetimetype;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TypeType;
import com.ibm.etools.fm.model.template.datetimescrtype;
import com.ibm.etools.fm.model.template.impl.DatetimetypeImpl;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DateTimeDialog
extends AbstractDateTimeDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(DateTimeDialog.class);
    private IPDHost pdHost = null;
    private boolean enabledDT;
    private int fieldLength;
    private MyDatetimetypeImp myDatetimetypeImp = new MyDatetimetypeImp();
    private Button DT;
    private Combo iFormat;
    private Combo iType;
    private Combo oFormat;
    private Text formatExample;
    private Text baseDate;
    private Text dayAdj;
    private Text monthAdj;
    private Text yearAdj;
    private Button scrTypeRandom;
    private Text rangeStart;
    private Text rangeEnd;
    private String[] internalFormats = new String[]{"CBLDATE", "STCK", "STCKE", "LILDATE", "LILTIME", "CYYDDD", "YYDDD", "YYYYYMMDD", "MMDDYYYY", "DDMMYYYY", "YYMMDDHHMISS", "YYYYMMDDHHMISS", "CENTSECS", "MICSECS", "MILLSECS"};
    private String[] typeOverrides = new String[]{Messages.DateTimeDialog_Type_Asis, "PD", "BI", "AN"};
    private String[] outputFormats = new String[]{"MM/DD/YY", "MM/DD/YYYY", "DD/MM/YY", "DD/MM/YYYY", "YYYY/MM/DD", "Www Mmm DD, YYYY", "MM/DD/YY HH:MI", "DD/MM/YY HH:MI", "MM/DD/YYYY HH:MI", "DD/MM/YYYY HH:MI", "YYYY/MM/DD HH:MI", "HH:MI AP Www Mmm DD, YYYY"};
    private String[] exampleFormats = new String[]{"MM/dd/YY", "MM/dd/YYYY", "dd/MM/YY", "dd/MM/YYYY", "YYYY/MM/dd", "eee MMM dd, YYYY", "MM/dd/YY HH:mm", "dd/MM/YY HH:mm", "MM/dd/YYYY HH:mm", "dd/MM/YYYY HH:mm", "YYYY/MM/dd HH:mm", "hh:mm a eee MMM dd, YYYY"};

    public DateTimeDialog(IRetrieveCcsidSession aSession, IPDHost aHostProvider, Layouttype aLayout, int selectedInd) {
        super(aSession, aLayout, selectedInd);
        this.pdHost = aHostProvider;
        this.fieldLength = ((Symboltype)aLayout.getSymbol().get(selectedInd)).getLength();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.DateTimeDialog_Title);
        this.setMessage(Messages.DateTimeDialog_Msg);
        parent.setLayout((Layout)GUI.grid.l.noMargins((int)1, (boolean)true));
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        scrolledComposite.setLayoutData((Object)GUI.grid.d.fillAll());
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Composite composite = GUI.composite((Composite)scrolledComposite, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        scrolledComposite.setContent((Control)composite);
        this.DT = GUI.button.checkbox((Composite)composite, (String)Messages.DateTimeDialog_Enable, (Object)GUI.grid.d.standard());
        Group internalGroup = GUI.group((Composite)composite, (String)Messages.DateTimeSec1_Title, (Layout)GUI.grid.l.margins((int)3, (boolean)true), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)internalGroup, (String)Messages.DateTimeSec1_Format, (Object)GUI.grid.d.left1());
        this.iFormat = GUI.combo.editable((Composite)internalGroup, (Object)GUI.grid.d.fillH((int)2));
        this.iFormat.setItems(this.internalFormats);
        this.iFormat.setToolTipText(Messages.DateTimeDialog_Tooltip_Internal_Format);
        new AutoCompleteField((Control)this.iFormat, (IControlContentAdapter)new ComboContentAdapter(), this.internalFormats);
        this.iFormat.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DateTimeDialog.this.validateEnteredValue();
            }
        });
        GUI.label.left((Composite)internalGroup, (String)Messages.DateTimeSec1_Type, (Object)GUI.grid.d.left1());
        this.iType = GUI.combo.readOnly((Composite)internalGroup, (Object)GUI.grid.d.left1(), (Object[])this.typeOverrides);
        this.iType.setToolTipText(Messages.DateTimeDialog_Tooltip_Internal_Type);
        this.iType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DateTimeDialog.this.validateEnteredValue();
            }
        });
        Group outputGroup = GUI.group((Composite)composite, (String)Messages.DateTimeSec2_Title, (Layout)GUI.grid.l.margins((int)3, (boolean)true), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)outputGroup, (String)Messages.DateTimeSec2_Format, (Object)GUI.grid.d.left1());
        this.oFormat = GUI.combo.editable((Composite)outputGroup, (Object)GUI.grid.d.fillH((int)2));
        this.oFormat.setItems(this.outputFormats);
        new AutoCompleteField((Control)this.oFormat, (IControlContentAdapter)new ComboContentAdapter(), this.outputFormats);
        this.oFormat.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DateTimeDialog.this.validateEnteredValue();
                DateTimeDialog.this.updateExample();
            }
        });
        this.oFormat.setToolTipText(Messages.DateTimeDialog_Tooltip_External_Format);
        GUI.label.left((Composite)outputGroup, (String)Messages.DateTimeDialog_Label_Example, (Object)GUI.grid.d.left1());
        this.formatExample = GUI.text.fieldReadOnly((Composite)outputGroup, (Object)GUI.grid.d.fillH((int)2));
        this.formatExample.setToolTipText(Messages.DateTimeDialog_Tooltip_Example);
        Group attributesGroup = GUI.group((Composite)composite, (String)Messages.DateTimeSec3_Title, (Layout)GUI.grid.l.margins((int)3, (boolean)true), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)attributesGroup, (String)Messages.DateTimeSec3_BaseDate, (Object)GUI.grid.d.left1());
        this.baseDate = GUI.text.field((Composite)attributesGroup, (Object)GUI.grid.d.fillH((int)2));
        this.baseDate.setToolTipText(Messages.DateTimeDialog_Tooltip_BaseDate);
        GUI.label.left((Composite)attributesGroup, (String)Messages.DateTimeSec3_Day, (Object)GUI.grid.d.left1());
        this.dayAdj = GUI.text.field((Composite)attributesGroup, (Object)GUI.grid.d.left1());
        this.dayAdj.setToolTipText(Messages.DateTimeDialog_Tooltip_Adjust);
        GUI.grid.padding((Composite)attributesGroup, (int)1);
        GUI.label.left((Composite)attributesGroup, (String)Messages.DateTimeSec3_Month, (Object)GUI.grid.d.left1());
        this.monthAdj = GUI.text.field((Composite)attributesGroup, (Object)GUI.grid.d.left1());
        this.monthAdj.setToolTipText(Messages.DateTimeDialog_Tooltip_Adjust);
        GUI.grid.padding((Composite)attributesGroup, (int)1);
        GUI.label.left((Composite)attributesGroup, (String)Messages.DateTimeSec3_Year, (Object)GUI.grid.d.left1());
        this.yearAdj = GUI.text.field((Composite)attributesGroup, (Object)GUI.grid.d.left1());
        this.yearAdj.setToolTipText(Messages.DateTimeDialog_Tooltip_Adjust);
        GUI.grid.padding((Composite)attributesGroup, (int)1);
        Group scrambleGroup = GUI.group((Composite)composite, (String)Messages.DateTimeSec4_Title, (Layout)GUI.grid.l.margins((int)3, (boolean)true), (Object)GUI.grid.d.fillH((int)3));
        this.scrTypeRandom = GUI.button.checkbox((Composite)scrambleGroup, (String)Messages.DateTimeSec4_Random, (Object)GUI.grid.d.fillH((int)3));
        String rangeTooltip = Messages.DateTimeDialog_Tooltip_Range;
        GUI.label.left((Composite)scrambleGroup, (String)Messages.DateTimeSec4_RangeStart, (Object)GUI.grid.d.left1());
        this.rangeStart = GUI.text.field((Composite)scrambleGroup, (Object)GUI.grid.d.fillH((int)1));
        this.rangeStart.setToolTipText(rangeTooltip);
        GUI.grid.padding((Composite)scrambleGroup, (int)1);
        GUI.label.left((Composite)scrambleGroup, (String)Messages.DateTimeSec4_RangeEnd, (Object)GUI.grid.d.left1());
        this.rangeEnd = GUI.text.field((Composite)scrambleGroup, (Object)GUI.grid.d.fillH((int)1));
        this.rangeEnd.setToolTipText(rangeTooltip);
        this.populateControls();
        this.DT.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateTimeDialog.this.enableDT();
                DateTimeDialog.this.validateEnteredValue();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DateTimeDialog.this.enableDT();
                DateTimeDialog.this.validateEnteredValue();
            }
        });
        this.scrTypeRandom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        return composite;
    }

    private void updateExample() {
        if (this.oFormat.getText().length() == 0) {
            this.formatExample.setText(null);
        } else {
            int format = -1;
            int i = 0;
            while (i < this.outputFormats.length) {
                if (this.outputFormats[i].equals(this.oFormat.getText())) {
                    format = i;
                    this.oFormat.select(format);
                }
                ++i;
            }
            if (format == -1) {
                this.formatExample.setText(Messages.DateTimeDialog_Example_UserDefined);
            } else if (format > this.exampleFormats.length) {
                logger.debug((Object)"Array index out of bounds. Ensure outputFormat and exampleFormat arrays of equal length");
            } else {
                try {
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.exampleFormats[format]);
                    LocalDateTime exampleDT = LocalDateTime.now();
                    this.formatExample.setText(exampleDT.format(formatter));
                }
                catch (Exception e) {
                    this.formatExample.setText("Invalid Output Format");
                }
            }
        }
    }

    private void populateControls() {
        int i;
        Symboltype symbol = (Symboltype)this.aLayout.getSymbol().get(this.selectedInd);
        Datetimetype symbolDateTime = symbol.getDatetime();
        if (!DateTimeDialog.DeletedDateTime(symbolDateTime)) {
            this.enabledDT = true;
            this.myDatetimetypeImp = new MyDatetimetypeImp(symbolDateTime);
            this.DT.setSelection(true);
        } else {
            this.myDatetimetypeImp = new MyDatetimetypeImp();
            this.DT.setSelection(false);
        }
        if (this.myDatetimetypeImp.getDatetimetype().getIform() != null) {
            this.iFormat.setText(this.myDatetimetypeImp.getDatetimetype().getIform());
            i = 0;
            while (i < this.internalFormats.length) {
                if (this.internalFormats[i].equals(this.myDatetimetypeImp.getDatetimetype().getIform())) {
                    this.iFormat.select(i);
                    break;
                }
                ++i;
            }
        }
        if (this.myDatetimetypeImp.getDatetimetype().isSetItype() && this.myDatetimetypeImp.getDatetimetype().getItype() != null) {
            this.iType.setText(this.myDatetimetypeImp.getDatetimetype().getItype().getLiteral());
            i = 0;
            while (i < this.typeOverrides.length) {
                if (this.typeOverrides[i].equals(this.myDatetimetypeImp.getDatetimetype().getItype().getLiteral())) {
                    this.iType.select(i);
                    break;
                }
                ++i;
            }
        } else {
            this.iType.select(0);
        }
        if (this.myDatetimetypeImp.getDatetimetype().getOform() != null) {
            this.oFormat.setText(this.myDatetimetypeImp.getDatetimetype().getOform());
            i = 0;
            while (i < this.outputFormats.length) {
                if (this.outputFormats[i].equals(this.myDatetimetypeImp.getDatetimetype().getOform())) {
                    this.oFormat.select(i);
                    break;
                }
                ++i;
            }
        } else {
            this.formatExample.setText(null);
        }
        if (this.myDatetimetypeImp.getDatetimetype().getBdate() != null) {
            this.baseDate.setText(this.myDatetimetypeImp.getDatetimetype().getBdate());
        }
        this.dayAdj.setText((String)(this.myDatetimetypeImp.getDatetimetype().isSetDdadj() ? "" + this.myDatetimetypeImp.getDatetimetype().getDdadj() : ""));
        this.monthAdj.setText((String)(this.myDatetimetypeImp.getDatetimetype().isSetMmadj() ? "" + this.myDatetimetypeImp.getDatetimetype().getMmadj() : ""));
        this.yearAdj.setText((String)(this.myDatetimetypeImp.getDatetimetype().isSetYyadj() ? "" + this.myDatetimetypeImp.getDatetimetype().getYyadj() : ""));
        this.scrTypeRandom.setSelection(this.myDatetimetypeImp.getDatetimetype().isSetScrtype() && this.myDatetimetypeImp.getDatetimetype().getScrtype() == datetimescrtype.RANDOM);
        this.rangeStart.setText(this.myDatetimetypeImp.getDatetimetype().getScrstart() != null ? this.myDatetimetypeImp.getDatetimetype().getScrstart() : "");
        this.rangeEnd.setText(this.myDatetimetypeImp.getDatetimetype().getScrend() != null ? this.myDatetimetypeImp.getDatetimetype().getScrend() : "");
        this.enableDT();
    }

    private void enableDT() {
        boolean enableDT = this.DT.getSelection();
        this.iFormat.setEnabled(enableDT);
        this.iType.setEnabled(enableDT);
        this.oFormat.setEnabled(enableDT);
        this.formatExample.setEnabled(enableDT);
        this.baseDate.setEnabled(enableDT);
        this.dayAdj.setEnabled(enableDT);
        this.monthAdj.setEnabled(enableDT);
        this.yearAdj.setEnabled(enableDT);
        this.scrTypeRandom.setEnabled(enableDT);
        this.rangeStart.setEnabled(enableDT);
        this.rangeEnd.setEnabled(enableDT);
    }

    private int iFormatLength() {
        String format;
        switch (format = this.iFormat.getText().trim()) {
            case "LILDATE": {
                return 6;
            }
            case "MILLSECS": 
            case "CENTSECS": 
            case "STCK": 
            case "CBLDATE": {
                return 8;
            }
            case "LILTIME": 
            case "MICSECS": {
                return 11;
            }
            case "STCKE": {
                return 16;
            }
        }
        return format.length();
    }

    private boolean validateType() {
        block5 : switch (this.iType.getText()) {
            case "BI": {
                switch (this.fieldLength) {
                    case 2: 
                    case 4: 
                    case 8: {
                        if (this.fieldLength * 2 + 1 >= this.iFormatLength()) break block5;
                        this.setErrorMessage(String.format(Messages.DateTimeDialog_Validation_TooSmall, this.fieldLength, this.iFormatLength()));
                        return false;
                    }
                    default: {
                        this.setErrorMessage(String.format(Messages.DateTimeDialog_Validation_BinaryLength, this.fieldLength));
                        return false;
                    }
                }
            }
            case "PD": {
                if (this.fieldLength * 2 + 1 >= this.iFormatLength()) break;
                this.setErrorMessage(String.format(Messages.DateTimeDialog_Validation_TooSmall, this.fieldLength, this.iFormatLength()));
                return false;
            }
            case "AN": {
                if (this.fieldLength >= this.iFormatLength()) break;
                this.setErrorMessage(String.format(Messages.DateTimeDialog_Validation_TooSmall, this.fieldLength, this.iFormatLength()));
                return false;
            }
            default: {
                this.setMessage(Messages.DateTimeDialog_Validation_UponSave, 1);
                return true;
            }
        }
        this.setMessage(null);
        return true;
    }

    private boolean checkCompletion() {
        if (this.DT.getSelection()) {
            if (this.iFormat.getText() == null || this.iFormat.getText().trim().isEmpty()) {
                this.setErrorMessage(Messages.DateTimeSec1_Format_Empty);
                return false;
            }
            if (this.oFormat.getText() == null || this.oFormat.getText().trim().isEmpty()) {
                this.setErrorMessage(Messages.DateTimeSec2_Format_Empty);
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean validateEnteredValue() {
        boolean complete = this.checkCompletion();
        boolean valid = this.validateType();
        this.setValidated(valid);
        this.setComplete(this.checkCompletion());
        if (valid && complete) {
            this.setErrorMessage(null);
        }
        return valid && complete;
    }

    @Override
    boolean changedValues() {
        if (this.enabledDT != this.DT.getSelection()) {
            return true;
        }
        if (!this.DT.getSelection() && !this.enabledDT) {
            return false;
        }
        if (!this.myDatetimetypeImp.getDatetimetype().getIform().equals(this.iFormat.getText()) || !this.myDatetimetypeImp.getDatetimetype().getOform().equals(this.oFormat.getText())) {
            return true;
        }
        if (this.iType.getText() != null) {
            if (this.myDatetimetypeImp.getDatetimetype().getItype() != null) {
                if (!this.myDatetimetypeImp.getDatetimetype().getItype().equals((Object)this.iType.getText())) {
                    return true;
                }
            } else {
                return true;
            }
        }
        if (this.baseDate.getText() != null) {
            if (this.myDatetimetypeImp.getDatetimetype().getBdate() != null) {
                if (!this.myDatetimetypeImp.getDatetimetype().getBdate().equals(this.baseDate.getText())) {
                    return true;
                }
            } else {
                return true;
            }
        }
        if (this.dayAdj.getText() != null) {
            if (this.myDatetimetypeImp.getDatetimetype().isSetDdadj()) {
                if (this.myDatetimetypeImp.getDatetimetype().getDdadj() != Integer.valueOf(this.dayAdj.getText().trim()).intValue()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        if (this.monthAdj.getText() != null) {
            if (this.myDatetimetypeImp.getDatetimetype().isSetMmadj()) {
                if (this.myDatetimetypeImp.getDatetimetype().getMmadj() != Integer.valueOf(this.monthAdj.getText().trim()).intValue()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        if (this.yearAdj.getText() != null) {
            if (this.myDatetimetypeImp.getDatetimetype().isSetYyadj()) {
                if (this.myDatetimetypeImp.getDatetimetype().getYyadj() != Integer.valueOf(this.yearAdj.getText().trim()).intValue()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        if (this.scrTypeRandom.getSelection() != (this.myDatetimetypeImp.getDatetimetype().isSetScrtype() && this.myDatetimetypeImp.getDatetimetype().getScrtype() == datetimescrtype.RANDOM)) {
            return true;
        }
        if (this.rangeStart.getText() != null) {
            if (this.myDatetimetypeImp.getDatetimetype().getScrstart() != null) {
                if (!this.myDatetimetypeImp.getDatetimetype().getScrstart().equals(this.rangeStart.getText())) {
                    return true;
                }
            } else {
                return true;
            }
        }
        if (this.rangeEnd.getText() != null) {
            if (this.myDatetimetypeImp.getDatetimetype().getScrend() != null) {
                if (!this.myDatetimetypeImp.getDatetimetype().getScrend().equals(this.rangeEnd.getText())) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    void setValues(Symboltype symboltype) {
        Datetimetype datetimeType;
        boolean repeatScramble = false;
        if (!this.enabledDT) {
            if (this.DT.getSelection()) {
                symboltype.setDatetime(this.myDatetimetypeImp.getDatetimetype());
            }
        } else if (!this.DT.getSelection()) {
            symboltype.setDatetime(new MyDatetimetypeImp().setDeleted());
            return;
        }
        if ((datetimeType = symboltype.getDatetime()) == null) {
            return;
        }
        datetimeType.setIform(null);
        datetimeType.setIform(this.iFormat.getText());
        datetimeType.unsetItype();
        String tmpStr = this.iType.getText();
        if (tmpStr != this.typeOverrides[0] && !(tmpStr = tmpStr.trim()).isEmpty()) {
            datetimeType.setItype(TypeType.get((String)tmpStr));
        }
        datetimeType.setOform(null);
        datetimeType.setOform(this.oFormat.getText());
        datetimeType.unsetBdate();
        tmpStr = this.baseDate.getText();
        if (tmpStr != null && !(tmpStr = tmpStr.trim()).isEmpty()) {
            datetimeType.setBdate(tmpStr);
        }
        datetimeType.unsetDdadj();
        tmpStr = this.dayAdj.getText();
        if (tmpStr != null && !(tmpStr = tmpStr.trim()).isEmpty()) {
            datetimeType.setDdadj(Integer.valueOf(tmpStr).intValue());
        }
        datetimeType.unsetMmadj();
        tmpStr = this.monthAdj.getText();
        if (tmpStr != null && !(tmpStr = tmpStr.trim()).isEmpty()) {
            datetimeType.setMmadj(Integer.valueOf(tmpStr).intValue());
        }
        datetimeType.unsetYyadj();
        tmpStr = this.yearAdj.getText();
        if (tmpStr != null && !(tmpStr = tmpStr.trim()).isEmpty()) {
            datetimeType.setYyadj(Integer.valueOf(tmpStr).intValue());
        }
        datetimeType.unsetScrtype();
        if (this.scrTypeRandom.getSelection()) {
            datetimeType.setScrtype(null);
            datetimeType.setScrtype(datetimescrtype.RANDOM);
        }
        datetimeType.unsetScrstart();
        tmpStr = this.rangeStart.getText();
        if (tmpStr != null && !(tmpStr = tmpStr.trim()).isEmpty()) {
            datetimeType.setScrstart(tmpStr);
            repeatScramble = true;
        }
        datetimeType.unsetScrend();
        tmpStr = this.rangeEnd.getText();
        if (tmpStr != null && !(tmpStr = tmpStr.trim()).isEmpty()) {
            datetimeType.setScrend(tmpStr);
            repeatScramble = true;
        }
        if (repeatScramble && !datetimeType.isSetScrtype()) {
            datetimeType.setScrtype(datetimescrtype.REPEAT);
        }
    }

    public static boolean DeletedDateTime(Datetimetype datetimetype) {
        if (datetimetype == null) {
            return true;
        }
        String iform = datetimetype.getIform();
        String oform = datetimetype.getOform();
        return iform != null && oform != null && iform.equalsIgnoreCase(" ") && oform.equalsIgnoreCase(" ");
    }

    private class MyDatetimetypeImp
    extends DatetimetypeImpl {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        public DatetimetypeImpl datetimetype;

        public MyDatetimetypeImp() {
            String emptyStr = new String("");
            this.setIform(emptyStr);
            this.unsetItype();
            this.setOform(emptyStr);
            this.setBdate(emptyStr);
            this.unsetDdadj();
            this.unsetMmadj();
            this.unsetYyadj();
            this.unsetScrtype();
            this.setScrstart(emptyStr);
            this.setScrend(emptyStr);
            this.datetimetype = null;
        }

        public MyDatetimetypeImp(Datetimetype datetimetype) {
            this.datetimetype = datetimetype instanceof DatetimetypeImpl ? (DatetimetypeImpl)datetimetype : null;
        }

        public Datetimetype getDatetimetype() {
            return this.datetimetype == null ? this : this.datetimetype;
        }

        public Datetimetype setDeleted() {
            this.setIform(" ");
            this.setOform(" ");
            this.unsetBdate();
            this.unsetScrstart();
            this.unsetScrend();
            return this;
        }
    }
}

