/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionTemplate;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.template.TemplateEditor;
import com.ibm.etools.fm.editor.template.dialogs.CriteriaElement;
import com.ibm.etools.fm.editor.template.dialogs.FieldCriteriaSpecificationDialog;
import com.ibm.etools.fm.editor.template2.dialogs.ByFieldCriteriaSpecificationTableLabelProvider;
import com.ibm.etools.fm.model.template.Bylinetype;
import com.ibm.etools.fm.model.template.Criteriatype;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.LparenType;
import com.ibm.etools.fm.model.template.RparenType;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateFactory;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.TypeType1;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ByFieldCriteriaSpecificationDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int TABLE_COLUMN_COUNT = 13;
    private static final int INDEX_STATUS_COLUMN = 0;
    private static final int INDEX_CONNECTOR_COLUMN = 1;
    private static final int INDEX_GROUP_OPEN_COLUMN = 2;
    private static final int INDEX_REF_COLUMN = 3;
    private static final int INDEX_LEVEL_COLUMN = 4;
    private static final int INDEX_FIELD_COLUMN = 5;
    private static final int INDEX_START_COLUMN = 6;
    private static final int INDEX_LEN_COLUMN = 7;
    private static final int INDEX_TYPE_COLUMN = 8;
    private static final int INDEX_OPERATOR_COLUMN = 9;
    private static final int INDEX_CRITERIA_VALUE_COLUMN = 10;
    private static final int INDEX_GROUP_CLOSR_COLUMN = 11;
    private static final int INDEX_ERROR_MESSAGE_COLUMN = 12;
    private Text templateNameText;
    private Text templateLayoutText;
    private Text ridLayoutText;
    private Button ridOrButton;
    private Table criteriaTable;
    private TableViewer criteriaTableViewer;
    private TableCursor criteriaTableCursor;
    private Button addButton;
    private Button modifyButton;
    private Button duplicateButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private AbstractSessionTemplate session;
    private IZRL selectedTemplate;
    private TemplateType currentTemplate;
    private int selectedLayoutIndex = 0;
    private int ridLayoutIndex = -1;
    private TypeType1 criteriaType;
    private TemplateType templateWithNewCriteria;
    private int referenceId;
    private ArrayList<CriteriaElement> currentCriteriaList;

    public ByFieldCriteriaSpecificationDialog(AbstractSessionTemplate session, IZRL aTemplate, TemplateType currentTemplate, int selectedLayoutIndex, int ridLayoutIndex, TypeType1 criteriaType, int referenceId) {
        this.session = session;
        this.selectedTemplate = aTemplate;
        this.currentTemplate = currentTemplate;
        this.selectedLayoutIndex = selectedLayoutIndex;
        this.currentCriteriaList = new ArrayList();
        this.ridLayoutIndex = ridLayoutIndex;
        this.criteriaType = criteriaType;
        this.referenceId = referenceId;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.CriteriaSpecDialog_Title);
        this.setMessage(Messages.CriteriaSpecDialog_Msg);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.createLayoutComposite(composite);
        this.initByExistingCriteria();
        this.validateGroupingSpecification();
        this.populateTable(this.criteriaTableViewer, this.currentCriteriaList);
        return composite;
    }

    private void createLayoutComposite(Composite parent) {
        Composite templateComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)templateComposite, (String)Messages.CriteriaSpecDialog_TemplateName, (Object)GUI.grid.d.left1(), (int)16384);
        this.templateNameText = GUI.text.fieldReadOnly((Composite)templateComposite, (Object)GUI.grid.d.fillH((int)1));
        this.templateNameText.setText(this.selectedTemplate.getFormattedName());
        GUI.label((Composite)templateComposite, (String)Messages.CriteriaSpecDialog_Layout_name, (Object)GUI.grid.d.left1(), (int)16384);
        this.templateLayoutText = GUI.text.fieldReadOnly((Composite)templateComposite, (Object)GUI.grid.d.fillH((int)1));
        this.templateLayoutText.setText(((Symboltype)((Layouttype)this.currentTemplate.getLayout().get(this.selectedLayoutIndex)).getSymbol().get(0)).getName(this.selectedTemplate.getSystem()));
        if (this.criteriaType == TypeType1.RID) {
            GUI.label((Composite)templateComposite, (String)Messages.ByFieldCriteriaSpecificationDialog_0, (Object)GUI.grid.d.left1(), (int)16384);
            this.ridLayoutText = GUI.text.fieldReadOnly((Composite)templateComposite, (Object)GUI.grid.d.fillH((int)1));
            this.ridLayoutText.setText(((Symboltype)((Layouttype)this.currentTemplate.getLayout().get(this.ridLayoutIndex)).getSymbol().get(0)).getName(this.selectedTemplate.getSystem()));
            this.ridOrButton = GUI.button.checkbox((Composite)templateComposite, (String)Messages.ByFieldCriteriaSpecificationDialog_1, (Object)GUI.grid.d.fillH((int)2));
            this.ridOrButton.setToolTipText(Messages.ByFieldCriteriaSpecificationDialog_2);
            Criteriatype criteria = this.getCriteriaForEdit();
            if (criteria != null) {
                this.ridOrButton.setSelection(criteria.isSetOr() || criteria.isOr());
            }
        }
        GridData tableGridData = GUI.grid.d.fillAll();
        tableGridData.heightHint = 300;
        Composite tableComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)tableGridData);
        this.criteriaTable = new Table(tableComposite, 68354);
        this.criteriaTable.setHeaderVisible(true);
        this.criteriaTable.setLinesVisible(true);
        this.criteriaTable.setLayoutData((Object)GUI.grid.d.fillAll());
        this.criteriaTableViewer = new TableViewer(this.criteriaTable);
        this.criteriaTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ByFieldCriteriaSpecificationDialog.createMappingTableColumns(this.criteriaTableViewer);
        this.criteriaTableCursor = new TableCursor(this.criteriaTable, 0);
        this.criteriaTableCursor.setFont(JFaceResources.getTextFont());
        ControlEditor controlEditor = new ControlEditor((Composite)this.criteriaTableCursor);
        controlEditor.grabHorizontal = true;
        controlEditor.grabVertical = true;
        this.criteriaTableCursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ByFieldCriteriaSpecificationDialog.this.handleSelectionEventForGroupStartEndColumn();
            }
        });
        this.criteriaTableCursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ByFieldCriteriaSpecificationDialog.this.handleSelectionEventForGroupStartEndColumn();
            }
        });
        this.createFieldManipulateButtonsComposite(tableComposite);
        this.populateTable(this.criteriaTableViewer, this.currentCriteriaList);
    }

    private void handleSelectionEventForGroupStartEndColumn() {
        int columnNo = this.criteriaTableCursor.getColumn();
        if (columnNo == 2) {
            CriteriaElement selectedCriteria;
            TableItem selectedRow = this.criteriaTableCursor.getRow();
            int rowInex = this.criteriaTable.indexOf(selectedRow);
            selectedCriteria.setGroupStart(!(selectedCriteria = this.currentCriteriaList.get(rowInex)).isGroupStart());
            this.validateGroupingSpecification();
            int[] selection = this.criteriaTable.getSelectionIndices();
            this.populateTable(this.criteriaTableViewer, this.currentCriteriaList);
            this.criteriaTable.setSelection(selection);
            return;
        }
        if (columnNo == 11) {
            CriteriaElement selectedCriteria;
            TableItem selectedRow = this.criteriaTableCursor.getRow();
            int rowInex = this.criteriaTable.indexOf(selectedRow);
            selectedCriteria.setGroupEnd(!(selectedCriteria = this.currentCriteriaList.get(rowInex)).isGroupEnd());
            int[] selection = this.criteriaTable.getSelectionIndices();
            this.validateGroupingSpecification();
            this.populateTable(this.criteriaTableViewer, this.currentCriteriaList);
            this.criteriaTable.setSelection(selection);
            return;
        }
    }

    private static void createMappingTableColumns(TableViewer viewer) {
        FormattedEditorUtility.createTableViewerColumn("", 30, viewer, 0x1000000);
        FormattedEditorUtility.createTableViewerColumn(Messages.CriteriaSpecDialog_CONNECTOR_COLUMN, 80, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.CriteriaSpecDialog_GROUP_OPEN, 80, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.CriteriaSpecDialog_REF_COLUMN, 50, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.CriteriaSpecDialog_LEVEL_COLUMN, 50, viewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.CriteriaSpecDialog_FIELD_COLUMN, 150, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.CriteriaSpecDialog_START_COLUMN, 50, viewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.CriteriaSpecDialog_LEN_COLUMN, 50, viewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.CriteriaSpecDialog_TYPE_COLUMN, 50, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.CriteriaSpecDialog_OPERATOR_COLUMN, 60, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.CriteriaSpecDialog_CRITERIA_VALUE_COLUMN, 150, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.CriteriaSpecDialog_GROUP_CLOSE, 80, viewer, 131072);
        viewer.setLabelProvider((IBaseLabelProvider)new ByFieldCriteriaSpecificationTableLabelProvider(12, 0));
    }

    private void populateTable(TableViewer aTableViewer, ArrayList<CriteriaElement> contents) {
        Layouttype currentLayout = (Layouttype)this.currentTemplate.getLayout().get(this.selectedLayoutIndex);
        ArrayList<String[]> fieldList = new ArrayList<String[]>();
        int i = 0;
        while (i < contents.size()) {
            CriteriaElement anElement = contents.get(i);
            Symboltype aSymbol = anElement.getSymbol();
            String status0 = "";
            String connector1 = i == 0 ? "" : anElement.getConnectorType().getLiteral();
            String groupOpen2 = anElement.getGroupStartMarker();
            String ref3 = TemplateEditor.getFieldReferenceNumberForDisplay(currentLayout, aSymbol, false);
            String level4 = "" + aSymbol.getLvl();
            String field5 = aSymbol.getName(this.selectedTemplate != null ? this.selectedTemplate.getSystem() : null);
            String start6 = "" + aSymbol.getStart();
            String len7 = "" + aSymbol.getLength();
            String type8 = aSymbol.getType().getName();
            String operator9 = anElement.getOperator().getLiteral();
            String criteriaValue10 = anElement.getCriteriaValue();
            String groupCloser11 = anElement.getGroupEndMarker();
            String errorMessage12 = anElement.getErrorMessage();
            fieldList.add(new String[]{status0, connector1, groupOpen2, ref3, level4, field5, start6, len7, type8, operator9, criteriaValue10, groupCloser11, errorMessage12});
            ++i;
        }
        aTableViewer.setInput(fieldList);
    }

    private void createFieldManipulateButtonsComposite(Composite parent) {
        GridData bGridData = GUI.grid.d.left1();
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.left1());
        this.addButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/add.gif"), (String)Messages.CriteriaSpecDialog_addButtonTip, (Object)bGridData);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FieldCriteriaSpecificationDialog dialog;
                ByFieldCriteriaSpecificationDialog.this.setErrorMessage(null);
                boolean allowConnectorChange = true;
                if (ByFieldCriteriaSpecificationDialog.this.criteriaTable.getItemCount() == 0) {
                    allowConnectorChange = false;
                }
                if ((dialog = new FieldCriteriaSpecificationDialog(ByFieldCriteriaSpecificationDialog.this.selectedTemplate, ByFieldCriteriaSpecificationDialog.this.currentTemplate, ByFieldCriteriaSpecificationDialog.this.selectedLayoutIndex, allowConnectorChange)).open() != 0) {
                    return;
                }
                CriteriaElement newElement = dialog.getSpecifiedCriteria();
                if (ByFieldCriteriaSpecificationDialog.this.criteriaTable.getSelectionIndex() != -1) {
                    int insertLocation = ByFieldCriteriaSpecificationDialog.this.criteriaTable.getSelectionIndex() + 1;
                    ByFieldCriteriaSpecificationDialog.this.currentCriteriaList.add(insertLocation, newElement);
                    ByFieldCriteriaSpecificationDialog.this.validateGroupingSpecification();
                    ByFieldCriteriaSpecificationDialog.this.populateTable(ByFieldCriteriaSpecificationDialog.this.criteriaTableViewer, ByFieldCriteriaSpecificationDialog.this.currentCriteriaList);
                    ByFieldCriteriaSpecificationDialog.this.criteriaTable.select(insertLocation);
                    return;
                }
                ByFieldCriteriaSpecificationDialog.this.currentCriteriaList.add(newElement);
                ByFieldCriteriaSpecificationDialog.this.validateGroupingSpecification();
                ByFieldCriteriaSpecificationDialog.this.populateTable(ByFieldCriteriaSpecificationDialog.this.criteriaTableViewer, ByFieldCriteriaSpecificationDialog.this.currentCriteriaList);
                ByFieldCriteriaSpecificationDialog.this.criteriaTable.select(ByFieldCriteriaSpecificationDialog.this.currentCriteriaList.size() - 1);
            }
        });
        this.modifyButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/editfield.gif"), (String)Messages.CriteriaSpecDialog_modifyButtonTip, (Object)bGridData);
        this.modifyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ByFieldCriteriaSpecificationDialog.this.criteriaTable.getSelectionIndex() == -1) {
                    ByFieldCriteriaSpecificationDialog.this.setErrorMessage(Messages.CriteriaSpecDialog_SelectItemWarning);
                    return;
                }
                ByFieldCriteriaSpecificationDialog.this.setErrorMessage(null);
                int selection = ByFieldCriteriaSpecificationDialog.this.criteriaTable.getSelectionIndex();
                boolean allowConnectorChange = selection != 0;
                CriteriaElement modifyElement = ByFieldCriteriaSpecificationDialog.this.currentCriteriaList.get(selection);
                FieldCriteriaSpecificationDialog dialog = new FieldCriteriaSpecificationDialog(ByFieldCriteriaSpecificationDialog.this.selectedTemplate, ByFieldCriteriaSpecificationDialog.this.currentTemplate, ByFieldCriteriaSpecificationDialog.this.selectedLayoutIndex, allowConnectorChange, modifyElement);
                if (dialog.open() != 0) {
                    return;
                }
                ByFieldCriteriaSpecificationDialog.this.validateGroupingSpecification();
                ByFieldCriteriaSpecificationDialog.this.populateTable(ByFieldCriteriaSpecificationDialog.this.criteriaTableViewer, ByFieldCriteriaSpecificationDialog.this.currentCriteriaList);
                ByFieldCriteriaSpecificationDialog.this.criteriaTable.select(selection);
            }
        });
        this.duplicateButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/duplicate.gif"), (String)Messages.CriteriaSpecDialog_duplicateButtonTip, (Object)bGridData);
        this.duplicateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ByFieldCriteriaSpecificationDialog.this.criteriaTable.getSelectionIndex() == -1) {
                    ByFieldCriteriaSpecificationDialog.this.setErrorMessage(Messages.CriteriaSpecDialog_SelectItemWarning);
                    return;
                }
                ByFieldCriteriaSpecificationDialog.this.setErrorMessage(null);
                int selection = ByFieldCriteriaSpecificationDialog.this.criteriaTable.getSelectionIndex();
                CriteriaElement copyFromElement = ByFieldCriteriaSpecificationDialog.this.currentCriteriaList.get(selection);
                CriteriaElement dupElement = new CriteriaElement(copyFromElement.getConnectorType(), copyFromElement.getSymbol(), copyFromElement.getOperator(), copyFromElement.getSequenceNo(), copyFromElement.getCriteriaValue(), copyFromElement.getSystem());
                ByFieldCriteriaSpecificationDialog.this.currentCriteriaList.add(selection + 1, dupElement);
                ByFieldCriteriaSpecificationDialog.this.validateGroupingSpecification();
                ByFieldCriteriaSpecificationDialog.this.populateTable(ByFieldCriteriaSpecificationDialog.this.criteriaTableViewer, ByFieldCriteriaSpecificationDialog.this.currentCriteriaList);
                ByFieldCriteriaSpecificationDialog.this.criteriaTable.select(selection + 1);
            }
        });
        this.removeButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/delete.gif"), (String)Messages.CriteriaSpecDialog_removeButtonTip, (Object)bGridData);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ByFieldCriteriaSpecificationDialog.this.criteriaTable.getSelectionIndex() == -1) {
                    ByFieldCriteriaSpecificationDialog.this.setErrorMessage(Messages.CriteriaSpecDialog_SelectItemWarning);
                    return;
                }
                ByFieldCriteriaSpecificationDialog.this.setErrorMessage(null);
                int[] selection = ByFieldCriteriaSpecificationDialog.this.criteriaTable.getSelectionIndices();
                ArrayList<CriteriaElement> criteriaToRemove = new ArrayList<CriteriaElement>();
                int i = 0;
                while (i < selection.length) {
                    criteriaToRemove.add(ByFieldCriteriaSpecificationDialog.this.currentCriteriaList.get(selection[i]));
                    ++i;
                }
                i = 0;
                while (i < criteriaToRemove.size()) {
                    ByFieldCriteriaSpecificationDialog.this.currentCriteriaList.remove(criteriaToRemove.get(i));
                    ++i;
                }
                ByFieldCriteriaSpecificationDialog.this.validateGroupingSpecification();
                ByFieldCriteriaSpecificationDialog.this.populateTable(ByFieldCriteriaSpecificationDialog.this.criteriaTableViewer, ByFieldCriteriaSpecificationDialog.this.currentCriteriaList);
                if (ByFieldCriteriaSpecificationDialog.this.currentCriteriaList.size() > 0) {
                    if (ByFieldCriteriaSpecificationDialog.this.criteriaTableViewer.getElementAt(selection[0]) != null) {
                        ByFieldCriteriaSpecificationDialog.this.criteriaTable.select(selection[0]);
                    } else {
                        ByFieldCriteriaSpecificationDialog.this.criteriaTable.select(selection[0] - 1);
                    }
                }
            }
        });
        this.upButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/moveup.gif"), (String)Messages.CriteriaSpecDialog_upButtonTip, (Object)bGridData);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ByFieldCriteriaSpecificationDialog.this.criteriaTable.getSelectionIndex() == -1) {
                    ByFieldCriteriaSpecificationDialog.this.setErrorMessage(Messages.CriteriaSpecDialog_SelectItemWarning);
                    return;
                }
                ByFieldCriteriaSpecificationDialog.this.setErrorMessage(null);
                int selectionIndex = ByFieldCriteriaSpecificationDialog.this.criteriaTable.getSelectionIndex();
                if (selectionIndex == 0) {
                    return;
                }
                CriteriaElement selectedItem = ByFieldCriteriaSpecificationDialog.this.currentCriteriaList.get(selectionIndex);
                ByFieldCriteriaSpecificationDialog.this.currentCriteriaList.remove(selectedItem);
                ByFieldCriteriaSpecificationDialog.this.currentCriteriaList.add(selectionIndex - 1, selectedItem);
                ByFieldCriteriaSpecificationDialog.this.validateGroupingSpecification();
                ByFieldCriteriaSpecificationDialog.this.populateTable(ByFieldCriteriaSpecificationDialog.this.criteriaTableViewer, ByFieldCriteriaSpecificationDialog.this.currentCriteriaList);
                ByFieldCriteriaSpecificationDialog.this.criteriaTable.setSelection(selectionIndex - 1);
            }
        });
        this.downButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/movedown.gif"), (String)Messages.CriteriaSpecDialog_downButtonTip, (Object)bGridData);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ByFieldCriteriaSpecificationDialog.this.criteriaTable.getSelectionIndex() == -1) {
                    ByFieldCriteriaSpecificationDialog.this.setErrorMessage(Messages.CriteriaSpecDialog_SelectItemWarning);
                    return;
                }
                ByFieldCriteriaSpecificationDialog.this.setErrorMessage(null);
                int selectionIndex = ByFieldCriteriaSpecificationDialog.this.criteriaTable.getSelectionIndex();
                if (selectionIndex == ByFieldCriteriaSpecificationDialog.this.currentCriteriaList.size() - 1) {
                    return;
                }
                CriteriaElement selectedItem = ByFieldCriteriaSpecificationDialog.this.currentCriteriaList.get(selectionIndex);
                ByFieldCriteriaSpecificationDialog.this.currentCriteriaList.remove(selectedItem);
                ByFieldCriteriaSpecificationDialog.this.currentCriteriaList.add(selectionIndex + 1, selectedItem);
                ByFieldCriteriaSpecificationDialog.this.validateGroupingSpecification();
                ByFieldCriteriaSpecificationDialog.this.populateTable(ByFieldCriteriaSpecificationDialog.this.criteriaTableViewer, ByFieldCriteriaSpecificationDialog.this.currentCriteriaList);
                ByFieldCriteriaSpecificationDialog.this.criteriaTable.setSelection(selectionIndex + 1);
            }
        });
    }

    private boolean validateGroupingSpecification() {
        this.setErrorMessage(null);
        int i = 0;
        while (i < this.currentCriteriaList.size()) {
            CriteriaElement aCriteria = this.currentCriteriaList.get(i);
            aCriteria.setErrorMessage(null);
            ++i;
        }
        Stack<CriteriaElement> groupingStack = new Stack<CriteriaElement>();
        int i2 = 0;
        while (i2 < this.currentCriteriaList.size()) {
            CriteriaElement aCriteria = this.currentCriteriaList.get(i2);
            if (!aCriteria.isGroupStart() || !aCriteria.isGroupEnd()) {
                if (aCriteria.isGroupStart()) {
                    groupingStack.push(aCriteria);
                } else if (aCriteria.isGroupEnd()) {
                    if (groupingStack.isEmpty()) {
                        aCriteria.setErrorMessage(Messages.CriteriaSpecDialog_UnmatchingOperator);
                        this.setErrorMessage(Messages.CriteriaSpecDialog_UnmatchingOperator);
                        return false;
                    }
                    groupingStack.pop();
                }
            }
            ++i2;
        }
        if (groupingStack.size() != 0) {
            CriteriaElement prevCriteria = (CriteriaElement)groupingStack.pop();
            prevCriteria.setErrorMessage(Messages.CriteriaSpecDialog_UnmatchingOperator);
            this.setErrorMessage(Messages.CriteriaSpecDialog_UnmatchingOperator);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private void initByExistingCriteria() {
        Criteriatype currentCriteria = this.getCriteriaForEdit();
        if (currentCriteria == null) {
            return;
        }
        if (!currentCriteria.isSetByfield()) {
            return;
        }
        EList list = currentCriteria.getByline();
        int i = 0;
        while (i < list.size()) {
            Bylinetype aLine = (Bylinetype)list.get(i);
            if (aLine.isSetOper()) {
                CriteriaElement anElement = new CriteriaElement(aLine.getConn(), this.getSymbol(aLine.getSym()), aLine.getOper(), aLine.getSeq(), aLine.getByval(), this.session != null ? this.session.getSystem() : null);
                if (aLine.isSetLparen()) {
                    anElement.setGroupStart(true);
                }
                if (aLine.isSetRparen()) {
                    anElement.setGroupEnd(true);
                }
                ByFieldCriteriaSpecificationDialog.insertBySequenceNo(this.currentCriteriaList, anElement);
            }
            ++i;
        }
    }

    private static void insertBySequenceNo(ArrayList<CriteriaElement> list, CriteriaElement newElement) {
        int i = 0;
        while (i < list.size()) {
            CriteriaElement anElement = list.get(i);
            if (newElement.getSequenceNo() < anElement.getSequenceNo()) {
                list.add(i, newElement);
                return;
            }
            ++i;
        }
        list.add(newElement);
    }

    private Criteriatype getCriteriaForEdit() {
        for (Criteriatype ct : ((Layouttype)this.currentTemplate.getLayout().get(this.selectedLayoutIndex)).getCriteria()) {
            if (ct.getType() != this.criteriaType) continue;
            if (this.criteriaType == TypeType1.RID) {
                if (!ct.isSetRelated01() || ct.getRelated01() != ((Layouttype)this.currentTemplate.getLayout().get(this.ridLayoutIndex)).getId()) continue;
                return ct;
            }
            if (this.criteriaType == TypeType1.RDF) {
                if (ct.getFref() != this.referenceId) continue;
                return ct;
            }
            return ct;
        }
        return null;
    }

    private Symboltype getSymbol(int symbolRef) {
        Layouttype selectedLayout = (Layouttype)this.currentTemplate.getLayout().get(this.selectedLayoutIndex);
        int i = 0;
        while (i < selectedLayout.getSymbol().size()) {
            Symboltype aSymbol = (Symboltype)selectedLayout.getSymbol().get(i);
            if (aSymbol.getRef() == symbolRef) {
                return aSymbol;
            }
            ++i;
        }
        for (Layouttype aLayout : this.currentTemplate.getLayout()) {
            for (Symboltype aSymbol : aLayout.getSymbol()) {
                if (aSymbol.getRef() != symbolRef) continue;
                return aSymbol;
            }
        }
        return null;
    }

    private Layouttype getLayout(int symbolRef) {
        Layouttype selectedLayout = (Layouttype)this.currentTemplate.getLayout().get(this.selectedLayoutIndex);
        int i = 0;
        while (i < selectedLayout.getSymbol().size()) {
            Symboltype aSymbol = (Symboltype)selectedLayout.getSymbol().get(i);
            if (aSymbol.getRef() == symbolRef) {
                return selectedLayout;
            }
            ++i;
        }
        for (Layouttype aLayout : this.currentTemplate.getLayout()) {
            for (Symboltype aSymbol : aLayout.getSymbol()) {
                if (aSymbol.getRef() != symbolRef) continue;
                return aLayout;
            }
        }
        return null;
    }

    private Map<Layouttype, Criteriatype> getNewCriteria() {
        HashMap<Layouttype, Criteriatype> lookup = new HashMap<Layouttype, Criteriatype>();
        int i = 0;
        while (i < this.currentCriteriaList.size()) {
            CriteriaElement anElement = this.currentCriteriaList.get(i);
            Bylinetype aLine = ByFieldCriteriaSpecificationDialog.getCriteriaElement(anElement, i + 1);
            Layouttype aLayout = this.getLayout(anElement.getSymbol().getRef());
            Criteriatype aCriteria = (Criteriatype)lookup.get(aLayout);
            if (aCriteria == null) {
                aCriteria = TemplateFactory.eINSTANCE.createCriteriatype();
                aCriteria.setType(this.criteriaType);
                aCriteria.setByfield(true);
                lookup.put(aLayout, aCriteria);
            }
            if (this.criteriaType == TypeType1.RID) {
                aCriteria.setRelated01(((Layouttype)this.currentTemplate.getLayout().get(this.ridLayoutIndex)).getId());
                aCriteria.setOr(this.ridOrButton.getSelection());
            }
            aCriteria.getByline().add((Object)aLine);
            ++i;
        }
        return lookup;
    }

    private static Bylinetype getCriteriaElement(CriteriaElement anElement, int sequenceNo) {
        Bylinetype aLine = TemplateFactory.eINSTANCE.createBylinetype();
        if (anElement.getCriteriaValue() != null && anElement.getCriteriaValue().length() > 0) {
            aLine.setByval(anElement.getCriteriaValue());
        }
        aLine.setConn(anElement.getConnectorType());
        if (anElement.isGroupStart()) {
            aLine.setLparen(LparenType.__);
        }
        if (anElement.isGroupEnd()) {
            aLine.setRparen(RparenType.__);
        }
        aLine.setOper(anElement.getOperator());
        aLine.setSym(anElement.getSymbol().getRef());
        aLine.setSeq(sequenceNo);
        return aLine;
    }

    private boolean validateCriteria() {
        StringBuffer newTemplate;
        block10: {
            Result result;
            try {
                this.templateWithNewCriteria = null;
                Map<Layouttype, Criteriatype> newCriteriaSpecification = this.getNewCriteria();
                TemplateType aTemplate = TemplateFactory.eINSTANCE.createTemplateType();
                if (this.currentTemplate.isSetSegmented() && this.currentTemplate.isSegmented()) {
                    aTemplate.setSegmented(true);
                }
                for (Map.Entry<Layouttype, Criteriatype> entry : newCriteriaSpecification.entrySet()) {
                    Layouttype aLayout = TemplateFactory.eINSTANCE.createLayouttype();
                    aLayout.setId(entry.getKey().getId());
                    if (entry.getKey().isSetOffset()) {
                        aLayout.setOffset(entry.getKey().getOffset());
                    }
                    aLayout.setSel(entry.getKey().isSel());
                    Criteriatype t = entry.getValue();
                    if (this.criteriaType == TypeType1.RDF) {
                        t.setFref(this.referenceId);
                    }
                    aLayout.getCriteria().add((Object)t);
                    aTemplate.getLayout().add((Object)aLayout);
                }
                final StringBuffer xmlTemplate = TemplateSerializeUtils.save((TemplateType)aTemplate, (IZRL)this.selectedTemplate);
                result = new Result();
                newTemplate = new StringBuffer();
                try {
                    PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask(Messages.CriteriaSpecDialog_CheckCriteriaWithHost, 1);
                            IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                            StringBuffer newXmlTemplate = ByFieldCriteriaSpecificationDialog.this.session.updateTemplate(xmlTemplate, howIsGoing, result, true, false);
                            newTemplate.append(newXmlTemplate);
                        }
                    });
                }
                catch (Exception e) {
                    PDDialogs.openErrorThreadSafe((String)Messages.CriteriaSpecDialog_ExceptionWhileValidatingCriteria, (String)result.dumpOutputAndMessages(true), (Throwable)e);
                    return false;
                }
            }
            catch (Exception e) {
                String errMsg = Messages.CriteriaSpecDialog_ExceptionWhileValidatingCriteria;
                logger.error((Object)errMsg, (Throwable)e);
                PDDialogs.openErrorThreadSafe((String)errMsg);
                return false;
            }
            if (result.isSuccessfulWithoutWarnings()) break block10;
            PDDialogs.openErrorThreadSafe((String)Messages.CriteriaSpecDialog_CriteriaValidationErr, (String)result.dumpOutputAndMessages(true));
            return false;
        }
        this.templateWithNewCriteria = TemplateSerializeUtils.load((StringBuffer)newTemplate, (IZRL)this.selectedTemplate);
        return true;
    }

    public TemplateType getTemplateWithNewCriteria() {
        return this.templateWithNewCriteria;
    }

    protected void okPressed() {
        if (this.currentCriteriaList.isEmpty()) {
            this.setErrorMessage(Messages.CriteriaSpecDialog_NoCriteriaSpecified);
            return;
        }
        if (!this.validateGroupingSpecification()) {
            return;
        }
        if (!this.validateCriteria()) {
            return;
        }
        super.okPressed();
    }
}

