/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.IRetrieveCcsidSession;
import com.ibm.etools.fm.model.template.CreateType;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.DialogUtils;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractCcsidSelectionDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected IRetrieveCcsidSession aSession;
    protected Layouttype aLayout;
    protected int[] selectedIndices;
    private Combo ccsidValueCombo;
    private Button lookupCcsidButton;
    protected Table layoutTable;
    protected TableViewer layoutTableViewer;

    public AbstractCcsidSelectionDialog(IRetrieveCcsidSession aSession, Layouttype aLayout, int[] indices) {
        this.aSession = aSession;
        this.aLayout = aLayout;
        this.selectedIndices = indices != null ? Arrays.copyOf(indices, indices.length) : new int[1];
    }

    protected void createCcsidEntryComposite(Composite parent) {
        Composite entryComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)entryComposite, (String)Messages.CCSID, (Object)GUI.grid.d.left1());
        this.ccsidValueCombo = GUI.combo.editable((Composite)entryComposite, (Object)GUI.grid.d.fillH((int)1));
        new ComboValueSaver(this.ccsidValueCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "ccsid");
        this.ccsidValueCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractCcsidSelectionDialog.this.validateEnteredValue();
            }
        });
        this.lookupCcsidButton = LookupButton.createLookupButton(entryComposite, Messages.AbstractEncodingSelectionDialog_4);
        this.lookupCcsidButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Result overallResult = new Result();
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask(Messages.AbstractCcsidSelectionDialog_0, 2);
                            IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                            if (monitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                            monitor.worked(1);
                            Result result = (this).AbstractCcsidSelectionDialog.this.aSession.retrieveSupportedCcsids(howIsGoing);
                            overallResult.copy(result);
                            monitor.worked(1);
                            monitor.done();
                        }
                    });
                }
                catch (InvocationTargetException e1) {
                    PDDialogs.openErrorThreadSafe((String)Messages.AbstractCcsidSelectionDialog_1, (Throwable)e1);
                    return;
                }
                catch (InterruptedException e1) {
                    PDDialogs.openInfoThreadSafe((String)Messages.AbstractCcsidSelectionDialog_2);
                    return;
                }
                if (overallResult.isSuccessfulWithoutWarnings()) {
                    StringBuffer output = (StringBuffer)overallResult.getOutput();
                    if (output != null) {
                        String[] values = AbstractCcsidSelectionDialog.parseCcsids(output.toString());
                        AbstractCcsidSelectionDialog.this.ccsidValueCombo.setItems(values);
                        AbstractCcsidSelectionDialog.this.ccsidValueCombo.select(0);
                    }
                } else {
                    PDDialogs.openErrorThreadSafe((String)Messages.Error, (String)Messages.AbstractCcsidSelectionDialog_3, (String)overallResult.dumpOutputAndMessages(true));
                }
            }
        });
    }

    public static String[] parseCcsids(String buf) {
        final ArrayList values = new ArrayList();
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(new InputSource(new StringReader(buf)), new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (attributes.getValue(0) != null && attributes.getValue(1) != null) {
                        values.add(attributes.getValue(0) + ": " + attributes.getValue(1));
                        this.printDebugLine(attributes);
                    }
                }

                private void printDebugLine(Attributes attributes) {
                    String ccsid = attributes.getValue(0);
                    String desc = attributes.getValue(1);
                    String encoding = attributes.getLength() > 2 ? attributes.getValue(2) : null;
                    boolean supported = encoding != null ? Charset.isSupported(encoding) : false;
                    logger.debug((Object)("CCSID: " + ccsid + " desc: " + desc + " encoding: " + encoding + " supported: " + supported));
                }
            });
        }
        catch (Exception e) {
            String errMsg = Messages.AbstractCcsidSelectionDialog_4;
            logger.error((Object)errMsg, (Throwable)e);
            DialogUtils.openErrorThreadSafe((String)Messages.Error, (String)errMsg);
            e.printStackTrace();
            return new String[0];
        }
        String[] valueArray = new String[values.size()];
        int i = 0;
        while (i < values.size()) {
            valueArray[i] = (String)values.get(i);
            ++i;
        }
        return valueArray;
    }

    protected abstract void createLayoutTable(Composite var1);

    protected boolean validateEnteredValue() {
        this.setErrorMessage(null);
        return true;
    }

    protected String getEnteredValue() {
        String value = this.ccsidValueCombo.getText().trim();
        if (value.indexOf(58) != -1) {
            return value.substring(0, value.indexOf(58));
        }
        return value;
    }

    protected void okPressed() {
        CreateType createType;
        if (!this.validateEnteredValue()) {
            return;
        }
        if (this.layoutTable.getSelectionIndex() == -1) {
            this.setErrorMessage(Messages.AbstractEncodingSelectionDialog_6);
            return;
        }
        String enteredValue = this.getEnteredValue();
        boolean invalidFieldSelected = false;
        int[] selected = this.layoutTable.getSelectionIndices();
        int i = 0;
        while (i < selected.length) {
            createType = ((Symboltype)this.aLayout.getSymbol().get(selected[i])).getCreate();
            if (createType != CreateType.AN && createType != CreateType.VC) {
                invalidFieldSelected = true;
            }
            ++i;
        }
        if (invalidFieldSelected && !PDDialogs.openQuestion((String)Messages.AbstractEncodingSelectionDialog_7)) {
            return;
        }
        i = 0;
        while (i < selected.length) {
            createType = ((Symboltype)this.aLayout.getSymbol().get(selected[i])).getCreate();
            if (createType == CreateType.AN || createType == CreateType.VC) {
                ((Symboltype)this.aLayout.getSymbol().get(selected[i])).setCcside(null);
                ((Symboltype)this.aLayout.getSymbol().get(selected[i])).setCcsid(enteredValue);
            }
            ++i;
        }
        super.okPressed();
    }
}

