/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionTemplate;
import com.ibm.etools.fm.editor.template.ITemplateEditor;
import com.ibm.etools.fm.editor.template.TemplateEditorUtilities;
import com.ibm.etools.fm.editor.template.dialogs.ByFieldCriteriaSpecificationDialog;
import com.ibm.etools.fm.editor.template.dialogs.FreeCriteriaEntryDialog;
import com.ibm.etools.fm.editor.template.dialogs.LayoutSelectionDialog;
import com.ibm.etools.fm.editor.template.dialogs.NewLayoutNameDialog;
import com.ibm.etools.fm.editor.template.nattable.NatTableWrapper;
import com.ibm.etools.fm.editor.template.nattable.config.TemplateEditorConfiguration;
import com.ibm.etools.fm.jhost.core.version.FMFeature;
import com.ibm.etools.fm.model.template.Criteriatype;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateFactory;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.TypeType;
import com.ibm.etools.fm.model.template.TypeType1;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.version.PDFeature;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class TemplateLayoutComposite {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(TemplateLayoutComposite.class);
    private AbstractSessionTemplate session = null;
    private TemplateType aTemplate = null;
    private IZRL aTemplateResource = null;
    private ITemplateEditor editor = null;
    private Combo currentLayoutCombo = null;
    private Text copybookNameText = null;
    private Button addLayoutButton = null;
    private Button removeLayoutButton = null;
    private Button segmentedTemplateCheckbox = null;
    private Button lzeroCheckBox = null;
    private Button layoutSelectedCheckbox = null;
    private Text idCriteriaText = null;
    private Text selCriteriaText = null;
    private Text relIDCriteriaText = null;
    private Button idCriteriaBuildButton = null;
    private Button idCriteriaWriteButton = null;
    private Button idCriteriaClearButton = null;
    private Button selCriteriaBuildButton = null;
    private Button selCriteriaWritedButton = null;
    private Button selCriteriaClearButton = null;
    private Button ridCriteriaBuildButton = null;
    private Button ridCriteriaWriteButton = null;
    private Text offsetText = null;
    private TabItem layoutTab = null;
    private NatTableWrapper table = null;
    private boolean symbolsUpdated = false;
    private boolean updateInProgress = false;

    public TemplateLayoutComposite(AbstractSessionTemplate session, TemplateType aTemplate, IZRL aTemplateResource, ITemplateEditor editor2) {
        this.session = session;
        this.aTemplate = aTemplate;
        this.aTemplateResource = aTemplateResource;
        this.editor = editor2;
    }

    public void createLayoutTab(TabFolder tabFolder) {
        this.layoutTab = new TabItem(tabFolder, 0);
        this.layoutTab.setText(Messages.TE_layoutTabName);
        Composite parent = GUI.composite((Composite)tabFolder, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        Composite layoutSelComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        Composite layoutLZeroComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)layoutSelComposite, (String)Messages.TE_LAYOUT, (Object)GUI.grid.d.left1(), (int)16384);
        this.currentLayoutCombo = "BASE".equals(this.aTemplate.getType()) || "DYNAMIC".equals(this.aTemplate.getType()) ? GUI.combo.readOnly((Composite)layoutSelComposite, (Object)GUI.grid.d.fillH((int)1), (Object[])new String[0]) : GUI.combo.readOnly((Composite)layoutSelComposite, (Object)GUI.grid.d.fillH((int)3), (Object[])new String[0]);
        this.currentLayoutCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int selectionIndex = TemplateLayoutComposite.this.currentLayoutCombo.getSelectionIndex();
                TemplateLayoutComposite.this.updateInProgress = true;
                TemplateLayoutComposite.this.setLayoutInformation(selectionIndex, 0);
                TemplateLayoutComposite.this.table.setLayoutIndex(selectionIndex);
                TemplateLayoutComposite.this.updateInProgress = false;
            }
        });
        if ("BASE".equals(this.aTemplate.getType())) {
            GUI.label((Composite)layoutSelComposite, (String)Messages.TemplateLayoutComposite_0, (Object)GUI.grid.d.left1(), (int)16384);
            this.copybookNameText = GUI.text.fieldReadOnly((Composite)layoutSelComposite, (Object)GUI.grid.d.fillH((int)1));
            this.copybookNameText.setToolTipText(Messages.TemplateLayoutComposite_1);
        } else if ("DYNAMIC".equals(this.aTemplate.getType())) {
            this.addLayoutButton = GUI.button.push((Composite)layoutSelComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/add.gif"), (String)Messages.TemplateLayoutComposite_2, (Object)GUI.grid.d.left1());
            this.addAddLayoutButtonListener();
            this.removeLayoutButton = GUI.button.push((Composite)layoutSelComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/delete.gif"), (String)Messages.TemplateLayoutComposite_3, (Object)GUI.grid.d.left1());
            this.addRemoveLayoutButtonListener();
        }
        this.segmentedTemplateCheckbox = GUI.button.checkbox((Composite)layoutLZeroComposite, (String)Messages.TE_LAYOUT_SEGMENTED_TEMPLATE, (Object)GUI.grid.d.left1());
        this.segmentedTemplateCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateLayoutComposite.this.segmentedTemplateCheckbox.getSelection()) {
                    TemplateLayoutComposite.this.enableControlsForSegmented(true);
                    TemplateLayoutComposite.this.aTemplate.setSegmented(true);
                    TemplateLayoutComposite.this.editor.setEditorDirty();
                    return;
                }
                TemplateLayoutComposite.this.enableControlsForSegmented(false);
                TemplateLayoutComposite.this.aTemplate.setSegmented(false);
                TemplateLayoutComposite.this.editor.setEditorDirty();
            }
        });
        this.lzeroCheckBox = GUI.button.checkbox((Composite)layoutLZeroComposite, (String)Messages.MSG_LEADING_ZEROS_LBL, (Object)GUI.grid.d.fillH((int)2));
        this.lzeroCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateLayoutComposite.this.aTemplate.setLzero(TemplateLayoutComposite.this.lzeroCheckBox.getSelection());
                TemplateLayoutComposite.this.editor.setEditorDirty();
            }
        });
        this.lzeroCheckBox.setEnabled(false);
        this.lzeroCheckBox.setSelection(this.aTemplate.isLzero());
        Group layoutGroup = GUI.group((Composite)parent, (String)Messages.TE_LAYOUT_DETAILED_INFO, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        Composite layoutInfoComposite = GUI.composite((Composite)layoutGroup, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.layoutSelectedCheckbox = GUI.button.checkbox((Composite)layoutInfoComposite, (String)Messages.TE_LAYOUT_SELECTED, (Object)GUI.grid.d.fillH((int)3));
        this.layoutSelectedCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Layouttype currentLayout = (Layouttype)TemplateLayoutComposite.this.aTemplate.getLayout().get(TemplateLayoutComposite.this.currentLayoutCombo.getSelectionIndex());
                if (TemplateLayoutComposite.this.layoutSelectedCheckbox.getSelection()) {
                    currentLayout.setSel(true);
                    TemplateLayoutComposite.this.editor.setEditorDirty();
                    return;
                }
                currentLayout.setSel(false);
                TemplateLayoutComposite.this.editor.setEditorDirty();
            }
        });
        GridData buttonGridData = GUI.grid.d.left1();
        GUI.label((Composite)layoutInfoComposite, (String)Messages.TE_LAYOUT_ID_CRITERIA, (Object)GUI.grid.d.left1(), (int)16384);
        this.idCriteriaText = GUI.text.fieldReadOnly((Composite)layoutInfoComposite, (Object)GUI.grid.d.fillH((int)1));
        Composite idButtonsComposite = GUI.composite((Composite)layoutInfoComposite, (Layout)GUI.grid.l.noMargins((int)3, (boolean)false), (Object)GUI.grid.d.left1());
        this.idCriteriaBuildButton = GUI.button.push((Composite)idButtonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaWiz.gif"), (String)Messages.TE_LAYOUT_BuildCriteriaButton_ID, (Object)buttonGridData);
        this.idCriteriaBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateLayoutComposite.this.isSynchWithHostRequired() && !TemplateLayoutComposite.this.synchSymbolsWithHost()) {
                    return;
                }
                if (TemplateLayoutComposite.this.offsetUpdated()) {
                    return;
                }
                TemplateLayoutComposite.this.buildCriteria(TypeType1.ID);
            }
        });
        this.idCriteriaWriteButton = GUI.button.push((Composite)idButtonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaWriter.gif"), (String)Messages.TE_LAYOUT_WriteCriteriaButton_ID, (Object)buttonGridData);
        this.idCriteriaWriteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateLayoutComposite.this.isSynchWithHostRequired() && !TemplateLayoutComposite.this.synchSymbolsWithHost()) {
                    return;
                }
                if (TemplateLayoutComposite.this.offsetUpdated()) {
                    return;
                }
                TemplateLayoutComposite.this.writeCriteria(TypeType1.ID);
            }
        });
        this.idCriteriaClearButton = GUI.button.push((Composite)idButtonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaClear.gif"), (String)Messages.TE_LAYOUT_ClearCriteriaButton_ID, (Object)buttonGridData);
        this.idCriteriaClearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateLayoutComposite.this.isSynchWithHostRequired() && !TemplateLayoutComposite.this.synchSymbolsWithHost()) {
                    return;
                }
                if (TemplateLayoutComposite.this.offsetUpdated()) {
                    return;
                }
                int layoutIndex = TemplateLayoutComposite.this.currentLayoutCombo.getSelectionIndex();
                Layouttype currentLayout = (Layouttype)TemplateLayoutComposite.this.aTemplate.getLayout().get(layoutIndex);
                EList criteriaList = currentLayout.getCriteria();
                int i = 0;
                while (i < criteriaList.size()) {
                    Criteriatype aCriteria = (Criteriatype)criteriaList.get(i);
                    if (aCriteria.getType() == TypeType1.ID) {
                        TemplateLayoutComposite.clearCriteriaSpec(aCriteria);
                        TemplateLayoutComposite.this.editor.setEditorDirty();
                        TemplateType clearedTemplate = TemplateLayoutComposite.this.clearCriteria();
                        if (clearedTemplate != null) {
                            TemplateLayoutComposite.this.idCriteriaText.setText("");
                            TemplateLayoutComposite.this.updateCriteria(clearedTemplate);
                            TemplateLayoutComposite.this.updateInProgress = true;
                            TemplateLayoutComposite.this.setLayoutInformation(layoutIndex, -1);
                            TemplateLayoutComposite.this.updateInProgress = false;
                        }
                        return;
                    }
                    ++i;
                }
            }
        });
        GUI.label((Composite)layoutInfoComposite, (String)Messages.TE_LAYOUT_SEL_CRITERIA, (Object)GUI.grid.d.left1(), (int)16384);
        this.selCriteriaText = GUI.text.fieldReadOnly((Composite)layoutInfoComposite, (Object)GUI.grid.d.fillH((int)1));
        Composite selButtonsComposite = GUI.composite((Composite)layoutInfoComposite, (Layout)GUI.grid.l.noMargins((int)3, (boolean)false), (Object)GUI.grid.d.left1());
        this.selCriteriaBuildButton = GUI.button.push((Composite)selButtonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaWiz.gif"), (String)Messages.TE_LAYOUT_BuildCriteriaButton_SEL, (Object)buttonGridData);
        this.selCriteriaBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateLayoutComposite.this.isSynchWithHostRequired() && !TemplateLayoutComposite.this.synchSymbolsWithHost()) {
                    return;
                }
                if (TemplateLayoutComposite.this.offsetUpdated()) {
                    return;
                }
                TemplateLayoutComposite.this.buildCriteria(TypeType1.SEL);
            }
        });
        this.selCriteriaWritedButton = GUI.button.push((Composite)selButtonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaWriter.gif"), (String)Messages.TE_LAYOUT_WriteCriteriaButton_SEL, (Object)buttonGridData);
        this.selCriteriaWritedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateLayoutComposite.this.isSynchWithHostRequired() && !TemplateLayoutComposite.this.synchSymbolsWithHost()) {
                    return;
                }
                if (TemplateLayoutComposite.this.offsetUpdated()) {
                    return;
                }
                TemplateLayoutComposite.this.writeCriteria(TypeType1.SEL);
            }
        });
        this.selCriteriaClearButton = GUI.button.push((Composite)selButtonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaClear.gif"), (String)Messages.TE_LAYOUT_ClearCriteriaButton_SEL, (Object)buttonGridData);
        this.selCriteriaClearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateLayoutComposite.this.isSynchWithHostRequired() && !TemplateLayoutComposite.this.synchSymbolsWithHost()) {
                    return;
                }
                if (TemplateLayoutComposite.this.offsetUpdated()) {
                    return;
                }
                int layoutIndex = TemplateLayoutComposite.this.currentLayoutCombo.getSelectionIndex();
                Layouttype currentLayout = (Layouttype)TemplateLayoutComposite.this.aTemplate.getLayout().get(layoutIndex);
                EList criteriaList = currentLayout.getCriteria();
                int i = 0;
                while (i < criteriaList.size()) {
                    Criteriatype aCriteria = (Criteriatype)criteriaList.get(i);
                    if (aCriteria.getType() == TypeType1.SEL) {
                        TemplateLayoutComposite.clearCriteriaSpec(aCriteria);
                        TemplateLayoutComposite.this.editor.setEditorDirty();
                        TemplateType clearedTemplate = TemplateLayoutComposite.this.clearCriteria();
                        if (clearedTemplate != null) {
                            TemplateLayoutComposite.this.selCriteriaText.setText("");
                            TemplateLayoutComposite.this.updateCriteria(clearedTemplate);
                            TemplateLayoutComposite.this.updateInProgress = true;
                            TemplateLayoutComposite.this.updateInProgress = false;
                        }
                        return;
                    }
                    ++i;
                }
            }
        });
        GUI.label((Composite)layoutInfoComposite, (String)Messages.TE_LAYOUT_RID_CRITERIA, (Object)GUI.grid.d.left1(), (int)16384);
        this.relIDCriteriaText = GUI.text.fieldReadOnly((Composite)layoutInfoComposite, (Object)GUI.grid.d.fillH((int)1));
        Composite ridButtonsComposite = GUI.composite((Composite)layoutInfoComposite, (Layout)GUI.grid.l.noMargins((int)3, (boolean)false), (Object)GUI.grid.d.left1());
        this.ridCriteriaBuildButton = GUI.button.push((Composite)ridButtonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaWiz.gif"), (String)Messages.TE_LAYOUT_BuildCriteriaButton_RID, (Object)buttonGridData);
        this.ridCriteriaBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateLayoutComposite.this.isSynchWithHostRequired() && !TemplateLayoutComposite.this.synchSymbolsWithHost()) {
                    return;
                }
                if (TemplateLayoutComposite.this.offsetUpdated()) {
                    return;
                }
                TemplateLayoutComposite.this.buildCriteria(TypeType1.RID);
            }
        });
        this.ridCriteriaWriteButton = GUI.button.push((Composite)ridButtonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaWriter.gif"), (String)Messages.TE_LAYOUT_WriteCriteriaButton_RID, (Object)buttonGridData);
        this.ridCriteriaWriteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateLayoutComposite.this.isSynchWithHostRequired() && !TemplateLayoutComposite.this.synchSymbolsWithHost()) {
                    return;
                }
                if (TemplateLayoutComposite.this.offsetUpdated()) {
                    return;
                }
                TemplateLayoutComposite.this.writeCriteria(TypeType1.RID);
            }
        });
        GUI.label.left((Composite)ridButtonsComposite, (String)"", (Object)GUI.grid.d.left1());
        GUI.label((Composite)layoutInfoComposite, (String)Messages.TE_LAYOUT_OFFSET, (Object)GUI.grid.d.left1(), (int)16384);
        this.offsetText = GUI.text.field((Composite)layoutInfoComposite, (Object)GUI.grid.d.fillH((int)2));
        NumberForcer nf = NumberForcer.addTo(this.offsetText);
        nf.setLowerBound(-32760, true);
        nf.setUpperBound(32760, true);
        this.offsetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TemplateLayoutComposite.this.updateInProgress) {
                    return;
                }
                TemplateLayoutComposite.this.editor.offsetUpdated();
                Layouttype currentLayout = (Layouttype)TemplateLayoutComposite.this.aTemplate.getLayout().get(TemplateLayoutComposite.this.currentLayoutCombo.getSelectionIndex());
                if (!TemplateLayoutComposite.this.offsetText.getText().trim().isEmpty()) {
                    if (TemplateLayoutComposite.this.offsetText.getText().trim().equals("-")) {
                        currentLayout.setOffset(0);
                        TemplateLayoutComposite.this.editor.setEditorDirty();
                    } else {
                        currentLayout.setOffset(Integer.parseInt(TemplateLayoutComposite.this.offsetText.getText().trim()));
                        TemplateLayoutComposite.this.editor.setEditorDirty();
                    }
                } else {
                    currentLayout.setOffset(0);
                    TemplateLayoutComposite.this.editor.setEditorDirty();
                }
            }
        });
        this.table = new NatTableWrapper(this, (Composite)layoutGroup);
        this.layoutTab.setControl((Control)parent);
        this.initialiseGUI();
        this.table.setLayoutIndex(this.currentLayoutCombo.getSelectionIndex());
        this.table.setFocus();
    }

    private void addAddLayoutButtonListener() {
        IPDHost aHost = this.editor.getEditorInput().getResource().getSystem();
        if (!aHost.supports((PDFeature)FMFeature.DYNAMIC_TEMPLATE_MULTIPLE_LAYOUTS)) {
            this.addLayoutButton.setEnabled(false);
            return;
        }
        this.addLayoutButton.setEnabled(true);
        this.addLayoutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateLayoutComposite.this.isSynchWithHostRequired() && !TemplateLayoutComposite.this.synchSymbolsWithHost()) {
                    return;
                }
                NewLayoutNameDialog dialog = new NewLayoutNameDialog();
                if (dialog.open() != 0) {
                    return;
                }
                String layoutName = dialog.getNewLayoutName();
                Layouttype layout = TemplateFactory.eINSTANCE.createLayouttype();
                layout.setSel(true);
                TemplateLayoutComposite.this.aTemplate.getLayout().add((Object)layout);
                Symboltype symbol01 = TemplateFactory.eINSTANCE.createSymboltype();
                symbol01.setLvl(1);
                symbol01.setName(layoutName);
                symbol01.setType(TypeType.AN);
                symbol01.setStart(1);
                symbol01.setLength(1);
                symbol01.setSeglen(false);
                layout.getSymbol().add((Object)symbol01);
                TemplateLayoutComposite.this.editor.setEditorDirty();
                if (!TemplateLayoutComposite.this.synchTemplateWithHost(TemplateLayoutComposite.this.aTemplate.getLayout().size() - 1)) {
                    TemplateLayoutComposite.this.aTemplate.getLayout().remove((Object)layout);
                }
                TemplateLayoutComposite.this.table.getNatTable().refresh();
            }
        });
    }

    private void addRemoveLayoutButtonListener() {
        IPDHost aHost = this.editor.getEditorInput().getResource().getSystem();
        if (!aHost.supports((PDFeature)FMFeature.DYNAMIC_TEMPLATE_MULTIPLE_LAYOUTS)) {
            this.removeLayoutButton.setEnabled(false);
            return;
        }
        this.removeLayoutButton.setEnabled(true);
        this.removeLayoutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TemplateLayoutComposite.this.aTemplate.getLayout().size() == 1) {
                    PDDialogs.openInfoThreadSafe((String)Messages.TemplateLayoutComposite_4);
                    return;
                }
                if (TemplateLayoutComposite.this.isSynchWithHostRequired() && !TemplateLayoutComposite.this.synchSymbolsWithHost()) {
                    return;
                }
                int index = TemplateLayoutComposite.this.currentLayoutCombo.getSelectionIndex();
                Layouttype layoutToRemove = (Layouttype)TemplateLayoutComposite.this.aTemplate.getLayout().remove(index);
                TemplateLayoutComposite.this.editor.setEditorDirty();
                if (!TemplateLayoutComposite.this.synchTemplateWithHost(-1)) {
                    TemplateLayoutComposite.this.aTemplate.getLayout().add(index, (Object)layoutToRemove);
                }
            }
        });
    }

    private void initialiseGUI() {
        this.updateInProgress = true;
        this.currentLayoutCombo.setItems(TemplateLayoutComposite.getLayoutNames(this.aTemplate, this.session.getSystem()));
        int selLayoutIndex = 0;
        if (this.editor.getEditorInput().getInitialLayoutIndex() == -1) {
            selLayoutIndex = TemplateLayoutComposite.getFirstSelectedLayoutIndex(this.aTemplate);
        } else {
            selLayoutIndex = this.editor.getEditorInput().getInitialLayoutIndex();
            if (selLayoutIndex >= this.aTemplate.getLayout().size()) {
                selLayoutIndex = TemplateLayoutComposite.getFirstSelectedLayoutIndex(this.aTemplate);
            }
        }
        this.setLayoutInformation(selLayoutIndex, 0);
        this.enableControlsForSegmented(this.aTemplate.isSetSegmented() && this.aTemplate.isSegmented());
        this.enableControlsByTemplateType();
        this.updateInProgress = false;
    }

    public static void clearCriteriaSpec(Criteriatype aCriteria) {
        aCriteria.unsetByfield();
        aCriteria.unsetOr();
        aCriteria.unsetRelated01();
        aCriteria.setExp("");
        aCriteria.getByline().clear();
    }

    private static int getSmallestUnusedSequenceNumber(Layouttype aLayout) {
        int i = 0;
        while (i < aLayout.getSymbol().size()) {
            if (!TemplateLayoutComposite.isIndexUsed(aLayout, i + 1)) {
                return i + 1;
            }
            ++i;
        }
        return aLayout.getSymbol().size();
    }

    private static boolean isIndexUsed(Layouttype aLayout, int index) {
        int i = 0;
        while (i < aLayout.getSymbol().size()) {
            Symboltype aSymbol = (Symboltype)aLayout.getSymbol().get(i);
            if (aSymbol.isSetSeq() && aSymbol.getSeq() == index) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String[] getLayoutNames(TemplateType aTemplate, IPDHost pdHost) {
        Objects.requireNonNull(aTemplate, "Must specify a non-null aTemplate.");
        return TemplateLayoutComposite.getLayoutNames((List<Layouttype>)aTemplate.getLayout(), pdHost);
    }

    public static String[] getLayoutNames(List<Layouttype> layouts, IPDHost pdHost) {
        Objects.requireNonNull(layouts, "Must specify a non-null layouts.");
        String[] layoutNames = new String[layouts.size()];
        int i = 0;
        while (i < layouts.size()) {
            layoutNames[i] = ((Symboltype)layouts.get(i).getSymbol().get(0)).getName(pdHost);
            ++i;
        }
        return layoutNames;
    }

    private static int getFirstSelectedLayoutIndex(TemplateType aTemplate) {
        Objects.requireNonNull(aTemplate, "Must specify a non-null aTemplate.");
        EList layouts = aTemplate.getLayout();
        int i = 0;
        while (i < layouts.size()) {
            Layouttype aLayout = (Layouttype)layouts.get(i);
            if (aLayout.isSetSel() && aLayout.isSel()) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public int getSelectedLayoutIndex() {
        if (this.currentLayoutCombo != null && !this.currentLayoutCombo.isDisposed()) {
            if (this.currentLayoutCombo.getSelectionIndex() == -1) {
                return 0;
            }
            return this.currentLayoutCombo.getSelectionIndex();
        }
        return 0;
    }

    public void setLayoutInformation(int layoutIndex, int rowSelectionIndex) {
        EList layouts = this.aTemplate.getLayout();
        if (layoutIndex >= layouts.size()) {
            String errMsg = MessageFormat.format(Messages.TE_InvalidLayoutIndex, layoutIndex, layouts.size(), this.aTemplateResource.getFormattedName());
            PDDialogs.openErrorThreadSafe((String)errMsg);
            logger.error((Object)errMsg);
            return;
        }
        Layouttype aLayout = (Layouttype)layouts.get(layoutIndex);
        if ("BASE".equals(this.aTemplate.getType()) && aLayout.getCopybook() != null) {
            this.copybookNameText.setText(aLayout.getCopybook());
        }
        this.currentLayoutCombo.select(layoutIndex);
        if (aLayout.isSetOffset()) {
            this.offsetText.setText("" + aLayout.getOffset());
        } else {
            this.offsetText.setText("0");
        }
        if (aLayout.isSetSel()) {
            this.layoutSelectedCheckbox.setSelection(aLayout.isSel());
        } else {
            this.layoutSelectedCheckbox.setSelection(false);
        }
        if (rowSelectionIndex != -1) {
            this.table.setSelectionIndex(rowSelectionIndex);
        }
        this.idCriteriaText.setText("");
        this.selCriteriaText.setText("");
        this.relIDCriteriaText.setText("");
        EList criteriaList = aLayout.getCriteria();
        if (criteriaList != null && criteriaList.size() > 0) {
            for (Criteriatype aCriteria : criteriaList) {
                if (aCriteria.getType() == TypeType1.ID) {
                    this.idCriteriaText.setText(aCriteria.getExp() != null ? aCriteria.getExp() : "");
                    continue;
                }
                if (aCriteria.getType() == TypeType1.SEL) {
                    this.selCriteriaText.setText(aCriteria.getExp() != null ? aCriteria.getExp() : "");
                    continue;
                }
                if (aCriteria.getType() == TypeType1.RID && !aCriteria.isSetRelated01()) {
                    this.relIDCriteriaText.setText(aCriteria.getExp() != null ? aCriteria.getExp() : "");
                    continue;
                }
                if (aCriteria.getType() == TypeType1.RDF && aCriteria.getFref() != -1) continue;
                logger.error((Object)("Unknown criteria type: " + aCriteria.getType().toString()));
            }
        }
    }

    public void buildCriteria(TypeType1 type) {
        this.buildCriteria(type, -1);
    }

    public void buildCriteria(TypeType1 type, int reference) {
        BaseTitleAreaDialog dialog;
        int layoutIndex = this.currentLayoutCombo.getSelectionIndex();
        if (type != TypeType1.RID) {
            Criteriatype currentCriteria = null;
            for (Criteriatype ct : ((Layouttype)this.aTemplate.getLayout().get(layoutIndex)).getCriteria()) {
                if (type == TypeType1.RDF) {
                    if (ct.getFref() != reference) continue;
                    currentCriteria = ct;
                    break;
                }
                if (ct.getType() != type) continue;
                currentCriteria = ct;
                break;
            }
            if (!(currentCriteria == null || currentCriteria.isSetByfield() && currentCriteria.isByfield() || PDDialogs.openConfirm((String)Messages.TE_CriteriaChangeConfirm, (String)Messages.TE_FreeToByFieldWarning))) {
                return;
            }
        }
        int ridLayoutIndex = -1;
        if (type == TypeType1.RID) {
            dialog = new LayoutSelectionDialog(this.aTemplateResource, (List<Layouttype>)this.aTemplate.getLayout(), layoutIndex);
            if (dialog.open() != 0) {
                return;
            }
            ridLayoutIndex = dialog.getSelectedLayoutIndex();
            Criteriatype currentCriteria = null;
            for (Criteriatype ct : ((Layouttype)this.aTemplate.getLayout().get(ridLayoutIndex)).getCriteria()) {
                if (ct.getType() != type || !ct.isSetRelated01() || ct.getRelated01() != ((Layouttype)this.aTemplate.getLayout().get(layoutIndex)).getId()) continue;
                currentCriteria = ct;
                break;
            }
            if (!(currentCriteria == null || currentCriteria.isSetByfield() && currentCriteria.isByfield() || PDDialogs.openConfirm((String)Messages.TE_CriteriaChangeConfirm, (String)Messages.TE_FreeToByFieldWarning))) {
                return;
            }
        }
        dialog = null;
        dialog = type == TypeType1.RID ? new ByFieldCriteriaSpecificationDialog(this.session, this.aTemplateResource, this.aTemplate, layoutIndex, ridLayoutIndex, type, reference) : (type == TypeType1.RDF ? new ByFieldCriteriaSpecificationDialog(this.session, this.aTemplateResource, this.aTemplate, layoutIndex, -1, type, reference) : new ByFieldCriteriaSpecificationDialog(this.session, this.aTemplateResource, this.aTemplate, layoutIndex, -1, type, reference));
        if (dialog.open() != 0) {
            return;
        }
        TemplateType templateWithNewCriteria = dialog.getTemplateWithNewCriteria();
        this.updateCriteria(templateWithNewCriteria);
        this.updateInProgress = true;
        this.setLayoutInformation(layoutIndex, -1);
        this.updateInProgress = false;
        this.editor.setEditorDirty();
    }

    public void updateCriteria(TemplateType templateWithNewCriteria) {
        Objects.requireNonNull(templateWithNewCriteria, "Must specify a non-null templateWithNewCriteria.");
        int i = 0;
        while (i < templateWithNewCriteria.getLayout().size()) {
            Layouttype aLayout = (Layouttype)templateWithNewCriteria.getLayout().get(i);
            this.updateCriteriaForLayout(aLayout);
            ++i;
        }
    }

    private void updateCriteriaForLayout(Layouttype newLayout) {
        int i = 0;
        while (i < this.aTemplate.getLayout().size()) {
            Layouttype aLayout = (Layouttype)this.aTemplate.getLayout().get(i);
            if (aLayout.getId() == newLayout.getId()) {
                aLayout.getCriteria().clear();
                aLayout.getCriteria().addAll((Collection)newLayout.getCriteria());
                return;
            }
            ++i;
        }
    }

    private void writeCriteria(TypeType1 type) {
        this.writeCriteria(type, -1);
    }

    public void writeCriteria(TypeType1 type, int reference) {
        BaseTitleAreaDialog dialog;
        int layoutIndex = this.currentLayoutCombo.getSelectionIndex();
        Criteriatype currentCriteria = null;
        for (Criteriatype ct : ((Layouttype)this.aTemplate.getLayout().get(layoutIndex)).getCriteria()) {
            if (ct.getType() != type) continue;
            if (type == TypeType1.RID) {
                if (ct.isSetRelated01()) continue;
                currentCriteria = ct;
                break;
            }
            if (type == TypeType1.RDF) {
                if (ct.getFref() != reference) continue;
                currentCriteria = ct;
                break;
            }
            currentCriteria = ct;
            break;
        }
        if (currentCriteria != null && currentCriteria.isSetByfield() && currentCriteria.isByfield() && !PDDialogs.openConfirm((String)Messages.TE_CriteriaChangeConfirm, (String)Messages.TE_ByFieldToFreeWarning)) {
            return;
        }
        int ridTargetLayoutID = -1;
        if (type == TypeType1.RID) {
            dialog = new LayoutSelectionDialog(this.aTemplateResource, (List<Layouttype>)this.aTemplate.getLayout(), layoutIndex);
            if (dialog.open() != 0) {
                return;
            }
            ridTargetLayoutID = dialog.getSelectedLayoutIndex();
        }
        dialog = null;
        dialog = type == TypeType1.RID ? new FreeCriteriaEntryDialog(this.session, this.aTemplateResource, this.aTemplate, ridTargetLayoutID, type, layoutIndex, reference) : (type == TypeType1.RDF ? new FreeCriteriaEntryDialog(this.session, this.aTemplateResource, this.aTemplate, layoutIndex, type, layoutIndex, reference) : new FreeCriteriaEntryDialog(this.session, this.aTemplateResource, this.aTemplate, layoutIndex, type, -1, reference));
        if (dialog.open() != 0) {
            return;
        }
        TemplateType templateWithNewCriteria = dialog.getTemplateWithNewCriteria();
        this.updateCriteria(templateWithNewCriteria);
        this.updateInProgress = true;
        this.setLayoutInformation(layoutIndex, -1);
        this.updateInProgress = false;
        this.editor.setEditorDirty();
    }

    private void enableControlsForSegmented(boolean segmented) {
        if (segmented) {
            if (this.aTemplate.getLayout().size() <= 1) {
                this.segmentedTemplateCheckbox.setSelection(false);
                this.relIDCriteriaText.setEnabled(false);
                this.ridCriteriaBuildButton.setEnabled(false);
                this.ridCriteriaWriteButton.setEnabled(false);
            } else {
                this.segmentedTemplateCheckbox.setSelection(segmented);
                this.relIDCriteriaText.setEnabled(segmented);
                this.ridCriteriaBuildButton.setEnabled(segmented);
                this.ridCriteriaWriteButton.setEnabled(segmented);
            }
        } else {
            this.segmentedTemplateCheckbox.setSelection(segmented);
            this.relIDCriteriaText.setEnabled(segmented);
            this.ridCriteriaBuildButton.setEnabled(segmented);
            this.ridCriteriaWriteButton.setEnabled(segmented);
        }
    }

    private void enableControlsByTemplateType() {
        if (this.aTemplate.getType().equalsIgnoreCase("DYNAMIC")) {
            this.segmentedTemplateCheckbox.setEnabled(false);
            this.offsetText.setEnabled(false);
            if (this.aTemplateResource.getSystem().supports((PDFeature)FMFeature.DYNAMIC_TEMPLATE_MULTIPLE_LAYOUTS)) {
                this.idCriteriaText.setEnabled(true);
                this.idCriteriaBuildButton.setEnabled(true);
                this.idCriteriaWriteButton.setEnabled(true);
                this.idCriteriaClearButton.setEnabled(true);
                this.selCriteriaWritedButton.setEnabled(true);
            } else {
                this.idCriteriaText.setEnabled(false);
                this.idCriteriaBuildButton.setEnabled(false);
                this.idCriteriaWriteButton.setEnabled(false);
                this.idCriteriaClearButton.setEnabled(false);
                this.selCriteriaWritedButton.setEnabled(false);
            }
        } else if ((this.aTemplate.getType().equalsIgnoreCase("BASE") || this.aTemplate.getType().equalsIgnoreCase("IMSBASE")) && this.aTemplate.getLayout().size() <= 1) {
            this.segmentedTemplateCheckbox.setEnabled(false);
        }
    }

    public void setNewTemplate(TemplateType newTemplate) {
        this.aTemplate = newTemplate;
        this.initialiseGUI();
        this.table.updateBody();
    }

    public boolean offsetUpdated() {
        if (this.editor.isOffsetUpdated()) {
            PDDialogs.openInfoThreadSafe((String)Messages.TE_LAYOUT_offsetModifiedMustSaveMsg);
            return true;
        }
        return false;
    }

    public TemplateType clearCriteria() {
        StringBuffer newTemplate;
        block6: {
            Result result;
            try {
                final StringBuffer xmlTemplate = TemplateSerializeUtils.save((TemplateType)this.aTemplate, (IZRL)this.aTemplateResource);
                result = new Result();
                newTemplate = new StringBuffer();
                try {
                    PlatformUI.getWorkbench().getProgressService().run(false, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask(Messages.CriteriaSpecDialog_CheckCriteriaWithHost, 1);
                            IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                            StringBuffer newXmlTemplate = TemplateLayoutComposite.this.session.updateTemplate(xmlTemplate, howIsGoing, result, true, false);
                            newTemplate.append(newXmlTemplate);
                        }
                    });
                }
                catch (Exception e) {
                    PDDialogs.openErrorThreadSafe((String)Messages.CriteriaSpecDialog_ExceptionWhileValidatingCriteria, (String)result.dumpOutputAndMessages(true), (Throwable)e);
                    return null;
                }
            }
            catch (Exception e) {
                PDDialogs.openErrorThreadSafe((String)Messages.CriteriaSpecDialog_ExceptionWhileValidatingCriteria, (Throwable)e);
                TemplateEditorUtilities.end(this.session);
                return null;
            }
            if (result.isSuccessfulWithoutWarnings()) break block6;
            PDDialogs.openErrorThreadSafe((String)Messages.CriteriaSpecDialog_CriteriaValidationErr, (String)result.dumpOutputAndMessages(true));
            return null;
        }
        return TemplateSerializeUtils.load((StringBuffer)newTemplate, (IZRL)this.aTemplateResource);
    }

    public void setSymbolsUpdated() {
        if (!"DYNAMIC".equals(this.aTemplate.getType())) {
            return;
        }
        this.symbolsUpdated = true;
    }

    public boolean isSynchWithHostRequired() {
        if (!"DYNAMIC".equals(this.aTemplate.getType())) {
            return false;
        }
        return this.symbolsUpdated;
    }

    public boolean synchSymbolsWithHost() {
        if (!this.symbolsUpdated) {
            return true;
        }
        if (!"DYNAMIC".equals(this.aTemplate.getType())) {
            return true;
        }
        return this.synchTemplateWithHost(this.currentLayoutCombo.getSelectionIndex());
    }

    private boolean synchTemplateWithHost(int preferredLayoutIndex) {
        Result<StringBuffer> result;
        block4: {
            try {
                result = this.editor.updateTemplate(null, false);
                if (!result.isSuccessfulWithoutWarnings()) break block4;
                this.editor.refreshGUI();
                this.symbolsUpdated = false;
                if (preferredLayoutIndex != -1 && preferredLayoutIndex < this.aTemplate.getLayout().size()) {
                    this.currentLayoutCombo.select(preferredLayoutIndex);
                    this.updateInProgress = true;
                    this.setLayoutInformation(preferredLayoutIndex, 0);
                    this.updateInProgress = false;
                }
                return true;
            }
            catch (Exception e) {
                PDDialogs.openErrorThreadSafe((String)Messages.TemplateLayoutComposite_6, (Throwable)e);
                TemplateEditorUtilities.end(this.session);
                return false;
            }
        }
        PDDialogs.openErrorThreadSafe((String)Messages.TemplateLayoutComposite_5, (String)result.getMessagesCombined().toString());
        return false;
    }

    public void setUpdateInProgress(boolean status) {
        this.updateInProgress = status;
    }

    public AbstractSessionTemplate getSession() {
        return this.session;
    }

    public TemplateType getTemplateType() {
        return this.aTemplate;
    }

    public IZRL getTemplateResource() {
        return this.aTemplateResource;
    }

    public ITemplateEditor getEditor() {
        return this.editor;
    }

    public TemplateEditorConfiguration getTemplateEditorConfiguration() {
        return this.table.getTemplateEditorConfiguration();
    }
}

