/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.template.ITemplateEditor;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.text.MessageFormat;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class TemplateInfoComposite {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int NUMBER_OF_DESCRIPTION_TEXT = 5;
    private static final int LENGTH_OF_DESCRIPTION_TEXT = 54;
    private ITemplateEditor templateEditor = null;
    private TemplateType aTemplate = null;
    private TabItem infoTab = null;
    private Text typeText = null;
    private Text langText = null;
    private Text creationDateText = null;
    private Text creationTimeText = null;
    private Text modifyDateText = null;
    private Text modifyTimeText = null;
    private Text[] descText = null;

    public TemplateInfoComposite(ITemplateEditor editor2, TemplateType aTemplate) {
        this.templateEditor = editor2;
        this.aTemplate = aTemplate;
    }

    public void createInfoTab(TabFolder tabFolder) {
        this.infoTab = new TabItem(tabFolder, 0);
        this.infoTab.setText(Messages.TE_infoTabName);
        Composite parent = GUI.composite((Composite)tabFolder, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        this.createMiscInfoGroup(parent);
        this.infoTab.setControl((Control)parent);
    }

    private void createMiscInfoGroup(Composite parent) {
        Group miscGroup = GUI.group((Composite)parent, (String)Messages.TE_infoMiscGroup, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)miscGroup, (String)Messages.TE_infotypeText, (Object)GUI.grid.d.left1(), (int)16384);
        this.typeText = GUI.text.fieldReadOnly((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)miscGroup, (String)Messages.TE_infolangText, (Object)GUI.grid.d.left1(), (int)16384);
        this.langText = GUI.text.fieldReadOnly((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)miscGroup, (String)Messages.TE_infocreationDateText, (Object)GUI.grid.d.left1(), (int)16384);
        this.creationDateText = GUI.text.fieldReadOnly((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)miscGroup, (String)Messages.TE_infocreationTimeText, (Object)GUI.grid.d.left1(), (int)16384);
        this.creationTimeText = GUI.text.fieldReadOnly((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)miscGroup, (String)Messages.TE_infomodifyDateText, (Object)GUI.grid.d.left1(), (int)16384);
        this.modifyDateText = GUI.text.fieldReadOnly((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)1));
        GUI.label((Composite)miscGroup, (String)Messages.TE_infomodifyTimeText, (Object)GUI.grid.d.left1(), (int)16384);
        this.modifyTimeText = GUI.text.fieldReadOnly((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)1));
        this.descText = new Text[5];
        GUI.label((Composite)miscGroup, (String)MessageFormat.format(Messages.TE_infodescText, 1), (Object)GUI.grid.d.left1(), (int)16384);
        this.descText[0] = GUI.text.field((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)3));
        this.descText[0].setTextLimit(54);
        GUI.label((Composite)miscGroup, (String)MessageFormat.format(Messages.TE_infodescText, 2), (Object)GUI.grid.d.left1(), (int)16384);
        this.descText[1] = GUI.text.field((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)3));
        this.descText[1].setTextLimit(54);
        GUI.label((Composite)miscGroup, (String)MessageFormat.format(Messages.TE_infodescText, 3), (Object)GUI.grid.d.left1(), (int)16384);
        this.descText[2] = GUI.text.field((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)3));
        this.descText[2].setTextLimit(54);
        GUI.label((Composite)miscGroup, (String)MessageFormat.format(Messages.TE_infodescText, 4), (Object)GUI.grid.d.left1(), (int)16384);
        this.descText[3] = GUI.text.field((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)3));
        this.descText[3].setTextLimit(54);
        GUI.label((Composite)miscGroup, (String)MessageFormat.format(Messages.TE_infodescText, 5), (Object)GUI.grid.d.left1(), (int)16384);
        this.descText[4] = GUI.text.field((Composite)miscGroup, (Object)GUI.grid.d.fillH((int)3));
        this.descText[4].setTextLimit(54);
        this.setMiscInformation();
        int i = 0;
        while (i < this.descText.length) {
            BidiUtils.applyTextDirection((Control)this.descText[i], (String)"default");
            this.descText[i].addModifyListener(this.createDescriptionModifyListener());
            this.descText[i].addVerifyListener(TemplateInfoComposite.createDescriptionVerifyListener());
            ++i;
        }
    }

    private ModifyListener createDescriptionModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TemplateInfoComposite.this.templateEditor.setEditorDirty();
                EList descList = TemplateInfoComposite.this.aTemplate.getDescribe();
                descList.clear();
                int i = 0;
                while (i < TemplateInfoComposite.this.descText.length) {
                    descList.add((Object)TemplateInfoComposite.this.descText[i].getText().trim());
                    ++i;
                }
            }
        };
    }

    private static VerifyListener createDescriptionVerifyListener() {
        return new VerifyListener(){

            public void verifyText(VerifyEvent e) {
            }
        };
    }

    private void setMiscInformation() {
        this.typeText.setText(this.aTemplate.getType());
        this.langText.setText(this.aTemplate.getLang() != null ? this.aTemplate.getLang() : "");
        this.creationDateText.setText(this.aTemplate.getCdate() != null ? this.aTemplate.getCdate() : "");
        this.creationTimeText.setText(this.aTemplate.getCtime() != null ? this.aTemplate.getCtime() : "");
        this.modifyDateText.setText(this.aTemplate.getUdate() != null ? this.aTemplate.getUdate() : "");
        this.modifyTimeText.setText(this.aTemplate.getUtime() != null ? this.aTemplate.getUtime() : "");
        EList descList = this.aTemplate.getDescribe();
        if (descList != null) {
            int i = 0;
            while (i < descList.size()) {
                this.descText[i].setText((String)descList.get(i));
                ++i;
            }
        }
    }

    public void setNewTemplate(TemplateType newTemplate) {
        this.aTemplate = newTemplate;
        this.setMiscInformation();
    }
}

