/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionTemplate;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.MessageQueue;
import com.ibm.etools.fm.core.model.MessageQueueManager;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsResource;
import com.ibm.etools.fm.core.model.db2.Db2Database;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.editor.template.FMTemplateEditorInput;
import com.ibm.etools.fm.editor.template.ITemplateEditor;
import com.ibm.etools.fm.editor.template.TemplateEditorDialog;
import com.ibm.etools.fm.model.template.CopybooksType;
import com.ibm.etools.fm.model.template.MemberType;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.impl.SymboltypeImpl;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.MemberPresence;
import com.ibm.etools.fm.ui.dialog.TemplateResourceSaveAsDialog;
import com.ibm.etools.fm.ui.util.EditorManagement;
import com.ibm.etools.fm.ui.util.ZrlLoaderDialogUtils;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.ISessionEdit;
import com.ibm.pdtools.common.component.core.util.PDFileSystemUtil;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.PDDialogWithText;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDEditorManagement;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsTreeUpdater;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class TemplateEditorUtilities {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(TemplateEditorUtilities.class);
    private static UUID uniqueKey;
    private static boolean runTempFlag;

    public static boolean existsInCopybooks(String memberName, CopybooksType copybooks) {
        if (copybooks == null) {
            return false;
        }
        EList library = copybooks.getLibrary();
        EList members = copybooks.getMember();
        int i = 0;
        while (i < members.size()) {
            MemberType aMember = (MemberType)members.get(i);
            if (aMember.getLib() != 0 && memberName.equalsIgnoreCase((String)library.get(aMember.getLib() - 1) + "(" + aMember.getName() + ")")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Result<StringBuffer> updateTemplate(IHowIsGoing monitor, boolean updateFromCopybooks, final TemplateType currentTemplate, final IZRL aTemplateResource, final AbstractSessionTemplate session, final StringBuffer newXmlTemplateContents) throws CoreException, InterruptedException, InvocationTargetException {
        if (updateFromCopybooks) {
            currentTemplate.getLayout().clear();
        }
        if (monitor != null) {
            Result result = new Result();
            StringBuffer xmlTemplate = TemplateSerializeUtils.save((TemplateType)currentTemplate, (IZRL)aTemplateResource);
            StringBuffer newXmlTemplate = session.updateTemplate(xmlTemplate, monitor, result, true, false);
            if (!result.isSuccessfulWithoutWarnings()) {
                monitor.done();
                return result;
            }
            newXmlTemplateContents.append(newXmlTemplate.toString());
            return result;
        }
        final Result overallResult = new Result();
        PlatformUI.getWorkbench().getProgressService().run(false, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (!runTempFlag) {
                    monitor.beginTask(MessageFormat.format(Messages.TemplateEditor_UPDATE_TEMPLATE_IN_PROGRESS, aTemplateResource.getFormattedName()), 1);
                }
                IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                try {
                    Result result = new Result();
                    StringBuffer xmlTemplate = TemplateSerializeUtils.save((TemplateType)currentTemplate, (IZRL)aTemplateResource);
                    StringBuffer newXmlTemplate = session.updateTemplate(xmlTemplate, howIsGoing, result, true, false);
                    overallResult.addSubResult(result);
                    if (!result.isSuccessfulWithoutWarnings()) {
                        monitor.done();
                        return;
                    }
                    newXmlTemplateContents.append(newXmlTemplate.toString());
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
                monitor.done();
            }
        });
        return overallResult;
    }

    public static Result<StringBuffer> doSave(ITemplateEditor templateEditor, final AbstractSessionTemplate session, final IZRL aTemplate, final TemplateType currentTemplate, boolean libraryUpdated, final StringBuffer templateContentsAfterSave, boolean fromDialog, final PDLogger logger) {
        if (libraryUpdated && !PDDialogs.openConfirm((String)Messages.Confirm, (String)Messages.TE_LibChangedConfirm)) {
            return null;
        }
        if (currentTemplate.getType().equals("BASE") && TemplateEditorUtilities.existsInCopybooks(aTemplate.getFormattedName(), currentTemplate.getCopybooks())) {
            if (PDDialogs.openQuestion((String)MessageFormat.format(Messages.TemplateEditor_COPYBOOK_OVERWRITE, aTemplate.getFormattedName()))) {
                return TemplateEditorUtilities.doSaveAs(templateEditor, session, aTemplate, currentTemplate, false, templateContentsAfterSave, fromDialog, logger);
            }
            return null;
        }
        CopybooksType copybooks = currentTemplate.getCopybooks();
        currentTemplate.setCopybooks(null);
        final Result overallResult = new Result((Object)new StringBuffer());
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.TemplateEditor_SAVE_IN_PROGRESS, aTemplate.getFormattedName()), 2);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    try {
                        Result updateResult = new Result();
                        StringBuffer xmlTemplate = TemplateSerializeUtils.save((TemplateType)currentTemplate, (IZRL)aTemplate);
                        session.updateTemplate(xmlTemplate, howIsGoing, updateResult, false, false);
                        overallResult.addSubResult(updateResult);
                        if (!updateResult.isSuccessfulWithoutWarnings()) {
                            PDDialogs.openErrorThreadSafe((String)Messages.TE_UpdateErrWhileSave, (String)updateResult.dumpOutputAndMessages(true));
                            return;
                        }
                        Result saveResult = session.save(howIsGoing);
                        overallResult.addSubResult(saveResult);
                        if (saveResult.getRC() > 4) {
                            if (saveResult.getMessagesCombined().toString().contains(Messages.TemplateEditor_SAVE_DYNAMIC_ERR_MSG)) {
                                session.saveAs(aTemplate, howIsGoing, saveResult);
                            } else {
                                PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.TemplateEditor_SAVE_ERR_MSG, aTemplate.getFormattedName()), (String)saveResult.getMessagesCombined().toString());
                                return;
                            }
                        }
                        Result loadCurrentResult = new Result();
                        StringBuffer latestXMLContents = session.getCurrentTemplateContents(howIsGoing, loadCurrentResult);
                        overallResult.addSubResult(loadCurrentResult);
                        if (!loadCurrentResult.isSuccessfulWithoutWarnings()) {
                            PDDialogs.openErrorThreadSafe((String)Messages.TE_ErrGetLatestAfterSave, (String)loadCurrentResult.dumpOutputAndMessages(true));
                            return;
                        }
                        templateContentsAfterSave.append(latestXMLContents.toString());
                    }
                    catch (CoreException e1) {
                        overallResult.add((Throwable)e1);
                        overallResult.setRC(8);
                        String errMsg = Messages.TemplateEditorAction_EX;
                        logger.error((Object)errMsg, (Throwable)e1);
                        PDDialogs.openErrorThreadSafe((String)errMsg);
                        return;
                    }
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            PDDialogs.openErrorThreadSafe((String)Messages.TemplateEditor_SAVE_EX, (Throwable)e);
            overallResult.add(e);
            overallResult.setRC(8);
            currentTemplate.setCopybooks(copybooks);
            return overallResult;
        }
        catch (InterruptedException e) {
            PDDialogs.openInfoThreadSafe((String)Messages.TemplateEditor_ACTION_CANCEL);
            overallResult.add((Throwable)e);
            overallResult.setRC(8);
            currentTemplate.setCopybooks(copybooks);
            return overallResult;
        }
        if (overallResult.isSuccessfulWithoutWarnings()) {
            return overallResult;
        }
        currentTemplate.setCopybooks(copybooks);
        return overallResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Result<StringBuffer> doSaveAs(final ITemplateEditor templateEditor, final AbstractSessionTemplate session, final IZRL aTemplate, final TemplateType currentTemplate, boolean libraryUpdated, StringBuffer templateContentsAfterSave, final boolean fromDialog, final PDLogger logger) {
        IZRL target;
        IPDHost host;
        IZRL templateResource;
        block18: {
            if (libraryUpdated && !PDDialogs.openConfirm((String)Messages.Confirm, (String)Messages.TE_LibChangedConfirm)) {
                return null;
            }
            templateResource = aTemplate;
            host = session.getSystem();
            TemplateResourceSaveAsDialog dialog = new TemplateResourceSaveAsDialog(host, aTemplate, MemberPresence.Required);
            if (dialog.open() != 0) {
                return null;
            }
            target = dialog.getSelectedResource();
            if (templateResource.getFormattedName().equals(target.getFormattedName())) {
                if (!PDDialogs.openQuestion((String)Messages.TemplateEditor_SAVE_AS_SAME_TARGET)) return TemplateEditorUtilities.doSaveAs(templateEditor, session, aTemplate, currentTemplate, libraryUpdated, templateContentsAfterSave, fromDialog, logger);
                return TemplateEditorUtilities.doSave(templateEditor, session, aTemplate, currentTemplate, libraryUpdated, templateContentsAfterSave, fromDialog, logger);
            }
            if (currentTemplate.getType().equals("BASE") && TemplateEditorUtilities.existsInCopybooks(target.getFormattedName(), currentTemplate.getCopybooks())) {
                if (!PDDialogs.openQuestion((String)MessageFormat.format(Messages.TemplateEditor_COPYBOOK_OVERWRITE, aTemplate.getFormattedName()))) return null;
                return TemplateEditorUtilities.doSaveAs(templateEditor, session, aTemplate, currentTemplate, libraryUpdated, templateContentsAfterSave, fromDialog, logger);
            }
            if (FMUIPlugin.getDefault().templateEditSessionExist(target)) {
                PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.TemplateEditor_DUP_EDIT, target.getFormattedName()));
                return null;
            }
            try {
                Result<StringBuffer> checkDataSetResult = ZrlLoaderDialogUtils.retrieveInformation(target);
                if (!checkDataSetResult.isSuccessfulWithoutWarnings()) {
                    PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.TemplateEditor_SAVE_AS_TARGET_ERR, target.getFormattedName()), (String)checkDataSetResult.getMessagesCombined().toString());
                    return null;
                }
                if (target instanceof DataSetOrMember) {
                    DataSetOrMember dsom = (DataSetOrMember)target;
                    if (dsom.getConfirmedExists() && !PDDialogs.openQuestion((String)MessageFormat.format(Messages.TemplateEditor_SAVE_AS_TARGET_EXIST, target.getFormattedName()))) {
                        return null;
                    }
                    break block18;
                }
                if (!(target instanceof UssFile)) {
                    throw new IllegalArgumentException(MessageFormat.format(Messages.TemplateEditorUtilities_19, target.getFormattedName()));
                }
                UssFile ussFile = (UssFile)target;
                if (ussFile.getConfirmedExists()) {
                    if (!PDDialogs.openQuestion((String)MessageFormat.format(Messages.TemplateEditor_SAVE_AS_TARGET_EXIST, target.getFormattedName()))) {
                        return null;
                    }
                } else if (ussFile.isDirectory()) {
                    PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.TemplateEditorUtilities_18, target.getFormattedName()));
                    return null;
                }
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        final Result overallResult = new Result();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.TemplateEditor_SAVE_AS_IN_PROGRESS, target.getFormattedName()), 2);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    CopybooksType copybooks = currentTemplate.getCopybooks();
                    if (templateEditor.isDirty()) {
                        currentTemplate.setCopybooks(null);
                        try {
                            Result result = new Result();
                            StringBuffer xmlTemplate = TemplateSerializeUtils.save((TemplateType)currentTemplate, (IZRL)aTemplate);
                            session.updateTemplate(xmlTemplate, howIsGoing, result, false, false);
                            overallResult.addSubResult(result);
                            if (!result.isSuccessfulWithoutWarnings()) {
                                currentTemplate.setCopybooks(copybooks);
                                return;
                            }
                        }
                        catch (CoreException e1) {
                            currentTemplate.setCopybooks(copybooks);
                            overallResult.add((Throwable)e1);
                            overallResult.setRC(8);
                            String errMsg = Messages.TemplateEditorAction_EX;
                            logger.error((Object)errMsg, (Throwable)e1);
                            PDDialogs.openErrorThreadSafe((String)errMsg);
                            return;
                        }
                    }
                    Result saveAsResult = new Result((Object)new StringBuffer());
                    session.saveAs(target, howIsGoing, saveAsResult);
                    overallResult.addSubResult(saveAsResult);
                    IFile newTemplateFile = session.getFromCacheFile();
                    if (newTemplateFile == null || !saveAsResult.isSuccessfulWithoutWarnings()) {
                        currentTemplate.setCopybooks(copybooks);
                        PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.TemplateEditor_SAVE_AS_ERR_MSG, target.getFormattedName(), host.getConnectionName()), (String)saveAsResult.getMessagesCombined().toString());
                        return;
                    }
                    FMTemplateEditorInput fmiInput = new FMTemplateEditorInput(newTemplateFile, target, (ISessionEdit)session, true, null, -1);
                    EditorManagement.openTemplateEditorFromWorkerThread(newTemplateFile, fmiInput, monitor, fromDialog);
                    FMUIPlugin.getDefault().addNewTemplateEditSession(target);
                    FMUIPlugin.getDefault().removeTemplateEditSession(templateResource);
                    PDSystemsTreeUpdater.refreshAllRelatedTo((Object)target);
                    if (templateEditor instanceof TemplateEditorDialog) {
                        TemplateEditorDialog dlg = (TemplateEditorDialog)templateEditor;
                        dlg.notifyTemplateChanged(fmiInput.getResource());
                    }
                }
            });
            return overallResult;
        }
        catch (InvocationTargetException e) {
            PDDialogs.openErrorThreadSafe((String)Messages.TemplateEditorAction_EX, (Throwable)e);
            overallResult.add(e);
            overallResult.setRC(8);
            return overallResult;
        }
        catch (InterruptedException e) {
            PDDialogs.openInfoThreadSafe((String)Messages.TemplateEditorAction_CACELLED);
            overallResult.add((Throwable)e);
            overallResult.setRC(8);
            return overallResult;
        }
    }

    public static void openTemplateEditSession(IZRL template) {
        TemplateEditorUtilities.openTemplateEditSession(template, null);
    }

    public static void openTemplateEditSession(IZRL template, Object notifier) {
        TemplateEditorUtilities.openTemplateEditSession(template, notifier, true);
    }

    public static void openTemplateEditSession(IZRL template, Object notifier, boolean inDialog) {
        TemplateEditorUtilities.openTemplateEditSession(template, notifier, null, false, true);
    }

    public static void openTemplateEditSession(IZRL template, Object notifier, boolean dynamicTemplate, UUID uniqueKey) {
        TemplateEditorUtilities.openTemplateEditSession(template, notifier, uniqueKey, dynamicTemplate, true);
    }

    public static void openTemplateEditSession(IZRL template, Object notifier, UUID uniqueKey) {
        TemplateEditorUtilities.openTemplateEditSession(template, notifier, uniqueKey, false, true);
    }

    public static void openTemplateEditSession(final IZRL template, final Object notifier, final UUID uniqueKey, final boolean dynamicTemplate, final boolean inDialog) {
        Objects.requireNonNull(template, "Must specify a non-null template.");
        final AbstractSessionTemplate session = AbstractSessionTemplate.createTemplateEditSession((IZRL)template);
        final Result overallResult = new Result((Object)new StringBuffer());
        final Job job = new Job(MessageFormat.format(Messages.BottomNavigationBar_OPEN_TEMPLATE, template.getFormattedName())){

            public IStatus run(IProgressMonitor monitor) {
                Result result;
                monitor.beginTask(MessageFormat.format(Messages.BottomNavigationBar_OPEN_TEMPLATE, template.getFormattedName()), 1);
                IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                try {
                    if (uniqueKey != null) {
                        if (dynamicTemplate) {
                            StringBuffer xmlBuffer = new StringBuffer();
                            xmlBuffer.append(FMUIPlugin.getDefault().getTemplateXMLBuffer(uniqueKey));
                            result = session.startNew(howIsGoing, xmlBuffer);
                        } else {
                            result = session.start(howIsGoing, FMUIPlugin.getDefault().getTemplateXMLBuffer(uniqueKey));
                        }
                    } else {
                        result = session.start(howIsGoing);
                    }
                }
                catch (InterruptedException e) {
                    logger.trace((Object)"Cancelled opening template editor session from template editor utils");
                    return new Status(8, "com.ibm.etools.fm.core", Messages._JOB_WAS_CANCELLED);
                }
                overallResult.copy(result);
                if (result.getRC() >= 8 || session.getFromCacheFile() == null) {
                    return Status.OK_STATUS;
                }
                monitor.worked(1);
                FMTemplateEditorInput fmiInput = new FMTemplateEditorInput(session.getFromCacheFile(), template, (ISessionEdit)session, true, null, -1);
                if (uniqueKey != null) {
                    EditorManagement.openTemplateEditorFromWorkerThread(session.getFromCacheFile(), fmiInput, monitor, notifier, uniqueKey, inDialog);
                } else {
                    EditorManagement.openTemplateEditorFromWorkerThread(session.getFromCacheFile(), fmiInput, monitor, notifier, inDialog);
                }
                FMUIPlugin.getDefault().addNewTemplateEditSession(template);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                job.setName("");
                if (!overallResult.isSuccessfulWithoutWarnings()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            String errMsg = MessageFormat.format(Messages.OpenAsTemplate_START_ERR_MSG, template.getFormattedName());
                            PDDialogWithText.ITextDialogRunnable action = new PDDialogWithText.ITextDialogRunnable(){

                                public void run(PDDialogWithText context) {
                                    try {
                                        PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                                monitor.setTaskName(Messages.OpenAsTemplate_GET_LIST_OPS_NAME);
                                                IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                                                IFile tmpFile = null;
                                                try {
                                                    tmpFile = PDFileSystemUtil.getTempFile((String)"FM", (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
                                                    Result listResult = session.getCompilerListing(howIsGoing, tmpFile);
                                                    if (listResult.getRC() == 0) {
                                                        PDEditorManagement.openEditorFromWorkerThread((IFile)tmpFile, (IHowIsGoing)howIsGoing);
                                                    } else {
                                                        PDDialogs.openErrorThreadSafe((String)Messages.OpenAsTemplate_GET_LIST_ERR, (String)listResult.getMessagesCombined().toString());
                                                    }
                                                }
                                                catch (CoreException e) {
                                                    String errMsg = Messages.OpenAsTemplate_GET_LIST_ERR;
                                                    PDDialogs.openErrorThreadSafe((String)errMsg);
                                                    logger.error((Object)errMsg, (Throwable)e);
                                                }
                                            }
                                        });
                                    }
                                    catch (Exception e) {
                                        String errMsg = Messages.OpenAsTemplate_GET_LIST_ERR;
                                        PDDialogs.openErrorThreadSafe((String)errMsg);
                                        logger.error((Object)errMsg, (Throwable)e);
                                    }
                                }
                            };
                            PDDialogs.openErrorThreadSafe((String)Messages.OpenAsTemplate_START_ERR_TITLE, (String)errMsg, (String)overallResult.getMessagesCombined().toString(), (String[])new String[]{Messages.OpenAsTemplate_GET_LIST}, (PDDialogWithText.ITextDialogRunnable[])new PDDialogWithText.ITextDialogRunnable[]{action});
                            session.unlock();
                        }
                    });
                }
            }
        });
        job.schedule();
    }

    public static void end(final AbstractSessionTemplate sessionToClose) {
        block4: {
            try {
                PlatformUI.getWorkbench().getProgressService().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        if (!runTempFlag) {
                            monitor.beginTask(Messages.EndTemplateSession_0, 2);
                        }
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        monitor.worked(1);
                        if (sessionToClose == null) {
                            monitor.done();
                            return;
                        }
                        sessionToClose.end(howIsGoing);
                        monitor.worked(1);
                        monitor.done();
                    }
                });
            }
            catch (Exception e) {
                if (sessionToClose == null) break block4;
                try {
                    sessionToClose.closeConnection();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static String okAsTemplate(IZRL aTemplate, boolean mustExist, IHowIsGoing monitor) throws InvocationTargetException, InterruptedException {
        Objects.requireNonNull(aTemplate, "Must specify a non-null aTemplate.");
        if (aTemplate instanceof CicsResource) {
            return Messages.TemplateEditorUtilities_0;
        }
        if (aTemplate instanceof CicsAppl) {
            return Messages.TemplateEditorUtilities_1;
        }
        if (aTemplate instanceof Db2Database) {
            return Messages.TemplateEditorUtilities_2;
        }
        if (aTemplate instanceof Db2Subsystem) {
            return Messages.TemplateEditorUtilities_3;
        }
        if (aTemplate instanceof MessageQueue) {
            return Messages.TemplateEditorUtilities_4;
        }
        if (aTemplate instanceof MessageQueueManager) {
            return Messages.TemplateEditorUtilities_5;
        }
        if (aTemplate instanceof DataSetOrMember) {
            return TemplateEditorUtilities.okAsTemplateDSOM((DataSetOrMember)aTemplate, mustExist, monitor);
        }
        if (aTemplate instanceof UssFile) {
            return TemplateEditorUtilities.okAsTemplateUssFile((UssFile)aTemplate, mustExist, monitor);
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.TemplateEditorUtilities_6, aTemplate == null ? Messages.TemplateEditorUtilities_7 : aTemplate.getFormattedName()));
    }

    private static String okAsTemplateDSOM(final DataSetOrMember aTemplate, final boolean mustExist, IHowIsGoing monitor) throws InvocationTargetException, InterruptedException {
        if (aTemplate.getSystem().getHostType() != HostType.ZOS) {
            return Messages.TemplateEditorUtilities_8;
        }
        if (monitor != null) {
            return TemplateEditorUtilities.okAsTemplateDSOMChild(aTemplate, mustExist, monitor);
        }
        final Result result = new Result();
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(MessageFormat.format(Messages.TemplateEditorUtilities_9, aTemplate.getFormattedName()), 1);
                IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                String s = TemplateEditorUtilities.okAsTemplateDSOMChild(aTemplate, mustExist, howIsGoing);
                result.setOutput((Object)s);
            }
        });
        return (String)result.getOutput();
    }

    private static String okAsTemplateDSOMChild(DataSetOrMember aTemplate, boolean mustExist, IHowIsGoing monitor) throws InterruptedException {
        Result result = aTemplate.refreshSelf(monitor);
        if (!result.isSuccessfulWithoutWarnings()) {
            return result.dumpOutputAndMessages(true);
        }
        if (aTemplate.asMember() != null) {
            if (mustExist) {
                if (aTemplate.getConfirmedExists()) {
                    return null;
                }
                return Messages.TemplateEditorUtilities_10;
            }
            if (aTemplate.asDataSet().getType() == DataSetType.PDS || aTemplate.asDataSet().getType() == DataSetType.LIBRARY) {
                return null;
            }
            return Messages.TemplateEditorUtilities_11;
        }
        if (aTemplate.getConfirmedExists() && aTemplate.asDataSet().getType() == DataSetType.PS) {
            return null;
        }
        if (!aTemplate.getConfirmedExists()) {
            return Messages.TemplateEditorUtilities_12;
        }
        return Messages.TemplateEditorUtilities_13;
    }

    private static String okAsTemplateUssFile(final UssFile aTemplate, final boolean mustExist, IHowIsGoing monitor) throws InvocationTargetException, InterruptedException {
        if (aTemplate.getSystem().getHostType() == HostType.ZOS) {
            return Messages.TemplateEditorUtilities_14;
        }
        if (monitor != null) {
            return TemplateEditorUtilities.okAsTemplateUssFileChild(aTemplate, mustExist, monitor);
        }
        final Result result = new Result();
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(MessageFormat.format(Messages.TemplateEditorUtilities_15, aTemplate.getFormattedName()), 1);
                IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                String s = TemplateEditorUtilities.okAsTemplateUssFileChild(aTemplate, mustExist, howIsGoing);
                result.setOutput((Object)s);
            }
        });
        return (String)result.getOutput();
    }

    private static String okAsTemplateUssFileChild(UssFile aTemplate, boolean mustExist, IHowIsGoing monitor) throws InterruptedException {
        Result result = aTemplate.refreshSelf(monitor);
        if (!result.isSuccessfulWithoutWarnings()) {
            return result.dumpOutputAndMessages(true);
        }
        if (aTemplate.isDirectory()) {
            return Messages.TemplateEditorUtilities_16;
        }
        if (!mustExist) {
            return null;
        }
        if (aTemplate.getConfirmedExists()) {
            return null;
        }
        return Messages.TemplateEditorUtilities_17;
    }

    public static ViewerFilter createLocateFilter(final String filterstring) {
        return new ViewerFilter(){

            public boolean select(Viewer aTableViewer, Object parentElement, Object element) {
                boolean res = false;
                if (element instanceof String[]) {
                    res = ((String[])element)[2].contains(filterstring.toUpperCase());
                } else if (element instanceof SymboltypeImpl) {
                    res = ((SymboltypeImpl)element).getName().contains(filterstring.toUpperCase());
                }
                return res;
            }
        };
    }

    public static void setRunTempKey(UUID key) {
        uniqueKey = key;
    }

    public static void setRunTempFlag(boolean flag) {
        runTempFlag = flag;
    }

    public static UUID getRunTempKey() {
        return uniqueKey;
    }
}

