/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template;

import com.ibm.etools.fm.core.model.AbstractSessionTemplate;
import com.ibm.etools.fm.editor.template.ITemplateEditor;
import com.ibm.etools.fm.editor.template.TemplateCopybookComposite;
import com.ibm.etools.fm.editor.template.TemplateInfoComposite;
import com.ibm.etools.fm.editor.template.TemplateLayoutComposite;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.pdtools.common.component.core.util.GUI;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;

public class TemplateEditorTabs {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private TemplateLayoutComposite layoutComposite = null;
    private TemplateCopybookComposite copybookComposite = null;
    private TemplateInfoComposite infoComposite = null;
    TabFolder tabFolder;

    public Control buildTemplateEditorTabs(Composite parent, ITemplateEditor editor2) {
        parent.setLayout((Layout)GUI.grid.l.noMargins((int)1, (boolean)true));
        final ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        scrolledComposite.setLayoutData((Object)GUI.grid.d.fillAll());
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Composite composite = GUI.composite((Composite)scrolledComposite, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        scrolledComposite.setContent((Control)composite);
        this.tabFolder = new TabFolder(composite, 128);
        this.tabFolder.setLayoutData((Object)GUI.grid.d.fillAll());
        scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                scrolledComposite.setMinSize(TemplateEditorTabs.this.tabFolder.computeSize(-1, -1));
            }
        });
        this.layoutComposite = new TemplateLayoutComposite((AbstractSessionTemplate)editor2.getEditorInput().getSessionIdentifer(), editor2.getEditorInput().getLoadedTemplate(), editor2.getEditorInput().getResource(), editor2);
        this.layoutComposite.createLayoutTab(this.tabFolder);
        if (!editor2.getEditorInput().getLoadedTemplate().getType().equals("DYNAMIC") && !editor2.getEditorInput().getLoadedTemplate().getType().equals("IMSBASE")) {
            this.copybookComposite = new TemplateCopybookComposite((AbstractSessionTemplate)editor2.getEditorInput().getSessionIdentifer(), editor2, editor2.getEditorInput().getLoadedTemplate(), editor2.getEditorInput().getResource());
            this.copybookComposite.createCopybookTab(this.tabFolder);
        }
        this.infoComposite = new TemplateInfoComposite(editor2, editor2.getEditorInput().getLoadedTemplate());
        this.infoComposite.createInfoTab(this.tabFolder);
        return scrolledComposite;
    }

    public void setNewTemplate(TemplateType type) {
        this.layoutComposite.setNewTemplate(type);
        if (this.copybookComposite != null) {
            this.copybookComposite.setNewTemplate(type);
        }
        this.infoComposite.setNewTemplate(type);
    }

    public TemplateLayoutComposite getLayoutComposite() {
        return this.layoutComposite;
    }

    public void setFocus() {
        if (this.tabFolder != null && !this.tabFolder.isDisposed()) {
            this.tabFolder.setFocus();
        }
    }
}

