/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionTemplate;
import com.ibm.etools.fm.core.model.BaseEditorOptions;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.editor.formatted.BottomNavigationBar;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.template.FMTemplateEditorInput;
import com.ibm.etools.fm.editor.template.ITemplateEditor;
import com.ibm.etools.fm.editor.template.TemplateEditorTabs;
import com.ibm.etools.fm.editor.template.TemplateEditorUtilities;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.util.EditorManagement;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.ISessionEdit;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.HowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.ImageLoader;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.UUID;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TemplateEditorDialog
extends BaseTitleAreaDialog
implements ITemplateEditor {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int EDITOR_CLOSE = 100;
    private static final int SAVE_AS_CLOSE = 101;
    private static final PDLogger logger = PDLogger.get(TemplateEditorDialog.class);
    private FMTemplateEditorInput fmEditorInput = null;
    private AbstractSessionTemplate session = null;
    private boolean libUpdated = false;
    private boolean offsetUpdated = false;
    private TemplateEditorTabs templateEditorTabs = null;
    private Button okButton = null;
    private Button cancelButton = null;
    private Button saveButton = null;
    private Button saveAsButton = null;
    private Button editorButton = null;
    private Button runTemplateButton = null;
    private final FormattedEditor notifier;
    private final IZRL aResource;
    private final BaseEditorOptions baseOptions;
    private UUID uniqueKey;
    private StringBuffer xmlBuffer;
    private boolean dynamicTemplateFlag = false;
    public static final int MIN_RUNTEMP_VERSION = 140115;
    private static final String IMG_LOCK = "lock";
    private ImageLoader loader = new ImageLoader();
    boolean locked;

    public TemplateEditorDialog(FMTemplateEditorInput input, Object notifier) {
        if (notifier instanceof BaseEditorOptions) {
            this.baseOptions = (BaseEditorOptions)notifier;
            this.aResource = this.baseOptions.getaResource();
            this.notifier = null;
        } else if (notifier instanceof Boolean) {
            this.dynamicTemplateFlag = true;
            this.notifier = null;
            this.baseOptions = null;
            this.aResource = null;
        } else {
            this.notifier = (FormattedEditor)notifier;
            this.baseOptions = null;
            this.aResource = null;
        }
        this.fmEditorInput = input;
    }

    public TemplateEditorDialog(FMTemplateEditorInput input, Object notifier, UUID uniqueKey) {
        this.fmEditorInput = input;
        if (notifier instanceof BaseEditorOptions) {
            this.baseOptions = (BaseEditorOptions)notifier;
            this.aResource = this.baseOptions.getaResource();
            this.notifier = null;
            this.dynamicTemplateFlag = this.baseOptions.getDynamicTemplateFlag();
        } else if (notifier instanceof Boolean) {
            this.dynamicTemplateFlag = true;
            this.notifier = null;
            this.baseOptions = null;
            this.aResource = null;
        } else {
            this.notifier = (FormattedEditor)notifier;
            this.baseOptions = null;
            this.aResource = null;
        }
        this.uniqueKey = uniqueKey;
    }

    public int open() {
        IFile localFile = this.fmEditorInput.getFile();
        IZRL zosResource = this.fmEditorInput.getResource();
        if (!(this.fmEditorInput.getSessionIdentifer() instanceof AbstractSessionTemplate)) {
            throw new IllegalArgumentException();
        }
        this.session = (AbstractSessionTemplate)this.fmEditorInput.getSessionIdentifer();
        Member member = (Member)this.fmEditorInput.getResource();
        this.fetchLockedStatus(member);
        if (localFile == null) {
            FMUIPlugin.getDefault().removeTemplateEditSession(this.fmEditorInput.getResource());
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.TE_NoCachedFile, zosResource.getFormattedName()));
            this.close();
            return 1;
        }
        if (this.fmEditorInput.getLoadedTemplate() == null) {
            try {
                if (this.uniqueKey != null) {
                    StringBuffer xmlTemplate = new StringBuffer();
                    xmlTemplate.append(FMUIPlugin.getDefault().getTemplateXMLBuffer(this.uniqueKey));
                    this.fmEditorInput.setTemplate(TemplateSerializeUtils.load((StringBuffer)xmlTemplate, (IZRL)this.getTemplateResource()));
                    this.setEditorDirty(true);
                }
                this.fmEditorInput.setTemplate(TemplateSerializeUtils.load((IFile)localFile, (IZRL)this.getTemplateResource()));
            }
            catch (Exception e) {
                FMUIPlugin.getDefault().removeTemplateEditSession(this.fmEditorInput.getResource());
                String errMsg = MessageFormat.format(Messages.TE_TemplateOpenError, this.fmEditorInput.getName());
                PDDialogs.openErrorThreadSafe((String)errMsg);
                logger.error((Object)errMsg, (Throwable)e);
                this.close();
                return 1;
            }
        } else if (this.fmEditorInput.isDirty()) {
            this.setEditorDirty();
        }
        if (!(this.fmEditorInput.getLoadedTemplate() == null || "BASE".equals(this.fmEditorInput.getLoadedTemplate().getType()) || "DYNAMIC".equals(this.fmEditorInput.getLoadedTemplate().getType()) || "IMSBASE".equals(this.fmEditorInput.getLoadedTemplate().getType()))) {
            FMUIPlugin.getDefault().removeTemplateEditSession(this.fmEditorInput.getResource());
            String errMsg = MessageFormat.format(Messages.TemplateEditor_TypeNotSupportede, this.fmEditorInput.getName(), this.fmEditorInput.getLoadedTemplate().getType());
            PDDialogs.openErrorThreadSafe((String)errMsg);
            this.close();
            return 1;
        }
        return super.open();
    }

    private void fetchLockedStatus(Member member) {
        Member.TemplateInfo templateInfo = member.getTemplateInfo();
        if (templateInfo == null) {
            try {
                Result result = member.loadTemplateInfo((IHowIsGoing)new HowIsGoing((Object)new NullProgressMonitor()));
                if (result.isSuccessfulWithoutWarnings()) {
                    templateInfo = member.getTemplateInfo();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.locked = templateInfo.isLocked();
    }

    public IZRL getTemplateResource() {
        return this.fmEditorInput.getResource();
    }

    protected Control createDialogArea(Composite parent) {
        if (this.isDirty()) {
            this.setTitle(MessageFormat.format(Messages.TemplateEditor_DialogTitleDirty, this.getTemplateResource().getSystem().getFullHostName(), this.getTemplateResource().getFormattedName()));
        } else {
            this.setTitle(MessageFormat.format(Messages.TemplateEditor_DialogTitle, this.getTemplateResource().getSystem().getFullHostName(), this.getTemplateResource().getFormattedName()));
        }
        this.setMessage(Messages.TemplateEditor_DialogMsg);
        this.templateEditorTabs = new TemplateEditorTabs();
        return this.templateEditorTabs.buildTemplateEditorTabs(parent, this);
    }

    @Override
    public boolean builtFromCopybook() {
        return TemplateEditorUtilities.existsInCopybooks(this.fmEditorInput.getResource().getFormattedName(), this.fmEditorInput.getLoadedTemplate().getCopybooks());
    }

    @Override
    public boolean isDirty() {
        return this.fmEditorInput.isDirty();
    }

    @Override
    public void setEditorDirty() {
        this.setTitle(MessageFormat.format(Messages.TemplateEditor_DialogTitleDirty, this.getTemplateResource().getSystem().getFullHostName(), this.getTemplateResource().getFormattedName()));
        this.fmEditorInput.setDirty(true);
        if (this.notifier != null || this.baseOptions != null || this.dynamicTemplateFlag) {
            this.enableApplyTemplate(true);
        }
    }

    @Override
    public void setEditorDirty(boolean dirty) {
        this.fmEditorInput.setDirty(dirty);
        if (this.fmEditorInput.isDirty()) {
            this.setTitle(MessageFormat.format(Messages.TemplateEditor_DialogTitleDirty, this.getTemplateResource().getSystem().getFullHostName(), this.getTemplateResource().getFormattedName()));
        } else {
            this.setTitle(MessageFormat.format(Messages.TemplateEditor_DialogTitle, this.getTemplateResource().getSystem().getFullHostName(), this.getTemplateResource().getFormattedName()));
        }
    }

    @Override
    public boolean isOffsetUpdated() {
        return this.offsetUpdated;
    }

    @Override
    public void offsetUpdated() {
        this.setEditorDirty();
        this.offsetUpdated = true;
    }

    @Override
    public void libUpdated(boolean updated) {
        this.setEditorDirty();
        this.libUpdated = updated;
    }

    @Override
    public void refreshGUI() {
        this.templateEditorTabs.setNewTemplate(this.fmEditorInput.getLoadedTemplate());
    }

    @Override
    public void updateTemplate(TemplateType newTemplate, IZRL aTemplate) {
        if (newTemplate == null) {
            return;
        }
        if (!this.templateEditorTabs.tabFolder.isDisposed()) {
            this.removeRunTemp();
            this.reloadTemplate(newTemplate, aTemplate);
            this.refreshGUI();
            this.setEditorDirty(false);
        }
    }

    private void reloadTemplate(TemplateType newTemplate, IZRL aTemplate) {
        this.closeSessionIfRequired();
        if (FMUIPlugin.getDefault().templateEditSessionExist(aTemplate)) {
            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.OpenAsTemplate_DUP_SESSION, aTemplate.getFormattedName()));
            return;
        }
        FMUIPlugin.getDefault().addNewTemplateEditSession(aTemplate);
        AbstractSessionTemplate newSession = AbstractSessionTemplate.createTemplateEditSession((IZRL)aTemplate);
        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)new NullProgressMonitor());
        try {
            FMTemplateEditorInput fmiInput;
            if (this.uniqueKey != null) {
                newSession.start(howIsGoing, FMUIPlugin.getDefault().getTemplateXMLBuffer(this.uniqueKey));
            } else {
                newSession.start(howIsGoing);
            }
            this.fmEditorInput = fmiInput = new FMTemplateEditorInput(newSession.getFromCacheFile(), aTemplate, (ISessionEdit)newSession, true, newTemplate, -1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Result<StringBuffer> updateTemplate(IHowIsGoing monitor, boolean updateFromCopybooks) throws CoreException, InterruptedException, InvocationTargetException {
        StringBuffer newTemplateContents = new StringBuffer();
        Result<StringBuffer> result = TemplateEditorUtilities.updateTemplate(monitor, updateFromCopybooks, this.fmEditorInput.getLoadedTemplate(), this.getTemplateResource(), this.session, newTemplateContents);
        if (!result.isSuccessfulWithoutWarnings()) {
            return result;
        }
        this.fmEditorInput.setTemplate(TemplateSerializeUtils.load((StringBuffer)newTemplateContents, (IZRL)this.getTemplateResource()));
        this.xmlBuffer = newTemplateContents;
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData data = new GridData();
        data.widthHint = 100;
        this.okButton = GUI.button.push((Composite)parent, (String)JFaceResources.getString((String)"ok"), (Object)data, (String)Messages.TemplateEditor_OK_TIP);
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TemplateEditorDialog.this.okPressed();
            }
        });
        this.cancelButton = GUI.button.push((Composite)parent, (String)JFaceResources.getString((String)"cancel"), (Object)data, (String)Messages.TemplateEditor_CANCEL_TIP);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TemplateEditorDialog.this.cancelPressed();
            }
        });
        this.saveButton = GUI.button.push((Composite)parent, (String)Messages.TemplateEditor_SAVE, (Object)data, (String)Messages.TemplateEditor_SAVE_TIP);
        this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateEditorDialog.this.doSave();
            }
        });
        this.saveAsButton = GUI.button.push((Composite)parent, (String)Messages.TemplateEditor_SAVEAS, (Object)data, (String)Messages.TemplateEditor_SAVEAS_TIP);
        this.saveAsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateEditorDialog.this.doSaveAs();
            }
        });
        this.editorButton = GUI.button.push((Composite)parent, (String)Messages.TemplateEditor_EditorOpen, (Object)data, (String)Messages.TemplateEditor_EditorOpen_TIP);
        this.editorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int layoutIndex = TemplateEditorDialog.this.templateEditorTabs.getLayoutComposite().getSelectedLayoutIndex();
                TemplateEditorDialog.this.fmEditorInput.setInitialLayoutIndex(layoutIndex);
                EditorManagement.openTemplateEditorFromWorkerThread(TemplateEditorDialog.this.session.getFromCacheFile(), TemplateEditorDialog.this.fmEditorInput, (IProgressMonitor)new NullProgressMonitor(), TemplateEditorDialog.this.notifier, false);
                TemplateEditorDialog.this.setReturnCode(100);
                TemplateEditorDialog.this.close();
            }
        });
        this.runTemplateButton = GUI.button.push((Composite)parent, (String)Messages.TemplateEditor_RUNTEMPLATE, (Object)data, (String)Messages.TemplateEditor_RUNTEMPLATE_TIP);
        this.runTemplateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateEditorDialog.this.doRunTemp();
            }
        });
        if (this.notifier != null && this.uniqueKey != null || this.baseOptions != null && this.uniqueKey != null || this.baseOptions != null && this.fmEditorInput.isFmix()) {
            this.enableApplyTemplate(true);
        } else {
            this.enableApplyTemplate(false);
        }
        this.getShell().setDefaultButton(this.okButton);
        this.setEnableStateForSave();
    }

    private void setEnableStateForSave() {
        if (this.locked) {
            this.saveButton.setEnabled(false);
            this.okButton.setEnabled(false);
        }
    }

    public boolean close() {
        if (this.getReturnCode() == 1) {
            if (this.isDirty()) {
                if (!PDDialogs.openConfirm((String)Messages.Confirm, (String)Messages.TemplateEditor_DialogCancelConfirm)) {
                    return false;
                }
                this.removeRunTemp();
                this.closeSessionIfRequired();
                return super.close();
            }
            this.closeSessionIfRequired();
            return super.close();
        }
        if (this.getReturnCode() != 100 && this.getReturnCode() != 101 && this.isDirty()) {
            this.doSave();
        }
        this.closeSessionIfRequired();
        return super.close();
    }

    private void closeSessionIfRequired() {
        if (this.getReturnCode() != 100) {
            FMUIPlugin.getDefault().removeTemplateEditSession(this.fmEditorInput.getResource());
            try {
                this.session.deleteCache();
                if (this.getReturnCode() != 101) {
                    TemplateEditorUtilities.end(this.session);
                }
            }
            catch (Exception e) {
                PDDialogs.openErrorThreadSafe((String)Messages.TemplateEditor_DISPOSE_ERR);
                logger.error((Object)"Failed to properly dispose of template editor", (Throwable)e);
            }
        }
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.customMargins((int)2, (boolean)false, (int)10, (int)2), (Object)new GridData(4, 4, true, false));
        if (this.locked) {
            this.showLocked(composite);
        }
        Composite buttonBar = GUI.composite((Composite)composite, (Layout)GUI.grid.l.customMargins((int)9, (boolean)false, (int)10, (int)15), (Object)new GridData(0x1000008, 4, true, false));
        this.createButtonsForButtonBar(buttonBar);
        return buttonBar;
    }

    private void showLocked(Composite composite) {
        Composite lockComposite = new Composite(composite, 0);
        lockComposite.setLayout((Layout)new GridLayout(2, false));
        Label imageLabel = new Label(lockComposite, 0);
        imageLabel.setImage(this.loader.getImageByName("com.ibm.etools.fm.ui", IMG_LOCK));
        imageLabel.setLayoutData((Object)new GridData(1, 4, false, false));
        Label messageLbl = new Label(lockComposite, 0);
        messageLbl.setText("(" + Messages.MSG_Template_Locked + ")");
    }

    public void doSave() {
        StringBuffer latestXMLContents = new StringBuffer();
        Result<StringBuffer> result = TemplateEditorUtilities.doSave(this, this.session, this.getTemplateResource(), this.fmEditorInput.getLoadedTemplate(), this.libUpdated, latestXMLContents, true, logger);
        if (result == null) {
            return;
        }
        if (result.isSuccessfulWithoutWarnings()) {
            if (latestXMLContents.length() == 0) {
                this.setReturnCode(101);
                this.close();
                return;
            }
            try {
                this.fmEditorInput.setTemplate(TemplateSerializeUtils.load((StringBuffer)latestXMLContents, (IZRL)this.getTemplateResource()));
                this.offsetUpdated = false;
                this.refreshGUI();
                this.setEditorDirty(false);
                this.enableApplyTemplate(false);
                if (this.uniqueKey != null) {
                    this.removeRunTemp();
                }
            }
            catch (CoreException e) {
                String errMsg = Messages.TemplateEditor_SAVE_EX;
                logger.error((Object)errMsg, (Throwable)e);
                PDDialogs.openErrorThreadSafe((String)errMsg);
                return;
            }
        }
    }

    public void doSaveAs() {
        StringBuffer latestXMLContents = new StringBuffer();
        Result<StringBuffer> result = TemplateEditorUtilities.doSaveAs(this, this.session, this.getTemplateResource(), this.fmEditorInput.getLoadedTemplate(), this.libUpdated, latestXMLContents, true, logger);
        if (result == null) {
            return;
        }
        if (result.isSuccessfulWithoutWarnings()) {
            if (this.uniqueKey != null) {
                this.removeRunTemp();
            }
            this.setReturnCode(101);
            this.close();
        }
    }

    public void doRunTemp() {
        try {
            TemplateEditorUtilities.setRunTempFlag(true);
            this.updateTemplate(null, false);
            if (this.notifier != null || this.baseOptions != null || this.dynamicTemplateFlag) {
                String xmlStr = this.xmlBuffer.toString();
                if (this.uniqueKey == null) {
                    this.uniqueKey = UUID.randomUUID();
                }
                logger.trace((Object)("XML Buffer value : " + xmlStr));
                if (this.notifier != null && this.notifier.getSessionIdentifier().getBaseEditOptions() != null) {
                    this.notifier.getSessionIdentifier().getBaseEditOptions().setRunTempKey(this.uniqueKey);
                    FMUIPlugin.getDefault().addRunTempEntry(this.uniqueKey, this.notifier.getResource(), this.fmEditorInput.getResource(), xmlStr);
                    this.notifyTemplateChanged(this.fmEditorInput.getResource());
                } else {
                    FMUIPlugin.getDefault().addRunTempEntry(this.uniqueKey, this.aResource, this.fmEditorInput.getResource(), xmlStr);
                    this.baseOptions.setRunTempKey(this.uniqueKey);
                    this.baseOptions.setTemplateDirty(true);
                    TemplateEditorUtilities.setRunTempKey(this.uniqueKey);
                }
            }
            this.setEditorDirty(false);
            this.close();
        }
        catch (Exception e) {
            PDDialogs.openErrorThreadSafe((String)Messages.TemplateLayoutComposite_6, (Throwable)e);
            e.printStackTrace();
            TemplateEditorUtilities.end(this.session);
        }
    }

    @Override
    public FMTemplateEditorInput getEditorInput() {
        return this.fmEditorInput;
    }

    public void notifyTemplateChanged(final IZRL zrl) {
        if (this.notifier != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BottomNavigationBar.newTemplateAssociation(TemplateEditorDialog.this.notifier, zrl);
                }
            });
        }
    }

    public void enableApplyTemplate(boolean flag) {
        if (this.runTemplateButton != null) {
            if (flag) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (FMHost.requestFMVRM((IPDHost)TemplateEditorDialog.this.fmEditorInput.getSystem()) < 140115) {
                            TemplateEditorDialog.this.runTemplateButton.setEnabled(false);
                            return;
                        }
                    }
                });
            }
            this.runTemplateButton.setEnabled(flag);
        }
    }

    public void removeRunTemp() {
        if (this.baseOptions != null) {
            this.baseOptions.setRunTempKey(null);
            this.baseOptions.setTemplateDirty(false);
            TemplateEditorUtilities.setRunTempKey(null);
        }
        if (this.notifier != null && this.notifier.getSessionIdentifier().getBaseEditOptions() != null) {
            this.notifier.getSessionIdentifier().getBaseEditOptions().setRunTempKey(null);
            this.notifier.getSessionIdentifier().getBaseEditOptions().setTemplateDirty(false);
            if (this.notifier.getSessionIdentifier().getBaseEditOptions().getDynamicTemplateFlag()) {
                this.notifier.getSessionIdentifier().getBaseEditOptions().setDynamicTemplateFlag(false);
                this.notifier.getSessionIdentifier().getBaseEditOptions().setaTemplate(null);
                this.notifyTemplateChanged(null);
            }
        }
        FMUIPlugin.getDefault().removeRunTempEntry(this.uniqueKey);
        this.uniqueKey = null;
        TemplateEditorUtilities.setRunTempFlag(false);
        this.enableApplyTemplate(false);
    }
}

