/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.template;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionTemplate;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.util.CompilerOptionsUtil;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.template.ITemplateEditor;
import com.ibm.etools.fm.editor.template.dialogs.AdvancedCopybookEntry;
import com.ibm.etools.fm.editor.template.dialogs.EditAdvancedSelectionCopybookDialog;
import com.ibm.etools.fm.editor.template1.StringArrayElementTableLabelProvider;
import com.ibm.etools.fm.model.template.Asmtype;
import com.ibm.etools.fm.model.template.Coboltype;
import com.ibm.etools.fm.model.template.MemberType;
import com.ibm.etools.fm.model.template.Plitype;
import com.ibm.etools.fm.model.template.Redefinetype;
import com.ibm.etools.fm.model.template.Sourcerangetype;
import com.ibm.etools.fm.model.template.TemplateFactory;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.models.compiler.CompileType;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.lookup.ResourceLookupDialog;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDFileSystemUtil;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.PDDialogWithText;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDEditorManagement;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class TemplateCopybookComposite {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(TemplateCopybookComposite.class);
    private static final int MAX_COPYBOOK_LIBRARY_NUMBER = 12;
    private static final int MEMBER_NUMBER_OF_COLUMNS = 3;
    private static final int INDEX_MEMBER_STATUS_COLUMN = 0;
    private static final int INDEX_MEMBER_LIBRARY_INDEX_COLUMN = 1;
    private static final int INDEX_MEMBER_NAME_COLUMN = 2;
    private static final int INDEX_LIBRARY_LIBRARY_INDEX_COLUMN = 2;
    private AbstractSessionTemplate session;
    private ITemplateEditor editor;
    private TemplateType aTemplate;
    private IZRL aTemplateResource;
    private Table libraryTable;
    private TableViewer libraryTableViewer;
    private Table memberTable;
    private TableViewer memberTableViewer;
    private Button addLibButton;
    private Button removeLibButton;
    private Button addMemButton;
    private Button removeMemButton;
    private Button editMemButton;
    private Button updateButton;

    public TemplateCopybookComposite(AbstractSessionTemplate session, ITemplateEditor editor2, TemplateType aTemplate, IZRL aTemplateResource) {
        this.session = session;
        this.editor = editor2;
        this.aTemplate = aTemplate;
        this.aTemplateResource = aTemplateResource;
    }

    public void createCopybookTab(TabFolder tabFolder) {
        TabItem copybookTab = new TabItem(tabFolder, 0);
        copybookTab.setText(Messages.TE_copyTabName);
        Composite parent = GUI.composite((Composite)tabFolder, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        SashForm tableSashForm = new SashForm(parent, 512);
        this.createLibraryTable((Composite)tableSashForm);
        this.createMemberTable((Composite)tableSashForm);
        tableSashForm.setLayoutData((Object)GUI.grid.d.fillAll());
        tableSashForm.setWeights(new int[]{50, 50});
        this.createButtons(parent);
        copybookTab.setControl((Control)parent);
        this.setCopybooks();
    }

    private void createLibraryTable(Composite parent) {
        Group group = GUI.group((Composite)parent, (String)Messages.TE_infoCopybookLibraryGroup, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.libraryTable = new Table((Composite)group, 68354);
        this.libraryTable.setHeaderVisible(true);
        this.libraryTable.setLinesVisible(true);
        this.libraryTable.setLayoutData((Object)GUI.grid.d.fillAll());
        this.libraryTableViewer = new TableViewer(this.libraryTable);
        this.libraryTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TemplateCopybookComposite.createLibraryTableColumns(this.libraryTableViewer);
        this.libraryTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int selectionIndex = TemplateCopybookComposite.this.libraryTable.getSelectionIndex();
                int[] selection = TemplateCopybookComposite.this.getUsageIndex(selectionIndex + 1);
                TemplateCopybookComposite.this.memberTable.setSelection(selection);
            }
        });
        Composite buttonsComposite = GUI.composite((Composite)group, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.left1());
        this.addLibButton = GUI.button.push((Composite)buttonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/add.gif"), (String)Messages.TE_infoCopybookAddLibTip, (Object)GUI.grid.d.left1());
        this.addLibButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceLookupDialog dialog = new ResourceLookupDialog(TemplateCopybookComposite.this.aTemplateResource.getSystem(), FMHost.getPermittedTemplateResourceType((IPDHost)TemplateCopybookComposite.this.aTemplateResource.getSystem()));
                dialog.setAllowingMultiSelect(true);
                if (dialog.open() != 0) {
                    return;
                }
                TemplateCopybookComposite.this.editor.libUpdated(true);
                List<IZRL> selectedResource = dialog.getSelection();
                int i = 0;
                while (i < selectedResource.size()) {
                    IZRL selected = selectedResource.get(i);
                    if (selected instanceof DataSetOrMember) {
                        DataSetOrMember dsom = (DataSetOrMember)selected;
                        if (dsom.asMember() != null) {
                            Member aMember = dsom.asMember();
                            DataSet aDataSet = dsom.asDataSet();
                            int libNo = TemplateCopybookComposite.addLibIfNew((List<String>)TemplateCopybookComposite.this.aTemplate.getCopybooks().getLibrary(), aDataSet.getName());
                            TemplateCopybookComposite.addMemIfNew((List<MemberType>)TemplateCopybookComposite.this.aTemplate.getCopybooks().getMember(), libNo, aMember.getName());
                            TemplateCopybookComposite.this.setCopybooks();
                            TemplateCopybookComposite.this.editor.setEditorDirty();
                        } else {
                            DataSet aDataSet = dsom.asDataSet();
                            TemplateCopybookComposite.addLibIfNew((List<String>)TemplateCopybookComposite.this.aTemplate.getCopybooks().getLibrary(), aDataSet.getName());
                            TemplateCopybookComposite.this.setCopybooks();
                            TemplateCopybookComposite.this.editor.setEditorDirty();
                        }
                    } else {
                        throw new IllegalArgumentException("Specified resource type not supported: " + selected.getFormattedName());
                    }
                    ++i;
                }
            }
        });
        this.removeLibButton = GUI.button.push((Composite)buttonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/delete.gif"), (String)Messages.TE_infoCopybookRemoveLibTip, (Object)GUI.grid.d.left1());
        this.removeLibButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] selLibIDs = TemplateCopybookComposite.this.libraryTable.getSelectionIndices();
                if (selLibIDs == null || selLibIDs.length == 0) {
                    return;
                }
                String[] delLibs = new String[selLibIDs.length];
                int i = 0;
                while (i < selLibIDs.length) {
                    delLibs[i] = (String)TemplateCopybookComposite.this.aTemplate.getCopybooks().getLibrary().get(selLibIDs[i]);
                    ++i;
                }
                i = 0;
                while (i < delLibs.length) {
                    TemplateCopybookComposite.this.aTemplate.getCopybooks().getLibrary().remove((Object)delLibs[i]);
                    ++i;
                }
                TemplateCopybookComposite.this.editor.libUpdated(true);
                TemplateCopybookComposite.this.setCopybooks();
                TemplateCopybookComposite.this.editor.setEditorDirty();
            }
        });
    }

    private int[] getUsageIndex(int libIndex) {
        ArrayList<Integer> usageIndex = new ArrayList<Integer>();
        int i = 0;
        while (i < this.aTemplate.getCopybooks().getMember().size()) {
            if (((MemberType)this.aTemplate.getCopybooks().getMember().get(i)).getLib() == libIndex) {
                usageIndex.add(i);
            }
            ++i;
        }
        int[] index = new int[usageIndex.size()];
        int i2 = 0;
        while (i2 < usageIndex.size()) {
            index[i2] = (Integer)usageIndex.get(i2);
            ++i2;
        }
        return index;
    }

    private void createMemberTable(Composite parent) {
        Group group = GUI.group((Composite)parent, (String)Messages.TE_infoCopybookMemberGroup, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.memberTable = new Table((Composite)group, 68354);
        this.memberTable.setHeaderVisible(true);
        this.memberTable.setLinesVisible(true);
        this.memberTable.setLayoutData((Object)GUI.grid.d.fillAll());
        this.memberTableViewer = new TableViewer(this.memberTable);
        this.memberTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TemplateCopybookComposite.createMemberTableColumns(this.memberTableViewer);
        this.memberTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int selectionIndex = TemplateCopybookComposite.this.memberTable.getSelectionIndex();
                TableItem item = TemplateCopybookComposite.this.memberTable.getItem(selectionIndex);
                int libIndex = Integer.parseInt(item.getText(1));
                int[] selection = new int[]{libIndex - 1};
                TemplateCopybookComposite.this.libraryTable.setSelection(selection);
            }
        });
        Composite buttonsComposite = GUI.composite((Composite)group, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.left1());
        this.addMemButton = GUI.button.push((Composite)buttonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/add.gif"), (String)Messages.TE_infoCopybookAddMemTip, (Object)GUI.grid.d.left1());
        this.addMemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceLookupDialog dialog = new ResourceLookupDialog(TemplateCopybookComposite.this.aTemplateResource.getSystem(), FMHost.getPermittedTemplateResourceType((IPDHost)TemplateCopybookComposite.this.aTemplateResource.getSystem()));
                dialog.setAllowingMultiSelect(true);
                int tempSelection = -1;
                if (TemplateCopybookComposite.this.libraryTable != null && TemplateCopybookComposite.this.libraryTable.getItemCount() > 0 && (tempSelection = TemplateCopybookComposite.this.libraryTable.getSelectionIndex()) < 0) {
                    tempSelection = 0;
                }
                if (tempSelection >= 0) {
                    dialog.setInitialFilter(TemplateCopybookComposite.this.libraryTable.getItem(tempSelection).getText(2));
                }
                if (dialog.open() != 0) {
                    return;
                }
                List<IZRL> selectedResource = dialog.getSelection();
                int i = 0;
                while (i < selectedResource.size()) {
                    IZRL selected = selectedResource.get(i);
                    if (!(selected instanceof DataSetOrMember)) {
                        throw new IllegalArgumentException("Specified resource type not supported: " + selected.getFormattedName());
                    }
                    DataSetOrMember dsom = (DataSetOrMember)selected;
                    Member aMember = dsom.asMember();
                    DataSet aDataSet = dsom.asDataSet();
                    int libNo = TemplateCopybookComposite.addLibIfNew((List<String>)TemplateCopybookComposite.this.aTemplate.getCopybooks().getLibrary(), aDataSet.getName());
                    TemplateCopybookComposite.addMemIfNew((List<MemberType>)TemplateCopybookComposite.this.aTemplate.getCopybooks().getMember(), libNo, aMember.getName());
                    ++i;
                }
                TemplateCopybookComposite.this.editor.libUpdated(true);
                TemplateCopybookComposite.this.setCopybooks();
                TemplateCopybookComposite.this.editor.setEditorDirty();
            }
        });
        this.removeMemButton = GUI.button.push((Composite)buttonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/delete.gif"), (String)Messages.TE_infoCopybookRemoveMemTip, (Object)GUI.grid.d.left1());
        this.removeMemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] memSel = TemplateCopybookComposite.this.memberTable.getSelectionIndices();
                MemberType[] selMembers = new MemberType[memSel.length];
                int i = 0;
                while (i < memSel.length) {
                    selMembers[i] = (MemberType)TemplateCopybookComposite.this.aTemplate.getCopybooks().getMember().get(memSel[i]);
                    ++i;
                }
                i = 0;
                while (i < selMembers.length) {
                    TemplateCopybookComposite.this.aTemplate.getCopybooks().getMember().remove((Object)selMembers[i]);
                    ++i;
                }
                TemplateCopybookComposite.this.editor.libUpdated(true);
                TemplateCopybookComposite.this.setCopybooks();
                TemplateCopybookComposite.this.editor.setEditorDirty();
            }
        });
        this.editMemButton = GUI.button.push((Composite)buttonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/criteriaWriter.gif"), (String)Messages.TE_infoCopybookEditMemTip, (Object)GUI.grid.d.left1());
        this.editMemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] memSel = TemplateCopybookComposite.this.memberTable.getSelectionIndices();
                if (memSel == null || memSel.length == 0) {
                    PDDialogs.openInfoThreadSafe((String)Messages.TE_infoCopybookEditNoSelErr);
                    return;
                }
                MemberType selectedMember = (MemberType)TemplateCopybookComposite.this.aTemplate.getCopybooks().getMember().get(memSel[0]);
                if (selectedMember.getLib() > TemplateCopybookComposite.this.aTemplate.getCopybooks().getLibrary().size()) {
                    String errMsg = MessageFormat.format(Messages.TE_infoCopybookEditLibIndexErr, selectedMember.getLib(), TemplateCopybookComposite.this.aTemplate.getCopybooks().getLibrary().size());
                    PDDialogs.openErrorThreadSafe((String)errMsg);
                    return;
                }
                AdvancedCopybookEntry entry = TemplateCopybookComposite.this.populateAdvancedCopybookEntry(selectedMember);
                EditAdvancedSelectionCopybookDialog dlg = new EditAdvancedSelectionCopybookDialog(Display.getCurrent().getActiveShell());
                dlg.setCopybookEntry(entry);
                if (dlg.open() != 0) {
                    return;
                }
                TemplateCopybookComposite.repopulateMemberInfo(entry, selectedMember);
                TemplateCopybookComposite.this.editor.libUpdated(true);
                TemplateCopybookComposite.this.editor.setEditorDirty();
            }
        });
    }

    private AdvancedCopybookEntry populateAdvancedCopybookEntry(MemberType selectedMember) {
        String libName = (String)this.aTemplate.getCopybooks().getLibrary().get(selectedMember.getLib() - 1);
        AdvancedCopybookEntry anEntry = new AdvancedCopybookEntry();
        anEntry.setCopybook(Member.parse((IPDHost)this.aTemplateResource.getSystem(), (String)libName, (String)selectedMember.getName()));
        if (selectedMember.getName01() != null && selectedMember.getName01().length() > 0) {
            anEntry.setInsert01(true);
            anEntry.setInsert01FieldName(selectedMember.getName01());
        } else {
            anEntry.setInsert01(false);
            anEntry.setInsert01FieldName(null);
        }
        if (selectedMember.getRedefine() != null) {
            Redefinetype redefine = selectedMember.getRedefine();
            if (redefine.isSetChglvl() && redefine.isChglvl()) {
                anEntry.setRedefinesCOBOLLevelChange(true);
            } else {
                anEntry.setRedefinesCOBOLLevelChange(false);
            }
            if (redefine.isSetOffset() && redefine.isOffset()) {
                anEntry.setRedefinesSetOffset(true);
            } else {
                anEntry.setRedefinesSetOffset(false);
            }
            if (redefine.getName() != null && !redefine.getName().equals("")) {
                anEntry.setRedefinesFieldName(redefine.getName());
            } else {
                anEntry.setRedefinesFieldName(null);
            }
            if (redefine.isSetLevel()) {
                anEntry.setRedefinesLevel(redefine.getLevel());
            } else {
                anEntry.setRedefinesLevel(0);
            }
        }
        if (selectedMember.getSourcerange() != null) {
            Sourcerangetype sourceRange = selectedMember.getSourcerange();
            if (sourceRange.isSetFromstmt()) {
                anEntry.setRangeFromStatement(sourceRange.getFromstmt());
                anEntry.setRangeFromString(sourceRange.getFromstr());
            } else {
                anEntry.setRangeFromStatement(0);
                anEntry.setRangeFromString(null);
            }
            if (sourceRange.isSetTostmt()) {
                anEntry.setRangeToStatement(sourceRange.getTostmt());
                anEntry.setRangeToString(sourceRange.getFromstr());
            } else {
                anEntry.setRangeToStatement(0);
                anEntry.setRangeToString(null);
            }
        }
        return anEntry;
    }

    private static void repopulateMemberInfo(AdvancedCopybookEntry anEntry, MemberType aMember) {
        if (anEntry.isInsert01()) {
            aMember.setName01(anEntry.getInsert01FieldName());
        } else {
            aMember.setName01("");
        }
        Redefinetype aRedefine = TemplateFactory.eINSTANCE.createRedefinetype();
        aMember.setRedefine(aRedefine);
        if (anEntry.isRedefinesCOBOLLevelChange()) {
            aRedefine.setChglvl(true);
        } else {
            aRedefine.setChglvl(false);
        }
        if (anEntry.isRedefinesSetOffset()) {
            aRedefine.setOffset(true);
        } else {
            aRedefine.setOffset(false);
        }
        if (anEntry.getRedefinesFieldName() != null && anEntry.getRedefinesFieldName().length() > 0) {
            aRedefine.setName(anEntry.getRedefinesFieldName());
        } else {
            aRedefine.setName("");
        }
        if (anEntry.getRedefinesLevel() > 0) {
            aRedefine.setLevel(anEntry.getRedefinesLevel());
        } else {
            aRedefine.setLevel(0);
        }
        Sourcerangetype sourceRange = TemplateFactory.eINSTANCE.createSourcerangetype();
        aMember.setSourcerange(sourceRange);
        if (anEntry.getRangeFromStatement() > 0) {
            sourceRange.setFromstmt(anEntry.getRangeFromStatement());
        } else {
            sourceRange.setFromstmt(0);
        }
        if (anEntry.getRangeFromString() != null && anEntry.getRangeFromString().length() > 0) {
            sourceRange.setFromstr(anEntry.getRangeFromString());
        } else {
            sourceRange.setFromstr("");
        }
        if (anEntry.getRangeToStatement() > 0) {
            sourceRange.setTostmt(anEntry.getRangeToStatement());
        } else {
            sourceRange.setTostmt(0);
        }
        if (anEntry.getRangeToString() != null && anEntry.getRangeToString().length() > 0) {
            sourceRange.setTostr(anEntry.getRangeToString());
        } else {
            sourceRange.setTostr("");
        }
    }

    private void createButtons(Composite parent) {
        GridData data = new GridData();
        data.widthHint = 100;
        Composite buttonsComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)true), (Object)GUI.grid.d.fillH((int)1));
        this.updateButton = GUI.button.push((Composite)buttonsComposite, (String)Messages.TE_infoCopybookUpdateButton, (Object)data);
        this.updateButton.setToolTipText(Messages.TE_infoCopybookUpdateButtonTip);
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompileType compOpts;
                if (TemplateCopybookComposite.this.libraryTable.getItemCount() > 12) {
                    PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.TE_infoCopybookUpdateTooManyLibErr, 12));
                    return;
                }
                if (TemplateCopybookComposite.this.libraryTable.getItemCount() == 0) {
                    PDDialogs.openErrorThreadSafe((String)Messages.TE_infoCopybookUpdateNoLibErr);
                    return;
                }
                if (TemplateCopybookComposite.this.memberTable.getItemCount() == 0) {
                    PDDialogs.openErrorThreadSafe((String)Messages.TE_infoCopybookUpdateNoMemErr);
                    return;
                }
                if (FMHost.getSystem((IPDHost)TemplateCopybookComposite.this.aTemplateResource.getSystem()).getCompilerOptions() != null && FMHost.getSystem((IPDHost)TemplateCopybookComposite.this.aTemplateResource.getSystem()).getCompilerOptions().length() > 0 && (compOpts = CompilerOptionsUtil.load((String)FMHost.getSystem((IPDHost)TemplateCopybookComposite.this.aTemplateResource.getSystem()).getCompilerOptions(), (String)TemplateCopybookComposite.this.aTemplateResource.getSystem().getConnectionName())) != null && compOpts.isOverride()) {
                    if (TemplateCopybookComposite.this.aTemplate.getCopybooks().getCobol() != null) {
                        Coboltype cobType = TemplateFactory.eINSTANCE.createCoboltype();
                        TemplateCopybookComposite.this.aTemplate.getCopybooks().setCobol(cobType);
                    }
                    if (TemplateCopybookComposite.this.aTemplate.getCopybooks().getPli() != null) {
                        Plitype pliType = TemplateFactory.eINSTANCE.createPlitype();
                        TemplateCopybookComposite.this.aTemplate.getCopybooks().setPli(pliType);
                    }
                    if (TemplateCopybookComposite.this.aTemplate.getCopybooks().getAsm() != null) {
                        Asmtype asmType = TemplateFactory.eINSTANCE.createAsmtype();
                        TemplateCopybookComposite.this.aTemplate.getCopybooks().setAsm(asmType);
                    }
                }
                HashMap<MemberType, Integer> libNumberList = new HashMap<MemberType, Integer>();
                EList members = TemplateCopybookComposite.this.aTemplate.getCopybooks().getMember();
                int i = 0;
                while (i < members.size()) {
                    MemberType aMember = (MemberType)members.get(i);
                    libNumberList.put(aMember, aMember.getLib());
                    aMember.unsetLib();
                    ++i;
                }
                try {
                    Result<StringBuffer> result = TemplateCopybookComposite.this.editor.updateTemplate(null, true);
                    if (result.isSuccessfulWithoutWarnings()) {
                        TemplateCopybookComposite.this.editor.refreshGUI();
                        TemplateCopybookComposite.this.editor.libUpdated(false);
                        PDDialogs.openInfoThreadSafe((String)Messages.TE_infoCopybookUpdateSuccess);
                        return;
                    }
                    EList mems = TemplateCopybookComposite.this.aTemplate.getCopybooks().getMember();
                    int i2 = 0;
                    while (i2 < mems.size()) {
                        MemberType aMember = (MemberType)mems.get(i2);
                        Integer libNo = (Integer)libNumberList.get(aMember);
                        if (libNo != null) {
                            aMember.setLib(libNo.intValue());
                        }
                        ++i2;
                    }
                    PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.TE_infoCopybookUpdateError, TemplateCopybookComposite.this.aTemplateResource.getFormattedName()), (String)result.dumpOutputAndMessages(true), (String[])new String[]{Messages.OpenAsTemplate_GET_LIST}, (PDDialogWithText.ITextDialogRunnable[])new PDDialogWithText.ITextDialogRunnable[]{TemplateCopybookComposite.this.getRetrieveCompilerListingAction()});
                    return;
                }
                catch (Exception ex) {
                    String errMsg = MessageFormat.format(Messages.TE_infoCopybookUpdateError, TemplateCopybookComposite.this.aTemplateResource.getFormattedName());
                    logger.error((Object)errMsg, (Throwable)ex);
                    PDDialogs.openErrorThreadSafe((String)errMsg);
                    return;
                }
            }
        });
    }

    private PDDialogWithText.ITextDialogRunnable getRetrieveCompilerListingAction() {
        return new PDDialogWithText.ITextDialogRunnable(){

            public void run(PDDialogWithText dialog) {
                try {
                    PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.setTaskName(Messages.OpenAsTemplate_GET_LIST_OPS_NAME);
                            IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                            try {
                                IFile tmpFile = PDFileSystemUtil.getTempFile((String)"FM");
                                Result listResult = (this).TemplateCopybookComposite.this.session.getCompilerListing(howIsGoing, tmpFile);
                                if (listResult.getRC() == 0) {
                                    PDEditorManagement.openEditorFromWorkerThread((IFile)tmpFile, (IHowIsGoing)howIsGoing);
                                } else {
                                    PDDialogs.openErrorThreadSafe((String)Messages.OpenAsTemplate_GET_LIST_ERR, (String)listResult.getMessagesCombined().toString());
                                }
                            }
                            catch (CoreException e) {
                                String errMsg = Messages.OpenAsTemplate_GET_LIST_ERR;
                                PDDialogs.openErrorThreadSafe((String)errMsg);
                                logger.error((Object)errMsg, (Throwable)e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    String errMsg = Messages.OpenAsTemplate_GET_LIST_ERR;
                    PDDialogs.openErrorThreadSafe((String)errMsg);
                    logger.error((Object)errMsg, (Throwable)e);
                }
            }
        };
    }

    private static void createLibraryTableColumns(TableViewer viewer) {
        FormattedEditorUtility.createTableViewerColumn("", 50, viewer, 0x1000000);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_infoCopybookTableColumnLibIndex, 100, viewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_infoCopybookTableColumnLib, 500, viewer, 16384);
        viewer.setLabelProvider((IBaseLabelProvider)new StringArrayElementTableLabelProvider());
    }

    private static void createMemberTableColumns(TableViewer viewer) {
        FormattedEditorUtility.createTableViewerColumn("", 50, viewer, 0x1000000);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_infoCopybookTableColumnMemberLibIndex, 100, viewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_infoCopybookTableColumnMember, 500, viewer, 16384);
        viewer.setLabelProvider((IBaseLabelProvider)new StringArrayElementTableLabelProvider());
    }

    private void setCopybooks() {
        if (!this.aTemplate.getType().equals("BASE")) {
            this.enableCopybookControls(false);
            return;
        }
        this.enableCopybookControls(true);
        ArrayList<String[]> libraryContents = new ArrayList<String[]>();
        int i = 0;
        while (i < this.aTemplate.getCopybooks().getLibrary().size()) {
            String libraryStatus0 = "";
            String libraryIndex1 = "" + (i + 1);
            String libraryName2 = (String)this.aTemplate.getCopybooks().getLibrary().get(i);
            libraryContents.add(new String[]{libraryStatus0, libraryIndex1, libraryName2});
            ++i;
        }
        this.libraryTableViewer.setInput(libraryContents);
        ArrayList<String[]> memberContents = new ArrayList<String[]>();
        for (MemberType aMember : this.aTemplate.getCopybooks().getMember()) {
            String memberStatus0 = "";
            String memberLibrary1 = "" + aMember.getLib();
            String memberName2 = aMember.getName();
            memberContents.add(new String[]{memberStatus0, memberLibrary1, memberName2});
        }
        this.memberTableViewer.setInput(memberContents);
    }

    private void enableCopybookControls(boolean enable) {
        this.libraryTable.setEnabled(enable);
        this.memberTable.setEnabled(enable);
        this.addLibButton.setEnabled(enable);
        this.removeLibButton.setEnabled(enable);
        this.addMemButton.setEnabled(enable);
        this.removeMemButton.setEnabled(enable);
        this.updateButton.setEnabled(enable);
    }

    private static int addLibIfNew(List<String> list, String newLibName) {
        int i = 0;
        while (i < list.size()) {
            String aLib = list.get(i);
            if (aLib.equals(newLibName)) {
                return i + 1;
            }
            ++i;
        }
        list.add(newLibName);
        return list.size();
    }

    private static void addMemIfNew(List<MemberType> memList, int libNo, String memName) {
        MemberType aNewMember = TemplateFactory.eINSTANCE.createMemberType();
        aNewMember.setLib(libNo);
        aNewMember.setName(memName);
        memList.add(aNewMember);
    }

    public void setNewTemplate(TemplateType newTemplate) {
        this.aTemplate = newTemplate;
        this.setCopybooks();
    }
}

