/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted2.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2EditOptions;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.handler.ViewSqlError;
import com.ibm.etools.fm.editor.template1.StringArrayElementTableLabelProvider;
import com.ibm.etools.fm.model.redit.ReditType;
import com.ibm.etools.fm.model.redit.ReltabType;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.views.systems.handlers.OpenFormatted;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class ReditSelectionDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private Db2Subsystem subsystem;
    private ReditType tables;
    private Table reditTable;
    private TableViewer reditTableViewer;
    private Button closeButton;

    public ReditSelectionDialog(Db2Subsystem subsystem, ReditType tables) {
        if (subsystem == null) {
            throw new IllegalArgumentException("Must specify a non-null Db2Subsystem.");
        }
        if (tables == null) {
            throw new IllegalArgumentException("Must specify a non-null ReditType.");
        }
        this.subsystem = subsystem;
        this.tables = tables;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ReditSelectionDialog_0);
        this.setMessage(Messages.ReditSelectionDialog_1);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.createTableComposite(composite);
        this.createButtonComposite(composite);
        return composite;
    }

    private void createTableComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.reditTable = new Table(composite, 68356);
        this.reditTable.setHeaderVisible(true);
        this.reditTable.setLinesVisible(true);
        GridData data = GUI.grid.d.fillAll();
        data.minimumHeight = 300;
        this.reditTable.setLayoutData((Object)data);
        this.reditTableViewer = new TableViewer(this.reditTable);
        Font font = JFaceResources.getTextFont();
        this.reditTableViewer.getTable().setFont(font);
        GC gc = new GC((Drawable)this.reditTableViewer.getTable());
        gc.setFont(font);
        FontMetrics metrics = gc.getFontMetrics();
        int charWidth = metrics.getAverageCharWidth();
        FormattedEditorUtility.createTableViewerColumn(Messages.ReditSelectionDialog_2, charWidth * 20, this.reditTableViewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.ReditSelectionDialog_3, charWidth * 20, this.reditTableViewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.ReditSelectionDialog_4, charWidth * 10, this.reditTableViewer, 16384);
        this.reditTableViewer.setLabelProvider((IBaseLabelProvider)new StringArrayElementTableLabelProvider());
        this.reditTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.reditTableViewer.setInput(this.prepareContents());
        this.reditTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReditSelectionDialog.this.setErrorMessage(null);
            }
        });
        this.reditTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ReditSelectionDialog.this.setErrorMessage(null);
                ReditSelectionDialog.this.openDb2EditDialog();
            }
        });
        if (this.reditTable.getItemCount() > 0) {
            this.reditTable.select(0);
        }
    }

    private ArrayList<String[]> prepareContents() {
        ArrayList<String[]> contents = new ArrayList<String[]>();
        EList aList = this.tables.getReltab();
        int i = 0;
        while (i < aList.size()) {
            ReltabType aRelTable = (ReltabType)aList.get(i);
            String[] aTable = new String[]{ViewSqlError.convertHexToStr(aRelTable.getOwner(), this.subsystem.getSystem().getHostType()), ViewSqlError.convertHexToStr(aRelTable.getTable(), this.subsystem.getSystem().getHostType()), aRelTable.getType()};
            contents.add(aTable);
            ++i;
        }
        return contents;
    }

    private void createButtonComposite(Composite parent) {
        GridData data = GUI.grid.d.vert((int)128, (boolean)false, (int)1);
        data.grabExcessHorizontalSpace = false;
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)data);
        Button editButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/tree/action_history/formattededit.gif"), (String)Messages.ReditSelectionDialog_5, (Object)GUI.grid.d.left1());
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReditSelectionDialog.this.openDb2EditDialog();
            }
        });
    }

    private void openDb2EditDialog() {
        this.setErrorMessage(null);
        int index = this.reditTable.getSelectionIndex();
        if (index == -1) {
            this.setErrorMessage(Messages.ReditSelectionDialog_6);
            return;
        }
        ReltabType aReltable = (ReltabType)this.tables.getReltab().get(index);
        String tableOwner = ViewSqlError.convertHexToStr(aReltable.getOwner(), this.subsystem.getSystem().getHostType());
        String tableName = ViewSqlError.convertHexToStr(aReltable.getTable(), this.subsystem.getSystem().getHostType());
        Db2EditOptions opts = new Db2EditOptions();
        opts.setTable(new Db2Table(this.subsystem, tableName, tableOwner));
        OpenFormatted.invokeDb2Editor(opts);
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)new GridData(0x1000008, 4, false, false));
        this.createButtonsForButtonBar(buttonBar);
        return buttonBar;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData data = GUI.grid.d.fillAll();
        data.minimumWidth = 100;
        this.closeButton = GUI.button.push((Composite)parent, (String)Messages.ReditSelectionDialog_7, (Object)data);
        this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ReditSelectionDialog.this.close();
            }
        });
        this.getShell().setDefaultButton(this.closeButton);
    }
}

