/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted2.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2EditorOptions;
import com.ibm.etools.fm.core.model.db2.Db2SystemOptions;
import com.ibm.etools.fm.ui.widget.NumberForcer;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class Db2OptionsDialog
extends BaseTitleAreaDialog
implements ModifyListener {
    private static final int OPTROWS_LOWER_BOUND = 0;
    private static final int OPTROWS_UPPER_BOUND = 999999;
    private Db2SystemOptions systemOptions;
    private Db2EditorOptions editorOptions;
    private Button okButton = null;
    private Button cancelButton = null;
    private Button defaultButton = null;
    private TabFolder tabFolder;
    private TabItem systemOptionsTab;
    private Button ucsButton;
    private Combo ENCAPS;
    private Combo TIME;
    private Button urButton;
    private Button fkeyButton;
    private Combo DECFLOAT;
    private TabItem editorOptionsTab1;
    private TabItem editorOptionsTab2;
    private TabItem editorOptionsTab3;
    private TabItem editorOptionsTab4;
    private Button buttonOPTROWC;
    private Combo CSRTYPE;
    private Text OPTROWS;
    private Combo SAMTYPE;
    private Text ISKIP;
    private Text INCL;
    private Text FSKIP;
    private Text SLIMIT;
    private Text SFREQ;
    private Text SSEED;
    private Button buttonUPKEY;
    private Button buttonSHWENDVC;
    private Button disableINPUTDELM;
    private Text VCDELIM;
    private Text DVCDELIM;
    private Button buttonCNVSPNUL;
    private Text NULLIND;
    private Text DNULLIND;
    private Button buttonAUTOZTS;
    private Combo ENTEROP;
    private Button buttonCOMSAVE;
    private Button buttonCOMNOSVE;
    private Text AUTOCOM;
    private Button buttonRDONLY;
    private Combo CONCURR;
    private Button buttonCOMFETCH;
    private Button buttonSKIPLOCK;
    private Combo LOCK;
    private Combo KLOCK;
    private int activeTab = 0;
    private static final String stringInputDelim = "INPUTDELIM";
    private static final String stringDisplayDelim = "DISPLAYDELIM";
    private static final String nullInputDelim = "NULLINPUTDELIM";
    private static final String nullDisplayDelim = "NULLDISPLAYDELIM";
    private static final String SAMPLINGLIMIT = "samplingLimit";
    private static final String INITIALSKIPCOUNT = "initialSkipCount";
    private static final String INCLUDECOUNT = "includeCount";
    private static final String SKIPCOUNT = "skipCount";
    private static final String SAMPLINGFREQ = "samplingfreq";
    private static final String SAMPLINGSEED = "samplingseed";
    private Text[] optionTexts;

    public Db2OptionsDialog(Db2SystemOptions options, Db2EditorOptions editorOptions) {
        this.systemOptions = options;
        this.editorOptions = editorOptions;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.Db2OptionsDialog_0);
        this.setMessage(Messages.Db2OptionsDialog_1);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.tabFolder = new TabFolder(composite, 128);
        this.tabFolder.setLayoutData((Object)GUI.grid.d.fillAll());
        this.optionTexts = new Text[10];
        this.createSystemOptionsTab(this.tabFolder);
        this.createEditorOptionsTab(this.tabFolder);
        this.initAllValues();
        if (this.activeTab > 0) {
            this.tabFolder.setSelection(this.activeTab);
        }
        this.setComplete(true);
        return composite;
    }

    public void setActiveTab(int index) {
        if (index >= 0 && index <= 4) {
            this.activeTab = index;
        }
    }

    private void initAllValues() {
        this.initSystemOptionsValues();
        this.initEditorOptions();
    }

    private void createSystemOptionsTab(TabFolder tabFolder) {
        this.systemOptionsTab = new TabItem(tabFolder, 0);
        this.systemOptionsTab.setText(Messages.Db2OptionsDialog_2);
        Composite composite = GUI.composite((Composite)tabFolder, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.ucsButton = GUI.button.checkbox((Composite)composite, (String)Messages.Db2OptionsDialog_5, (Object)GUI.grid.d.fillH((int)2));
        this.ucsButton.setToolTipText(Messages.Db2OptionsDialog_6);
        this.buttonAUTOZTS = GUI.button.checkbox((Composite)composite, (String)Messages.Db2OptionsDialog_49, (Object)GUI.grid.d.fillH((int)2));
        this.buttonAUTOZTS.setToolTipText(Messages.Db2OptionsDialog_50);
        this.fkeyButton = GUI.button.checkbox((Composite)composite, (String)Messages.Db2OptionsDialog_13, (Object)GUI.grid.d.fillH((int)2));
        this.fkeyButton.setToolTipText(Messages.Db2OptionsDialog_14);
        GUI.label.left((Composite)composite, (String)Messages.Db2OptionsDialog_17, (Object)GUI.grid.d.left1());
        this.DECFLOAT = GUI.combo.readOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1), (Object[])Db2SystemOptions.DECFLOAT_TYPE.values());
        this.DECFLOAT.setToolTipText(Messages.Db2OptionsDialog_18);
        GUI.label.left((Composite)composite, (String)Messages.Db2OptionsDialog_9, (Object)GUI.grid.d.left1());
        this.TIME = GUI.combo.readOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1), (Object[])Db2SystemOptions.EXTERNAL_FORMAT_TIME.values());
        this.TIME.setToolTipText(Messages.Db2OptionsDialog_10);
        GUI.label.left((Composite)composite, (String)Messages.Db2OptionsDialog_7, (Object)GUI.grid.d.left1());
        this.ENCAPS = GUI.combo.readOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1), (Object[])Db2SystemOptions.ENCAPS_TYPE.values());
        this.ENCAPS.setToolTipText(Messages.Db2OptionsDialog_8);
        this.systemOptionsTab.setControl((Control)composite);
    }

    private void initSystemOptionsValues() {
        this.ucsButton.setSelection(this.systemOptions.getUCS());
        this.ENCAPS.setText(this.systemOptions.getENCAPS().toString());
        this.TIME.setText(this.systemOptions.getTIME().toString());
        this.urButton.setSelection(this.systemOptions.getUR());
        this.fkeyButton.setSelection(this.systemOptions.getFKEY());
        this.DECFLOAT.setText(this.systemOptions.getDECFLOAT().toString());
    }

    private void createEditorOptionsTab(TabFolder tabFolder) {
        this.createEditorOptionsTab1(tabFolder);
        this.createEditorOptionsTab2(tabFolder);
        this.createEditorOptionsTab3(tabFolder);
        this.createEditorOptionsTab4(tabFolder);
    }

    private void createEditorOptionsTab1(TabFolder tabFolder) {
        this.editorOptionsTab1 = new TabItem(tabFolder, 0);
        this.editorOptionsTab1.setText(Messages.Db2OptionsDialog_19);
        Composite composite = GUI.composite((Composite)tabFolder, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group varLenColumnsGroup = GUI.group((Composite)composite, (String)Messages.Db2OptionsDialog_51, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)2));
        this.buttonSHWENDVC = GUI.button.checkbox((Composite)varLenColumnsGroup, (String)Messages.Db2OptionsDialog_54, (Object)GUI.grid.d.fillH((int)2));
        this.buttonSHWENDVC.setToolTipText(Messages.Db2OptionsDialog_55);
        this.disableINPUTDELM = GUI.button.checkbox((Composite)varLenColumnsGroup, (String)Messages.Db2OptionsDialog_90, (Object)GUI.grid.d.fillH((int)2));
        this.disableINPUTDELM.setToolTipText(Messages.Db2OptionsDialog_91);
        GUI.label.left((Composite)varLenColumnsGroup, (String)Messages.Db2OptionsDialog_56, (Object)GUI.grid.d.left1());
        this.VCDELIM = GUI.text.field((Composite)varLenColumnsGroup, (Object)GUI.grid.d.fillH((int)1));
        this.VCDELIM.setTextLimit(1);
        this.VCDELIM.setToolTipText(Messages.Db2OptionsDialog_57);
        this.VCDELIM.addModifyListener((ModifyListener)this);
        this.VCDELIM.setData((Object)stringInputDelim);
        this.optionTexts[0] = this.VCDELIM;
        this.disableINPUTDELM.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean state = Db2OptionsDialog.this.disableINPUTDELM.getSelection();
                if (state) {
                    Db2OptionsDialog.this.VCDELIM.setEnabled(false);
                    Db2OptionsDialog.this.editorOptions.setDISABLEINPUTDELIM(true);
                    if (Db2OptionsDialog.this.VCDELIM.getText().trim().equals("")) {
                        Db2OptionsDialog.this.VCDELIM.setText("#");
                    }
                } else {
                    Db2OptionsDialog.this.VCDELIM.setEnabled(true);
                    Db2OptionsDialog.this.editorOptions.setDISABLEINPUTDELIM(false);
                }
            }
        });
        GUI.label.left((Composite)varLenColumnsGroup, (String)Messages.Db2OptionsDialog_58, (Object)GUI.grid.d.left1());
        this.DVCDELIM = GUI.text.field((Composite)varLenColumnsGroup, (Object)GUI.grid.d.fillH((int)1));
        this.DVCDELIM.setTextLimit(1);
        this.DVCDELIM.setToolTipText(Messages.Db2OptionsDialog_59);
        this.DVCDELIM.addModifyListener((ModifyListener)this);
        this.DVCDELIM.setData((Object)stringDisplayDelim);
        this.optionTexts[1] = this.DVCDELIM;
        Group nullColumnGroup = GUI.group((Composite)composite, (String)Messages.Db2OptionsDialog_60, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)2));
        this.buttonCNVSPNUL = GUI.button.checkbox((Composite)nullColumnGroup, (String)Messages.Db2OptionsDialog_61, (Object)GUI.grid.d.fillH((int)2));
        this.buttonCNVSPNUL.setToolTipText(Messages.Db2OptionsDialog_62);
        GUI.label.left((Composite)nullColumnGroup, (String)Messages.Db2OptionsDialog_63, (Object)GUI.grid.d.left1());
        this.NULLIND = GUI.text.field((Composite)nullColumnGroup, (Object)GUI.grid.d.fillH((int)1));
        this.NULLIND.setTextLimit(1);
        this.NULLIND.setToolTipText(Messages.Db2OptionsDialog_64);
        this.NULLIND.addModifyListener((ModifyListener)this);
        this.NULLIND.setData((Object)nullInputDelim);
        this.optionTexts[2] = this.NULLIND;
        GUI.label.left((Composite)nullColumnGroup, (String)Messages.Db2OptionsDialog_65, (Object)GUI.grid.d.left1());
        this.DNULLIND = GUI.text.field((Composite)nullColumnGroup, (Object)GUI.grid.d.fillH((int)1));
        this.DNULLIND.setTextLimit(1);
        this.DNULLIND.setToolTipText(Messages.Db2OptionsDialog_66);
        this.DNULLIND.addModifyListener((ModifyListener)this);
        this.DNULLIND.setData((Object)nullDisplayDelim);
        this.optionTexts[3] = this.DNULLIND;
        this.editorOptionsTab1.setControl((Control)composite);
    }

    private void enableSamplingControls() {
        Db2EditorOptions.SAMTYPE_TYPE type = Db2EditorOptions.SAMTYPE_TYPE.getStrValueToType((String)this.SAMTYPE.getText());
        if (type == Db2EditorOptions.SAMTYPE_TYPE.CLUSTER) {
            this.SLIMIT.setEnabled(true);
            this.ISKIP.setEnabled(true);
            this.INCL.setEnabled(true);
            this.FSKIP.setEnabled(true);
            this.SFREQ.setEnabled(false);
            this.SSEED.setEnabled(false);
        } else if (type == Db2EditorOptions.SAMTYPE_TYPE.RANDOM) {
            this.SLIMIT.setEnabled(true);
            this.ISKIP.setEnabled(false);
            this.INCL.setEnabled(false);
            this.FSKIP.setEnabled(false);
            this.SFREQ.setEnabled(true);
            this.SSEED.setEnabled(true);
        } else {
            this.SLIMIT.setEnabled(false);
            this.ISKIP.setEnabled(false);
            this.INCL.setEnabled(false);
            this.FSKIP.setEnabled(false);
            this.SFREQ.setEnabled(false);
            this.SSEED.setEnabled(false);
        }
    }

    private void createEditorOptionsTab2(TabFolder tabFolder) {
        this.editorOptionsTab2 = new TabItem(tabFolder, 0);
        this.editorOptionsTab2.setText(Messages.Db2OptionsDialog_44);
        Composite composite = GUI.composite((Composite)tabFolder, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)composite, (String)Messages.Db2OptionsDialog_69, (Object)GUI.grid.d.left1());
        this.ENTEROP = GUI.combo.readOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1), (Object[])Db2EditorOptions.ENTEROP_TYPE.values());
        this.ENTEROP.setToolTipText(Messages.Db2OptionsDialog_70);
        Group commitGroup = GUI.group((Composite)composite, (String)Messages.Db2OptionsDialog_68, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)2));
        this.buttonCOMSAVE = GUI.button.checkbox((Composite)commitGroup, (String)Messages.Db2OptionsDialog_71, (Object)GUI.grid.d.fillH((int)2));
        this.buttonCOMSAVE.setToolTipText(Messages.Db2OptionsDialog_72);
        this.buttonCOMNOSVE = GUI.button.checkbox((Composite)commitGroup, (String)Messages.Db2OptionsDialog_73, (Object)GUI.grid.d.fillH((int)2));
        this.buttonCOMNOSVE.setToolTipText(Messages.Db2OptionsDialog_74);
        GUI.label.left((Composite)commitGroup, (String)Messages.Db2OptionsDialog_75, (Object)GUI.grid.d.left1());
        this.AUTOCOM = GUI.text.field((Composite)commitGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.AUTOCOM).setUpperBound(Integer.MAX_VALUE, true);
        this.AUTOCOM.setToolTipText(Messages.Db2OptionsDialog_76);
        this.buttonUPKEY = GUI.button.checkbox((Composite)composite, (String)Messages.Db2OptionsDialog_47, (Object)GUI.grid.d.fillH((int)2));
        this.buttonUPKEY.setToolTipText(Messages.Db2OptionsDialog_48);
        this.editorOptionsTab2.setControl((Control)composite);
    }

    private void createEditorOptionsTab3(TabFolder tabFolder) {
        this.editorOptionsTab3 = new TabItem(tabFolder, 0);
        this.editorOptionsTab3.setText(Messages.Db2OptionsDialog_67);
        Composite composite = GUI.composite((Composite)tabFolder, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group samplingGroup = GUI.group((Composite)composite, (String)Messages.Db2OptionsDialog_29, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)2));
        GUI.label.left((Composite)samplingGroup, (String)Messages.Db2OptionsDialog_30, (Object)GUI.grid.d.left1());
        this.SAMTYPE = GUI.combo.readOnly((Composite)samplingGroup, (Object)GUI.grid.d.fillH((int)1), (Object[])Db2EditorOptions.SAMTYPE_TYPE.values());
        this.SAMTYPE.setToolTipText(Messages.Db2OptionsDialog_31);
        this.SAMTYPE.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Db2OptionsDialog.this.enableSamplingControls();
            }
        });
        GUI.label.left((Composite)samplingGroup, (String)Messages.Db2OptionsDialog_32, (Object)GUI.grid.d.left1());
        this.SLIMIT = GUI.text.field((Composite)samplingGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.SLIMIT);
        this.SLIMIT.setToolTipText(Messages.Db2OptionsDialog_33);
        this.SLIMIT.setData((Object)SAMPLINGLIMIT);
        this.SLIMIT.addModifyListener((ModifyListener)this);
        this.optionTexts[4] = this.SLIMIT;
        GUI.label.left((Composite)samplingGroup, (String)Messages.Db2OptionsDialog_34, (Object)GUI.grid.d.left1());
        this.ISKIP = GUI.text.field((Composite)samplingGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.ISKIP);
        this.ISKIP.setToolTipText(Messages.Db2OptionsDialog_35);
        this.ISKIP.setData((Object)INITIALSKIPCOUNT);
        this.ISKIP.addModifyListener((ModifyListener)this);
        this.optionTexts[5] = this.ISKIP;
        GUI.label.left((Composite)samplingGroup, (String)Messages.Db2OptionsDialog_36, (Object)GUI.grid.d.left1());
        this.INCL = GUI.text.field((Composite)samplingGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.INCL);
        this.INCL.setToolTipText(Messages.Db2OptionsDialog_37);
        this.INCL.setData((Object)INCLUDECOUNT);
        this.INCL.addModifyListener((ModifyListener)this);
        this.optionTexts[6] = this.INCL;
        GUI.label.left((Composite)samplingGroup, (String)Messages.Db2OptionsDialog_38, (Object)GUI.grid.d.left1());
        this.FSKIP = GUI.text.field((Composite)samplingGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.FSKIP);
        this.FSKIP.setToolTipText(Messages.Db2OptionsDialog_39);
        this.FSKIP.setData((Object)SKIPCOUNT);
        this.FSKIP.addModifyListener((ModifyListener)this);
        this.optionTexts[7] = this.FSKIP;
        GUI.label.left((Composite)samplingGroup, (String)Messages.Db2OptionsDialog_40, (Object)GUI.grid.d.left1());
        this.SFREQ = GUI.text.field((Composite)samplingGroup, (Object)GUI.grid.d.fillH((int)1));
        this.SFREQ.setToolTipText(Messages.Db2OptionsDialog_41);
        this.SFREQ.setData((Object)SAMPLINGFREQ);
        this.SFREQ.addModifyListener((ModifyListener)this);
        this.optionTexts[8] = this.SFREQ;
        GUI.label.left((Composite)samplingGroup, (String)Messages.Db2OptionsDialog_42, (Object)GUI.grid.d.left1());
        this.SSEED = GUI.text.field((Composite)samplingGroup, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer.addTo(this.SSEED);
        this.SSEED.setToolTipText(Messages.Db2OptionsDialog_43);
        this.SSEED.setData((Object)SAMPLINGSEED);
        this.SSEED.addModifyListener((ModifyListener)this);
        this.optionTexts[9] = this.SSEED;
        this.editorOptionsTab3.setControl((Control)composite);
    }

    private void createEditorOptionsTab4(TabFolder tabFolder) {
        this.editorOptionsTab4 = new TabItem(tabFolder, 0);
        this.editorOptionsTab4.setText(Messages.Db2OptionsDialog_89);
        Composite composite = GUI.composite((Composite)tabFolder, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        Group optimizationComposite = GUI.group((Composite)composite, (String)Messages.Db2OptionsDialog_24, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)2));
        this.buttonOPTROWC = GUI.button.checkbox((Composite)optimizationComposite, (String)Messages.Db2OptionsDialog_25, (Object)GUI.grid.d.fillH((int)2));
        this.buttonOPTROWC.setToolTipText(Messages.Db2OptionsDialog_26);
        GUI.label.left((Composite)optimizationComposite, (String)Messages.Db2OptionsDialog_27, (Object)GUI.grid.d.left1());
        this.OPTROWS = GUI.text.field((Composite)optimizationComposite, (Object)GUI.grid.d.fillH((int)1));
        NumberForcer numberForcer = NumberForcer.addTo(this.OPTROWS);
        numberForcer.setLowerBound(0, true);
        numberForcer.setUpperBound(999999, true);
        this.OPTROWS.setToolTipText(Messages.Db2OptionsDialog_28);
        this.buttonCOMFETCH = GUI.button.checkbox((Composite)composite, (String)Messages.Db2OptionsDialog_79, (Object)GUI.grid.d.fillH((int)2));
        this.buttonCOMFETCH.setToolTipText(Messages.Db2OptionsDialog_80);
        this.buttonRDONLY = GUI.button.checkbox((Composite)composite, (String)Messages.Db2OptionsDialog_77, (Object)GUI.grid.d.fillH((int)2));
        this.buttonRDONLY.setToolTipText(Messages.Db2OptionsDialog_78);
        this.buttonSKIPLOCK = GUI.button.checkbox((Composite)composite, (String)Messages.Db2OptionsDialog_81, (Object)GUI.grid.d.fillH((int)2));
        this.buttonSKIPLOCK.setToolTipText(Messages.Db2OptionsDialog_82);
        this.urButton = GUI.button.checkbox((Composite)composite, (String)Messages.Db2OptionsDialog_11, (Object)GUI.grid.d.fillH((int)2));
        this.urButton.setToolTipText(Messages.Db2OptionsDialog_12);
        GUI.label.left((Composite)composite, (String)Messages.Db2OptionsDialog_83, (Object)GUI.grid.d.left1());
        this.CONCURR = GUI.combo.readOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1), (Object[])Db2EditorOptions.CONCURR_TYPE.values());
        this.CONCURR.setToolTipText(Messages.Db2OptionsDialog_84);
        GUI.label.left((Composite)composite, (String)Messages.Db2OptionsDialog_85, (Object)GUI.grid.d.left1());
        this.LOCK = GUI.combo.readOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1), (Object[])Db2EditorOptions.LOCK_TYPE.values());
        this.LOCK.setToolTipText(Messages.Db2OptionsDialog_86);
        GUI.label.left((Composite)composite, (String)Messages.Db2OptionsDialog_87, (Object)GUI.grid.d.left1());
        this.KLOCK = GUI.combo.readOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1), (Object[])Db2EditorOptions.KLOCK_TYPE.values());
        this.KLOCK.setToolTipText(Messages.Db2OptionsDialog_88);
        GUI.label.left((Composite)composite, (String)Messages.Db2OptionsDialog_22, (Object)GUI.grid.d.left1());
        this.CSRTYPE = GUI.combo.readOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1), (Object[])Db2EditorOptions.CSRTYPE_TYPE.values());
        this.CSRTYPE.setToolTipText(Messages.Db2OptionsDialog_23);
        this.editorOptionsTab4.setControl((Control)composite);
    }

    private void initEditorOptions() {
        this.buttonOPTROWC.setSelection(this.editorOptions.getOPTROWC());
        this.CSRTYPE.setText(this.editorOptions.getCSRTYPE().toString());
        this.OPTROWS.setText(this.editorOptions.getOPTROWS());
        this.SAMTYPE.setText(this.editorOptions.getSAMTYPE().toString());
        this.enableSamplingControls();
        this.ISKIP.setText(this.editorOptions.getISKIP());
        this.INCL.setText(this.editorOptions.getINCL());
        this.FSKIP.setText(this.editorOptions.getFSKIP());
        this.SLIMIT.setText(this.editorOptions.getSLIMIT());
        this.SFREQ.setText(this.editorOptions.getSFREQ());
        this.SSEED.setText(this.editorOptions.getSSEED());
        this.buttonUPKEY.setSelection(this.editorOptions.getUPKEY());
        this.buttonSHWENDVC.setSelection(this.editorOptions.getSHWENDVC());
        this.disableINPUTDELM.setSelection(this.editorOptions.getDISABLEINPUTDELIM());
        this.VCDELIM.setText(this.editorOptions.getVCDELIM());
        this.VCDELIM.setEnabled(!this.editorOptions.getDISABLEINPUTDELIM());
        this.DVCDELIM.setText(this.editorOptions.getDVCDELIM());
        this.buttonCNVSPNUL.setSelection(this.editorOptions.getCNVSPNUL());
        this.NULLIND.setText(this.editorOptions.getNULLIND());
        this.DNULLIND.setText(this.editorOptions.getDNULLIND());
        this.buttonAUTOZTS.setSelection(this.editorOptions.getAUTOZTS());
        this.ENTEROP.setText(this.editorOptions.getENTEROP().toString());
        this.buttonCOMSAVE.setSelection(this.editorOptions.getCOMSAVE());
        this.buttonCOMNOSVE.setSelection(this.editorOptions.getCOMNOSVE());
        this.AUTOCOM.setText(this.editorOptions.getAUTOCOM());
        this.buttonRDONLY.setSelection(this.editorOptions.getRDONLY());
        this.CONCURR.setText(this.editorOptions.getCONCURR().toString());
        this.buttonCOMFETCH.setSelection(this.editorOptions.getCOMFETCH());
        this.buttonSKIPLOCK.setSelection(this.editorOptions.getSKIPLOCK());
        this.LOCK.setText(this.editorOptions.getLOCK().toString());
        this.KLOCK.setText(this.editorOptions.getKLOCK().toString());
    }

    protected void okPressed() {
        int i = 0;
        while (i < this.optionTexts.length) {
            String data;
            Text selectedTextBox = this.optionTexts[i];
            String selectedText = selectedTextBox.getText().trim();
            boolean status = this.performTextValidation(selectedTextBox, selectedText, data = (String)selectedTextBox.getData());
            if (!status) {
                return;
            }
            ++i;
        }
        this.systemOptions.setUCS(this.ucsButton.getSelection());
        this.systemOptions.setENCAPS(Db2SystemOptions.ENCAPS_TYPE.getStrValueToType((String)this.ENCAPS.getText()));
        this.systemOptions.setTIME(Db2SystemOptions.EXTERNAL_FORMAT_TIME.getStrValueToType((String)this.TIME.getText()));
        this.systemOptions.setUR(this.urButton.getSelection());
        this.systemOptions.setFKEY(this.fkeyButton.getSelection());
        this.systemOptions.setDECFLOAT(Db2SystemOptions.DECFLOAT_TYPE.getStrValueToType((String)this.DECFLOAT.getText()));
        this.editorOptions.setOPTROWC(this.buttonOPTROWC.getSelection());
        this.editorOptions.setCSRTYPE(Db2EditorOptions.CSRTYPE_TYPE.getStrValueToType((String)this.CSRTYPE.getText()));
        this.editorOptions.setOPTROWS(this.OPTROWS.getText());
        this.editorOptions.setSAMTYPE(Db2EditorOptions.SAMTYPE_TYPE.getStrValueToType((String)this.SAMTYPE.getText()));
        this.editorOptions.setISKIP(this.ISKIP.getText());
        this.editorOptions.setINCL(this.INCL.getText());
        this.editorOptions.setFSKIP(this.FSKIP.getText());
        this.editorOptions.setSLIMIT(this.SLIMIT.getText());
        this.editorOptions.setSFREQ(this.SFREQ.getText());
        this.editorOptions.setSSEED(this.SSEED.getText());
        this.editorOptions.setUPKEY(this.buttonUPKEY.getSelection());
        this.editorOptions.setSHWENDVC(this.buttonSHWENDVC.getSelection());
        this.editorOptions.setVCDELIM(this.VCDELIM.getText());
        this.editorOptions.setDISABLEINPUTDELIM(this.disableINPUTDELM.getSelection());
        this.editorOptions.setDVCDELIM(this.DVCDELIM.getText());
        this.editorOptions.setCNVSPNUL(this.buttonCNVSPNUL.getSelection());
        this.editorOptions.setNULLIND(this.NULLIND.getText());
        this.editorOptions.setDNULLIND(this.DNULLIND.getText());
        this.editorOptions.setAUTOZTS(this.buttonAUTOZTS.getSelection());
        this.editorOptions.setENTEROP(Db2EditorOptions.ENTEROP_TYPE.getStrValueToType((String)this.ENTEROP.getText()));
        this.editorOptions.setCOMSAVE(this.buttonCOMSAVE.getSelection());
        this.editorOptions.setCOMNOSVE(this.buttonCOMNOSVE.getSelection());
        this.editorOptions.setAUTOCOM(this.AUTOCOM.getText());
        this.editorOptions.setRDONLY(this.buttonRDONLY.getSelection());
        this.editorOptions.setCONCURR(Db2EditorOptions.CONCURR_TYPE.getStrValueToType((String)this.CONCURR.getText()));
        this.editorOptions.setCOMFETCH(this.buttonCOMFETCH.getSelection());
        this.editorOptions.setSKIPLOCK(this.buttonSKIPLOCK.getSelection());
        this.editorOptions.setLOCK(Db2EditorOptions.LOCK_TYPE.getStrValueToType((String)this.LOCK.getText()));
        this.editorOptions.setKLOCK(Db2EditorOptions.KLOCK_TYPE.getStrValueToType((String)this.KLOCK.getText()));
        super.okPressed();
    }

    public Db2SystemOptions getSystemOptions() {
        return this.systemOptions;
    }

    public Db2EditorOptions getEditorOptions() {
        return this.editorOptions;
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = GUI.composite((Composite)parent, (Layout)GUI.grid.l.customMargins((int)3, (boolean)false, (int)10, (int)15), (Object)new GridData(0x1000008, 4, true, true));
        this.createButtonsForButtonBar(buttonBar);
        return buttonBar;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData data = new GridData();
        data.widthHint = 100;
        this.okButton = GUI.button.push((Composite)parent, (String)JFaceResources.getString((String)"ok"), (Object)data);
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Db2OptionsDialog.this.okPressed();
            }
        });
        this.cancelButton = GUI.button.push((Composite)parent, (String)JFaceResources.getString((String)"cancel"), (Object)data);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Db2OptionsDialog.this.cancelPressed();
            }
        });
        this.defaultButton = GUI.button.push((Composite)parent, (String)Messages.__DEFAULT, (Object)data);
        this.defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Db2OptionsDialog.this.systemOptions = new Db2SystemOptions();
                Db2OptionsDialog.this.editorOptions = new Db2EditorOptions();
                Db2OptionsDialog.this.initAllValues();
            }
        });
        this.getShell().setDefaultButton(this.okButton);
    }

    private boolean validateDecimalValue(String enteredValue) {
        try {
            float numValue = Float.parseFloat(enteredValue);
            if (!(numValue > 0.0f) || !(numValue < 1.0f)) {
                this.setErrorMessage(Messages.Db2OptionsDialog_95);
                return false;
            }
        }
        catch (NumberFormatException ex) {
            this.setErrorMessage(Messages.Db2OptionsDialog_94);
            return false;
        }
        return true;
    }

    private boolean validateIntegerValue(String data, String enteredValue) {
        int numValue;
        block6: {
            block5: {
                try {
                    numValue = Integer.parseInt(enteredValue);
                    if (!data.equals(SAMPLINGLIMIT) && !data.equals(INITIALSKIPCOUNT) && !data.equals(SKIPCOUNT) || numValue >= 0 && numValue <= 999999999) break block5;
                    this.setErrorMessage(Messages.Db2OptionsDialog_95);
                    return false;
                }
                catch (NumberFormatException ex) {
                    this.setErrorMessage(Messages.Db2OptionsDialog_94);
                    return false;
                }
            }
            if (!data.equals(INCLUDECOUNT) || numValue >= 1 && numValue <= 999999999) break block6;
            this.setErrorMessage(Messages.Db2OptionsDialog_95);
            return false;
        }
        if (data.equals(SAMPLINGSEED) && (numValue < 0 || numValue > Integer.MAX_VALUE)) {
            this.setErrorMessage(Messages.Db2OptionsDialog_95);
            return false;
        }
        return true;
    }

    private boolean validateUniqueChars(String selectedText, Text selectedTextBox) {
        int i = 0;
        while (i < this.optionTexts.length) {
            Text textBox = this.optionTexts[i];
            if (textBox.isEnabled() && !selectedTextBox.getData().equals(textBox.getData())) {
                if (selectedText.equals(textBox.getText())) {
                    this.setErrorMessage(Messages.Db2OptionsDialog_93);
                    return false;
                }
                this.setErrorMessage(null);
            }
            ++i;
        }
        return true;
    }

    public void modifyText(ModifyEvent event) {
        Text selectedTextBox = (Text)event.widget;
        String selectedText = selectedTextBox.getText().trim();
        String data = (String)selectedTextBox.getData();
        this.performTextValidation(selectedTextBox, selectedText, data);
    }

    private boolean performTextValidation(Text selectedTextBox, String selectedText, String data) {
        boolean bCorrectValue;
        boolean bUniqueChar;
        if (selectedText.trim().isEmpty()) {
            this.setErrorMessage(Messages.Db2OptionsDialog_92);
            return false;
        }
        if ((data.equals(this.VCDELIM.getData()) || data.equals(this.DVCDELIM.getData()) || data.equals(this.NULLIND.getData()) || data.equals(this.DNULLIND.getData())) && !(bUniqueChar = this.validateUniqueChars(selectedText, selectedTextBox))) {
            return false;
        }
        if ((data.equals(SAMPLINGLIMIT) || data.equals(INITIALSKIPCOUNT) || data.equals(INCLUDECOUNT) || data.equals(SKIPCOUNT) || data.equals(SAMPLINGSEED)) && !(bCorrectValue = this.validateIntegerValue(data, selectedText))) {
            return false;
        }
        if (data.equals(SAMPLINGFREQ) && !(bCorrectValue = this.validateDecimalValue(selectedText))) {
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

