/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted2.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DummyMember;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.model.db2.Db2EditOptions;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.model.db2.Db2TemplateOptions;
import com.ibm.etools.fm.editor.formatted2.dialogs.Db2OptionsDialog;
import com.ibm.etools.fm.editor.template.TemplateEditorUtilities;
import com.ibm.etools.fm.editor.template2.TemplateEditorUtilities2;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.lookup.Db2SubsystemLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.Db2TableLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.util.ZrlLoaderDialogUtils;
import com.ibm.etools.fm.ui.widget.Db2TableContentProposals;
import com.ibm.etools.fm.ui.wizards.db2.Db2ObjectModelUtil;
import com.ibm.pdtools.common.component.bidi.BidiUtils;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDBiDiHelpers;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.EncodingUtils;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class Db2EditorDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static String[] layoutValues = new String[]{Messages.EditorOptionDialog_TEXT_LAYOUT_LOGICAL, Messages.EditorOptionDialog_TEXT_LAYOUT_VISUAL};
    private static String[] layoutValuesNonWindows = new String[]{Messages.EditorOptionDialog_TEXT_LAYOUT_LOGICAL};
    private static String[] directionValues = new String[]{Messages.EditorOptionDialog_TEXT_DIRECTION_LTR, Messages.EditorOptionDialog_TEXT_DIRECTION_RTL};
    private IPDHost host;
    private Db2EditOptions options;
    private Combo ssidCombo;
    private Combo ownerCombo;
    private Combo nameCombo;
    private Combo startPosCombo;
    private Combo rowCountCombo;
    private Combo encodingCombo;
    private Combo dbcsEncodingCombo;
    private Combo textLayoutCombo;
    private Combo textDirectionCombo;
    private Combo templateCombo;
    private Button templateEditButton;
    private Button templateUsageGenRepButton;
    private boolean initWithDb2EditOptions;
    private final ModifyListener clearErrorMessage = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Db2EditorDialog.this.setErrorMessage(null);
        }
    };

    public Db2EditorDialog(IPDHost host, Db2Subsystem subsystem, Db2Table table) {
        this.options = new Db2EditOptions();
        if (table != null) {
            this.options.setTable(table);
        } else if (subsystem != null) {
            this.options.setSubsystem(subsystem);
        } else {
            this.options.setHost(host);
        }
        this.host = this.options.getSystem();
        this.initWithDb2EditOptions = false;
    }

    public Db2EditorDialog(Db2EditOptions options) {
        Objects.requireNonNull(options, "Must specify a non-null options.");
        this.host = options.getSystem();
        this.options = options.clone();
        this.initWithDb2EditOptions = true;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.Db2EditorDialog_0);
        this.setMessage(Messages.Db2EditorDialog_1);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.createDB2ObjectGroup(composite);
        this.createTemplateGroup(composite);
        this.createDB2EditorOptionsGroup(composite);
        this.initialiseDialogValues();
        return composite;
    }

    private void initialiseDialogValues() {
        if (this.options.getSubsystem() != null) {
            this.ssidCombo.setText(this.options.getSubsystem().getSubsystemID());
        }
        if (this.options.getTable() != null) {
            this.ownerCombo.setText(Db2ObjectModelUtil.getObjectName(this.options.getCreator()));
            this.nameCombo.setText(Db2ObjectModelUtil.getObjectName(this.options.getName()));
        }
        if (this.options.getTemplate() != null) {
            this.templateCombo.setText(this.options.getTemplate().getFormattedName());
        }
        ComboValueSaver.getInstance((Combo)this.encodingCombo).setCustomItems(EncodingUtils.getDefaultEncodingValues(), false);
        ComboValueSaver.getInstance((Combo)this.dbcsEncodingCombo).setCustomItems(EncodingUtils.getDefaultDBCSEncodingValues(), false);
        this.templateUsageGenRepButton.setSelection(this.options.isGenRep());
        if (this.initWithDb2EditOptions) {
            this.startPosCombo.setText(this.options.getStartPosition());
            this.rowCountCombo.setText(this.options.getRowCount());
        } else {
            this.startPosCombo.setText("1");
            this.rowCountCombo.setText("ALL");
        }
        this.encodingCombo.setText(this.options.getEncoding());
        if (this.options.isDbcsEcndoingValueSet()) {
            this.dbcsEncodingCombo.setText(this.options.getDbcsEncoding());
        } else {
            this.dbcsEncodingCombo.setText("");
        }
        PDBiDiHelpers.enableBidiCombos((String)this.encodingCombo.getText(), (Combo)this.textLayoutCombo, (Combo)this.textDirectionCombo, (boolean)true);
        if (this.options.getSubsystem() == null) {
            this.ssidCombo.setFocus();
        } else if (this.options.getTable() == null) {
            this.ownerCombo.setFocus();
        } else {
            this.templateCombo.setFocus();
        }
    }

    private void createDB2ObjectGroup(Composite parent) {
        Group db2ObjectGroup = GUI.group((Composite)parent, (String)Messages.Db2EditorDialog_2, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)db2ObjectGroup, (String)Messages.Db2EditorDialog_3, (Object)GUI.grid.d.left1());
        this.ssidCombo = GUI.combo.editable((Composite)db2ObjectGroup, (Object)GUI.grid.d.fillH((int)1));
        this.ssidCombo.setToolTipText(Messages.Db2EditorDialog_4);
        new ComboValueSaver(this.ssidCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "ssid");
        this.ssidCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Db2EditorDialog.this.setErrorMessage(null);
                Db2EditorDialog.this.validateSubsystem();
            }
        });
        LookupButton.createLookupButton((Composite)db2ObjectGroup, Messages.Db2EditorDialog_38).addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                Db2SubsystemLookupDialog lookup = new Db2SubsystemLookupDialog(Db2EditorDialog.this.options.getSystem());
                if (lookup.open() == 0) {
                    Db2EditorDialog.this.options.setSubsystem((Db2Subsystem)lookup.getFirstSelectedObject());
                    Db2EditorDialog.this.ssidCombo.setText(Db2EditorDialog.this.options.getSubsystem().getSubsystemID());
                }
            }
        });
        GUI.label.left((Composite)db2ObjectGroup, (String)Messages.Db2EditorDialog_7, (Object)GUI.grid.d.left1());
        this.ownerCombo = GUI.combo.editable((Composite)db2ObjectGroup, (Object)GUI.grid.d.fillH((int)1));
        this.ownerCombo.setToolTipText(Messages.Db2EditorDialog_8);
        this.ownerCombo.addModifyListener(this.clearErrorMessage);
        SelectionAdapter lookupHandler = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Db2EditorDialog.this.validateSubsystem()) {
                    Db2TableLookupDialog lookup = new Db2TableLookupDialog(Db2EditorDialog.this.options.getSubsystem());
                    lookup.setInitialOwnerPattern(Db2EditorDialog.this.ownerCombo.getText());
                    lookup.setInitialNamePattern(Db2EditorDialog.this.nameCombo.getText());
                    if (Db2EditorDialog.this.options.getDb2Database() != null) {
                        lookup.setInitialDatabasePattern(Db2EditorDialog.this.options.getDb2Database().getName());
                    }
                    if (lookup.open() == 0) {
                        Db2Table selected = (Db2Table)lookup.getFirstSelectedObject();
                        Db2EditorDialog.this.options.setTable(selected);
                        Db2EditorDialog.this.initialiseDialogValues();
                    }
                }
            }
        };
        LookupButton.createLookupButton((Composite)db2ObjectGroup, Messages.Db2EditorDialog_33).addSelectionListener((SelectionListener)lookupHandler);
        GUI.label.left((Composite)db2ObjectGroup, (String)Messages.Db2EditorDialog_11, (Object)GUI.grid.d.left1());
        this.nameCombo = GUI.combo.editable((Composite)db2ObjectGroup, (Object)GUI.grid.d.fillH((int)1));
        this.nameCombo.setToolTipText(Messages.Db2EditorDialog_12);
        Db2TableContentProposals.addTo(this.ownerCombo, this.nameCombo, (Db2SubsystemProvider)this.options, ((Object)((Object)this)).getClass().getCanonicalName() + "Resource");
        this.nameCombo.addModifyListener(this.clearErrorMessage);
        LookupButton.createLookupButton((Composite)db2ObjectGroup, Messages.Db2EditorDialog_33).addSelectionListener((SelectionListener)lookupHandler);
    }

    private void createTemplateGroup(Composite parent) {
        Group group = GUI.group((Composite)parent, (String)Messages.Db2EditorDialog_19, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)group, (String)Messages.Db2EditorDialog_20, (Object)GUI.grid.d.left1());
        this.templateCombo = GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1));
        this.templateEditButton = GUI.button.push((Composite)group, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/templateEditor.gif"), (String)Messages.__EDIT_TEMPLATE, (Object)GUI.grid.d.left1());
        this.templateEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String aTemplateName = Db2EditorDialog.this.templateCombo.getText().trim();
                if (!aTemplateName.isEmpty() && Db2EditorDialog.this.validateSubsystem() && Db2EditorDialog.this.validateTableName()) {
                    if (Db2EditorDialog.this.validateTemplateDataSetName(true)) {
                        Db2TemplateOptions tmpOptions = new Db2TemplateOptions();
                        tmpOptions.setTable(Db2EditorDialog.this.options.getTable());
                        tmpOptions.setTemplate(Db2EditorDialog.this.options.getTemplate());
                        TemplateEditorUtilities2.openTemplateEditSession(tmpOptions);
                    } else {
                        Db2EditorDialog.this.setErrorMessage(MessageFormat.format(Messages.EditorOptionDialog_TemplateEditInvalidTemplate, aTemplateName));
                    }
                } else {
                    Db2EditorDialog.this.setErrorMessage(Messages.EditorOptionDialog_TemplateEditNoTemplate);
                }
            }
        });
        LookupDialogFactory.defaults(LookupButton.createLookupTemplateButtonLeft1((Composite)group), this.templateCombo, (IHostProvider)this.options).types(FMHost.getPermittedTemplateResourceType((IPDHost)this.host)).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                Db2EditorDialog.this.options.setTemplate(zrl);
                Db2EditorDialog.this.templateCombo.setText(Db2EditorDialog.this.options.getTemplate().getFormattedName());
            }
        }).addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "Template").create();
        List assocs = FMHost.getSystem((IPDHost)this.host).getTemplateAssociations((IZRL)this.options.getTable());
        if (assocs.size() > 0) {
            ComboValueSaver.getInstance((Combo)this.templateCombo).setCustomItems(assocs.toArray(new String[0]), false, false);
            this.templateCombo.select(0);
        }
        this.templateCombo.addModifyListener(this.clearErrorMessage);
        this.templateUsageGenRepButton = GUI.button.checkbox((Composite)group, (String)Messages.Db2EditorDialog_21, (Object)GUI.grid.d.fillH((int)4));
        this.templateUsageGenRepButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Db2EditorDialog.this.options.setGenRep(Db2EditorDialog.this.templateUsageGenRepButton.getSelection());
            }
        });
    }

    private void createDB2EditorOptionsGroup(Composite parent) {
        Group db2OptionsGroup = GUI.group((Composite)parent, (String)Messages.Db2EditorDialog_34, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)db2OptionsGroup, (String)Messages.Db2EditorDialog_13, (Object)GUI.grid.d.left1());
        this.startPosCombo = GUI.combo.editable((Composite)db2OptionsGroup, (Object)GUI.grid.d.fillH((int)1));
        this.startPosCombo.setToolTipText(Messages.Db2EditorDialog_14);
        new ComboValueSaver(this.startPosCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "startPosCombo");
        this.startPosCombo.addModifyListener(this.clearErrorMessage);
        GUI.label.left((Composite)db2OptionsGroup, (String)Messages.Db2EditorDialog_15, (Object)GUI.grid.d.left1());
        this.rowCountCombo = GUI.combo.editable((Composite)db2OptionsGroup, (Object)GUI.grid.d.fillH((int)1));
        this.rowCountCombo.setToolTipText(Messages.Db2EditorDialog_16);
        new ComboValueSaver(this.rowCountCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "rowCountCombo");
        this.rowCountCombo.addModifyListener(this.clearErrorMessage);
        GUI.label.left((Composite)db2OptionsGroup, (String)Messages.Db2EditorDialog_17, (Object)GUI.grid.d.left1());
        this.encodingCombo = GUI.combo.editable((Composite)db2OptionsGroup, (Object)GUI.grid.d.fillH((int)1));
        this.encodingCombo.setToolTipText(Messages.Db2EditorDialog_18);
        new ComboValueSaver(this.encodingCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "encodingCombo");
        this.encodingCombo.addModifyListener(this.clearErrorMessage);
        this.encodingCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PDBiDiHelpers.enableBidiCombos((String)Db2EditorDialog.this.encodingCombo.getText(), (Combo)Db2EditorDialog.this.textLayoutCombo, (Combo)Db2EditorDialog.this.textDirectionCombo, (boolean)false);
            }
        });
        GUI.label.left((Composite)db2OptionsGroup, (String)Messages.Db2EditorDialog_GraphicEncoding, (Object)GUI.grid.d.left1());
        this.dbcsEncodingCombo = GUI.combo.editable((Composite)db2OptionsGroup, (Object)GUI.grid.d.fillH((int)1));
        this.dbcsEncodingCombo.setToolTipText(Messages.Db2EditorDialog_GraphicEncodingDesc);
        new ComboValueSaver(this.dbcsEncodingCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "dbcsEncodingCombo");
        this.dbcsEncodingCombo.addModifyListener(this.clearErrorMessage);
        GUI.label.left((Composite)db2OptionsGroup, (String)Messages.EditorOptionDialog_TEXT_LAYOUT, (Object)GUI.grid.d.left1());
        if (Util.isMac()) {
            this.textLayoutCombo = GUI.combo.readOnly((Composite)db2OptionsGroup, (Object)GUI.grid.d.fillH((int)1), (Object[])layoutValuesNonWindows);
            this.textLayoutCombo.setToolTipText(Messages.Db2EditorDialog_MacBidiLimitationToolip);
        } else {
            this.textLayoutCombo = GUI.combo.readOnly((Composite)db2OptionsGroup, (Object)GUI.grid.d.fillH((int)1), (Object[])layoutValues);
            this.textLayoutCombo.setToolTipText(Messages.EditorOptionDialog_TEXT_LAYOUT_TIP);
        }
        new ComboValueSaver(this.textLayoutCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "textLayout");
        this.textLayoutCombo.select(BidiUtils.isBidiVisualSupportRequired((String)this.host.getBidiFormat()) ? 1 : 0);
        this.textLayoutCombo.setEnabled(false);
        GUI.label.left((Composite)db2OptionsGroup, (String)Messages.EditorOptionDialog_TEXT_DIRECTION, (Object)GUI.grid.d.left1());
        this.textDirectionCombo = GUI.combo.readOnly((Composite)db2OptionsGroup, (Object)GUI.grid.d.fillH((int)1), (Object[])directionValues);
        this.textDirectionCombo.setToolTipText(Messages.EditorOptionDialog_TEXT_DIRECTION_TIP);
        new ComboValueSaver(this.textDirectionCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "textDirection");
        this.textDirectionCombo.select(BidiUtils.isBidiRTLSupportRequired((String)this.host.getBidiFormat()) ? 1 : 0);
        this.textDirectionCombo.setEnabled(false);
    }

    private boolean validateTemplateDataSetName(boolean memberMustExist) {
        String result;
        block8: {
            String value;
            block7: {
                value = this.templateCombo.getText();
                if (value.isEmpty()) {
                    this.options.setTemplate((IZRL)DummyMember.createDummyMember((IPDHost)this.host));
                    return true;
                }
                if (this.options.getTemplate() != null && value.equalsIgnoreCase(this.options.getTemplate().getFormattedName())) {
                    return true;
                }
                this.options.setTemplate(null);
                if (Member.isParseable((String)value, (boolean)false, (String)this.host.getCodePage())) break block7;
                this.setErrorMessage(Messages.EditorOptionDialog_TemplateEditInvalid);
                return false;
            }
            this.setErrorMessage(null);
            boolean mustExist = !this.templateUsageGenRepButton.getSelection();
            result = TemplateEditorUtilities.okAsTemplate(ZRLs.parseZRL((IPDHost)this.host, (String)value), mustExist, null);
            if (result != null) break block8;
            this.options.setTemplate(ZRLs.parseZRL((IPDHost)this.host, (String)value));
            return true;
        }
        try {
            this.setErrorMessage(result);
            this.templateCombo.setFocus();
            this.options.setTemplate(null);
            return false;
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(Messages.Db2EditorDialog_26);
            this.templateCombo.setFocus();
            this.options.setTemplate(null);
            return false;
        }
        catch (InterruptedException e) {
            this.templateCombo.setFocus();
            this.options.setTemplate(null);
            return false;
        }
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)4, (boolean)true), (Object)new GridData(0x1000008, 4, false, false));
        this.createButtonsForButtonBar(buttonBar);
        return buttonBar;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData data = GUI.grid.d.fillAll();
        data.minimumWidth = 100;
        Button editButton = GUI.button.push((Composite)parent, (String)Messages.EditorOptionDialog_EDIT, (Object)data, (String)Messages.EditorOptionDialog_EDIT_TIP);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Db2EditorDialog.this.options.setEdit(true);
                Db2EditorDialog.this.validateAndClose();
            }
        });
        Button viewButton = GUI.button.push((Composite)parent, (String)Messages.EditorOptionDialog_VIEW, (Object)data, (String)Messages.EditorOptionDialog_VIEW_TIP);
        viewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Db2EditorDialog.this.options.setEdit(false);
                Db2EditorDialog.this.validateAndClose();
            }
        });
        Button optionButton = GUI.button.push((Composite)parent, (String)Messages.Db2EditorDialog_27, (Object)data, (String)Messages.Db2EditorDialog_28);
        optionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Db2OptionsDialog dialog;
                if (Db2EditorDialog.this.validateSubsystem() && (dialog = new Db2OptionsDialog(Db2EditorDialog.this.options.getSystemOptions(), Db2EditorDialog.this.options.getEditorOptions())).open() == 0) {
                    Db2EditorDialog.this.options.putEditorOptions(dialog.getEditorOptions());
                    Db2EditorDialog.this.options.setSystemOptions(dialog.getSystemOptions());
                }
            }
        });
        Button cancelButton = GUI.button.push((Composite)parent, (String)Messages.EditorOptionDialog_CANCEL, (Object)data);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Db2EditorDialog.this.cancelPressed();
            }
        });
        this.getShell().setDefaultButton(editButton);
    }

    private boolean validateAndClose() {
        this.setErrorMessage(null);
        if (!this.validateSubsystem()) {
            return false;
        }
        if (!this.validateTableName()) {
            return false;
        }
        if (this.options.getTable() == null) {
            this.setErrorMessage(Messages.Db2EditorDialog_35);
            return false;
        }
        if (!this.noDupEditSession()) {
            return false;
        }
        if (!this.validateStartPosition()) {
            return false;
        }
        if (!this.validateRowCount()) {
            return false;
        }
        if (!this.validateTemplateDataSetName(false)) {
            return false;
        }
        if (!this.validateEncoding()) {
            return false;
        }
        if (!this.validateDbcsEncoding()) {
            return false;
        }
        if (!this.validateBidiOptions()) {
            return false;
        }
        Result result = new Result();
        if (!ZrlLoaderDialogUtils.tableExists(this.options.getTable(), result, true)) {
            this.setErrorMessage(MessageFormat.format(Messages.Db2ObjectCheckError, this.options.getCreator(), this.options.getName()));
            return false;
        }
        return this.close();
    }

    private boolean validateSubsystem() {
        String ssid = this.ssidCombo.getText().trim();
        if (!Db2Subsystem.isValidName((IPDHost)this.options.getSystem(), (String)ssid)) {
            this.setErrorMessage(Messages.Db2EditorDialog_39);
            this.ssidCombo.setFocus();
            return false;
        }
        String encoding = this.options.getEncoding();
        this.options.setSubsystem(new Db2Subsystem(this.options.getSystem(), ssid));
        this.options.setEncoding(encoding);
        return true;
    }

    private boolean validateTableName() {
        String tableCreater = Db2ObjectModelUtil.getObjectName(this.ownerCombo.getText());
        if (tableCreater.isEmpty()) {
            try {
                AuthDetails authDetails = this.options.getSystem().getLogin(true);
                tableCreater = authDetails.getUsername();
            }
            catch (InterruptedException e) {
                logger.debug((Object)"User cancelled while retrieving the user name.");
            }
        }
        if (!Db2Table.isValidOwner((IPDHost)this.options.getSystem(), (String)tableCreater)) {
            this.setErrorMessage(Messages.Db2EditorDialog_36);
            this.ownerCombo.setText(tableCreater);
            this.ownerCombo.setFocus();
            return false;
        }
        String tableName = Db2ObjectModelUtil.getObjectName(this.nameCombo.getText());
        if (!Db2Table.isValidName((IPDHost)this.options.getSystem(), (String)tableName)) {
            this.setErrorMessage(Messages.Db2EditorDialog_37);
            this.nameCombo.setFocus();
            return false;
        }
        this.options.setTable(new Db2Table(this.options.getSubsystem(), tableName, tableCreater));
        return true;
    }

    private boolean noDupEditSession() {
        if (this.options == null || this.options.getTable() == null) {
            this.setErrorMessage(Messages.Db2EditorDialog_35);
            return false;
        }
        if (FMUIPlugin.getDefault().dsEditSessionExist((IZRL)this.options.getTable())) {
            this.setErrorMessage(MessageFormat.format(Messages.OpenAsFormatted_DUP_EDIT2, this.options.getTable().getFormattedName()));
            return false;
        }
        return true;
    }

    private boolean validateStartPosition() {
        String value = this.startPosCombo.getText().trim();
        if (value.isEmpty()) {
            this.options.setStartPosition("1");
            this.startPosCombo.setText(this.options.getStartPosition());
            return true;
        }
        if (Db2EditorDialog.validInteger(value)) {
            this.options.setStartPosition(value);
            return true;
        }
        this.setErrorMessage(Messages.Db2EditorDialog_29);
        this.startPosCombo.setFocus();
        return false;
    }

    private boolean validateRowCount() {
        String value = this.rowCountCombo.getText().trim();
        if (value.isEmpty()) {
            this.options.setRowCount("ALL");
            this.rowCountCombo.setText(this.options.getRowCount());
            return true;
        }
        if ("ALL".equalsIgnoreCase(value)) {
            this.options.setRowCount("ALL");
            return true;
        }
        if (Db2EditorDialog.validInteger(value)) {
            this.options.setRowCount(value);
            return true;
        }
        this.setErrorMessage(MessageFormat.format(Messages.Db2EditorDialog_30, "ALL"));
        this.rowCountCombo.setFocus();
        return false;
    }

    private static boolean validInteger(String value) {
        try {
            int intValue = Integer.parseInt(value);
            return intValue > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean validateEncoding() {
        String value = this.encodingCombo.getText();
        if (value.isEmpty()) {
            this.options.setEncoding(this.host.getHostType().getDefaultEncoding());
            return true;
        }
        if (!EncodingUtils.isValidCodePage((String)(value = EncodingUtils.parseCodePage((String)value)))) {
            this.setErrorMessage(Messages.Db2EditorDialog_31);
            this.encodingCombo.setFocus();
            this.options.setEncoding(this.host.getHostType().getDefaultEncoding());
            return false;
        }
        this.options.setEncoding(value);
        return true;
    }

    private boolean validateDbcsEncoding() {
        String value = this.dbcsEncodingCombo.getText();
        if (value.isEmpty()) {
            this.options.setDbcsEncoding("");
            return true;
        }
        if (!EncodingUtils.isValidCodePage((String)(value = EncodingUtils.parseCodePage((String)value)))) {
            this.setErrorMessage(Messages.Db2EditorDialog_31);
            this.dbcsEncodingCombo.setFocus();
            this.options.setDbcsEncoding("");
            return false;
        }
        this.options.setDbcsEncoding(value);
        return true;
    }

    private boolean validateBidiOptions() {
        this.options.setBidiFormat(PDBiDiHelpers.getBidiFormat((String)this.textLayoutCombo.getText(), (String)this.textDirectionCombo.getText()));
        return true;
    }

    public Db2EditOptions getOptions() {
        return this.options;
    }
}

