/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted2.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2EditOptions;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.template1.StringArrayElementTableLabelProvider;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.views.systems.handlers.OpenFormatted;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class DReditSelectionDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00c2\u00a9 Copyright HCL Technologies Ltd. 2022. All rights reserved. \u00c2\u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private Db2Subsystem subsystem;
    private Table reditTable;
    private String[][] result;
    private TableViewer reditTableViewer;
    private Map<String, Integer> colstoIndexMap;
    private Button closeButton;
    private Map<String, String> colNoToValsMap;
    private DisplayLine displayLine;
    private boolean editSession;

    public DReditSelectionDialog(Db2Subsystem subsystem, String[][] result, Map<String, String> colNoToValsMap, DisplayLine recType, boolean editSession) {
        if (subsystem == null) {
            throw new IllegalArgumentException("Must specify a non-null Db2Subsystem.");
        }
        this.colstoIndexMap = new HashMap<String, Integer>();
        this.subsystem = subsystem;
        this.result = result;
        this.colNoToValsMap = colNoToValsMap;
        this.displayLine = recType;
        this.editSession = editSession;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ReditSelectionDialog_0);
        this.setMessage(Messages.DReditSelectionDialog_Heading);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.createTableComposite(composite);
        this.createButtonComposite(composite);
        return composite;
    }

    private void createTableComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.reditTable = new Table(composite, 68356);
        this.reditTable.setHeaderVisible(true);
        this.reditTable.setLinesVisible(true);
        GridData data = GUI.grid.d.fillAll();
        data.minimumHeight = 300;
        this.reditTable.setLayoutData((Object)data);
        this.reditTableViewer = new TableViewer(this.reditTable);
        Font font = JFaceResources.getTextFont();
        this.reditTableViewer.getTable().setFont(font);
        GC gc = new GC((Drawable)this.reditTableViewer.getTable());
        gc.setFont(font);
        String[][] table = this.result;
        String[][] elements = null;
        ArrayList<String> colsList = new ArrayList<String>();
        int row = 0;
        while (row < table.length) {
            int col = 0;
            while (col < table[row].length) {
                if (row == 0) {
                    colsList.add(table[row][col]);
                    this.colstoIndexMap.put(table[row][col], col);
                } else if (elements == null) {
                    elements = new String[table.length - 1][colsList.size()];
                    elements[row - 1][col] = table[row][col];
                } else {
                    elements[row - 1][col] = table[row][col];
                }
                ++col;
            }
            ++row;
        }
        int cols = 0;
        while (cols < colsList.size()) {
            String colName = (String)colsList.get(cols);
            FormattedEditorUtility.createTableViewerColumn(colName, colName.length() * 20, this.reditTableViewer, 16384);
            ++cols;
        }
        this.reditTableViewer.setLabelProvider((IBaseLabelProvider)new StringArrayElementTableLabelProvider());
        this.reditTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.reditTableViewer.setInput((Object)elements);
        this.reditTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DReditSelectionDialog.this.setErrorMessage(null);
            }
        });
        this.reditTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DReditSelectionDialog.this.invokeEditSession();
            }
        });
        if (this.reditTable.getItemCount() > 0) {
            this.reditTable.select(0);
        }
    }

    private void createButtonComposite(Composite parent) {
        GridData data = GUI.grid.d.vert((int)128, (boolean)false, (int)1);
        data.grabExcessHorizontalSpace = false;
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)data);
        Button editButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/tree/action_history/formattededit.gif"), (String)Messages.DReditSelectionDialog_3, (Object)GUI.grid.d.left1());
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DReditSelectionDialog.this.invokeEditSession();
            }
        });
    }

    private void invokeEditSession() {
        StructuredSelection object = (StructuredSelection)this.reditTableViewer.getSelection();
        if (object.getFirstElement() instanceof String[]) {
            String[] rowElements = (String[])object.getFirstElement();
            int indexOfRefCreator = this.colstoIndexMap.get("REFTBCREATOR");
            int indexOfRefTbName = this.colstoIndexMap.get("REFTBNAME");
            int indexOfRefColName = this.colstoIndexMap.get("NAME");
            int indexofColNum = this.colstoIndexMap.get("COLNO");
            String refColValue = rowElements[indexofColNum];
            String value = this.colNoToValsMap.get(String.valueOf(this.displayLine) + "-" + (Integer.parseInt(refColValue) + 1));
            String whereClause = " WHERE " + rowElements[indexOfRefColName] + " = '" + value + "'";
            Db2EditOptions opts = new Db2EditOptions();
            opts.setTable(new Db2Table(this.subsystem, rowElements[indexOfRefTbName], rowElements[indexOfRefCreator]));
            opts.setEdit(this.editSession);
            OpenFormatted.invokeDb2Editor(opts, 'D', whereClause);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)new GridData(0x1000008, 4, false, false));
        this.createButtonsForButtonBar(buttonBar);
        return buttonBar;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData data = GUI.grid.d.fillAll();
        data.minimumWidth = 100;
        this.closeButton = GUI.button.push((Composite)parent, (String)Messages.ReditSelectionDialog_7, (Object)data);
        this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DReditSelectionDialog.this.close();
            }
        });
        this.getShell().setDefaultButton(this.closeButton);
    }
}

