/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted1.view;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.contents.ShadowGroup;
import com.ibm.etools.fm.editor.formatted1.view.AbstractViewDisplay;
import com.ibm.etools.fm.model.util.DataConversionUtils;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class UnstructuredDisplayComposite
extends AbstractViewDisplay {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(UnstructuredDisplayComposite.class);
    private Text textArea;
    private String textAreaContents = "";

    public UnstructuredDisplayComposite(IFMEditor editor2) {
        this.currentEditor = editor2;
    }

    @Override
    public Composite createDisplayComposite(Composite parent) {
        this.displayComposite = GUI.composite((Composite)parent, (Layout)new FillLayout(), (Object)GUI.grid.d.fillAll());
        this.createTextArea(this.displayComposite);
        return this.displayComposite;
    }

    private Text createTextArea(Composite parent) {
        ControlEditor cellEditor = new ControlEditor(parent);
        cellEditor.grabHorizontal = true;
        cellEditor.grabVertical = true;
        this.textArea = new Text(parent, 2634);
        this.textArea.setText(this.textAreaContents);
        this.textArea.setFont(JFaceResources.getTextFont());
        return this.textArea;
    }

    @Override
    public void displayCurrentLine(IFMEditor editor2, DisplayLine currentLine) {
        this.currentEditor = editor2;
        this.currentLine = currentLine;
        this.textAreaContents = this.prepareTextArea();
        this.textArea.setText(this.textAreaContents);
    }

    @Override
    public void clearViewContents() {
        this.currentEditor = null;
        this.currentLine = null;
        if (this.textArea != null) {
            this.textArea.setText(this.prepareTextArea());
        }
    }

    protected String prepareTextArea() {
        if (this.currentLine == null || this.currentEditor == null) {
            this.textArea.setEnabled(true);
            return new String();
        }
        if (this.currentLine instanceof ShadowGroup) {
            this.textArea.setEnabled(true);
            return new String();
        }
        this.textArea.setEnabled(true);
        try {
            String tmpStr = new String(DataConversionUtils.getEBCDICData((String)this.currentLine.getRecord().getHex()), this.currentEditor.getResource().getPersistentProperty("encoding"));
            String tmpStr1 = tmpStr.replaceAll("\\p{C}", ".");
            this.textArea.setEnabled(true);
            return tmpStr1;
        }
        catch (UnsupportedEncodingException e) {
            this.textArea.setEnabled(true);
            String errMsg = MessageFormat.format(Messages.CharModePage_CONV_ERR, this.currentLine.getRecord().getRecno());
            logger.error((Object)errMsg, (Throwable)e);
            return errMsg;
        }
    }

    @Override
    public String getDisplayModeName() {
        return Messages.UnstructuredDisplayComposite_0;
    }
}

